;;; -*- Mode: Lisp; Package: TV; Base: 8.; Patch-File: T -*-
;;; Written 2/13/85 14:55:08 by Mikie,
;;; Reason: Gave MOMENTARY-MENUs explosive visual effects.
;;; while running on Roo from band 1
;;; with Experimental HAL 1.61, Experimental Error Handler 1.5, Experimental Font Editor 1.0, Experimental ZMACS 1.0, Experimental Universal Command Loop 6.9, Experimental Compiler 2.1, Experimental FILE-Server 12.0, Experimental ZMail 1.0, Experimental Net-Config 3.0, Experimental Explorer Serial & Parallel Ports 2.0, Experimental Suggestions 1.0, Experimental Local-File 5.0, Experimental Explorer Streamer Tape 5.0, Experimental User Profile Utility 2.0, Experimental Glossary 2.0, Experimental Window System 1.26, microcode 178, HAL 1.7 basic.



; From file MENU.LISP#> WINDOW; LAM1:
#8R TV#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "TV")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; MENU  "


(DEFVAR EXPLODING-MOMENTARY-WINDOWS NIL
  "T will turn on Exploding Visual Effects on Momentary-Menus")

;;; TURN-ON-BLINKERS means that this window will soon become the
;;; SELECTED-WINDOW, so it is not necessary to change blinkers from
;;; :BLINK to their DESELECTED-BLINKER-VISIBILITY.
;;; If Exploding-Momentary-Windows 
(DEFMETHOD (momentary-menu :expose) 
           (&OPTIONAL INHIBIT-BLINKERS BITS-ACTION (X X-OFFSET) (Y Y-OFFSET)
            &AUX (OLD-INHIBIT-SCHEDULING-FLAG INHIBIT-SCHEDULING-FLAG)
            (INHIBIT-SCHEDULING-FLAG T) SUPERIOR-HAS-SCREEN-ARRAY
            OK ERROR)
  "Expose a sheet (place it on the physical screen)."
  (PROG ()
	(SETQ RESTORED-BITS-P T)
	(OR BITS-ACTION (SETQ BITS-ACTION (IF BIT-ARRAY ':RESTORE ':CLEAN)))
	(AND EXPOSED-P (RETURN NIL))
	(SETQ RESTORED-BITS-P NIL)
	(SETQ SUPERIOR-HAS-SCREEN-ARRAY (OR (NULL SUPERIOR)
                                            (SHEET-SCREEN-ARRAY SUPERIOR)))
	(MULTIPLE-VALUE (OK BITS-ACTION ERROR)
	  (SHEET-PREPARE-FOR-EXPOSE SELF T INHIBIT-BLINKERS BITS-ACTION X Y))
	(OR OK (*THROW 'SHEET-ABORT-EXPOSE ERROR))
	;; Have made our area of the screen safe for us.  We'll now call
        ;; ourselves "exposed", even though we haven't put our bits on
        ;; the screen at all.  This will win, because we have ourself
        ;; locked, and if someone wants to cover us he'll have to go
        ;; blocked until we are done -- it's a cretinous thing to have
        ;; happen, but the system shouldn't come crashing to the ground
        ;; because of it.
        ;; *** INHIBIT-SCHEDULING-FLAG had better still be T ***
	(OR INHIBIT-SCHEDULING-FLAG
	    (FERROR
              NIL
              "Hairy part of expose finished with INHIBIT-SCHEDULING-FLAG off"))
	;; Lie by saying that we are exposed, because we aren't really,
        ;; but we are locked so it doesn't matter.
	(AND SUPERIOR-HAS-SCREEN-ARRAY (SETQ EXPOSED-P T PREPARED-SHEET NIL))
	(AND SUPERIOR
	     (OR (NOT (MEMQ SELF (SHEET-EXPOSED-INFERIORS SUPERIOR)))
		 ;; Must always reorder in the case of temporary windows
                 ;; since they are the only type of window that can be
                 ;; exposed and overlapping some other exposed window.
		 (SHEET-TEMPORARY-P))
	     (SHEET-CONSING
               ;; Put us at the top.
	       (SETF (SHEET-EXPOSED-INFERIORS SUPERIOR)
		     (CONS SELF (COPYLIST
                                  (DELQ SELF
                                        (SHEET-EXPOSED-INFERIORS SUPERIOR)))))))
	(COND ((AND SUPERIOR-HAS-SCREEN-ARRAY BIT-ARRAY)
	       (SETF (SHEET-OUTPUT-HOLD-FLAG) 0)
	       ;; Open all our blinkers, etc, but don't think this sheet
               ;; is prepared.
	       (PREPARE-SHEET (SELF) )
	       (SETQ PREPARED-SHEET NIL)
	       (LET ((ARRAY (IF SUPERIOR
				(SHEET-SUPERIOR-SCREEN-ARRAY)
				(SCREEN-BUFFER SELF))))
		 (REDIRECT-ARRAY SCREEN-ARRAY (ARRAY-TYPE SCREEN-ARRAY)
				 (PIXEL-ARRAY-WIDTH ARRAY)
				 (PIXEL-ARRAY-HEIGHT SCREEN-ARRAY)
				 ARRAY
				 (+ X-OFFSET (* Y-OFFSET
						(PIXEL-ARRAY-WIDTH ARRAY))))))
	      (SUPERIOR-HAS-SCREEN-ARRAY
	       (SETQ SCREEN-ARRAY OLD-SCREEN-ARRAY)
	       (SETF (SHEET-OUTPUT-HOLD-FLAG) 0)))
	(COND ((AND SUPERIOR-HAS-SCREEN-ARRAY (SHEET-TEMPORARY-P))
	       (IF (EQ TEMPORARY-BIT-ARRAY T)
		   (SETQ TEMPORARY-BIT-ARRAY
			 (MAKE-PIXEL-ARRAY
                           (LOGAND -40 (+ 37 WIDTH)) HEIGHT
                           ':TYPE (SHEET-ARRAY-TYPE SELF)))
		   (PAGE-IN-PIXEL-ARRAY
                     TEMPORARY-BIT-ARRAY NIL (LIST WIDTH HEIGHT)))
	       (BITBLT ALU-SETA WIDTH HEIGHT
                       SCREEN-ARRAY 0 0
                       TEMPORARY-BIT-ARRAY 0 0)
	       (PAGE-OUT-PIXEL-ARRAY
                 TEMPORARY-BIT-ARRAY NIL (LIST WIDTH HEIGHT))))
	(DOLIST (SHEET *SHEETS-MADE-INVISIBLE-TO-MOUSE*)
	  (SETF (SHEET-INVISIBLE-TO-MOUSE-P SHEET) NIL))
	(SETQ *SHEETS-MADE-INVISIBLE-TO-MOUSE* NIL)
	(COND (Exploding-Momentary-Windows 
	       (LET* ((thickness 2)
		      (rate 15)
		      (DX (// (- WIDTH   right-shadow-width) 2.))
		      (DY (// (- HEIGHT bottom-shadow-width) 2.))
		      (LR-INC (MAX 1 (// DX RATE)))
		      (TB-INC (MAX 1 (// DY RATE))))
		 (prepare-sheet (self)
		   (DO* ((K 1 (+ K rate))
			 (X1         (- (+ DX (sheet-inside-left self))  right-margin-size)
				     (- X1 LR-INC))
			 (X2         X1        (+ X2 LR-INC))
			 (Y1         (- (+ DY (sheet-inside-top  self)) bottom-margin-size)
				     (- Y1 TB-INC))
			 (Y2         Y1        (+ Y2 TB-INC))
			 (MY-WIDTH   thickness (- X2 X1))
			 (MY-HEIGHT  thickness (- Y2 Y1))
			 (NOTHINK   5000     (MAX 1000 (- NOTHINK 300))))
			((OR (>=    MY-WIDTH   (- WIDTH  right-shadow-width thickness))
			     (>=    MY-HEIGHT  HEIGHT)))
		     (tv:without-interrupts
		       (TV:DRAW-RECTANGLE-INSIDE-CLIPPED
			 MY-WIDTH thickness  (+ X1 thickness) Y1 TV:ALU-XOR self)
		       (TV:DRAW-RECTANGLE-INSIDE-CLIPPED
			 thickness MY-HEIGHT X2 (+ Y1 thickness) TV:ALU-XOR self)	
		       (TV:DRAW-RECTANGLE-INSIDE-CLIPPED MY-WIDTH thickness  X1 Y2 TV:ALU-XOR self)
		       (TV:DRAW-RECTANGLE-INSIDE-CLIPPED thickness MY-HEIGHT X1 Y1 TV:ALU-XOR self)
		       
		       (DOTIMES (x nothink))
		       
		       (TV:DRAW-RECTANGLE-INSIDE-CLIPPED
			 MY-WIDTH thickness  (+ X1 thickness) Y1 TV:ALU-XOR self)
		       (TV:DRAW-RECTANGLE-INSIDE-CLIPPED
			 thickness MY-HEIGHT X2 (+ Y1 thickness) TV:ALU-XOR self)
		       (TV:DRAW-RECTANGLE-INSIDE-CLIPPED MY-WIDTH thickness  X1 Y2 TV:ALU-XOR self)
		       (TV:DRAW-RECTANGLE-INSIDE-CLIPPED thickness MY-HEIGHT X1 Y1 TV:ALU-XOR self)
		       ))))))
	
        (MOUSE-DISCARD-CLICKAHEAD)
	(MOUSE-WAKEUP)
	;; This goes after preceeding code so that blinkers won't accidentally
	;; turn on before the bits get BITBLT'ed into the temporary array.
	(SETQ INHIBIT-SCHEDULING-FLAG OLD-INHIBIT-SCHEDULING-FLAG)
	(COND (SUPERIOR-HAS-SCREEN-ARRAY
	       (SELECTQ BITS-ACTION
		 (:NOOP NIL)
		 (:RESTORE
		  (FUNCALL-SELF ':REFRESH ':USE-OLD-BITS))
		 (:CLEAN
		  (SHEET-HOME SELF)
		  (FUNCALL-SELF ':REFRESH ':COMPLETE-REDISPLAY))
		 (OTHERWISE
		  (FERROR NIL "Unknown BITS-ACTION ~S" BITS-ACTION)))
	       (OR INHIBIT-BLINKERS
		   (DESELECT-SHEET-BLINKERS SELF))
	       (OR BIT-ARRAY
		   ;; Expose in opposite order for the sake of temporary windows
		   (DOLIST (INFERIOR (REVERSE EXPOSED-INFERIORS))
		     (FUNCALL INFERIOR ':EXPOSE NIL)))
	       (RETURN T)))))

(DEFMETHOD (momentary-menu :DEEXPOSE)
           (&OPTIONAL (SAVE-BITS-P ':DEFAULT) SCREEN-BITS-ACTION
            (REMOVE-FROM-SUPERIOR T))
  "Deexpose a sheet (removing it virtually from the physical screen,
some bits may remain)"
  (DELAYING-SCREEN-MANAGEMENT
    (COND ((AND (EQ SAVE-BITS-P ':DEFAULT)
                (NOT (ZEROP (SHEET-FORCE-SAVE-BITS))) EXPOSED-P)
	   (SETQ SAVE-BITS-P ':FORCE)
	   (SETF (SHEET-FORCE-SAVE-BITS) 0)))
    (LET ((SW SELECTED-WINDOW))
      (AND SW (SHEET-ME-OR-MY-KID-P SW SELF)
	   (FUNCALL SW ':DESELECT NIL)))
    (OR SCREEN-BITS-ACTION (SETQ SCREEN-BITS-ACTION ':NOOP))
    (COND (EXPOSED-P
	   (OR BIT-ARRAY
               ;; We do not have a bit-array, take our inferiors off screen.
	       (EQ SAVE-BITS-P ':FORCE)		;but leave them in EXPOSED-INFERIORS
	       (DOLIST (INFERIOR EXPOSED-INFERIORS)
		 (FUNCALL INFERIOR ':DEEXPOSE SAVE-BITS-P ':NOOP NIL)))
	   (WITHOUT-INTERRUPTS
	     (AND (EQ SAVE-BITS-P ':FORCE)
		  (NULL BIT-ARRAY)
                  ;; We are to force a saving of the SCREEN-ARRAY and
                  ;; there isn't a BIT-ARRAY.  We must create a BIT-ARRAY.
		  (SETQ BIT-ARRAY
			(MAKE-PIXEL-ARRAY
                          (LOGAND (+ (TRUNCATE (* LOCATIONS-PER-LINE 32.)
                                               (SCREEN-BITS-PER-PIXEL
                                                 (SHEET-GET-SCREEN SELF)))
                                     37)
                                  -40)
                          HEIGHT
                          ':TYPE (SHEET-ARRAY-TYPE SELF))
			OLD-SCREEN-ARRAY NIL))
	     (PREPARE-SHEET (SELF)
	       (AND SAVE-BITS-P BIT-ARRAY
		    (PROGN
                      (PAGE-IN-PIXEL-ARRAY BIT-ARRAY NIL (LIST WIDTH HEIGHT))
                      (BITBLT ALU-SETA WIDTH HEIGHT
                              SCREEN-ARRAY 0 0
                              BIT-ARRAY    0 0)
                      (PAGE-OUT-PIXEL-ARRAY BIT-ARRAY NIL
                                            (LIST WIDTH HEIGHT)))))
	     (COND ((SHEET-TEMPORARY-P)
		    (PAGE-IN-PIXEL-ARRAY TEMPORARY-BIT-ARRAY NIL
                                         (LIST WIDTH HEIGHT))
		    (BITBLT ALU-SETA WIDTH HEIGHT
                            TEMPORARY-BIT-ARRAY 0 0
                            SCREEN-ARRAY        0 0)
		    (PAGE-OUT-PIXEL-ARRAY TEMPORARY-BIT-ARRAY NIL
                                          (LIST WIDTH HEIGHT))
		    (DOLIST (SHEET TEMPORARY-WINDOWS-LOCKED)
		      (SHEET-RELEASE-TEMPORARY-LOCK SHEET SELF))
		    (SETQ TEMPORARY-WINDOWS-LOCKED NIL))
		   (T
		    (SELECTQ SCREEN-BITS-ACTION
		      (:NOOP)
		      (:CLEAN
		       (%DRAW-RECTANGLE WIDTH HEIGHT 0 0 ALU-ANDCA SELF))
		      (OTHERWISE
		       (FERROR
                         NIL
                         "~S is not a valid bit action" SCREEN-BITS-ACTION)))))
	(COND (Exploding-Momentary-Windows 
  	       (PREPARE-SHEET (SELF)
	         (LET* ((thickness 2)
			(rate 15)
			(DX (// (- WIDTH   right-shadow-width) 2.))
			(DY (// (- HEIGHT bottom-shadow-width) 2.))
			(LR-INC (MAX 1 (// DX RATE)))
			(TB-INC (MAX 1 (// DY RATE))))
		   
		   (DO* ((K 1 (+ K RATE))
			 (X1         (sheet-inside-left   self)  (+ X1 LR-INC))
			 (X2         (sheet-inside-right  self)  (- X2 LR-INC))
			 (Y1         (sheet-inside-top    self)  (+ Y1 TB-INC))
			 (Y2         (sheet-inside-bottom self)  (- Y2 TB-INC))
			 (MY-WIDTH   (- X2 X1)   (- X2 X1))
			 (MY-HEIGHT  (- Y2 Y1)   (- Y2 Y1))
			 (nothink   500     (min 5000 (+ nothink 300))))
			((OR (< X2 X1) (< Y2 Y1)))
		     (tv:without-interrupts
		       (TV:DRAW-RECTANGLE-INSIDE-CLIPPED
			 MY-WIDTH thickness  (+ X1 thickness) Y1 TV:ALU-XOR SELF)
		       (TV:DRAW-RECTANGLE-INSIDE-CLIPPED
			 thickness MY-HEIGHT X2 (+ Y1 thickness) TV:ALU-XOR SELF)	
		       (TV:DRAW-RECTANGLE-INSIDE-CLIPPED MY-WIDTH thickness  X1 Y2 TV:ALU-XOR SELF)
		       (TV:DRAW-RECTANGLE-INSIDE-CLIPPED thickness MY-HEIGHT X1 Y1 TV:ALU-XOR SELF))
		     
		     (DOTIMES (x nothink))
		     (tv:without-interrupts        
		       (TV:DRAW-RECTANGLE-INSIDE-CLIPPED
			 MY-WIDTH thickness  (+ X1 thickness) Y1 TV:ALU-XOR SELF)
		       (TV:DRAW-RECTANGLE-INSIDE-CLIPPED
			 thickness MY-HEIGHT X2 (+ Y1 thickness) TV:ALU-XOR SELF)
		       (TV:DRAW-RECTANGLE-INSIDE-CLIPPED MY-WIDTH thickness  X1 Y2 TV:ALU-XOR SELF)
		       (TV:DRAW-RECTANGLE-INSIDE-CLIPPED thickness MY-HEIGHT X1 Y1 TV:ALU-XOR SELF))
		     )))))
	     (SETQ EXPOSED-P NIL)
	     (AND REMOVE-FROM-SUPERIOR SUPERIOR
		  (SETF (SHEET-EXPOSED-INFERIORS SUPERIOR)
			(DELQ SELF (SHEET-EXPOSED-INFERIORS SUPERIOR))))
	     (IF (NULL BIT-ARRAY)
		 (SETQ OLD-SCREEN-ARRAY SCREEN-ARRAY SCREEN-ARRAY NIL)
		 (REDIRECT-ARRAY SCREEN-ARRAY (ARRAY-TYPE BIT-ARRAY)
				 (PIXEL-ARRAY-WIDTH  BIT-ARRAY)
				 (PIXEL-ARRAY-HEIGHT BIT-ARRAY)
				 BIT-ARRAY 0))
	     (SETF (SHEET-OUTPUT-HOLD-FLAG) 1)))
	  (REMOVE-FROM-SUPERIOR
	   (AND SUPERIOR
		(SETF (SHEET-EXPOSED-INFERIORS SUPERIOR)
		      (DELQ SELF (SHEET-EXPOSED-INFERIORS SUPERIOR))))))))
))
