;; -*- Mode:LISP; Package:USER; Base:10; Fonts:(MEDFNT HL12B Hl12BI) -*-

;1 This is an attempt to build the top level control for my version of the ldip input screen*
;1 it relies heavily on the Appaloosa work bench concept.*

;1 Page numbers on flavor components refer to the Lisp Machine Window System Manual, edition 1.1,*
;1 system version 95, dated August 1983.*

(tv:add-system-key #\C 'l-dip "2l-dip*" t)   ;1 makes l-dip available via <system>-c*

(DEFUN l-dip ()
  "2selects an l-dip constriant frame, creating if necessary*"
  (LET ((l-dip-p
          (LOOP for j from 0 below (ARRAY-LENGTH tv:previously-selected-windows)
                for window = (AREF tv:previously-selected-windows j)
                IF (EQ 'l-dip (TYPEP window))
                DO (SEND (SEND window ':process) ':reset)(RETURN window)
                finally (RETURN (MAKE-INSTANCE 'l-dip)))))
    (SEND l-dip-p ':select)))

(DEFFLAVOR l-dip
           ((top-level (MAKE-INSTANCE 'l-dip-top-level))
            (pop-up (MAKE-INSTANCE 'crs-temp    ;1 temporary pop up window*
                              ':edges '(50 50 220 95)
                              ':font-map '(fonts:hl12b)
                              ':label '(:top :string "INCLUDE"))))
           (tv:process-mixin                    ;1 page 40*
            tv:alias-for-inferiors-mixin        ;1 page 36*
            tv:inferiors-not-in-select-menu-mixin       ;1 page 37*
            tv:select-mixin                     ;1 page 32*
            tv:stream-mixin                     ;1 page 49*
            tv:label-mixin                      ;1 page 132*
            tv:window-with-typeout-mixin        ;1 page 214*
            tv:essential-mouse                  
            tv:bordered-constraint-frame-with-shared-io-buffer) ;1 page 143*
  :settable-instance-variables
  (:default-init-plist
    :process '(l-dip-top-level :regular-pdl-size 5000)
    :typeout-window '(tv:typeout-window-with-mouse-sensitive-items
                       :deexposed-typeout-action (:expose-for-typeout)
                       :item-type-alist
                       ((:equ :edit "LEFT BUTTON SELECTS THIS EQUATION FOR EDIT. RIGHT FOR MENU OF EXECUTE AND EDIT"
                              ("EDIT" :value :edit :documentation
                               "PASS THIS EQUATION TO THE EDITOR")
                              ("EXECUTE" :value :exec :documentation
                               "EXECUTE THIS EQUATION AND SAVE THE RESULTANT GRID"))
                        (:traverse :select "LEFT BUTTON SELECTS THE NAMED DESCRIPTOR FOR A TRAVERSE.
RIGHT BUTTON FOR MENU OF SELECT OR DELETE"
                                   ("SELECT" :value :select :documentation
                                    "PROCEED TO TRAVERSE LOCATION DEFINITION")
                                   ("DELETE" :value :delete :documentation
                                    "REMOVE THIS DEFINITION FROM THIS LIST"))))
    :save-bits ':delayed))

(DEFFLAVOR crs-temp ()
           ;1 this is the flavor for the pop up text input buffer window*
           (tv:temporary-shadow-borders-window-mixin
            tv:window))

(DEFFLAVOR crs-basic-graphics-pane ()
           (gwin:graphics-window-pane)
  :settable-instance-variables
  (:documentation :basic-flavor 2"not actually that basic, its gwin:graphics-window-pane with
 * 2the general methods for the surface modeler, this includes the first quadrant modifications"*))

(DEFFLAVOR crs-graphics ((gwin:dx-annot 50)
                         (gwin:dy-annot 50)
                         (gwin:v-font fonts:rtiny)
                         (gwin:h-font fonts:tiny)
                         (gwin:follower-window))
           (crs-basic-graphics-pane)
  :settable-instance-variables
  (:documentation :special-purpose "2This is gwin:graphics-window-pane, it is additionally*
  2defined here to permit the addition of deamons without corrupting the actual gwin window*"))

(DEFFLAVOR crs-graphics-follower ((gwin:global-window nil))
           (crs-basic-graphics-pane)
  :settable-instance-variables
  (:documentation :special-purpose "2This is gwin:graphics-window-pane, it is additionally*
  2defined here to permit the addition of deamons without corrupting the actual gwin window
  follower aludes to the connection between this window and the main window.*"))

(DEFFLAVOR crs-option ((tv:prompt-text " "))        ;1 default documentation source*
           ;1 this is the option-dynamic menu flavor*
           (tv:dynamic-item-list-mixin          ;1 page 185*
            tv:stream-mixin                     ;1 page 49*
            tv:command-menu-mixin               ;1 page 184*
            tv:basic-menu                       ;1 page 181*
            tv:borders-mixin                    ;1 page 130*
            tv:top-box-label-mixin              ;1 page 133*
            tv:scroll-stuff-on-off-mixin        ;1 page 127 *
            tv:basic-scroll-bar                 ;1 page 125*
            tv:menu)                            ;1 page 182*
  :settable-instance-variables)

(DEFMETHOD (crs-option :who-line-documentation-string) ()
  "2attempt at enhancing the documentation to include general instructions*"
  (COND ((SEND-SELF ':reverse-video-p)
         "** WARNING ** PLEASE CHOOSE FROM ANOTHER WINDOW")
        (tv:current-item
         (tv:menu-item-who-line-documentation tv:current-item))
        (t
         tv:prompt-text)))

(DEFMETHOD (crs-option :set-prompt-text) (txt)
  (SETQ tv:prompt-text txt))

(DEFMETHOD (crs-option :adjustable-size-p) nil)

(DEFMETHOD (crs-option :enable-scrolling-p) ()
  "2needs to decide if the number of entries in the menu is larger than there is room for and if
    so to enable the scrolling, following any change to the menu alist where the size might be
    exceeded a call to the method :decide-if-scrolling-necessary should be issued*"
  (> tv:total-rows tv:screen-rows))

(DEFFLAVOR crs-window ((tv:operation nil))
                       ;1this flavor is basicaly tv:window with the label box added but without graphics*
           (tv:stream-mixin                           ;1 page 49*
            tv:borders-mixin                          ;1 page 130*
            tv:box-label-mixin                        ;1 page 133*
            tv:label-mixin                            ;1 page 132*
            tv:delay-notification-mixin               ;1 page 157*
            tv:minimum-window)                        ;1 page 6*
  :settable-instance-variables
  (:default-init-plist
    :font-map '(fonts:hl12bi fonts:medfnt fonts:medfnb)
    :blinker-p nil))

(DEFMETHOD (crs-window :adjustable-size-p) nil)

(DEFMETHOD (crs-window :after :refresh) (&rest ignore)
  "2this after deamon is intended to draw the basic status data on the operation window*"
  (SEND self ':draw-rectangle 70 20 63 10 tv:alu-ior)
  (SEND self ':draw-rectangle 66 16 65 12 tv:alu-andca)
  (SEND self ':draw-rectangle 70 20 133 10 tv:alu-ior)
  (SEND self ':draw-rectangle 66 16 135 12 tv:alu-andca)
  (SEND-SELF ':set-cursorpos 5 (* 4 (SEND-SELF ':line-height)))
  (SEND-SELF ':line-out "ACTION :")
  (SEND-SELF ':string-out-centered
             (STRING-APPEND tv:operation)
             (tv:sheet-inside-left)
             (tv:sheet-inside-right))
  (SEND-SELF ':set-cursorpos 5 (* 7 (SEND-SELF ':line-height)))
  (SEND-SELF ':line-out "PROSPECT :")
  (SEND-SELF ':string-out-centered
             (STRING-APPEND (SEND (SEND (SEND tv:superior ':top-level)
                                        ':data-base)
                                  ':prospect))
             (tv:sheet-inside-left)
             (tv:sheet-inside-right))
  (SEND-SELF ':set-cursorpos 5 (* 10 (SEND-SELF ':line-height)))
  (SEND-SELF ':line-out "SYSTEM :")
  (SEND-SELF ':string-out-centered
             (STRING-APPEND (SEND (SEND (SEND tv:superior ':top-level)
                                        ':data-base)
                                  ':configuration))
             (tv:sheet-inside-left)
             (tv:sheet-inside-right)))

(DEFMETHOD (crs-window :who-line-documentation-string) ()
  "2basically a dummy function to bury the click right for .. msg*"
  (STRING-APPEND "O.K. I GIVE UP, YOU ARE CURRENTLY IN THE '" tv:operation
                 "' STATE; BUT PLEASE DON'T POINT THAT MOUSE AT ME !"))
        
(DEFMETHOD (crs-basic-graphics-pane :after :mouse-moves) (&rest ignore)
  "2this is supposed to update the world co-ordinates displayed in the operation frame each
    time the mouse moves in the graphics window pane*"
  (LET ((target (SEND (SEND tv:superior ':get-pane 'operation) ':screen-array))
        x-real y-real)
    (MULTIPLE-VALUE (x-real y-real) (SEND-SELF ':get-mouse-position))
    (MULTIPLE-VALUE (x-real y-real) (SEND-SELF ':untransform-point x-real y-real))
    (WHEN gwin:grid-on
      (MULTIPLE-VALUE (x-real y-real) (SEND-SELF ':gridify-point x-real y-real)))
    (PSETQ x-real (FORMAT nil "~D" x-real)
           y-real (FORMAT nil "~D" y-real))
    (tv:%draw-rectangle 67 16 67 31 tv:erase-aluf target)
    (tv:%draw-rectangle 67 16 136 31 tv:erase-aluf target)
    (LOOP for ch being THE array-elements of x-real
          with start-pos = (FIX (+ 68 (* 9 (- 3.5 (// (LENGTH x-real) 2.0)))))
          AND num-char = 0
          DO 
          (tv:draw-char fonts:medfnt ch (+ start-pos (* 9 num-char))
                        34 tv:alu-ior target)
          (SETQ num-char (1+ num-char)))
    (LOOP for ch being THE array-elements of y-real
          with start-pos = (FIX (+ 138 (* 9 (- 3.5 (// (LENGTH y-real) 2.0)))))
          AND num-char = 0
          DO 
          (tv:draw-char fonts:medfnt ch (+ start-pos (* 9 num-char))
                        34 tv:alu-ior target)
          (SETQ num-char (1+ num-char)))))

(DEFMETHOD (crs-basic-graphics-pane :draw-grid)
           (grid-obj &optional (alu tv:alu-xor) &rest IGNORE)
  "2This method draws a grid of dots corresponding to the grid spacing.of the supplied entity
    The grid covers the entire window area on the screen.*"
  (WHEN (TYPEP grid-obj 'crs-grid)
    (LET ((x-space (SEND grid-obj ':dx))
          (y-space (SEND grid-obj ':dy))
          (x-min (SEND grid-obj ':xmin))
          (y-min (SEND grid-obj ':ymin))
          (x-max (SEND grid-obj ':xmax))
          (y-max (SEND grid-obj ':ymax))
          (window-left (tv:sheet-inside-left))
          (window-right (tv:sheet-inside-right))
          (window-top  (tv:sheet-inside-top))
          (window-bottom (tv:sheet-inside-bottom)))
      
      (MULTIPLE-VALUE (window-left window-top)  ;1 left and top of grid in window ?*
        (SEND-SELF ':untransform-point window-left window-top))
      (SETQ window-left
            (MAX (+ (* (CEILING (- window-left x-min) x-space) x-space) x-min)
                 x-min)
            window-top
            (MIN (+ (* (FLOOR (- window-top y-min) y-space) y-space) y-min)
                 y-max))
      (MULTIPLE-VALUE (window-left window-top)
        (SEND-SELF ':transform-point window-left window-top))

      (MULTIPLE-VALUE (window-right window-bottom)      ;1 bottom and right of grid in window ?*
        (SEND-SELF ':untransform-point window-right window-bottom))
      (WHEN (> window-right x-max)
        (SETQ window-right x-max))
      (WHEN (< window-bottom y-min)
        (SETQ window-bottom y-min))
      (MULTIPLE-VALUE (window-right window-bottom)
        (SEND-SELF ':transform-point window-right window-bottom))

      (MULTIPLE-VALUE (x-space y-space)         ;1 convert grid deltas*
        (SEND-SELF ':transform-deltas x-space y-space))
      (SETQ y-space (ABS y-space))              ;1 comprehend 'loop' and grid origin*

      (tv:prepare-sheet (self)                  ;1 open blinker*
        (LET ((grid (MAKE-PIXEL-ARRAY (PIXEL-ARRAY-WIDTH tv:screen-array) 1.
                                      ':type (ARRAY-TYPE tv:screen-array))))
          (WHEN (AND (> x-space 3.)             ;1 any smaller and all screen black !*
                     (> y-space 3.))
            (LOOP for i from window-left to window-right by x-space
                  DO
                  (AS-2-REVERSE gwin:black grid (G-ROUND i) 0.))
            (LOOP for j from window-top to window-bottom by y-space
                  DO
                  (BITBLT alu window-right 1.
                          grid 0. 0. tv:screen-array 0. (G-ROUND j)))
            (RETURN-ARRAY (PROG1 grid (SETQ grid nil)))))))))

(DEFMETHOD (l-dip :before :init) (&rest IGNORE)
  "2define the panes and constraints for the l-dip frame*"
  (SETQ tv:superior tv:main-screen
        tv:panes
        `((operation crs-window
                     :operation "start"
                     :save-bits t
                     :deexposed-typeout-action :permit
                     :label
                     (:top :string "OPERATION" :font fonts:medfnt))
          
          (option crs-option
                  :item-list-pointer
                  (SEND (SEND (SEND self ':superior)
                              ':top-level) ':menu-list) ;1 page 186*
                  :scroll-bar t
                  :scroll-bar-always-displayed t 
                  :flashy-scrolling-region ((10 .25 .75)
                                            (10 .25 .75))
                  :margin-scroll-regions ((:top "top" "more above")
                                          (:bottom "bottom"
                                                   "more below"))
                  :geometry (1 nil nil nil nil nil)
                  :edges (50 50 500 500)
                  :font-map (fonts:bigfnt fonts:medfnt fonts:medfnb) 
                  :default-font fonts:bigfnt
                  :prompt-text
                "CHOOSE AN OPERATION FROM THE LIST, STRIKE 'HELP' FOR MORE INFOMATION"
                  :label
                  (:top :string "OPTION LIST" :font fonts:medfnt))
          
          (contour crs-option
                   :item-list-pointer nil       ;1 page 186*
                   :scroll-bar t
                   :scroll-bar-always-displayed t 
                   :flashy-scrolling-region ((10 .25 .75)
                                             (10 .25 .75))
                   :margin-scroll-regions ((:top "top" "more above")
                                           (:bottom "bottom"
                                                    "more below"))
                   :geometry (2 nil nil nil nil nil)
                   :edges (50 50 500 500)
                   :vsp 8
                   :font-map (fonts:medfnt fonts:medfnb fonts:bigfnt) 
                   :default-font fonts:medfnt
                   :label
                   (:top :string "SELECT AN ATTRIBUTE" :font fonts:medfnt))
          
          (name input-window
                :documentation-text
                "ENTER THE NAME OF THE NEW GRID"
                :label
                (:top :string "NAME" :font fonts:medfnt))
          
          (constant input-window
                    :documentation-text "ENTER A NUMERIC CONSTANT"
                    :reverse-video-p t
                    :label
                    (:top :string "CONSTANT" :font fonts:medfnt))
          
          (bracket tv:command-menu
                   :reverse-video-p t
                   :label
                   (:top :string "PENDING" :font fonts:medfnt)
                   :geometry (2 nil nil nil nil nil)
                   :default-font fonts:bigfnt
                   :item-list
                   (("[" :eval
                     (SEND
                       (SEND (SEND-SELF ':superior)
                             ':get-pane 'equ)
                       ':serial-add '[) :documentation
                     "LEFT PARENTHESIS")
                    ("]" :eval
                     (SEND
                       (SEND (SEND-SELF ':superior)
                             ':get-pane 'equ)
                       ':serial-add ']) :documentation
                     "RIGHT PARENTHESIS")))
          
          (operator tv:command-menu
                    :reverse-video-p t
                    :label
                    (:top :string "OPERATORS" :font fonts:medfnt)
                    :geometry (4 nil nil nil nil nil)
                    :default-font fonts:bigfnt
                    :item-list
                    (("+" :eval
                      (SEND
                        (SEND (SEND-SELF ':superior)
                              ':get-pane 'equ)
                        ':serial-add '+) :documentation
                      "ADD OR SUMMATE OPERATION")
                     ("//" :eval
                      (SEND
                        (SEND (SEND-SELF ':superior)
                              ':get-pane 'equ)
                        ':serial-add '//) :documentation
                      "DIVIDE OR QUOTIENT OPERATION")
                     ("*" :eval
                      (SEND
                        (SEND (SEND-SELF ':superior)
                              ':get-pane 'equ)
                        ':serial-add '*) :documentation
                      "MULTIPLY OR PRODUCT OPERATION")
                     ("-" :eval
                      (SEND
                        (SEND (SEND-SELF ':superior)
                              ':get-pane 'equ)
                        ':serial-add '-) :documentation
                      "SUBTRACT OR DIFFERENCE OPERATION")))
          
          (equ equation-edit)
          
          (cvv tv:choose-variable-values-pane
               :font-map (fonts:hl12bi fonts:medfnt fonts:medfnb) 
               :label
               (:string "VALUE MODIFY" :font fonts:medfnt)
               :scroll-bar t
               :scroll-bar-always-displayed t
               :vsp 8
               :name-font fonts:medfnt
               :value-font fonts:medfnt
               :string-font fonts:medfnt
               :unselected-choice-font fonts:medfnt
               :selected-choice-font fonts:medfnb
               :flashy-scrolling-region ((10 .25 .75)
                                         (10 .25 .75))
               :margin-scroll-regions ((:top "top" "more above")
                                       (:bottom "bottom"
                                                "more below"))
               :margin-choices nil)
          
          (world crs-graphics
                 :border-margin-width 1
                 :borders tv:draw-crs-border
                 :save-bits :delayed
                 :grid-on t
                 :grid-x 1
                 :grid-y 1)
          
          (view crs-graphics-follower
                :save-bits :delayed
                :grid-on t
                :grid-x 1
                :grid-y 1
                :min-nil-delta 0
                :prompt-text
                "THE SMALL WINDOW AT BOTTOM LEFT REPRESENTS THE ENTIRE PROSPECT,
           THE RECTANGLE REPRESENTS THAT AREAL EXTENT IN THE MAIN PANE.")
          
          (Modadd crs-return))
        
        tv:constraints
        '((main . ((world top-strip)
                   ((top-strip :horizontal (.25)
                               (view operation option)
                               ((view :even)
                                (operation :even)
                                (option :even)))
                    (world .75))))
          (ask . ((world above-strip)
                  ((above-strip :horizontal (.25)
                                (view cvv)
                                ((cvv .67)
                                 (view .33)))
                   (world .75))))
          (add2 . ((world over-strip)
                   ((over-strip :horizontal (.25)
                                (view modadd)
                                ((modadd .67)
                                 (view .33)))
                    (world .75))))
          (edit . ((upper-strip equ contour lower-strip)
                   ((upper-strip :horizontal (.1)
                                 (name constant bracket operator)
                                 ((name .3)
                                  (constant .2)
                                  (bracket .2)
                                  (operator .3)))
                    (equ .25)
                    (contour .4)
                    (lower-strip :horizontal (.25)
                                 (view operation option)
                                 ((view :even)
                                  (operation :even)
                                  (option :even))))))
          (cont . ((world over-strip)
                   ((over-strip :horizontal (.25)
                                (view contour)
                                ((contour .67)
                                 (view .33)))
                    (world .75)))))))

(DEFMETHOD (l-dip :after :init) (&rest IGNORE)
  "2intended to ensure that the graphics follower pane knows who to follow and the the
    followed pane knows who to tell. In addition sets up the assoc-control and data-volume
    variables in the data-base.*"
  (LET ((vew (SEND-SELF ':get-pane 'view))
        (wld (SEND-SELF ':get-pane 'world)))
    (SEND wld ':new-window
          0 0 (tv:sheet-inside-width wld) (tv:sheet-inside-height wld))
    (SEND vew ':set-global-window wld)
    (SEND wld ':set-follower-window vew)
    (SEND
      (SEND top-level ':data-base)
      ':set-assoc-control top-level)
    (SEND
      (SEND top-level ':data-base)
      ':set-data-volume
      (SEND wld ':world))
    (SEND tv:typeout-window ':set-io-buffer tv:io-buffer)
    (SEND wld ':add-cursor
          'crs-sprite-cursor
          ':visibility nil                      ;1 make sprite blinkers*
          ':window wld
          ':x-offset 6
          ':y-offset 6
          ':height 12
          ':width 12
          ':array
          (FILLARRAY
            (MAKE-ARRAY '(12. 32.) ':type 'art-1b)
              '(1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)))
    (SEND vew ':set-cursor-list
          (list
            (MAKE-INSTANCE
              'crs-sprite-cursor
              ':visibility nil                  ;1 make sprite blinkers*
              ':window vew
              ':x-offset 5
              ':y-offset 5
              ':height 10
              ':width 10
              ':array
              (FILLARRAY
                (MAKE-ARRAY '(10. 32.) ':type 'art-1b)
                  '(1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                    0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                    1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                    0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                    0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                    0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                    0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                    1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                    0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                    1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)))
            (MAKE-INSTANCE
              'crs-sprite-cursor
              ':visibility nil
              ':window vew
              ':x-offset 5
              ':y-offset 5
              ':height 10
              ':width 10
              ':array
              (FILLARRAY
                (MAKE-ARRAY '(10. 32.) ':type 'art-1b)
                  '(1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                    0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                    0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                    0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                    0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                    0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                    0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                    0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                    0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                    1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)))))))

(DEFMETHOD (l-dip :name-for-selection) () tv:name)  ;1for select mixin *

(DEFMETHOD (l-dip :io-buffer) () tv:io-buffer)  ; 1who knows ??*

(DEFUN l-dip-top-level (constraint-frame)
  "2runs the top level of constraint-frame, function for the process mixin*"
  (SEND (SEND constraint-frame ':top-level) ':l-dip-top-level constraint-frame))

(COMPILE-FLAVOR-METHODS l-dip
                        crs-temp
                        crs-option
                        crs-window)
;