;;; -*- Mode: LISP;  Package: TV; Base: 8; Fonts: (CPTFONT CPTFONTB HL12BI) -*-

(DEFMETHOD (SHEET :EXPOSE)
           (&OPTIONAL INHIBIT-BLINKERS BITS-ACTION (X X-OFFSET) (Y Y-OFFSET)
            &AUX (OLD-INHIBIT-SCHEDULING-FLAG INHIBIT-SCHEDULING-FLAG)
            (INHIBIT-SCHEDULING-FLAG T) SUPERIOR-HAS-SCREEN-ARRAY
            OK ERROR)
  "Expose a sheet (place it on the physical screen)."
  (PROG ()
	(SETQ RESTORED-BITS-P T)
	(OR BITS-ACTION (SETQ BITS-ACTION (IF BIT-ARRAY ':RESTORE ':CLEAN)))
	(AND EXPOSED-P (RETURN NIL))
	(SETQ RESTORED-BITS-P NIL)
	(SETQ SUPERIOR-HAS-SCREEN-ARRAY (OR (NULL SUPERIOR)
                                            (SHEET-SCREEN-ARRAY SUPERIOR)))
	(MULTIPLE-VALUE (OK BITS-ACTION ERROR)
	  (SHEET-PREPARE-FOR-EXPOSE SELF T INHIBIT-BLINKERS BITS-ACTION X Y))
	(OR OK (*THROW 'SHEET-ABORT-EXPOSE ERROR))
	;; Have made our area of the screen safe for us.  We'll now call
        ;; ourselves "exposed", even though we haven't put our bits on
        ;; the screen at all.  This will win, because we have ourself
        ;; locked, and if someone wants to cover us he'll have to go
        ;; blocked until we are done -- it's a cretinous thing to have
        ;; happen, but the system shouldn't come crashing to the ground
        ;; because of it.
        ;; *** INHIBIT-SCHEDULING-FLAG had better still be T ***
	(OR INHIBIT-SCHEDULING-FLAG
	    (FERROR
              NIL
              "Hairy part of expose finished with INHIBIT-SCHEDULING-FLAG off"))
	;; Lie by saying that we are exposed, because we aren't really,
        ;; but we are locked so it doesn't matter.
	(AND SUPERIOR-HAS-SCREEN-ARRAY (SETQ EXPOSED-P T PREPARED-SHEET NIL))
	(AND SUPERIOR
	     (OR (NOT (MEMQ SELF (SHEET-EXPOSED-INFERIORS SUPERIOR)))
		 ;; Must always reorder in the case of temporary windows
                 ;; since they are the only type of window that can be
                 ;; exposed and overlapping some other exposed window.
		 (SHEET-TEMPORARY-P))
	     (SHEET-CONSING
               ;; Put us at the top.
	       (SETF (SHEET-EXPOSED-INFERIORS SUPERIOR)
		     (CONS SELF (COPYLIST
                                  (DELQ SELF
                                        (SHEET-EXPOSED-INFERIORS SUPERIOR)))))))
	(COND ((AND SUPERIOR-HAS-SCREEN-ARRAY BIT-ARRAY)
	       (SETF (SHEET-OUTPUT-HOLD-FLAG) 0)
	       ;; Open all our blinkers, etc, but don't think this sheet
               ;; is prepared.
	       (PREPARE-SHEET (SELF) )
	       (SETQ PREPARED-SHEET NIL)
	       (LET ((ARRAY (IF SUPERIOR
				(SHEET-SUPERIOR-SCREEN-ARRAY)
				(SCREEN-BUFFER SELF))))
		 (REDIRECT-ARRAY SCREEN-ARRAY (ARRAY-TYPE SCREEN-ARRAY)
				 (PIXEL-ARRAY-WIDTH ARRAY)
				 (PIXEL-ARRAY-HEIGHT SCREEN-ARRAY)
				 ARRAY
				 (+ X-OFFSET (* Y-OFFSET
						(PIXEL-ARRAY-WIDTH ARRAY))))))
	      (SUPERIOR-HAS-SCREEN-ARRAY
	       (SETQ SCREEN-ARRAY OLD-SCREEN-ARRAY)
	       (SETF (SHEET-OUTPUT-HOLD-FLAG) 0)))
	(COND ((AND SUPERIOR-HAS-SCREEN-ARRAY (SHEET-TEMPORARY-P))
	       (IF (EQ TEMPORARY-BIT-ARRAY T)
		   (SETQ TEMPORARY-BIT-ARRAY
			 (MAKE-PIXEL-ARRAY
                           (LOGAND -40 (+ 37 WIDTH)) HEIGHT
                           ':TYPE (SHEET-ARRAY-TYPE SELF)))
		   (PAGE-IN-PIXEL-ARRAY
                     TEMPORARY-BIT-ARRAY NIL (LIST WIDTH HEIGHT)))
	       (BITBLT ALU-SETA WIDTH HEIGHT
                       SCREEN-ARRAY 0 0
                       TEMPORARY-BIT-ARRAY 0 0)
	       (PAGE-OUT-PIXEL-ARRAY
                 TEMPORARY-BIT-ARRAY NIL (LIST WIDTH HEIGHT))))
	(DOLIST (SHEET *SHEETS-MADE-INVISIBLE-TO-MOUSE*)
	  (SETF (SHEET-INVISIBLE-TO-MOUSE-P SHEET) NIL))
	(SETQ *SHEETS-MADE-INVISIBLE-TO-MOUSE* NIL)
	(COND (Exploding-Momentary-Windows
		    
	       (LET* ((thickness 2)
		      (rate 4)
		      (spin-rate 30)
		      (DX (// width 2)) ;(// (- WIDTH   right-shadow-width) 2.))
		      (DY (// height 2)) ;(// (- HEIGHT bottom-shadow-width) 2.))
		      (LR-INC (MAX 1 (// DX RATE)))
		      (TB-INC (MAX 1 (// DY RATE))))
		 (prepare-sheet (self)
		   (DO* ((K 1 (+ K rate))
			 (X1         (- (+ DX (sheet-inside-left self))  right-margin-size)
				     (- X1 LR-INC))
			 (X2         X1        (+ X2 LR-INC))
			 (Y1         (- (+ DY (sheet-inside-top  self)) bottom-margin-size)
				     (- Y1 TB-INC))
			 (Y2         Y1        (+ Y2 TB-INC))
			 (MY-WIDTH   thickness (- X2 X1))
			 (MY-HEIGHT  thickness (- Y2 Y1))
			 (NOTHINK   5000     (MAX 1000 (- NOTHINK 300))))
			((OR (>=    MY-WIDTH   (- width thickness)) ;(- WIDTH  right-shadow-width thickness))
			     (>=    MY-HEIGHT  HEIGHT)))
		     
		     (let ((avey (// (+ y1 y2) 2)))
		       (loop for y-loop from 0 to  pi  by (// pi spin-rate)
			     for nw-x1 from x1 downto (- x1 lr-inc) by (// (float lr-inc) spin-rate)
			     for nw-x2 from x2 to (+ x2 lr-inc) by (// (float lr-inc) spin-rate)
			     for nw-y1 from y1 downto (- y1 tb-inc) by (// (float tb-inc) spin-rate)
			     do (let* ((sep (* (- 1 (sin y-loop)) (- avey nw-y1)))
				       (new-x1 (fix nw-x1))
				       (new-x2 (fix nw-x2))
				       (new-y1 (fix (- avey sep)))
				       (new-y2 (fix (+ avey sep)))
				       ;(far-width (* my-width (// sep (- avey y1))))
				       (my-new-height (- new-y2 new-y1))
				       (my-new-width (- new-x2 new-x1)))
			    
				     (tv:without-interrupts
				(TV:DRAW-RECTANGLE-INSIDE-CLIPPED
				  MY-new-WIDTH thickness  (+ NEW-X1 thickness) NEW-Y1 TV:ALU-XOR self)
				(TV:DRAW-RECTANGLE-INSIDE-CLIPPED
				  thickness MY-new-HEIGHT NEW-X2 (+ NEW-Y1 thickness) TV:ALU-XOR self)	
				(TV:DRAW-RECTANGLE-INSIDE-CLIPPED MY-new-WIDTH thickness  NEW-X1 NEW-Y2 TV:ALU-XOR self)
				(TV:DRAW-RECTANGLE-INSIDE-CLIPPED thickness MY-new-HEIGHT NEW-X1 NEW-Y1 TV:ALU-XOR self)
				
				(DOTIMES (x nothink))
				
				(TV:DRAW-RECTANGLE-INSIDE-CLIPPED
				  MY-new-WIDTH thickness  (+ NEW-X1 thickness) NEW-Y1 TV:ALU-XOR self)
				(TV:DRAW-RECTANGLE-INSIDE-CLIPPED
				  thickness MY-new-HEIGHT NEW-X2 (+ NEW-Y1 thickness) TV:ALU-XOR self)
				(TV:DRAW-RECTANGLE-INSIDE-CLIPPED MY-new-WIDTH thickness  NEW-X1 NEW-Y2 TV:ALU-XOR self)
				(TV:DRAW-RECTANGLE-INSIDE-CLIPPED thickness MY-new-HEIGHT NEW-X1 NEW-Y1 TV:ALU-XOR self)
				))))
			  
		     )))))
	(MOUSE-DISCARD-CLICKAHEAD)
	(MOUSE-WAKEUP)
	;; This goes after preceeding code so that blinkers won't accidentally
	;; turn on before the bits get BITBLT'ed into the temporary array.
	(SETQ INHIBIT-SCHEDULING-FLAG OLD-INHIBIT-SCHEDULING-FLAG)
	(COND (SUPERIOR-HAS-SCREEN-ARRAY
	       (SELECTQ BITS-ACTION
		 (:NOOP NIL)
		 (:RESTORE
		  (FUNCALL-SELF ':REFRESH ':USE-OLD-BITS))
		 (:CLEAN
		  (SHEET-HOME SELF)
		  (FUNCALL-SELF ':REFRESH ':COMPLETE-REDISPLAY))
		 (OTHERWISE
		  (FERROR NIL "Unknown BITS-ACTION ~S" BITS-ACTION)))
	       (OR INHIBIT-BLINKERS
		   (DESELECT-SHEET-BLINKERS SELF))
	       (OR BIT-ARRAY
		   ;; Expose in opposite order for the sake of temporary windows
		   (DOLIST (INFERIOR (REVERSE EXPOSED-INFERIORS))
		     (FUNCALL INFERIOR ':EXPOSE NIL)))
	       (RETURN T)))))

(DEFMETHOD (momentary-menu :expose) 
           (&OPTIONAL INHIBIT-BLINKERS BITS-ACTION (X X-OFFSET) (Y Y-OFFSET)
            &AUX (OLD-INHIBIT-SCHEDULING-FLAG INHIBIT-SCHEDULING-FLAG)
            (INHIBIT-SCHEDULING-FLAG T) SUPERIOR-HAS-SCREEN-ARRAY
            OK ERROR)
  "2Expose a sheet (place it on the physical screen).*"
  (PROG ()
	(SETQ RESTORED-BITS-P T)
	(OR BITS-ACTION (SETQ BITS-ACTION (IF BIT-ARRAY ':RESTORE ':CLEAN)))
	(AND EXPOSED-P (RETURN NIL))
	(SETQ RESTORED-BITS-P NIL)
	(SETQ SUPERIOR-HAS-SCREEN-ARRAY (OR (NULL SUPERIOR)
                                            (SHEET-SCREEN-ARRAY SUPERIOR)))
	(MULTIPLE-VALUE (OK BITS-ACTION ERROR)
	  (SHEET-PREPARE-FOR-EXPOSE SELF T INHIBIT-BLINKERS BITS-ACTION X Y))
	(OR OK (*THROW 'SHEET-ABORT-EXPOSE ERROR))
	;; Have made our area of the screen safe for us.  We'll now call
        ;; ourselves "exposed", even though we haven't put our bits on
        ;; the screen at all.  This will win, because we have ourself
        ;; locked, and if someone wants to cover us he'll have to go
        ;; blocked until we are done -- it's a cretinous thing to have
        ;; happen, but the system shouldn't come crashing to the ground
        ;; because of it.
        ;; *** INHIBIT-SCHEDULING-FLAG had better still be T ***
	(OR INHIBIT-SCHEDULING-FLAG
	    (FERROR
              NIL
              "Hairy part of expose finished with INHIBIT-SCHEDULING-FLAG off"))
	;; Lie by saying that we are exposed, because we aren't really,
        ;; but we are locked so it doesn't matter.
	(AND SUPERIOR-HAS-SCREEN-ARRAY (SETQ EXPOSED-P T PREPARED-SHEET NIL))
	(AND SUPERIOR
	     (OR (NOT (MEMQ SELF (SHEET-EXPOSED-INFERIORS SUPERIOR)))
		 ;; Must always reorder in the case of temporary windows
                 ;; since they are the only type of window that can be
                 ;; exposed and overlapping some other exposed window.
		 (SHEET-TEMPORARY-P))
	     (SHEET-CONSING
               ;; Put us at the top.
	       (SETF (SHEET-EXPOSED-INFERIORS SUPERIOR)
		     (CONS SELF (COPYLIST
                                  (DELQ SELF
                                        (SHEET-EXPOSED-INFERIORS SUPERIOR)))))))
	(COND ((AND SUPERIOR-HAS-SCREEN-ARRAY BIT-ARRAY)
	       (SETF (SHEET-OUTPUT-HOLD-FLAG) 0)
	       ;; Open all our blinkers, etc, but don't think this sheet
               ;; is prepared.
	       (PREPARE-SHEET (SELF) )
	       (SETQ PREPARED-SHEET NIL)
	       (LET ((ARRAY (IF SUPERIOR
				(SHEET-SUPERIOR-SCREEN-ARRAY)
				(SCREEN-BUFFER SELF))))
		 (REDIRECT-ARRAY SCREEN-ARRAY (ARRAY-TYPE SCREEN-ARRAY)
				 (PIXEL-ARRAY-WIDTH ARRAY)
				 (PIXEL-ARRAY-HEIGHT SCREEN-ARRAY)
				 ARRAY
				 (+ X-OFFSET (* Y-OFFSET
						(PIXEL-ARRAY-WIDTH ARRAY))))))
	      (SUPERIOR-HAS-SCREEN-ARRAY
	       (SETQ SCREEN-ARRAY OLD-SCREEN-ARRAY)
	       (SETF (SHEET-OUTPUT-HOLD-FLAG) 0)))
	(COND ((AND SUPERIOR-HAS-SCREEN-ARRAY (SHEET-TEMPORARY-P))
	       (IF (EQ TEMPORARY-BIT-ARRAY T)
		   (SETQ TEMPORARY-BIT-ARRAY
			 (MAKE-PIXEL-ARRAY
                           (LOGAND -40 (+ 37 WIDTH)) HEIGHT
                           ':TYPE (SHEET-ARRAY-TYPE SELF)))
		   (PAGE-IN-PIXEL-ARRAY
                     TEMPORARY-BIT-ARRAY NIL (LIST WIDTH HEIGHT)))
	       (BITBLT ALU-SETA WIDTH HEIGHT
                       SCREEN-ARRAY 0 0
                       TEMPORARY-BIT-ARRAY 0 0)
	       (PAGE-OUT-PIXEL-ARRAY
                 TEMPORARY-BIT-ARRAY NIL (LIST WIDTH HEIGHT))))
	(DOLIST (SHEET *SHEETS-MADE-INVISIBLE-TO-MOUSE*)
	  (SETF (SHEET-INVISIBLE-TO-MOUSE-P SHEET) NIL))
	(SETQ *SHEETS-MADE-INVISIBLE-TO-MOUSE* NIL)
	(COND (Exploding-Momentary-Windows
		    
	       (LET* ((thickness 2)
		      (rate 4)
		      (spin-rate 30)
		      (DX (// (- WIDTH   right-shadow-width) 2.))
		      (DY (// (- HEIGHT bottom-shadow-width) 2.))
		      (LR-INC (MAX 1 (// DX RATE)))
		      (TB-INC (MAX 1 (// DY RATE))))
		 (prepare-sheet (self)
		   (DO* ((K 1 (+ K rate))
			 (X1         (- (+ DX (sheet-inside-left self))  right-margin-size)
				     (- X1 LR-INC))
			 (X2         X1        (+ X2 LR-INC))
			 (Y1         (- (+ DY (sheet-inside-top  self)) bottom-margin-size)
				     (- Y1 TB-INC))
			 (Y2         Y1        (+ Y2 TB-INC))
			 (MY-WIDTH   thickness (- X2 X1))
			 (MY-HEIGHT  thickness (- Y2 Y1))
			 (NOTHINK   5000     (MAX 1000 (- NOTHINK 300))))
			((OR (>=    MY-WIDTH   (- width right-shadow-width thickness)) 
			     (>=    MY-HEIGHT  HEIGHT)))
		     
		     (let ((avey (// (+ y1 y2) 2)))
		       (loop for y-loop from 0 to  pi  by (// pi spin-rate)
			     for nw-x1 from x1 downto (- x1 lr-inc) by (// (float lr-inc) spin-rate)
			     for nw-x2 from x2 to (+ x2 lr-inc) by (// (float lr-inc) spin-rate)
			     for nw-y1 from y1 downto (- y1 tb-inc) by (// (float tb-inc) spin-rate)
			     do (let* ((sep (* (- 1 (sin y-loop)) (- avey nw-y1)))
				       (new-x1 (fix nw-x1))
				       (new-x2 (fix nw-x2))
				       (new-y1 (fix (- avey sep)))
				       (new-y2 (fix (+ avey sep)))
				       ;(far-width (* my-width (// sep (- avey y1))))
				       (my-new-height (- new-y2 new-y1))
				       (my-new-width (- new-x2 new-x1)))
			    
				     (tv:without-interrupts
				(TV:DRAW-RECTANGLE-INSIDE-CLIPPED
				  MY-new-WIDTH thickness  (+ NEW-X1 thickness) NEW-Y1 TV:ALU-XOR self)
				(TV:DRAW-RECTANGLE-INSIDE-CLIPPED
				  thickness MY-new-HEIGHT NEW-X2 (+ NEW-Y1 thickness) TV:ALU-XOR self)	
				(TV:DRAW-RECTANGLE-INSIDE-CLIPPED MY-new-WIDTH thickness  NEW-X1 NEW-Y2 TV:ALU-XOR self)
				(TV:DRAW-RECTANGLE-INSIDE-CLIPPED thickness MY-new-HEIGHT NEW-X1 NEW-Y1 TV:ALU-XOR self)
				
				(DOTIMES (x nothink))
				
				(TV:DRAW-RECTANGLE-INSIDE-CLIPPED
				  MY-new-WIDTH thickness  (+ NEW-X1 thickness) NEW-Y1 TV:ALU-XOR self)
				(TV:DRAW-RECTANGLE-INSIDE-CLIPPED
				  thickness MY-new-HEIGHT NEW-X2 (+ NEW-Y1 thickness) TV:ALU-XOR self)
				(TV:DRAW-RECTANGLE-INSIDE-CLIPPED MY-new-WIDTH thickness  NEW-X1 NEW-Y2 TV:ALU-XOR self)
				(TV:DRAW-RECTANGLE-INSIDE-CLIPPED thickness MY-new-HEIGHT NEW-X1 NEW-Y1 TV:ALU-XOR self)
				))))
			  
		     )))))
        (MOUSE-DISCARD-CLICKAHEAD)
	(MOUSE-WAKEUP)
	;; This goes after preceeding code so that blinkers won't accidentally
	;; turn on before the bits get BITBLT'ed into the temporary array.
	(SETQ INHIBIT-SCHEDULING-FLAG OLD-INHIBIT-SCHEDULING-FLAG)
	(COND (SUPERIOR-HAS-SCREEN-ARRAY
	       (SELECTQ BITS-ACTION
		 (:NOOP NIL)
		 (:RESTORE
		  (FUNCALL-SELF ':REFRESH ':USE-OLD-BITS))
		 (:CLEAN
		  (SHEET-HOME SELF)
		  (FUNCALL-SELF ':REFRESH ':COMPLETE-REDISPLAY))
		 (OTHERWISE
		  (FERROR NIL "Unknown BITS-ACTION ~S" BITS-ACTION)))
	       (OR INHIBIT-BLINKERS
		   (DESELECT-SHEET-BLINKERS SELF))
	       (OR BIT-ARRAY
		   ;; Expose in opposite order for the sake of temporary windows
		   (DOLIST (INFERIOR (REVERSE EXPOSED-INFERIORS))
		     (FUNCALL INFERIOR ':EXPOSE NIL)))
	       (RETURN T)))))