;;; -*- Mode: LISP; Package: USER; Base: 10 -*-


(DEFUN TILE (TILE-STREAM TILE-FUN TILE-WIDTH TILE-HEIGHT)
  ;; TILE-FUN should take five args. The first two are the coordinates
  ;; of the top left corner of the box.  The third is the stream to
  ;; which it is to draw. The last two are the tile-width and
  ;; tile-height, into which the tile should try to fit itself. If
  ;; it ignores these args, an upper left corner of what it draws will
  ;; be the tile.
  ;; Then we just BITBLT this.
  (LET* ((S-WIDTH (SEND TILE-STREAM ':WIDTH))
	 (S-HEIGHT (SEND TILE-STREAM ':HEIGHT))
	 (ACROSS (// S-WIDTH TILE-WIDTH))
	 (DOWN   (// S-HEIGHT TILE-HEIGHT)))
    (SEND TILE-STREAM ':REFRESH)
    (APPLY TILE-FUN (LIST 0 0 TILE-STREAM TILE-WIDTH TILE-HEIGHT))
    (DOTIMES (I ACROSS)
      (DOTIMES (J DOWN)
	(SEND TILE-STREAM ':BITBLT-WITHIN-SHEET TV:ALU-SETA
	      TILE-WIDTH TILE-HEIGHT
	      0 0 (* I TILE-WIDTH) (* J TILE-HEIGHT))))))

(DEFUN BULLS-EYE (X Y STREAM &OPTIONAL TW TH (RADIUS 50))
  (LOOP FOR R FROM 10 TO RADIUS BY 10 DO
	(SEND STREAM ':DRAW-FILLED-IN-CIRCLE (+ X RADIUS) (+ Y RADIUS) R TV:ALU-XOR)))

(DEFUN PAREN-GLYPH (X Y STREAM &OPTIONAL TW TH (RADIUS 50))
  (LOOP FOR R FROM RADIUS DOWNTO 10 BY 5 AND
	FOR CENTER FROM (+ X RADIUS) DOWNTO (+ X 5) BY 5 DO
	(SEND STREAM ':DRAW-FILLED-IN-CIRCLE CENTER (+ Y RADIUS) R TV:ALU-XOR)))

(DEFUN BULLS-EYE-R (X Y STREAM &OPTIONAL TW TH)
  (LET ((RADIUS (// TW 2)))
    (LOOP FOR R FROM 10 TO RADIUS BY 10 DO
	  (SEND STREAM ':DRAW-FILLED-IN-CIRCLE (+ X RADIUS) (+ Y RADIUS) R TV:ALU-XOR))))

(DEFUN PAREN-GLYPH-R (X Y STREAM &OPTIONAL TW TH)
  (LET ((RADIUS (// TW 2)))
    (LOOP FOR R FROM RADIUS DOWNTO 10 BY 5 AND
	  FOR CENTER FROM (+ X RADIUS) DOWNTO (+ X 5) BY 5 DO
	  (SEND STREAM ':DRAW-FILLED-IN-CIRCLE CENTER (+ Y RADIUS) R TV:ALU-XOR))))

(DEFVAR POLY-SIDES 6)

(DEFUN POLY-R (X1 Y1 STREAM &OPTIONAL TW TH (N POLY-SIDES))
 (LET* ((TW (IF TW TW 100))
	  (X1 (IF (ZEROP X1) (// TW 4)))
	  (X2 (- TW X1))
	  (Y2 Y1))
   (LOOP UNTIL (LESSP X2 X1) DO
	   (SEND STREAM ':DRAW-REGULAR-POLYGON X1 Y1 X2 Y2 N TV:ALU-XOR)
	   (SETQ X1 (+ X1 5))
	   (SETQ X2 (- X2 5)))))

(DEFUN SWEEP-CLOCK (WINDOW X Y RADIUS)
  (SEND WINDOW ':REFRESH)
  (SEND WINDOW ':DRAW-CIRCLE X Y (ADD1 RADIUS))
  (LET ((THETA 0) OLD-THETA (ALU-LIST (LIST TV:ALU-SETA TV:ALU-ANDCA)))
    (LOOP FOR I FROM 1 DO
	  (SETQ OLD-THETA THETA)
	  (SETQ THETA  (* 2 PI (// (REMAINDER (TIME) 3600) 3600.0)))
	  (SETQ ALU-LIST (DRAW-PIE-SLICE WINDOW X Y RADIUS (// OLD-THETA PI2) (// THETA PI2) ALU-LIST))
	  (PROCESS-SLEEP 1))))

(DEFUN DRAW-PIE-SLICE (WINDOW X Y RADIUS THETA1 THETA2 ALU-LIST)
  (SETQ THETA1 (* PI2 THETA1))
  (SETQ THETA2 (* PI2 THETA2))
  (LET* ((CROSS-NORTH (> THETA1 THETA2))
	 (THETA1 (- PI//2 THETA1))
	 (THETA2 (- PI//2 THETA2)))
    (COND (CROSS-NORTH
	   (SEND WINDOW ':DRAW-FILLED-IN-SECTOR X Y RADIUS THETA1 PI//2 (FIRST ALU-LIST))
	   (SEND WINDOW ':DRAW-FILLED-IN-SECTOR X Y RADIUS PI//2 THETA2 (SECOND ALU-LIST))
	   (LIST (SECOND ALU-LIST) (FIRST ALU-LIST)))
	  (T (SEND WINDOW ':DRAW-FILLED-IN-SECTOR X Y RADIUS THETA1 THETA2 (FIRST ALU-LIST))
	     ALU-LIST))))

(DEFVAR PI 3.14159265)

(DEFVAR PI//2 (// PI 2))

(DEFVAR PI2 (* 2 PI))

(DEFUN SEG-HACK (VECTORS WINDOW &OPTIONAL (WIDTH (SEND WINDOW ':WIDTH)) (HEIGHT (SEND WINDOW ':HEIGHT)))
  ;; Like the stuff in the demos, birds, escher, godel, etc.
  ;; But look how trivial!
  (SEND WINDOW ':REFRESH)
  (LET ((SEGS (MAPCAR (FUNCTION (LAMBDA (V) (LIST (LIST (ABS (* (CAR V) 100)) (ABS (* (CADR V) 100))) V)))
		      VECTORS))
	S1)
    (LOOP FOR I FROM 1 DO
	  (SETQ SEGS (MAPCAR (FUNCTION (LAMBDA (S) (UPDATE-SEG S WIDTH HEIGHT))) SEGS))
	  ;; Note that extract-points takes a boolean telling it whether to add the first
	  ;; point at the last for a closed curve.
	  (APPLY WINDOW (APPEND (LIST ':DRAW-LINES TV:ALU-XOR) (EXTRACT-POINTS SEGS T))))))


(DEFUN UPDATE-SEG (SEG WIDTH HEIGHT)
  ;; SEG is of the form ((xpos ypos)(xvelocity yvelocity))
  ;; Note that I am hoping that the windows will take care of clipping for me.
  (LET* ((XVEL (FIRST (SECOND SEG)))
	 (YVEL (SECOND (SECOND SEG)))
	 (XPOS (PLUS (FIRST  (FIRST SEG)) XVEL))
	 (YPOS (PLUS (SECOND (FIRST SEG)) YVEL)))
    (IF (OR (< XPOS 0) (> XPOS WIDTH)) (SETQ XVEL (MINUS XVEL)))
    (IF (OR (< YPOS 0) (> YPOS HEIGHT)) (SETQ YVEL (MINUS YVEL)))
    (LIST (LIST XPOS YPOS) (LIST XVEL YVEL))))

(DEFUN EXTRACT-POINTS (SEGS WRAP?)
  (SETQ SEGS (MAPCAN (FUNCTION (LAMBDA (A) (COPYLIST* (CAR A)))) SEGS))
  (IF (NOT WRAP?) SEGS (NCONC SEGS (LIST (CAR SEGS) (CADR SEGS)))))