/*
 * funcall.c
 *
 * function calling and returns
 */

#include "funcall.h"

#include "exploiter.h"
#include "context.h"
#include "memory.h"
#include "utils.h"

#include <stdio.h>
#include <stdlib.h>

static int stack_level = 0;

#define MAX_STACK_LEVEL 256
lisp_q saved_pdl_pointers[MAX_STACK_LEVEL];

int uentry_008(int args)
{
    lisp_q retval;
    lisp_q value;
    int i;

    retval = DTP_LIST | ADDRESS(allocate_list_qs(C_NIL, args));

    for (i = 0; i < (args - 1); i++) {
	value = CDR_NEXT | NOT_CDRCODE(memread(context.arg_pointer + i));
	dump_q(value, i);
	memwrite(retval + i, value);
    }

    value = CDR_NIL | NOT_CDRCODE(memread(context.arg_pointer + i));
    dump_q(value, i);
    memwrite(retval + i, value);

    return_1(retval);
}

void set_function(lisp_q fun)
{
    context.function = fun;
    context.location_counter = (memread(fun) & 0x3ff) << 1;

    printf("entering function:\n");
    dump_raw_fef(fun);
}

void create_frame_locals(int num_locals)
{
    printf("establishing local frame:\n");
    context.local_pointer = context.pdl_pointer;

    while(num_locals--) {
	push_cdrnext(C_NIL);
    }

    saved_pdl_pointers[stack_level - 1] = context.pdl_pointer;
}

void save_outbound_call_frame(void)
{
    push(context.call_info);
    push(context.arg_pointer);
    push(context.local_pointer);
    push(context.function);
    push(DTP_FIX | context.location_counter);

    printf("Calling level %d.\n", ++stack_level);
}

void dump_call_args(lisp_q arg_pointer, int num_args)
{
    int i;

    for (i = 0; i < num_args; i++) {
	dump_q(memread(arg_pointer + i), num_args);
    }
}

void restore_call_frame(void)
{
    lisp_q saved_arg_pointer;

    if (context.call_info & CI_BINDINGBLOCK) {
	unbind_block();
    }

    printf("old call_info: 0x%08lx.\n", context.call_info);

    saved_arg_pointer = context.arg_pointer;
    context.pdl_pointer = context.local_pointer;

    context.location_counter = ADDRESS(pop());
    context.function = pop();
    context.local_pointer = pop();
    context.arg_pointer = pop();
    context.call_info = pop();

    context.pdl_pointer = saved_arg_pointer;

    printf("Returning level %d to: ", stack_level--);
/*     dump_string(memread_inviz(memread_inviz(memread_inviz(context.function+2)+2)+SYM_PRINTNAME)); */
    dump_function_name(context.function);
}

#define CT_OPTIONALS  1
#define CT_LOCALS     2
#define CT_REST       4
#define CT_LONGARGS   8
#define CT_UNUSED    16

int call_types[8] = {
    0, 1, 2, 4, 3, 5, 16, 8
};

int arg_parse(lisp_q function, lisp_q fef_header, lisp_q call_info, int call_type, int num_args, lisp_q *rest, int *num_locals)
{
    int num_required;
    int num_optional;
    int want_rest;
    int want_optionals;
    int supplied_optionals;
    lisp_q longargs;

    /* FIXME: Cheap hack city, needs to cover a lot more stuff */

    if (call_types[call_type] & CT_LONGARGS) {
	longargs = memread(function + FEF_LONGARGS);
	num_required = (longargs & FEFLA_MINARGS) >> FEFLA_MINARGS_SHIFT;
	num_optional = ((longargs & FEFLA_MAXARGS) >> FEFLA_MAXARGS_SHIFT) - num_required;
	*num_locals = longargs & FEFLA_LOCALS;
	want_rest = longargs & FEFLA_HASREST;
	want_optionals = longargs & FEFLA_HASOPTIONALS;
    } else {
	num_required = (fef_header >> 14) & 15;
	num_optional = (fef_header >> 18) & 7;
	*num_locals = (fef_header >> 10) & 15;
	want_rest = call_types[call_type] & CT_REST;
	want_optionals = call_types[call_type] & CT_OPTIONALS;
    }

    supplied_optionals = num_args - num_required;

    if (supplied_optionals < 0) {
	printf("arg_parse: required %d args, found %d.\n", num_required, num_args);
	exit(-1);
    }

    while (num_args < (num_required + num_optional)) {
	push_cdrnext(C_NIL);
	num_args++;
    }

    if (supplied_optionals > num_optional) {
	if (want_rest) {
	    /* Change CDRCODE of last arg to CDR_NIL */
	    push(NOT_CDRCODE(pop()) | CDR_NIL);

	    /* Set *rest to point to start of &REST args with DTP_STACK_LIST */
	    *rest = DTP_STACK_LIST |
		(ADDRESS(context.pdl_pointer - num_args) +
		 num_optional + num_required);
	} else {
	    printf("too many arguments for function.\n");
	    exit(-1);
	}
    } else {
	if (want_rest) {
	    *rest = C_NIL;
	} else {
	    *rest = 0; /* Special magic code for not having &REST arg */
	}
    }

    if (want_optionals) {
	return DTP_FIX | supplied_optionals;
    } else {
	return 0;
    }
}

lisp_q fix_return_fields(lisp_q call_info)
{
    if ((call_info & CI_RETURNDEST) == D_RETURN) {
	/* Replace return fields */
	call_info &= ~CI_RETURNFIELDS;
	call_info |= (context.call_info & CI_RETURNFIELDS);
    } else if ((call_info & CI_RETURNDEST) == D_TAIL_REC) {
	/* Replace return fields and destination */
	call_info &= ~(CI_RETURNFIELDS | CI_RETURNDEST);
	call_info |= (context.call_info & (CI_RETURNFIELDS | CI_RETURNDEST));
	/* FIXME: Do stack-smash thing */

	printf("funcall_1(): D_TAIL_REC not complete.\n");
	exit(-1);
    }

    return call_info;
}

int spread_last_argument(int num_args)
{
    lisp_q arglist;
    
    if (!num_args) return 0;

    num_args--;
    arglist = pop();

    while ((DTP(arglist) == DTP_LIST) ||
	   (DTP(arglist) == DTP_STACK_LIST)) {
	push_cdrnext(car(arglist));
	arglist = cdr(arglist);
	num_args++;
    }
    
    return num_args;
}

void funcall_array(lisp_q function, lisp_q call_info)
{
    lisp_q ary_header;
    lisp_q data;
    lisp_q arg;
#if 0
    int size;
#endif

    ary_header = memread(function);
    
    if (DTP(ary_header) != DTP_ARRAY_HEADER) {
	printf("funcall(): bad array header.\n");
	dump_q(ary_header, 0);
	exit(-1);
    }
    
    if (ARY_NS(ary_header)) {
	printf("funcall(): array is named-structure.\n");
	dump_q(ary_header, 0);
	exit(-1);
    }

    if (ARY_PHYSICAL(ary_header)) {
	printf("funcall(): array is physical.\n");
    }

    if (ARY_DISPLACED(ary_header)) {
	data = memread(function + 1);
	printf("funcall(): array is displaced to %lx.\n", ADDRESS(data));
    } else if (ARY_LL(ary_header)) {
	data = function + 2;
    } else {
	data = function + 1;
    }

    if ((ARY_TYPE(ary_header) != ART_Q) &&
	(ARY_TYPE(ary_header) != ART_Q_LIST)) {
	printf("funcall(): array has unfamiliar layout. %lx\n", ary_header);
	dump_q(ary_header, 0);
	exit(-1);
    }
    
    arg = pop();
    printf("funcall(): hacking sca reference %ld.\n", ADDRESS(arg));
    push_cdrnext(memread(ADDRESS(data) + ADDRESS(arg)));
}

int hash_string(lisp_q strptr)
{
    int arysize;
    lisp_q ary_header;
    int i, hashval;
    unsigned int foo;

    ary_header = memread(strptr);

    arysize = ARY_INDEX(ary_header);
    printf("hash_string(): length %d\n", arysize);
    if (ARY_TYPE(ary_header) != ART_STRING) {
	printf("hash_string(): bad string type %ld\n", ARY_TYPE(ary_header));
	exit(-1);
    }

    foo = 0; /* "uninitialized" */

    hashval = 0;
    for (i = 0; i < arysize; i++) {
	if ((i & 3) == 0) {
	    foo = memread(strptr + (i >> 2) + 1);
	}
	hashval += foo >> (i << 3);
    }
    return hashval % arysize;
}

void funcall_instance(lisp_q function, lisp_q call_info)
{
    lisp_q flavor_structure;
    lisp_q method_name, flavor_name;
    lisp_q method_hash_table;
    lisp_q instance_size;
    lisp_q bindings;
    lisp_q hash_entry;
    int i;

    flavor_structure = memread(function);
    if (DTP(flavor_structure) != DTP_INSTANCE_HEADER) {
	printf("funcall(): bad instance header.\n");
	dump_q(flavor_structure, 0);
    }

    printf("flavor: ");

    method_name = pop();
    dump_string(memread(method_name));

    instance_size = memread(flavor_structure + 2);
    bindings = memread(flavor_structure + 3);
    flavor_name = memread(flavor_structure + 5);
    dump_string(memread(flavor_name));

    method_hash_table = memread(flavor_structure + 4);
    i = hash_string(memread(method_name + SYM_PRINTNAME));
    printf("hashes to %d\n", i);
    hash_entry = memread(ADDRESS(method_hash_table) + i);
    if (hash_entry == method_name) {
    }

    push_cdrnext(C_NIL);
    /* FIXME: Implement properly. where's SELF? the mapping table? */
    return;
}

void funcall(lisp_q function, lisp_q call_info)
{
    int num_args;
    lisp_q fef_header;
    int call_type;
    int num_locals;
    lisp_q optionals;
    lisp_q new_arg_pointer;
    lisp_q rest; /* for &REST args */
    
    num_args = call_info & CI_NUMARGS;

    /* FIXME: Is this really the best place for this? */
    if (call_info & CI_LEXPRFUNCALL) {
	num_args = spread_last_argument(num_args);
    }

    if (DTP(function) == DTP_SYMBOL) {
	dump_q(function, 0);
	function = memread(function + SYM_FUNCTION);
	dump_q(function, 1);
/* 	exit(-1); */
    }

    if (DTP(function) == DTP_ARRAY) {
	funcall_array(function, call_info);
	return;
    } else if (DTP(function) == DTP_INSTANCE) {
	funcall_instance(function, call_info);
	return;
    } else if (DTP(function) == DTP_STACK_GROUP) {
	printf("stack group %d args.\n", num_args);
	exit(-1);
    } else if (DTP(function) == DTP_U_ENTRY) {
	lisp_q u_entry;
	lisp_q debug_info;
	lisp_q u_link;
	lisp_q function_name;

	printf("funcall(): microcode entry.\n");
	dump_q(function, 0);
	u_entry = get_micro_code_entry(ADDRESS(function));
	dump_q(u_entry, 0);
	if (DTP(u_entry) != DTP_FIX) {
	    printf("funcall(): microcode entry not microcode entry.\n");
	    exit(-1);
	}
	
	debug_info = get_micro_code_entry_debug_info(ADDRESS(function));
	function_name = memread(debug_info + 2);
	dump_q(function_name, 0);

	u_link = get_micro_code_link(ADDRESS(u_entry));
	dump_q(u_link, 0);
	if (DTP(u_link) != DTP_FIX) {
	    printf("funcall(): microcode link not FIXNUM?!?\n");
	    exit(-1);
	}

	printf("link: uPC: #x%04lX arg-info: %ld &rest: %ld.\n",
	       u_link & 0xffff, (u_link >> 16) & 0x3f, (u_link >> 22) & 1);

	/* NOTE: Hacked copy of normal funcall case below */
	
	new_arg_pointer = context.pdl_pointer - num_args;

	call_info = fix_return_fields(call_info);

	save_outbound_call_frame();

	dump_call_args(new_arg_pointer, num_args);

	context.arg_pointer = new_arg_pointer;
	context.call_info = call_info;

	create_frame_locals(0);

	printf("Starting U-Entry.\n");
    
	context.function = function;

	uentry_008(num_args);

	return;
    } else if (DTP(function) != DTP_FUNCTION) {
	printf("funcall(): function not DTP_FUNCTION.\n");
	dump_q(function, 0);
	exit(-1);
    }

    fef_header = memread(function);

    call_type = (fef_header >> 21) & 7;

    if (call_types[call_type] & (CT_UNUSED)) {
	set_function(function); /* for debugging purposes */
	printf("unsupported call type %d.\n", call_type);
	exit(-1);
    }

    new_arg_pointer = context.pdl_pointer - num_args;

    call_info = fix_return_fields(call_info);

    optionals = arg_parse(function, fef_header, call_info, call_type, num_args, &rest, &num_locals);
    
    dump_q(function, 0);
    
    save_outbound_call_frame();

    dump_call_args(new_arg_pointer, num_args);

    context.arg_pointer = new_arg_pointer;
    context.call_info = call_info;
    
    set_function(function);
    create_frame_locals(num_locals);

    if (rest) {
	memwrite(context.local_pointer, rest);
    }

    if (optionals) {
	push_cdrnext(optionals);
    }
}

void return_1(lisp_q retval)
{
    int num_results;

    if (ADDRESS(context.pdl_pointer) <
	ADDRESS(saved_pdl_pointers[stack_level - 1])) {
	printf("Stack underrun screw.\n");
	exit(-1);
    }

    if (ADDRESS(saved_pdl_pointers[stack_level - 1]) <
	ADDRESS(context.m_catch_pointer)) {
	printf("catch pointer underrun screw.\n");
	exit(-1);
    }
    
    context.indicators = return_barrier(retval);

    if (((context.call_info & CI_RETURNTYPE) ==
	 RT_MULTIPLE_VALUE_LIST_RETURN) ||
	((context.call_info & CI_RETURNTYPE) ==
	 RT_RETURN_ALL_VALUES_WITH_COUNT_ON_STACK)) {
	printf("Unsupported return type.\n");
	exit(-1);
    }

    /* FIXME: double-check return barrier */
    /* FIXME: Add return-type checking */
    /* FIXME: Add NIL-padding for when multi-values expected */

    num_results = (context.call_info & CI_NUMRESULTS) >> 14;

    /* skip back over all D_RETURN FRAMES */
    while ((context.call_info & CI_RETURNDEST) == D_RETURN) {
	restore_call_frame();
    }

    if ((context.call_info & CI_RETURNDEST) == D_PUSH) {
	restore_call_frame();

	printf("return_1: returning %d results.\n", num_results);

	if (num_results) {
	    push_cdrnext(context.indicators);
	    
	    while (--num_results) {
		push_cdrnext(C_NIL);
	    }
	}
    } else if ((context.call_info & CI_RETURNDEST) == D_INDS) {
	restore_call_frame();
    } else {
	printf("unknown return code.\n");
	exit(-1);
    }

    /* XXX: Return value debug hack */
    dump_q(context.indicators, 0);
}

void return_n(int num_values)
{
    int num_results;
    int num_nils_needed;
    lisp_q return_value_pointer;
    
    return_value_pointer = context.pdl_pointer - num_values;

    if (ADDRESS(return_value_pointer) <
	ADDRESS(saved_pdl_pointers[stack_level - 1])) {
	printf("Stack underrun screw.\n");
	exit(-1);
    }

    if (ADDRESS(saved_pdl_pointers[stack_level - 1]) <
	ADDRESS(context.m_catch_pointer)) {
	printf("catch pointer underrun screw.\n");
	exit(-1);
    }

    if ((context.call_info & CI_RETURNTYPE) ==
	RT_MULTIPLE_VALUE_LIST_RETURN) {
	printf("m-v-list-return.\n");
	/* FIXME: Hack! */
	context.call_info &= ~CI_RETURNFIELDS;
	context.call_info |= 0x4000; /* 1 value */
	context.arg_pointer = context.pdl_pointer - num_values;
	uentry_008(num_values);
	print_list(context.indicators);
	printf("\n");
	return;
    } else if ((context.call_info & CI_RETURNTYPE) ==
	       RT_RETURN_ALL_VALUES_WITH_COUNT_ON_STACK) {
	printf("m-v-count-return.\n");
	push_cdrnext(DTP_FIX | num_values);
	num_values++;
	num_results = num_values;
    } else {
	num_results = (context.call_info & CI_NUMRESULTS) >> 14;
    }

    printf("num_values: %d\n", num_values);
    printf("num_results: %d\n", num_results);
    if (num_results > num_values) {
	/* FIXME: Do we need to adjust the return_value_pointer? */
	num_nils_needed = num_results - num_values;
	num_results = num_values;
    } else {
	num_nils_needed = 0;
    }
    
    /* FIXME: Add return-type checking */
    /* FIXME: Add NIL-padding for when multi-values expected */
    /* FIXME: Check the case when returning &REST to make sure it doesn't get stomped */

    /* skip back over all D_RETURN FRAMES */
    while ((context.call_info & CI_RETURNDEST) == D_RETURN) {
	restore_call_frame();
    }

    if ((context.call_info & CI_RETURNDEST) == D_PUSH) {
	restore_call_frame();

	/* FIXME: Push results here */
	while (num_results--) {
/* 	    push(return_barrier(memread(return_value_pointer++))); */
	    /* XXX: Return value debug hack */
	    lisp_q tmp;
	    push(tmp=return_barrier(memread(return_value_pointer++)));
	    dump_q(tmp, 0);
	}

	while (num_nils_needed--) {
	    push_cdrnext(C_NIL);
	}
    } else if ((context.call_info & CI_RETURNDEST) == D_INDS) {
	restore_call_frame();
	
	/* FIXME: Results? */
	printf("returning multiple values to D_INDS not supported.\n");
	exit(-1);
    } else {
	printf("unknown return code.\n");
	exit(-1);
    }
}

/* EOF */
