page		60,132
title           Template for .COM Programs
;---------------------------------------------------------------------------
;
;  CENTERING ADJUST TSR FOR CL-GD542X/3X IN ASSOCIATION WITH CLMODE.EXE
;
;  NAME:                 CENTER.ASM
;  LAST DATE MODIFIED:   09-02-93
;  MODIFIED BY:          Steve Cardiasmenos
;
;  TSR loads a new RAM Save Area Table that has been previously modified by
;  CLMODE for centering adjust purposes.  The new pointer in the linked
;  list points to the BIOS ROM Save Area table, so that the BIOS can continue
;  to process setmode requests beyond the redefined RAM version, loaded by
;  this TSR loader.
;
;---------------------------------------------------------------------------

_text		segment	byte public 'code'
		assume	cs:_text,ds:_text,ss:_text	; and tell the assembler
		org	100h		; .coms start at 100h
PRODUCT_ID	equ	'RV'
SLOT_NUM        equ     10h    ; Max of 10h slots only for redefined modes
SET		equ	1
RESET		equ	0
X_MODES		equ	0

USAGE_INIT	equ	911h
BIOS_FAIL	equ	921h
TSR_FAIL        equ     915h
OVERFLOW	equ	909h
JOB_DONE	equ	941h


entry_point:	jmp	start
main		proc	near
		public	main

;---------------------------------------------------------------------------
ana_ptr_ext_extra:
	dw 0000h
	dw 0000h
					;Additional fields here
	dw $ - ana_ptr_ext_extra
	dw 001Ch                ;Supplemental tables currently = 28d
	dw offset sup_parm_data_area
	dw 0000h
	dw offset std_parm_data_area
	dw 0000h
	dw X_MODES		;number of extended modes
	dw PRODUCT_ID		;signature word
SaveArea	label	word
	dw 0000h 		;ModeParameters
	dw 0000h
	dw 0000h 		;DynSave
	dw 0000h
	dw 0000h 		;Aux Alpha
	dw 0000h
	dw 0000h 		;Aux Grfx
	dw 0000h
	dw 0000h 	      	;Second Save
	dw 0000h
	dw 0000h 		;reserved
	dw 0000h
	dw 0000h 		;reserved
	dw 0000h
SaveAreaSize	equ ($ - offset SaveArea)/2

	dw 5443h                ;CLMODE pointer to tables (CTABLE)
	dw 4241h
	dw 454Ch

std_parm_data_area:
	db	64*SLOT_NUM dup(0) 	;  slots reserved for std. parm data
sup_parm_data_area:
	db      64*SLOT_NUM dup(0)      ;  slots reserved for sup. parm data
END_OF_TSR	label	byte
;----------------------------------------------------------------------------

dos_save_ptr_oft	dw	0a8h
dos_save_ptr_seg	dw	40h

all_done	db	RESET		   ; all file been load
tsr_flag	db	RESET		   ; if set then set tsr

error_flag	dw	USAGE_INIT

;-----------------------------------------------------------------
;
;  error code: kept in al
;	     bit
;        al = 0 : copyright
;	      5 : not our BIOS 
;             6 : load successfully
;------------------------------------------------------------------	
start: 
		mov     error_flag,JOB_DONE ; assume it's loaded succesfully to start
		call    is_bios_sup         ; is bios support
		jnz     exit                ; not support
		call    is_tsr_loaded       ; is tsr loaded already
		jnz     exit                ; not support

		call	is_ram		; is save area point to RAM
		jnc	set_point	; nope, skip

set_point:      call    set_save_area   ; set pointer table and 40:8a
		jc	exit		; skip, if all slots are filled

		mov	tsr_flag,SET	; set tsr_flag

exit:           call    err_handle      ; call  err_handle
		cmp     tsr_flag,SET    ; should set new tsr area
		jne     @f              ; nope
		mov     dx,offset END_OF_TSR
		int	27h
@@:		mov	ah,4ch
		int	21h

main		endp

;------------------------------------------------------------------
;
;	is_bios_sup()
;
;	 input:
;	       nothing
;	 output: 
;		zero set - BIOS  support
;		zero reset - BIOS not support
;	 function :
;
;------------------------------------------------------------------
is_bios_sup	proc	near
		public	is_bios_sup

		push	ds
		lds	si,dword ptr [dos_save_ptr_oft]	; get ds,si for SaveArea 
		lds	si,[si]			; ds:si point to SaveArea 
		cmp	word ptr [si-2],'RV'	; is there 'RV'?	
		pop	ds
		je	@f			; yup, jump
		mov	error_flag,BIOS_FAIL	; no 'RV', no support
@@:		ret
is_bios_sup	endp

;------------------------------------------------------------------
;
;       is_tsr_loaded()
;
;        input:
;              nothing
;        output:
;               zero set - BIOS  support
;               zero reset - BIOS not support
;        function :
;
;------------------------------------------------------------------
is_tsr_loaded   proc    near
		public  is_tsr_loaded

		push    ds
		lds     si,dword ptr [dos_save_ptr_oft] ; get ds,si for SaveArea
		lds     si,[si]                 ; ds:si point to SaveArea
		cmp     word ptr [si-10h],0     ; is this the last link?
		pop     ds
		je      @f                      ; yup, jump
		mov     error_flag,TSR_FAIL     ; TSR or something already loaded
@@:             ret
is_tsr_loaded   endp

;------------------------------------------------------------------
;
;	set_save_area()
;
;	 input:
;	       nothing
;	 output:
;	       nothing	
;	 function :
;	       check 40:8a point to RAM or ROM
;
;------------------------------------------------------------------
set_save_area	proc	near
		public	set_save_area

		cmp	tsr_flag,SET	; is new save area
		jne	continue	; yup, skip
	 	mov	error_flag,OVERFLOW	; set error code as too many file
		stc			; set flag
		jmp	short set_done	; set carry
continue:	mov	bx,ds		; preserve ds in bx

		lds	si,dword ptr [dos_save_ptr_oft]	;get save area offset
		lds	si,[si]			; point to save area
		mov	di,offset SaveArea	; destination
		push	di		; preserve di
		mov	cx,14		; save 14h bytes total
		rep	movsw		; copy data
		
		pop     si              ; revover si
		mov	ax,cs
		mov     es:[si-6],ax    ; set segment
		mov     es:[si-10],ax   ; set segment

		lds	si,dword ptr cs:[dos_save_ptr_oft] ; point to SaveArea

		lodsw			; get offset
 		push	ax		; save offset
		lodsw			; get segment
		push	ax		; save seg

		mov	ax,offset SaveArea ; get offset of SaveArea
		lds	si,dword ptr cs:[dos_save_ptr_oft] ; point to current 
							   ; save area
		mov	ds:[si],ax	; set SaveArea offset to 40:a8
		mov	ax,cs		; get segment
		mov	ds:[si+2],ax	; set SaveArea seg to 40:aa
		
		mov	ds,bx		; restore ds
		pop	ax		; pop offset of original SaveArea
		mov	word ptr ana_ptr_ext_extra + 2, ax ; save in save area
		pop	ax		; pop seg of original SaveArea 
		mov	word ptr ana_ptr_ext_extra, ax ; save in save area

		clc			; clear carry
set_done:	ret

set_save_area   endp

;------------------------------------------------------------------
;
;	is_ram()
;
;	 input:
;	       nothing
;	 output:
;	       carry set - ram
;	       carry reset - rom
;		
;	 function :
;	       check 40:8a point to RAM or ROM
;
;------------------------------------------------------------------
is_ram		proc	near
		public	is_ram
		push	ds		       ; preserve ds	
		lds	si,dword ptr[dos_save_ptr_oft]	; get current save area
		cmp	word ptr [si+2],0c000h ; if segment is c000 or bigger
					       ; then is rom	
		pop	ds
		ret
is_ram		endp

;------------------------------------------------------------------
;
;	err_handle()
;
;	 input:
;		bit
;        al =   0 : copyright         ; only ones used
;		5 : BIOS not support
;	        6 : load successfuly 		
;------------------------------------------------------------------

err_handle	proc	near
		public	err_handle
		mov	ax,error_flag
		test    al,1            ; is copyright
		jz      @f              ; no copyright
		mov     dx,offset copyright
		int 	21h

@@:		mov	ax,error_flag
		test	al,40h		; should print usage?
		jz	@f		; not needed
		mov	dx,offset ok
		int 	21h

@@:		mov	ax,error_flag
		test	al,20h		; is bios error
		jz	@f		; no bios error
		mov	dx,offset bios_err
		int 	21h

@@:             mov     ax,error_flag
		test    al,4            ; is tsr loaded already
		jz      @f              ; no error
		mov     dx,offset tsr_err
		int     21h

@@:             ret
err_handle	endp
;--------------------------------------------------------------------------------------
copyright       db 0dh,0ah,'Centering Adjust Loader Utility for CL-GD542X/3X',0Dh,0Ah
		db 'Copyright(c) 1993 Cirrus Logic Inc.',0Dh,0Ah,'$'
bios_err        db 0dh,0ah,'This video BIOS is not supported.',0Dh,0Ah,7,'$'
tsr_err         db 0dh,0ah,'The TSR is already installed.',0Dh,0Ah,7,'$'
ok              db 0dh,0ah,'TSR loaded successfully.',0Dh,0Ah,'$'
;--------------------------------------------------------------------------------------

_text		ends
		end	entry_point	; main entry point
						

 

