/*----------------------------------------------------------*/
/*																				*/
/*	  HELP.CPP - controls the Help Menu       					*/
/*	  Copyright (c) 1992 by Cirrus Logic Inc.					   */
/*																				*/
/*   MV:1/2/92 - file created                               */
/*----------------------------------------------------------*/

#include <ui_win.hpp>
#define USE_HELP_CONTEXTS
#include "clview.hpp"
#include "clmode.hpp"


void CONTROL_WINDOW::Option_Help(EVENT_TYPE item)
{
// Declare the help message/context pairs.
	static struct HELP_PAIR
	{
		int itemValue;
		UI_HELP_CONTEXT helpContext;
	} helpTable[] =
	{
		{ CLHELP_MONITOR,	   HELP_MONITOR },
		{ CLHELP_DISPLAY,	   HELP_DISPLAY },
		{ CLHELP_KEYBOARD,	HELP_KEYBOARD },
		{ CLHELP_MOUSE, 	   HELP_MOUSE },
#ifndef DESKTOP
		{ CLHELP_VGACONF, 	HELP_VGACONF },
#endif
		{ 0, 0 }	// End of array.
	};

// Get the help context then call the help system.
	USHORT helpContext = NO_HELP_CONTEXT;
	for (int i = 0; helpTable[i].itemValue; i++)
		if (item == helpTable[i].itemValue)
		{
			helpContext = helpTable[i].helpContext;
			break;
		}
	helpSystem->DisplayHelp(windowManager, helpContext);
}




