	INCLUDE PAGE.INC
	SUBTTL	Save Restore State
;****************************************************************
;
;	$Workfile:   rw_state.asm  $
; 
; 	Copyright 1989, 1990 Quadtel Corporation.
; 	All rights reserved.
; 
;	Contents:
;
; 	Modification History:
; 	$Log:   E:/vcs/vga/54xx/rw_state.asv  $
;      
;
;****************************************************************


include		..\lib\config.inc
include		..\lib\options.inc
include		..\lib\biosdata.inc
include		..\lib\argframe.inc


cgroup		group	VGA_Segment

VGA_Segment	SEGMENT PUBLIC WORD
		assume	cs:cgroup,ds:bios_data

		extrn	get_crtc_addr:near; get crtc/6845 addr 
		extrn	getreg:near
		extrn	Save_BIOS_Data_Area:near
 ifdef (XGA_BUG)
 		extrn	Is_Chip_Unlocked:near
 endif ;(XGA_BUG)
	 	extrn	setup_hidden:near
		extrn	Set_VGA_Registers:near
		extrn	Set_Palette:near
		extrn	Video_On:near

;-----------------------------------------------------------------------
;
;	Function 1ch: Save/Restore State
;
;	Entry:	ah -> 1ch
;		al -> 00h Return size of state save/restore buffer
;		cx -> Requested states
;
;	Returns:
;		al <- 1ch
;		bx <- Number of 64k blocks to save requested states
;
;
;	Entry:	ah -> 1ch
;		al -> 01h Save state
;		cx -> Requested states
;		bx -> State buffer offset
;		es -> State buffer segment
;
;	Returns:
;		al <- 1ch
;		requested state information in the buffer.
;
;
;	Entry:	ah -> 1ch
;		al -> 02h Restore state
;		cx -> Requested states
;		bx -> State buffer offset
;		es -> State buffer segment
;
;	Returns:
;		al <- 1ch
;		requested state information in the buffer.
;
;	Requested states:
;		0000000000000111b
;			       ^-- Save/restore hardware state
;			      ^--- Save/restore BIOS data area
;			     ^---- Save/restore DAC state and registers
;
;-----------------------------------------------------------------------
;
; Buffer Format:
;
st_hdr		struc
	id	dw	?		; PRODUCT_ID buffer identification
	vers	db	?		; version number
	states	db	?		; saved states (cl from save call)
st_hdr		ends
;
; Hardware State Buffer
;    Note: gpos1, gpos2, latches, arx and its flip/flop state are
;	   saved and restored by read/write of the extensions.
;
st_hdwe		struc
;gdl	misco		db	?		; miscellaneous output
	feat		db	?		; feature control
	srx		db	?		; sequencer/extensions index
	crx		db	?		; crtc index
	grx		db	?		; graphics controller index
	sr_rgs		db	04h dup (?)	; sr1 -> sr4 sequencer values
	misco		db	?		; miscellaneous output
	cr_rgs		db	19h dup (?)	; cr0 -> cr18
	ar_rgs		db	14h dup (?)	; ar0 -> ar13
	gr_rgs		db	09h dup (?)	; gr0 -> gr8
	ar14		db	(?)		; ar14
;
 	xsr_rgs06_13	db	(13h - 06h+1) dup (?)
	XSR_RGS16	DB	1	;(V1.3)
;v1.10A3xsr_rgs18_1F	db	(1Fh - 18h+1) dup (?)	;##5434(1)
 	xsr_rgs17_1F	db	(1Fh - 17h+1) dup (?)	;v1.10A3
 	xgr_rgs09_0B	db	(0Bh - 09h+1) dup (?)
 	xgr_rgs10_11	db	(11h - 10h+1) dup (?)
 	xcr_rgs19_1B	db	(1Bh - 19h+1) dup (?)
	xpelmask	db	?
	memlatch	db	4 dup (?)
st_hdwe		ends
;
; BIOS Video Data State Buffer
;
st_data		struc
	eqp	db	?		; bits 5, 6 of equip_flag
	pc_dt	db	1eh dup (?)	; cga/mda data area (40:49)
	ega_dt	db	07h dup (?)	; ega/vga data area (40:84)
	ega_ptr dd	05h dup (?)	; save_ptr, int's 5, 1d, 1f, 43
st_data		ends
;
; DAC state buffer
;
st_dac		struc
	rd_mask db	?		; ramdac mask register
	rd_stat	db	?		; ramdac r/w status
	rd_addr db	?		; ramdac address
	rgb_idx db	?		; R,G,B index
	rd_rgs	db	300h dup (?)	; color registers
	EX_RGS	DB	3*3 dup(?)	;(V1.3) index 256/257/258
st_dac		ends
;-----------------------------------------------------------------------

Video_Save_Restore_State	proc	near
		public	Video_Save_Restore_State

		mov	dx,3c4h		; sequencer
		get1reg			; read index for save state
		mov	ch,al		; save it away in ch
		mov	al,b_al[bp]	; restore sub-function code

		test	ega_info,08h	; ega/vga active ?
		jz	sr_buff_size	; yes
		jmp	sr_st_exit	; nope (return 1c in al ???)
;---------------
;
; state buffer size
;
;---------------
sr_buff_size:	or	al,al		; get size of buffer ?
		jnz	sr_save_state	; nope

		mov	b_al[bp],1ch	; success return code


sr_size0:
;v0.083	mov	bx,20h		; sizeof(buffer header)
		xor	bx,bx		;v0.083
		shr	cl,1		; save hardware state ?
		jnc	sr_size1	; nope
		add	bx,type st_hdwe ; sizeof(hardware area)

sr_size1:	shr	cl,1		; save BIOS data area ?
		jnc	sr_size2	; nope
		add	bx,type st_data ; sizeof(BIOS data area)

sr_size2:	shr	cl,1		; save DAC state and registers ?
		jnc	sr_size3	; nope
		add	bx,type st_dac	; sizeof(DAC state and regs)

sr_size3:
		or	bx,bx		;v0.083
		jz	short NoRequest	;v0.083
		add	bx,20h		;v0.083  sizeof(buffer header)
		add	bx,63		; round up
NoRequest:				;v0.083
		shft_r	bx,6		; compute 64 byte blocks
		mov	w_bx[bp],bx	; save bx return value
		jmp	sr_st_exit	; and return
;---------------
;
; save state
;
;---------------
sr_save_state:
		mov	di,w_bx[bp]	; save buffer offset
;v0.051	add	di,20h		; skip header <--

		dec	b_al[bp]	; save state ?
		jz	sr_save_it	; yes
		jmp	sr_rest_state	; nope

sr_save_it:
		add	di,20h		;v0.051  skip header <--
		push	ax		;v0.051
		push	cx		;v0.051
		push	di		;v0.051
		mov	di,w_bx[bp]	;v0.051
		mov	cx,20h/2	;v0.051
		xor	ax,ax		;v0.051
		rep	stosw		;v0.051  es:di Clean up Header!
		pop	di		;v0.051
		pop	cx		;v0.051
		pop	ax		;v0.051

		test	b_cl[bp],1	; save hardware state ?
		jnz	sr_save_hdwe	; yup
		jmp	sv_data		; nope

sr_save_hdwe:	mov	si,di		; save start of hardware buffer
		mov	es:[bx],di	;v1.31A
		mov	word ptr es:[bx+10h],0020h ;v1.00B1

		mov	dl,0cah		; feature control read address
		get1reg			; read it
		stosb			; save it

		mov	al,ch		; get sequencer index
		stosb			; save sequencer index

		call	get_crtc_addr	; current crtc/6845 address to dx
		push	dx		; save 3?4
		get1reg			; read crtc index
		stosb			; save it

		mov	dl,0ceh		; graphics controller
		get1reg			; read graphics index
		stosb			; save it

		mov	dl,0c4h		; sequencer
		mov	bl,1		; starting register
		mov	cx,length sr_rgs; number of regsters
		call	rd_block	; read and save them

;gdl:03/18/92 Codeview for Windows expects 3C4h to be 02h on exit.
		mov	al,02h
		set1reg

		mov	dl,0cch		; misc output register
		get1reg			; read it
		stosb			; save it

		pop	dx		; get crtc address
		xor	bl,bl		; starting register
		mov	cx,length cr_rgs; number of registers
		call	rd_block	; read and save them

save_ar:	mov	cx,length ar_rgs; number of registers
		xor	ah,ah		; starting register
sr_attr_loop:	call	palr_rdreg	; read the register
		stosb			; store the data
		loop	sr_attr_loop	; more registers ?

		mov	dl,0ceh		; graphics controller
		xor	bl,bl		; starting register
		mov	cx,length gr_rgs; number of registers
		call	rd_block	; read and save them

;gdl:02/06/92 Save AR14 separately
		mov	ah,14h		; starting register
		call	palr_rdreg	; read the register
		stosb			; store the data

 	call	Video_on

   ifdef (XGA_BUG)
 	call	Is_Chip_Unlocked
	jne	SkipExtensionSave
   endif ;(XGA_BUG)

 	mov	dx,SEQIDX
	mov	bl,06h			;Read 06 through 13h
	mov	cx,length xsr_rgs06_13	; number of registers
	call	rd_block		; read and save them
;(V1.3) {
	mov	bl,16h			;Read 16h
	mov	cl,1			; number of registers
	call	rd_block		; read and save them
;(V1.3) }

;v1.10A3mov	bl,18h			;Read 18 - 1E
;v1.10A3mov	cl,length xsr_rgs18_1F	; number of registers	##5434(1)
	mov	bl,17h			;v1.10A3  Read 17 - 1F
	mov	cl,length xsr_rgs17_1F	;v1.10A3  # of registers
	call	rd_block		; read and save them

 	mov	dl,Low(GFXIDX)
	mov	bl,09h			;Read 09 - 0B
	mov	cl,length xgr_rgs09_0B	;number of registers
	call	rd_block		;read and save them

	mov	bl,10h			;Read 10 - 11
	mov	cl,length xgr_rgs10_11	;number of registers
	call	rd_block		;read and save them

	call	get_crtc_addr
	mov	bl,19h			;Read 19 - 1B
	mov	cl,length xcr_rgs19_1B	;number of registers
	call	rd_block		;read and save them

	mov	dl,Low(PELMASK)
	call	setup_hidden	;setup hidden register access

	get1reg
	stosb

SkipExtensionSave:
;v0.082{
	MOV	DX,GFXIDX			;Now setup the graphics contrl
	MOV	AL,4
	CALL	getreg				; GR04
	PUSH	AX				; SAVE GR04
	PUSH	DX
	AND	AH,NOT 03H			; SET READ MAP TO PLANE 0
	OUT	DX,AX
	MOV	BX,DX				; GRAPHICS CONTROLLER BASE
	INC	BX				; 3CFH
	CALL	get_crtc_addr			; get crtc base
	MOV	AL,22h
	OUT	DX,AL
	INC	DX				; 3x5H
	MOV	CX,4				; 4 CPU latches
	XOR	AL,AL

ReadLatchesLoop:
	PUSH	DX				; save 3x5H
	MOV	DX,BX				; GET 3CFH
	OUT	DX,AL				; select read map
	POP	DX				; restore 3x5H
;
	PUSH	AX				; save read map data
	IN	AL,DX				; GET A CPU LATCH
	STOSB					; Save it in the buffer
	POP	AX
;
	INC	AL
	LOOP	ReadLatchesLoop			;Repeat for all four planes
;
	POP	DX
	POP	AX
	OUT	DX,AX				; restore GR04
;v0.082}

comment	%					;v0.082{
	PUSH	DS				;Save segment register
	MOV	AX,0A000H			;Setup DS to A000. Write
	MOV	DS,AX				;latches to FFFF then read
	MOV	DX,SEQIDX			;from ram and write to buffer
	MOV	AL,02H				;Read plane mask register
	CALL	getreg				;from the sequencer
	PUSH	AX				;Save it, restore later
	MOV	AH,0FH				;Enable all 4 planes for write
	OUT	DX,AX				;Write the plane mask reg
	MOV	AL,04H				;Read the memory mode reg
	CALL	getreg				;from the sequencer
	PUSH	AX				;Save it, restore later
	MOV	AH,07				;Force text mode, not odd/even
	OUT	DX,AX				;Write to memory mode reg
	MOV	DX,GFXIDX			;Now setup the graphics contrl
	MOV	AL,04H				;Read the map select reg
	CALL	getreg				;from graphics controller
	PUSH	AX				;Save it, restore later
	MOV	AL,05H				;Read the mode register
	CALL	getreg				;from the graphics controller
	PUSH	AX				;Save it, restore later
	MOV	AH,01				;Set write mode for latches
	OUT	DX,AX				;Write the mode register
	MOV	AL,06H				;Read the miscellaneous reg
	CALL	getreg				;from the graphics controller
	PUSH	AX				;Save it, restore later
	MOV	AH,04H				;Enable video from A000-AFFF
	OUT	DX,AX				;Write misc register
	MOV	BYTE PTR DS:[0FFFFH],00 	;Dump latches to FFFF
	MOV	CX,04				;No read latches from Video mem
	MOV	AH,00				;Use map select to select plane

Read_Latches_Loop:
	MOV	AL,04				;Get map select register
	OUT	DX,AX				;Select the current plane
	INC	AH				;Advance plane pointer
	MOV	AL,DS:[0FFFFH]			;Read the latch data
	STOSB					;Save it in the buffer
	LOOP	Read_Latches_Loop		;Repeat for all four planes

	POP	AX				;Get misc reg and data
	OUT	DX,AX				;Restore miscellaneous reg
	POP	AX				;Get graphics mode reg and data
	OUT	DX,AX				;Restore graphics mode reg
	POP	AX				;Get map select reg and data
	OUT	DX,AX				;Restore read map select
	MOV	DX,SEQIDX			;Now restore sequencer
	POP	AX				;Get memory mode reg and data
	OUT	DX,AX				;Restore memory mode register
	POP	AX				;Get plane map mask reg
	OUT	DX,AX				;Restore plane map mask reg
	POP	DS				;Restore DS register
%						;v0.082}

sv_data:	test	b_cl[bp],2	; save BIOS data area ?
		jz	sv_dac		; nope

		push	bx		;v1.31A
		mov	bx,w_bx[bp]	;v1.31A
;v1.00B1	{
		push	di
		sub	di,bx
		mov	es:[bx+12h],di
		pop	di
;v1.00B1	}
		mov	es:[bx+2],di	;v1.31A
		pop	bx		;v1.31A

		call	Save_BIOS_Data_Area	; save bios data

sv_dac:		test	b_cl[bp],4	; save DAC ?
		jz	sv_done		; nope, the way it should work

		push	bx		;v1.31A
		mov	bx,w_bx[bp]	;v1.31A
;v1.00B1	{
		push	di
		sub	di,bx
		mov	es:[bx+14h],di
		pop	di
;v1.00B1	}
		mov	es:[bx+4],di	;v1.31A
		pop	bx		;v1.31A

		mov	dl,0c6h		; get mask
		get1reg
		stosb			; keep it

		inc	dx		; get r/w status
		get1reg			; get it
		stosb			; save it
		mov	ch,al		; keep r/w state

		inc	dx		; get r/w index
		get1reg
		mov	cl,al		; keep in cl
		or	ch,ch		; is read?
		jz	not_read	; nope
		dec	ax
not_read:	stosb
		
		mov	byte ptr es:[di],03h; point to blue and save
next_chk:	dec	byte ptr es:[di]; point to blue	and save
		jz	lut_off
		inc	dx		; 3c9
		or	ch,ch
		jz	rg_write	; if write then jump
		get1reg			; dummy read
		jmp	short rg_chk
rg_write:	set1reg			; dummy	write
rg_chk:		dec	dx		; 3c8 to get index
		get1reg
		cmp	al,cl		; is index changed?
		jne	lut_off		
		jmp	short next_chk		

lut_off:	inc	di		; skip rgb_idx for stosb

;(V1.3) {
	xor	al,al		; start at zero
	mov	cx,length rd_rgs; number of  ramdac registers
	call	save_DAC
;
	call	save_set_sr12
;
	xor	al,al		;read DAC index 256
	mov	cx, 3		;RGB 3 bytes
	call	save_DAC

	mov	ax, 0fh		;read DAC index 257
	mov	cx, 3
	call	save_DAC

	mov	ax, 2		;read DAC index 258
	mov	cx, 3
	call	save_DAC
;
	call	restore_sr12

;(V1.3) }
sv_done:	mov	b_al[bp],1ch	; success return code
sv_exit_near:	jmp	sr_st_exit	; and return
;
;(V1.3) {
save_DAC:
		mov	dl,0c7h		; read address
		set1reg			; set read address
		jmp	$ + 2		; this is necessary !
		mov	dl,0c9h		; point to data
sv_dac2:	get1reg			; get it
		stosb			; save it
		loop	sv_dac2		; more registers ?
		ret
;
save_set_sr12:
	mov	dl, 0c4h
	in	al, dx
	mov	bl, al		;save 3c4h value
	mov	al, 12h
	out	dx, al
	inc	dx
	in	al, dx
	mov	ah, al		;AH = sr12h value
	or	al, 2		;allow access to extended DAC
	push	ax		;delay
	pop	ax		;delay
	out	dx, al
	ret
;
restore_sr12:
	mov	dl, 0c4h
	mov	al, 12h
	out	dx, al
	inc	dx
	mov	al, ah
	out	dx, al		;restore sr12h value
;
	mov	al, bl
	dec	dx
	out	dx, al		;restore 3c4h value
	ret
;
;(V1.3) }
;
;---------------
;
; restore state
;
;---------------
sr_rest_state:	dec	b_al[bp]	; restore state ?
		jnz	sv_exit_near	; nope

		mov	si,di		; src offset
		push	es		; src segment
		pop	ds		;    into ds
		assume	ds:nothing	; and tell the assembler

;
; check about restoring the hardware state
;
;gdl:01/16/92 Don't trash stack!
		test	b_cl[bp],01h	; restore hardware state ?
		jnz	sr_rhdwe	; yes

sr_rhdwe_exit:	jmp	rs_data 	; and go check data

sr_rhdwe:
;
; restore hardware state
;
;v1.00B1	mov	di,w_bx[bp]		;v0.051 save buffer offset
;v1.00B1	mov	si,word ptr ds:[di]	;v0.051
;v1.00B1	{
		mov	di,w_bx[bp]
		mov	si,word ptr ds:[di+10h]
		add	si,di
;v1.00B1	}
		push	bx		; save state buffer contents
;gdl:02/06/92	mov	bh,misco[si]	; get misc output value
		push	si		; save base of hardware state

		add	si,sr_rgs	; advance to sequencer data

;gdl:02/06/92 Use the existing function to restore, which saves code space
;	and eliminates white lines on panel.
		push	es
		push	ds
		mov	ax,ds
		mov	es,ax
		xor	ax,ax
		mov	ds,ax
		mov	al,ds:[489h]
		and	byte ptr ds:[489h],not 08h
		and	al,08h
		push	ax
		sub	si,5
		call	Set_VGA_Registers

		mov	bh,es:[si]
		inc	si
		mov	bl,14h
		call	Set_Palette

		pop	ax
		or	ds:[489h],al
		pop	ds
		pop	es

		call	get_crtc_addr
		add	dl,06h
		push	dx

 ifdef (XGA_BUG)
 	call	Is_Chip_Unlocked
	je	allow_ext_state
	jmp	short SkipExtensionRestore
allow_ext_state:
 endif ;(XGA_BUG)

 	mov	dx,SEQIDX
	mov	bl,06h			;Read 06 through 13h from buffer
	mov	cx,length xsr_rgs06_13	; number of registers
	call	wr_block		; get value and write them out
;(V1.3) {
	mov	bl,16h			;Read 16h from buffer
	mov	cl,1			; number of registers
	call	wr_block		; get value and write it out
;(V1.3) }

;v1.10A3mov	bl,18h			;Read 18 - 1E from buffer
;v1.10A3mov	cl,length xsr_rgs18_1F	; number of registers  ##5434(1)
	mov	bl,17h			;v1.10A3  Read 17 - 1F from buffer
	mov	cl,length xsr_rgs17_1F	;v1.10A3  # of registers
	call	wr_block		; get value and write them out

 	mov	dl,Low(GFXIDX)
	mov	bl,09h			;Read 09 - 0B from buffer
	mov	cl,length xgr_rgs09_0B	;number of registers
	call	wr_block		;get value and write them out

; 	mov	dx,GFXIDX
	mov	bl,10h			;Read 10 - 11 from buffer
	mov	cl,length xgr_rgs10_11	;number of registers
	call	wr_block		;get value and write them out

	call	get_crtc_addr
	mov	bl,19h			;Read 19 - 1B from buffer
	mov	cl,length xcr_rgs19_1B	;number of registers
	call	wr_block		;get value and write them out

	mov	dl,Low(PELMASK)
	call	setup_hidden	;setup hidden register access

	lodsb
	set1reg

	mov	al,0FFh
	set1reg

SkipExtensionRestore:
	MOV	Dl,Low(SEQIDX)			;from ram and write to buffer
	MOV	AL,02H				;Read plane mask register
	CALL	getreg				;from the sequencer
	PUSH	AX				;Save it, restore later
	MOV	AH,0FH				;Enable all 4 planes for write
	OUT	DX,AX				;Write the plane mask reg
;
	MOV	AL,04H				;Read the memory mode reg
	CALL	getreg				;from the sequencer
	PUSH	AX				;Save it, restore later
	MOV	AH,07				;Force text mode, not odd/even
	OUT	DX,AX				;Write to memory mode reg
;
	MOV	Dl,Low(GFXIDX)			;Now setup the graphics contrl
	MOV	AL,04H				;Read the map select reg
	CALL	getreg				;from graphics controller
	PUSH	AX				;Save it, restore later
;
	MOV	AL,05H				;Read the mode register
	CALL	getreg				;from the graphics controller
	PUSH	AX				;Save it, restore later
;v0.082MOV	AH,01				;Set write mode for latches
	xor	ah,ah				;v0.082
	OUT	DX,AX				;Write the mode register
;
	MOV	AL,06H				;Read the miscellaneous reg
	CALL	getreg				;from the graphics controller
	PUSH	AX				;Save it, restore later
	MOV	AH,04H				;Enable video from A000-AFFF
	OUT	DX,AX				;Write misc register
;
	mov	al,02h
	call	getreg				;GR02
	push	ax
;
	MOV	AX,0A000H			;Setup DS to point
	MOV	ES,AX				;to A000 video regen
	MOV	DI,0FFFFH			;Write latches to FFFF
;v0.082MOV	CH,04				;then read them into latches
;v0.082MOV	CL,01				;Start with plane 0
;v0.082{
	mov	cx,3
ReadMemLoop:
	mov	al,4
	mov	ah,cl
	out	dx,ax
	mov	al,es:[di]
	push	ax				;save contents
	dec	cx
	cmp	cx,-1
	jnz	short ReadMemLoop
;
	MOV	CH,04				;then read them into latches
	MOV	CL,01				;Start with plane 0
	MOV	Dl,Low(SEQIDX)			;v0.082
WriteMemLoop:
	MOV	AL,02				;Get map mask register
	MOV	AH,CL				;Get current plane
	OUT	DX,AX				;Enable the plane
	LODS	BYTE PTR DS:[SI]		;Get latch data for plane
	MOV	es:[DI],AL 			;Write it to the plane
	SHL	CL,1				;Move to next plane
	DEC	CH				;Decrement counter
	JNE	WriteMemLoop			;Repeat for all four planes
;
	mov	cx,3
	mov	dl,Low(GFXIDX)
RestoreLatchLoop:
	mov	al,4
	mov	ah,cl
	out	dx,ax
	mov	al,es:[di]
	dec	cx
	cmp	cx,-1
	jnz	short RestoreLatchLoop
;
	mov	dl,Low(SEQIDX)
	mov	ch,04
	mov	cl,01
RestoreMemLoop:
	pop	bx
	mov	al,2
	mov	ah,cl
	out	dx,ax
	mov	byte ptr es:[di],bl
	shl	cl,1	
	dec	ch
	jnz	RestoreMemLoop
	mov	dl,Low(GFXIDX)
;v0.082}
;
comment	%					;v0.082
	MOV	AL,02				;Now enable all 4 planes
	MOV	AH,0FH				;in the map mask and read
	OUT	DX,AX				;the data into the latches
	MOV	AL,es:[DI] 			;Read data
%						;v0.082
	pop	ax
	out	dx,ax				;GR02

	POP	AX				;Get misc reg and data
	OUT	DX,AX				;Restore miscellaneous reg
	POP	AX				;Get graphics mode reg and data
	OUT	DX,AX				;Restore graphics mode reg
	POP	AX				;Get map select reg and data
	OUT	DX,AX				;Restore read map select
;***	MOV	DX,SEQIDX			;Now restore sequencer
	MOV	Dl,Low(SEQIDX)			;Now restore sequencer
	POP	AX				;Get memory mode reg and data
	OUT	DX,AX				;Restore memory mode register
	POP	AX				;Get plane map mask reg
	OUT	DX,AX				;Restore plane map mask reg

if NOSYNC_RESET eq YES
		mov	dx,03c4h	; sequencer
		mov	ax,0300h	; restart the sequencer
		setreg			; start it
endif
		pop	dx		; restore status one address
		mov	di,si		; remember how far along we are
		pop	si		; restore base of hardware state

		mov	al,feat[si]	; feature control
		set1reg			; set feature control

		sub	dl,6		; get crtc address
		mov	al,crx[si]	; crtc index
		set1reg			; restore crtc index

if (SAVE_EXT_IDX eq YES)
		cmp	dl,0D4h
		je	color_stack
		mov	[bp-1],al	; set ext idx saved @ entry pt. stack
		jmp	short crtc_stack_done
color_stack:
		mov	[bp-4],al	; set ext idx saved @ entry pt. stack
crtc_stack_done:
endif  ;(SAVE_EXT_IDX eq YES)

		mov	dl,0ceh		; graphics controller
		mov	al,grx[si]	; graphics index
		set1reg			; restore graphics index

if (SAVE_EXT_IDX eq YES)
		mov	[bp-2],al	; set ext idx saved @ entry pt. stack
endif  ;(SAVE_EXT_IDX eq YES)

		mov	dl,0c4h		; sequencer address
		mov	al,srx[si]	; sequencer index
		set1reg			; restore sequencer index

if (SAVE_EXT_IDX eq YES)
		mov	[bp-3],al	; set ext idx saved @ entry pt. stack
endif  ;(SAVE_EXT_IDX eq YES)

		mov	si,di		; si -> next state buffer
		pop	bx		; save state buffer contents
;
; check about restoring video data state
;
rs_data:
;gdl:01/16/92 Don't trash stack!
		test	b_cl[bp],02h	; restore video data state ?
		jz	rs_dac	; and go check dac

sr_rdata:
;
; restore video data
;
;v1.00B1	mov	di,w_bx[bp]		;v0.051  save buffer offset
;v1.00B1	mov	si,word ptr ds:[di+2]	;v0.051
;v1.00B1	{
		mov	di,w_bx[bp]
		mov	si,word ptr ds:[di+12h]
		add	si,di
;v1.00B1	}
		call	rs_bios_data	; restore bios data
;
; check about restoring dac state
;
rs_dac:
;gdl:01/16/92 Don't trash stack!
		test	b_cl[bp],04h	; restore dac state ?
		jz	sr_done		; nope, the way it should work

;
; restore dac state
;
;v1.00B1	mov	di,w_bx[bp]		;v0.051  save buffer offset
;v1.00B1	mov	si,word ptr ds:[di+4]	;v0.051
;v1.00B1	{
		mov	di,w_bx[bp]
		mov	si,word ptr ds:[di+14h]
		add	si,di
;v1.00B1	}
		mov	dx,3c6h		; mask register
		mov	al,rd_mask[si]	; get the mask
		set1reg			; set the mask

		push	si		; save base of dac state
		add	si,rd_rgs	; point to registers
		mov	dx,3c8h		; write address
		xor	al,al		; start with zero
		mov	cx,length rd_rgs; registers to restore
		pushf
		cli			; don't want to get interrupted

;(V1.3) {
	call	program_DAC
	call	save_set_sr12

	mov	dl, 0c8h
	mov	cx, 3		;RGB 3 bytes
	mov	al, 0		;DAC index 256
	call	program_DAC
	mov	cx, 3
	mov	al, 0fh		;DAC index 257
	call	program_DAC
	mov	cx, 3
	mov	al, 2		;DAC index 258
	call	program_DAC

	call	restore_sr12
;(V1.3) }
		popf			; ok to be interrupted now

		pop	si		; recover base of dac state

		inc	rgb_idx[si]	; put bias on  rgb index
		xor	ax,ax		; clear bx
		mov	al,rd_addr[si]	; index value
		mov	dl,0c7h
		mov	ch,rd_stat[si]	; is write state?
		or	ch,ch
		jnz	g_read		; nope
		inc	dx		; port 3c8
		push	ax
		mov	al,03h
		mul	rd_addr[si]	; times 3
		xchg	ax,bx
		mov	bx,word ptr rd_rgs[si+bx]  ; bl=red bh=green
		pop	ax
g_read:		set1reg			; set index --3c7/3c8
		mov	dl,0c9h		; set port 3c9

g_chk:		dec	rgb_idx[si]	; get rgb index
		jz	sr_done
		or	ch,ch
		jz	g_write		; write then jump
		get1reg			; get a dummy ram data
		jmp 	short g_chk

g_write:	xchg	al,bl		; set red data to al
		set1reg			; set data to port 3c9
		xchg	bh,bl		; set green data to bl
		jmp	short g_chk

sr_done:	mov	b_al[bp],1ch	; success return code

sr_st_exit:
		ret			; and return

;(V1.3) {
program_DAC:
		set1reg			; set write adress

		inc	dl		; point to data
if CPU ge 186
		set1regrep	       	; restore dac data
else
sr_rdac_loop:	lodsb			; get the value
		set1reg			; write it
		loop	sr_rdac_loop	; more registers ?
endif
		dec	dl		; point to 3c8h
		ret
;(V1.3) }


Video_Save_Restore_State	endp
;gdl;-----------------------------------------------------------------------
;***;
;***;	sv_bios_data()
;***;
;***;	Function:
;***;	   Copy BIOS data into specified save buffer
;***;
;***;	Input:
;***;	   es:di -> points to save buffer
;***;	   ds	 -> must be bios_data
;***;
;***;	Returns:
;***;	   Nothing.
;***;	   al, si, di, cx are trashed
;***;
;***;	Remarks:
;***;	   This routine is currently only called from Save/Restore State
;***;	and Display Switch.
;***;
;***;-----------------------------------------------------------------------
;***sv_bios_data	proc	near
;***		public	sv_bios_data
;***
;***		assume	ds:bios_data
;***		mov	si,offset equip ; offset of equipment flag
;***		lodsb			; get it
;***		and	al,30h		; just the monitor bits
;***		stosb			; and save it
;***
;***		mov	si,offset con_mode; cga/mda data
;***		mov	cx,length pc_dt ; bytes to read
;***		rep	movsb		; save them
;***
;***		mov	si,offset rows	; ega data
;***		mov	cl,length ega_dt; bytes to read
;***		rep	movsb		; save them
;***
;***		mov	si,offset save_ptr; save_ptr
;***		movsw			; save offset
;***		movsw			; save segment
;***
;***		mov	si,4*05h	; print screen vector
;***		movsw			; save offset
;***		movsw			; save segment
;***
;***		mov	si,4*1dh	; cmga parameters
;***		movsw			; save offset
;***		movsw			; save segment
;***
;***		mov	si,4*1fh	; chars 128 to 255
;***		movsw			; save offset
;***		movsw			; save segment
;***
;***		mov	si,4*43h	; font pointer
;***		movsw			; save offset
;***		movsw			; save segment
;***		ret
;***sv_bios_data	endp
page
;-----------------------------------------------------------------------
;
;	rs_bios_data()
;
;	Function:
;	   Copy BIOS data from specified save buffer
;
;	Input:
;	   ds:si -> points to save buffer
;
;	Returns:
;	   Nothing.
;	   ax, si, di, cx are trashed
;	   es=0000h
;
;	Remarks:
;	   This routine is currently only called from Save/Restore State
;	and Display Switch.
;
;-----------------------------------------------------------------------
rs_bios_data	proc	near
		public	rs_bios_data

		xor	ax,ax		; BIOS data segment
		mov	es,ax		; into es
		assume	es:bios_data	; and tell the assembler

		and	es:equip,not 30h; clear monitor bits
		lodsb			; get old monitor bits
		or	es:equip,al	; set old monitor bits

		mov	di,offset con_mode; cga/mda data
		mov	cx,length pc_dt ; bytes to read
		rep	movsb		; save them

		mov	di,offset rows	; ega data
		mov	cl,length ega_dt; bytes to read
		rep	movsb		; save them

		mov	di,offset save_ptr; save_ptr
		movsw			; restore offset
		movsw			; restore segment

		mov	di,4*05h	; print screen vector
		movsw			; restore offset
		movsw			; restore segment

		mov	di,4*1dh	; cmga parameters
		movsw			; restore offset
		movsw			; restore segment

		mov	di,4*1fh	; chars 128 to 255
		movsw			; restore offset
		movsw			; restore segment

		mov	di,4*43h	; font pointer
		movsw			; restore offset
		movsw			; restore segment
		ret
rs_bios_data	endp
page
;-----------------------------------------------------------------------
;
;	wr_block()
;
;	Function:
;	   Set a block of indexed registers.
;
;	Input:
;	   ds:si -> points to values to set
;	   bl	 -> first index to set
;	   cx	 -> number of registers to set
;	   dx	 -> I/O port of index register
;
;	Returns:
;	   Nothing.
;
;-----------------------------------------------------------------------
wr_block	proc	near
		public	wr_block

wb_loop:	lodsb			; get the value
		mov	ah,al		;    into ah
		mov	al,bl		; index into al
		setreg			; set register
		inc	bl		; next index
		loop	wb_loop		; more registers ?

		ret			; and return
wr_block	endp
page
;-----------------------------------------------------------------------
;
;	rd_block()
;
;	Function:
;	   Get a block of indexed registers.
;
;	Input:
;	   es:di -> points to where to store the values
;	   bl	 -> first index to get
;	   cx	 -> number of registers to get
;	   dx	 -> I/O port of index register
;
;	Returns:
;	   The registers.
;
;-----------------------------------------------------------------------
rd_block	proc	near
		public	rd_block

gb_loop:	mov	al,bl		; index into al
		call	getreg		; read it
		mov	al,ah		; data into al
		stosb			; store it

		inc	bl		; next index
		loop	gb_loop		; more registers ?

		ret			; and return
rd_block	endp
;-----------------------------------------------------------------------
;
;	palr_rdreg()
;
;	Function:
;	   Read an attribute controller register.
;
;	Input:
;	   ah -> the register to read
;
;	Returns:
;	   al <- the register value
;	   ah <- ah + 1
;	   dx <- 3c0h
;	   the attribute toggle pointing to data
;
;	Remarks:
;	   Routines that want to leave the attribute toggle
;	pointing to index can follow the call to this routine
;	with a dec dx and an out dx,al.
;
;-----------------------------------------------------------------------
palr_rdreg	proc	near
		public	palr_rdreg

		call	get_crtc_addr
		add	dl,6		; status register
		get1reg			; toggle to index

		mov	al,ah		; index to al
		mov	dl,0c0h		; attr controller
		set1reg			; set index
		inc	dx		; point to data
		get1reg			; read the data, no toggle
		inc	ah		; auto increment

		ret
palr_rdreg	endp

VGA_Segment	ends
		end
