	INCLUDE PAGE.INC
	SUBTTL	Standard VGA BIOS OEM Configuration Module
;****************************************************************
;
;	$Workfile:   vcp.asm  $
; 
; 	Copyright 1989, 1990 Quadtel Corporation.
; 	All rights reserved.
; 
;	Contents:
;	This module contains the VGA Configuration table
;	used to configure the BIOS at the OEM level.
;
; 	Modification History:
; 	$Log:   E:/vcs/vga/vga/oem/vcp.asv  $
;      
;         Rev 1.1   03 Jun 1991 17:23:16   Darryl
;      $UPDATE:Added PUBLIC declaration.
;      VGA_Segment1 is now PUBLIC.
;      $
;      
;         Rev 1.0   24 Dec 1990 04:19:12   Darryl
;      Initial checkin to VCS.
;      
;	01/02/90  Changes were made to support the VCP structure
;		  for the Quadtel VGAEDIT program.
;      
;****************************************************************

SUB_VERSION	EQU	01			;Chipset/OEM version
STRING_SUB	EQU	<'01'>                  ;Also in string form

	.XLIST
	INCLUDE VGADATA.INC
	include	config.inc
	include	options.inc
	include	biosdata.inc
	.LIST

	%OUT	Assembling Standard VGA OEM Configuration Module

cgroup	group	VGA_Segment

VGA_Segment	SEGMENT PUBLIC PARA

	ASSUME	CS:VGA_Segment
	ASSUME	DS:bios_data
	ASSUME	ES:NOTHING

	PUBLIC	Message_Ctrl
	PUBLIC	Module_Start
	PUBLIC	OEM_Msg
	PUBLIC	Quadtel_Msg
	PUBLIC	VGA_Options1
	PUBLIC	VGA_Options3

	EXTRN	C8X8_Character_Set:BYTE
	EXTRN	Mode_Parameters:BYTE
	EXTRN	Module_End:BYTE
	EXTRN	Power_On_Start:NEAR
	EXTRN	VGA_Video_Interface:NEAR
	EXTRN	Direct_Video_Interface:NEAR

	extrn	getreg:near
	extrn	use_switches:byte
	extrn	avga_confbyte:byte

;**********************************************************************
;   This must be the first module of the VGA BIOS. Included are
;   header, copyright, and oem configuration information.
;**********************************************************************

Module_Start	LABEL	BYTE

	DB	055H				;Signature used to
	DB	0AAH				;acknowledge VGA
	DB	BIOS_LEN / 512			;Size of VGA BIOS
ifdef TotallySkipPOST
	%out "WARNING: Including complete and total skip of POST of VGA."
	xor	bp,bp
	retf
else	;TotallySkipPOST
	JMP	Power_On_Start			;Start VGA POD
endif	;TotallySkipPOST

IFDEF	(PCI)
		ORG	7h
		db	11h dup(0)		;Reserved

		ORG	18h
		dw	offset PCI_Data_Area
ELSE	;PCI
		dw	PRODUCT_ID	; id for Cirrus bios on Cirrus Chips
		dw	Quadtel_Msg	; offset of version/copyright
		dw	0		; place holder

		org	0ch
		db	77h,0cch	; signature code 
		db	'VIDEO '	; for MCA support
comment	#				;v0.071
		extrn	ana_ptr_tbl_c000:dword	; ana save area
		extrn	table_ptrs:near

		public	pointers

		org	15h
		dw	offset cgroup:ana_ptr_tbl_c000

pointers	dw	offset cgroup:table_ptrs; array of table pointers

	org	19h
	dw	offset cgroup:Direct_Video_Interface
#					;v0.071
ENDIF	;PCI

	org	1bh
	jmp	VGA_Video_Interface

	org	01eh			; for VGA id

	DB	'IBM VGA Compatible BIOS. '

		org	30h		; MCA POS parameters here
		db	0f7h		; POS byte 102
		db	0c8h		; POS byte 103
		db	030h		; POS byte 104
		db	0dfh		; POS byte 105

	dw	offset cgroup:Direct_Video_Interface	;v0.071

	ORG	038H

;**********************************************************************
;      V I D E O   C O N F I G U R A T I O N   P A R A M E T E R S
;
;    This are contains parameters that allow customization of the
;    VGA BIOS. This information is located at fixed offsets within
;    the BIOS and should not be moved.
;**********************************************************************

;Video_Configuration_Parameters	  LABEL   BYTE
;
;BIOS_Header	DW	066BBH			;BMP Signature
;VCP_Length	DW	VCP_Size		;Length of VCP
;VCP_Checksum	DB	00H			;VCP straight checksum
;VCP_Revision	DB	00H			;VCP Revision number
;BIOS_Type	DB	02H			;Chip Type - Enhanced VGA (32K)
;Vendor_ID	DW	0000H			;Vendor ID word
;Privelege_Level DB	0FFH			;Privelege level (FF=least)
;VCP_Control	DB	00H			;Extra control area
;gdl Re-enable eval message
;gdl Disable eval message
ifdef ALPHA_VER
	Message_Ctrl	DB	00000100B		;D0=Quadtel,D1=OEM,D2=EVAL
else	;ALPHA_VER
 ifdef BETA_VER
	Message_Ctrl	DB	00000100B		;D0=Quadtel,D1=OEM,D2=EVAL
 else	;BETA_VER
	Message_Ctrl	DB	00000000B		;D0=Quadtel,D1=OEM,D2=EVAL
 endif	;BETA_VER
endif	;ALPHA_VER

Quadtel_Msg	LABEL	BYTE			;Quadtel Power on message
	DB BIOS_MSG
	db ' BIOS Version '
	db ((BIOS_VER and 0f00h) / 100h) + '0'
	db '.'
	db ((BIOS_VER and 00f0h) /  10h) + '0'
	db ((BIOS_VER and 000fh) /  01h) + '0'
	db 'B'
if (BIOS_VER_INCRE ne NO)
	db BIOS_VER_INCRE
endif
	db ' '
	db ALPHA_BETA_MSG
ifdef SPECIAL_MSG
	db SPECIAL_MSG
endif
	DB 0DH,0AH
	DB 'Copyright 1992-1994 Cirrus Logic, Inc. All Rights Reserved.',0DH,0AH
 	DB 'Copyright 1987-1990 Quadtel Corp. All Rights Reserved.',0DH,0AH,00

		ORG	Quadtel_Msg + 0A9H
OEM_Msg		label byte
		DB	00h

;gdl:01/15/92 Trim down message size to match what OEMSI allows.  We need the
;	space desperately.
		ORG	OEM_Msg + 050H
;		ORG	OEM_Msg + 0A0H
if 0	; gdl:11/26/91
BIOS_Date	DB	'01/01/91'              ;Date BIOS was created
VCP_Date	DB	'01/01/91'              ;Date BCP was last modified
Major_Ver	DB	BIOS_MAJOR		;Major BIOS revision
Minor_Ver	DB	BIOS_MINOR		;Minor BIOS revision
Sub_Ver 	DB	BIOS_SUB_VER		;Chipset/oem revision
endif	;0 gdl:11/26/91

VGA_Options1	DB	00000001B		;VGA Options 1 byte
  PS2_Mode	EQU	01H			;1=Mode Switch like PS/2
VGA_Options2	DB	00000000B		;VGA Options 2 byte
  Auto_Emul	EQU	01H			;1=Support Auto Emulation
  Locked_Emul	EQU	02H			;1=Support Locked Emulation
VGA_Options3	DB	00000000B		;VGA Options 3 byte

;****************************************************************
;   Breakout hooks for OEM options
;****************************************************************

;----------------------------------------------------------------------------
; Send the command in bx to the EEPROM

send_cmd:
	push	cx
	mov	cx,10			; command is 10 bits
	mov	al,ah			; Get original bit 6
	or	al,33h			; Or in EEPROM control
sc:
	shl	bx,1			; Get bit to send into carry flag
	jnc	sc1			; Jmp if a zero bit
	or	al,8			; Else or in a 1 bit
sc1:
	call	send_out		; Send it to the port (SK low)
	or	al,4
	call	send_out		; Send it to the port (SK high)
	and	al,not 12		; Clear data and clock bits
	loop	sc			; Loop until all bits have been sent
	pop	cx
	ret

;----------------------------------------------------------------------------

		public	_writeprom
_writeprom:
	test	cs:avga_confbyte,088h	; Local Bus or eeprom removed?
	jnz	prom_done		; yes, forget the eeprom

	push	bx
	mov	bx,'CL'
	mov	ax,write_cmd0
	call	WritePromWord

	pop	bx
	mov	ax,write_cmd1
	call	WritePromWord

if 0
ifdef (ALP_NEW)
	mov	bx, cx
	mov	ax,write_cmd1
	call	WritePromWord

endif	; (ALP_NEW)
endif

prom_done:
	ret

;----------------------------------------------------------------------------

send_word:
	push	cx
	mov	cx,16			; Write 16 bits at a time
ww:
	and	al,not 12		; Clear data and SK
	rcl	bx,1			; Put data into the carry flag
	jnc	ww1			; If a 0 bit
	or	al,8			; Else set a 1 bit
ww1:
	call	send_out		; Send clock bit low
	or	al,4			; Set the clock bit
	call	send_out		; Send clock bit high
	in	al,dx			; Get data bit
	loop	ww			; Loop until all bits have been written
	pop	cx
	ret

;----------------------------------------------------------------------------
;
	PUBLIC	XXX

	ALIGN	16				;(3/22/93) V1.204,5 {

XXX	PROC	near

        DEC     AH                              ;Down one
	JE      YYY                             ;Timed out

Horiz_In_Loop:
	IN	AL,DX				;Get Horizontal retrace
	TEST	AL,01				;Test for Horizontal retrace
	LOOPE	Horiz_In_Loop			;No -Keep waiting for entry
	JE	XXX
YYY:
	mov	ah, 5			;put bigger value without setting cx=0
XXXX:
	dec	ah
	je	YYYY
wait_for_on:
	IN	AL,DX				;Get Horizontal retrace
	TEST	AL,01				;Test for Horizontal retrace
	LOOPNE	wait_for_on			;No -Keep waiting for entry
	JNE     XXXX
YYYY:
	MOV	DX,Miscellaneous		;Now read sense bit
	IN	AL,DX				;from miscellaneous reg
	ret
						;(3/22/93) V1.204,5 }
XXX	endp


;---------------------------------------------------------------------
IFDEF (PCI)
	ALIGN	4
PCI_Data_Area:
	db	'PCIR'			;PCI Signature
	dw	1013h			;Vendor ID, Cirrus Logic ID
	dw	00A8h			;Device ID, Alpine ID
	dw	0			;Vital Product Data pointer
	dw	18h			;PCI Data Struture length
	db	0			;PCI Data Structure Revision
;v1.00a	db	03h,00h,00h		;Class Code
	db	00h,00h,03h		;Class Code  v1.00a
	dw	BIOS_LEN / 512		;Image length
	dw	0			;ROM Revision Level
	db	0			;Code Type = Intel 86x
	db	10000000b		;Indicator, last image
	dw	0			;Reserved
ENDIF	;PCI
;---------------------------------------------------------------------
;

	PUBLIC	Configure_OEM_Options

Configure_OEM_Options:

	test	cs:avga_confbyte,088h	; Local Bus or eeprom removed?
	jnz	EEPROMReadDone		; yes, forget the eeprom

	call	enable_eeprom		; Turn on the EEPROM
					;Careful: DX and AL contain info
					; necessary for subsequenct calls
	mov	bx,read_cmd0		; Get ready to read a word
	call	send_cmd		; Send a command
	call	get_word		; Get a word from the EEPROM
	push	bx			;Save data from EEPROM
	call	disable_eeprom		; Turn off the EEPROM

	call	enable_eeprom		; Turn on the EEPROM
	mov	bx,read_cmd1		; Get ready to read a word
	call	send_cmd		; Send a command
	call	get_word		; Get a word from the EEPROM
	push	bx			;Save signature from EEPROM
	call	disable_eeprom		; Turn off the EEPROM

	pop	bx
	pop	ax
	cmp	ax,'CL'
	jne	EEPROMReadDone

	mov	dx,SEQIDX
	mov	al,09h
ifdef	(MONTYPE_VERT)
	call	getreg			; dont blow away [1:0]
	and	bl,0FCh			; Update SR09[7:2] only (montype)
	and	ah,not 0FCh
else  ;(MONTYPE_VERT)
	and	bl,01Ch			; Update SR09[4:2] only (montype)
	and	ah,not 01Ch
endif ;(MONTYPE_VERT)
	or	ah,bl
	setreg

	inc	ax
	call	getreg
;v0.082and	ah,not 040h		; Update SR0A[6] only (high ref)
;v0.082and	bh,040h
;v0.082or	ah,bh
	mov	ah,bh			;v0.082
	setreg

EEPROMReadDone:

	mov	ax,448Eh		; planar BIOS configuration call
	int	15h

	ret

; The commands to the EEPROM are left justified
read_cmd0	equ	0110000000000000b	; Read command (Address 0)
read_cmd1	equ	0110000001000000b	; Read command (Address 1)
wen_cmd		equ	0100110000000000b	; Write enable command
write_cmd0	equ	0101000000000000b	; Write command (Address 0)
write_cmd1	equ	0101000001000000b	; Write command (Address 1)

;---------------------------------------------------------------------------

WritePromWord:
	push	cx
	push	bx			; Save value to program
	push	ax
	call	enable_eeprom		; Turn on the EEPROM

	mov	bx,wen_cmd		; Enable the EEPROM write command
	call	send_cmd		; Send a command

	call	ToggleEEPROMCS

	pop	bx			; Get ready to read a word
	call	send_cmd		; Send a command
	pop	bx			; Get word to send
	call	send_word		; Get a word from the EEPROM

	call	ToggleEEPROMCS

;***	mov	cx,800h
	xor	cx,cx
WriteEEPROMLoop:
	get1reg
	test	al,80h
	loopz	WriteEEPROMLoop

	call	disable_eeprom		; Turn off the EEPROM
	pop	cx
	ret

ToggleEEPROMCS:
	and	al,not 0Ch
	call	send_out		; Send it out
	and	al,not 1		; Disable EEPROM CS
	call	send_out		; Send it out
	or	al,1			; Enable EEPROM CS
	call	send_out		; Send it out
	ret

;----------------------------------------------------------------------------
; Send out the control 8 times, this is done to provide for proper I/O delays
send_out:
	push	cx
;***	mov	cx,8
	mov	cx,16
so:
	out	dx,al			; Send data to the port
	loop	so			; Do it 8 times
	pop	cx
	ret

;----------------------------------------------------------------------------
get_word:
	push	cx
	mov	cx,16			; Read 16 bits at a time
gw:
	mov	al,ah
	and	al,40h
	or	al,33h
	call	send_out		; Send clock bit low
	or	al,4			; Set the clock bit
	call	send_out		; Send clock bit high
	in	al,dx			; Get data bit
	rcl	al,1			; Put data into the carry flag
	rcl	bx,1			; Save new bit
	shr	al,1			; Restore port data
	loop	gw			; Loop until all bits have been read in
	pop	cx
	ret

;----------------------------------------------------------------------------
enable_eeprom:
	mov	dx,SEQIDX		; Point to the sequencer
	mov	al,8			; EEPROM at index 8
	out	dx,al			; Select eeprom port
	inc	dx			; Point to control port
	in	al,dx			; Get current setting
	mov	ah,al			; Save port value

	or	al,20h			; Latch Evideo & Esync
	call	send_out		; Send it to the port
	or	al,12h			; Enable EEPROM data and SK
	call	send_out		; Send it to the port
	or	al,1			; Enable EEPROM CS
	call	send_out		; Send it to the port

	ret

;----------------------------------------------------------------------------
disable_eeprom:
	mov	al,ah			; Get bit 6
	and	al,40h			; Mask to bit 6
	or	al,33h			; Or in eeprom control
	call	send_out		; Send it out
	and	al,not 1		; Disable EEPROM CS
	call	send_out		; Send it out
	call	send_out		; Send it out (extra dalay)
	and	al,not 12h		; Disable EPROM data out and SK
	call	send_out		; Send it out
	and	al,not 20h		; Disable EEPROM latch
	call	send_out		; Send it out
	mov	al,ah			; Get original port value
	out	dx,al			; Write it to the port
	ret



;****************************************************************
VGA_Segment	ENDS

	END
