	INCLUDE PAGE.INC
	SUBTTL	VGA BIOS Module E
;****************************************************************
;
;	$Workfile:   vgae.asm  $
; 
; 	Copyright 1989, 1990 Quadtel Corporation.
; 	All rights reserved.
; 
;	Contents:
;	This module contains the read character function, and the
;	write character functions for both standard and VGA modes.
;
; 	Modification History:
; 	$Log:   M:/vcs/vga/vgae.asv  $
;      
;         Rev 1.1   23 Jul 1991 20:49:20   dale
;      The read/write character routines were modified to reload
;      the DS register upon exit, relieving the burden from function
;      0EH. This enhanced the performance of Function 0EH.
;      
;         Rev 1.0   21 Dec 1990 11:00:28   Darryl
;      Initial checkin to VCS.
;
;	09/14/89  XOR functions for modes 4,5 and D-12 did
;		  not work properly. Broke during speed
;		  optimizations.
;
;	07/08/89  Speed optimizations made to read character
;		  write character functions.
;
;****************************************************************

	.XLIST
	INCLUDE VGADATA.INC
	.LIST

	%OUT	Assembling VGA BIOS Module E

VGA_Segment SEGMENT PUBLIC WORD

	PUBLIC	Video_Read_Char_Attr
	PUBLIC	BIOS_Read_Char_Attr
	PUBLIC	Default_VGA_Read_Char
	PUBLIC	Default_VGA_Write_Char_Attr
	PUBLIC	Default_VGA_Write_Char
	PUBLIC	Default_CGA_Write_Char
	PUBLIC	Default_CGA_Write_Char_Attr
	PUBLIC	Default_CGA_Read_Char
	PUBLIC	Do_VGA_Graphics_Read
	PUBLIC	Do_VGA_Graphics_Write
	PUBLIC	Do_VGA_Mode13_Read
	PUBLIC	Video_Write_Char
	PUBLIC	Video_Write_Char_Attr


	EXTRN	BIOS_Address:WORD
	EXTRN	C8x8_Character_Set:BYTE
	EXTRN	Extended_Read_Char:NEAR
	EXTRN	Extended_Write_Char_Attr:NEAR
	EXTRN	Extended_Write_Char:NEAR
	EXTRN	INT_Address:WORD
	EXTRN	Segment_A000:WORD
	extrn	DetectEnvPtr:near		;v0.051

	ASSUME	CS:VGA_Segment
	ASSUME	DS:VGA_Data_Area
	ASSUME	ES:NOTHING

;****************************************************************
;   AH = 08	Read character and attribute at cursor
;		BH - Video page to read character
;		Exit:	AL - Character
;			AH - Character attribute
;****************************************************************

;gdl	ALIGN	4

Video_Read_Char_Attr PROC NEAR
	CALL	BIOS_Read_Char_Attr		;Use routine without stack
	MOV	AX_Stack,AX			;access. Now save on stack
	RET
Video_Read_Char_Attr ENDP

;gdl	ALIGN	4

BIOS_Read_Char_Attr	PROC	NEAR
	MOV	AH,Video_Mode			;Get current video mode
	CMP	AH,07				;Test for compatible mode
	JBE	Default_CGA_Read_Char		;Go handle CGA modes

	cmp	ah,0Ch
	jbe	BIOS_Read_Char_Attr_Abort

	CMP	AH,13H				;Test for mode 13
	JE	Mode13_Read			;Go handle mode 13
	ja	Do_Extended_Read_Char		;Do extended graphics read
;	JB	Default_VGA_Read_Char		;Perform VGA graphics read
;	JMP	Extended_Read_Char		;Do extended graphics read

;gdl	ALIGN	4

Default_VGA_Read_Char:
	JMP	VGA_Graphics_Read		;Perform VGA graphics read
Do_Extended_Read_Char:
	jmp	Extended_Read_Char		;Do extended graphics read

;gdl	ALIGN	4

Default_CGA_Read_Char:
	MOV	DX,AX				;Save callers register
	MOV	AX,Equipment_Installed		;Get equipment installed
	AND	AL,030H 			;Isolate video switches
	CMP	AL,030H 			;Test if monochrome
	MOV	AX,0B000H			;Get monochrome seg address
	JE	Set_Regen_Ptr			;Yes-Go set monochrome seg
	MOV	AH,0B8H 			;Advance to color graphics

Set_Regen_Ptr:
	MOV	ES,AX				;Set video segment address
	MOV	AX,DX				;Restore callers AX

IFDEF ADAPTER
	CMP	AH,02				;Are we in 40 x 25 mode
	JB	Fast_Read			;Yes-Go write w/o retrace
	CMP	AH,04				;Are we in 80 x25 CG
	JB	Slow_Read			;Yes-Go write with retrace
ELSE
	CMP	AH,04				;Are we a text mode
	JB	Fast_Read			;Yes-Go write w/o retrace
ENDIF

	CMP	AH,07				;Are we in monochrome
	JE	Fast_Read			;Yes-Go write w/o retrace
	JMP	Graphics_Read			;Go do graphics write

Mode13_Read:
	JMP	VGA_Mode13_Read

;gdl	ALIGN	4

Fast_Read:
	OR	BH,BH				;Handle page 0 as a
	JNE	Not_Page0_RC			;special case
	MOV	BX,Cursor_Location[00]		;Get cursor position
	MOV	AL,BYTE PTR Video_Columns	;Get column position
	MUL	BH				;Multiply by row size
	XOR	BH,BH				;Column position is in BX
	ADD	BX,AX				;Add in column offset
	SHL	BX,1				;Mult by 2 for attributes
	MOV	AX,ES:[BX]			;Read character from screen
BIOS_Read_Char_Attr_Abort:
	RET

Not_Page0_RC:
	CALL	Text_Position			;Compute character position
	MOV	AX,ES:[DI]			;Read character from screen
	RET

IFDEF ADAPTER
Slow_Read:
	TEST	EGA_StatusA,Retrace_Active	;Test for retrace active
	JE	Fast_Read			;Don't wait for retrace
	CALL	Text_Position			;Compute text position
	MOV	DX,M6845_Address		;Get 6845 base address
	ADD	DX,06				;Advance to status register
	MOV	AX,ES				;Set DS:SI to Video segment
	MOV	DS,AX				;for fast screen access
	MOV	SI,DI				;during horizontal retrace

Read_In_Retrace:
	IN	AL,DX				;Wait for out of retrace
	AND	AL,01				;Test if in retrace
	JNE	Read_In_Retrace 		;Yes-Dont catch it in the
;gdl	CLI					;middle to avoid hash

Read_Out_Retrace:
	IN	AL,DX				;Now wait for entry back into
	AND	AL,01				;retrace before reading char
	JE	Read_Out_Retrace		;Keep waiting for retrace
	LODSW					;Get char/attr from screen
	MOV	DS,INT_Address			;It wasn't-Check for user
	RET
ENDIF

;****************************************************************
;   Read the data from the screen and match against a
;   character set.
;****************************************************************

Graphics_Read:
	MOV	AL,BYTE PTR Cursor_Location[01] ;Get current row position
	MUL	BYTE PTR Video_Columns		;Multiply by column length
	MOV	DI,AX				;Save row offset
	SHL	DI,1				;Multiply by 4 since 4 lines
	SHL	DI,1				;per char (dont count odd)
	MOV	AL,BYTE PTR Cursor_Location[00] ;Get column position
	XOR	AH,AH				;Extend to AX
	ADD	DI,AX				;Add column offset
	MOV	AH,Video_Mode
	CMP	AH,06				;Are we in hi res graphics
	JE	Hi_PositionGP			;Yes-Weve got our position
	SHL	DI,1				;Have two bytes / row

Hi_PositionGP:
	ADD	DI,2000H + 0F0H 		;Move to last scan row of char
	CMP	AH,06				;Test if in hi res mode
	MOV	SI,DI				;Setup DS:SI to char position
	MOV	AX,ES				;for fast access
	MOV	DS,AX				;Set DS to video regen segment
	MOV	CX,04				;Scan 4 even and 4 odd lines
	JE	Read_Hi_Res_Char		;Go handle hi res mode

Read_Low_Res_Row:
	CALL	Row_Read			;Read odd low res row
	MOV	BH,BL				;Save value read
	SUB	SI,2000H + 2			;Move to even row
	CALL	Row_Read			;Read even low res row
	ADD	SI,2000H - 2 - 50H		;Move to next odd row
	PUSH	BX				;Build character on stack
	LOOP	Read_Low_Res_Row		;Repeat for all scan lines
	JMP	SHORT Find_Character		;Now go find it

Read_Hi_Res_Char:
	LODSB					;Read odd high res row
	MOV	AH,AL				;Save value read
	SUB	SI,2000H + 1			;Move to even row
	LODSB					;Read even low res row
	ADD	SI,2000H - 50H - 1		;Move to next odd row
	PUSH	AX				;Build character on stack
	LOOP	Read_Hi_Res_Char		;Repeat for all scan lines

Find_Character:
	MOV	SI,SP				;Save ptr to character to find
	MOV	AX,SS				;Set DS:SI to character data
	MOV	DS,AX				;just read
	MOV	AX,CS				;Set ES:DI to first 128 char
	MOV	ES,AX				;table located within BIOS
	MOV	DI,OFFSET C8x8_Character_Set	;Get offset to table
	MOV	DX,128				;Search for chars 0 - 127
	CALL	Character_Search		;Search character table
	JNE	Return_Character		;Go -If character was found
	MOV	ES,INT_Address			;It wasn't-Check for user
	LES	DI,ES:[01FH*4]			;Get top 128 character table
	MOV	AX,ES				;Test if table exists by
	OR	AX,DI				;check if address is zero
	JE	Return_Character		;Yes-No character is there
	MOV	DX,128				;Search for character
	CALL	Character_Search		;in 128-255 range
	JE	Return_Character		;Exit if not found
	ADD	AL,128				;Yes-Char was relative zero

Return_Character:
	MOV	DS,INT_Address			;It wasn't-Check for user
	ADD	SP,08				;Clear character from stack
	RET

;****************************************************************
;  Character read modes 0DH through 12H
;****************************************************************
public	VGA_Graphics_Read
VGA_Graphics_Read:
	MOV	AX,0A000H			;High res mode page
	MOV	ES,AX				;Set high res
	MOV	AL,BH				;Get page number
	XOR	AH,AH				;Reset high byte
	SHL	AX,1				;Make word offset
	MOV	SI,AX				;Get page number
	MOV	AX,Cursor_Location[SI]		;Get cursor location
	MOV	SI,AX				;Get column
	AND	SI,0FFH 			;Reset high byte
	MOV	AL,AH				;AL is row position
	MUL	BYTE PTR Video_Columns		;Multiply by columns
	MUL	Char_Length			;Multiply by length
	ADD	SI,AX				;Set starting scan line
	XOR	AH,AH				;Reset high byte
	MOV	AL,BH				;Get page number
	MUL	Video_Length			;Multiply by page size
	ADD	SI,AX				;Add to base

Do_VGA_Graphics_Read:
	MOV	AL,BYTE PTR Char_Length 	;Get length of character
	DEC	AL				;Backup by one
	MUL	BYTE PTR Video_Columns		;Multiply by width
	ADD	SI,AX				;Point to last scan line
	MOV	AX,0805H			;Set color compare
	MOV	DX,Graphics_Controller
	OUT	DX,AX				;Write to the controller
	MOV	CX,Char_Length			;Get number of scan lines
	MOV	BX,Video_Columns		;Get width
	INC	BX				;Subtract one more

Read_Graphics_Loop:
	LODS	BYTE PTR ES:[SI]		;Set color compare
	MOV	AH,AL				;Save byte
	NOT	AH				;Invert result
	PUSH	AX				;Save on stack
	INC	SP				;Remove byte from stack
	SUB	SI,BX				;Backup one scan
	LOOP	Read_Graphics_Loop		;Read entire byte
	MOV	AX,05				;Restore read/write mode
	OUT	DX,AX				;Reset color compare
	MOV	SI,SP				;Get stack pointer
	XOR	AL,AL				;Start with first character
	MOV	ES,INT_Address			;Set interrupt area
	LES	BX,ES:[43H*4]			;Get pointer to graphics
	MOV	DX,SI				;Save pointer to character
;v0.083{
	cmp	Char_length,14			;Is 14 height font?
	jnz	short NotFont14
	call	DetectEnvPtr
	jnz	short NotFont14
	mov	ah,5
NotFont14:
;v0.083}
	MOV	DI,BX				;Save pointer to table
	MOV	BX,Char_Length			;Get length of character
	mov	cx, 256				;256 font images

Locate_High_Res_LoopA:
	push	cx
	push	di	 			; save DI
	MOV	CX,BX				;Get length of character
	REPE	CMPS BYTE PTR SS:[SI],ES:[DI]	;Test for match
	pop	di	     			; restore DI
	pop	cx
	JE	Found_High_ResA 		;Found character

	ADD	DI, BX				;Next position
;v0.083{
	or	ah,ah
	jz	short NonFont14
	add	di,2
NonFont14:
;v0.083}
	MOV	SI,DX				;Restore position
	INC	AL				;Next character
	JNE	Locate_High_Res_LoopA		;Locate character

Found_High_ResA:
	MOV	AH,05				;For compatibility
	ADD	SP,Char_Length			;Restore stack
	RET

comment	%					;v0.083{
VGA_Graphics_Read:
	MOV	AX,0A000H			;High res mode page
	MOV	ES,AX				;Set high res
	MOV	AL,BH				;Get page number
	XOR	AH,AH				;Reset high byte
	SHL	AX,1				;Make word offset
	MOV	SI,AX				;Get page number
	MOV	AX,Cursor_Location[SI]		;Get cursor location
	MOV	SI,AX				;Get column
	AND	SI,0FFH 			;Reset high byte
	MOV	AL,AH				;AL is row position
	MUL	BYTE PTR Video_Columns		;Multiply by columns
	MUL	Char_Length			;Multiply by length
	ADD	SI,AX				;Set starting scan line
	XOR	AH,AH				;Reset high byte
	MOV	AL,BH				;Get page number
	MUL	Video_Length			;Multiply by page size
	ADD	SI,AX				;Add to base

Do_VGA_Graphics_Read:
	MOV	AL,BYTE PTR Char_Length 	;Get length of character
	DEC	AL				;Backup by one
	MUL	BYTE PTR Video_Columns		;Multiply by width
	ADD	SI,AX				;Point to last scan line
	MOV	AX,0805H			;Set color compare
	MOV	DX,Graphics_Controller
	OUT	DX,AX				;Write to the controller
	MOV	CX,Char_Length			;Get number of scan lines
	MOV	BX,Video_Columns		;Get width
	INC	BX				;Subtract one more

Read_Graphics_Loop:
	LODS	BYTE PTR ES:[SI]		;Set color compare
	MOV	AH,AL				;Save byte
	NOT	AH				;Invert result
	PUSH	AX				;Save on stack
	INC	SP				;Remove byte from stack
	SUB	SI,BX				;Backup one scan
	LOOP	Read_Graphics_Loop		;Read entire byte
	MOV	AX,05				;Restore read/write mode
	OUT	DX,AX				;Reset color compare
	MOV	SI,SP				;Get stack pointer
	XOR	AL,AL				;Start with first character
	MOV	ES,INT_Address			;Set interrupt area
	LES	BX,ES:[43H*4]			;Get pointer to graphics
	MOV	DX,SI				;Save pointer to character

Locate_High_Res_LoopA:
	MOV	DI,BX				;Save pointer to table
;gdl	pushf
;	CLI					;No interrupts
	MOV	CX,Char_Length			;Get length of character
	REPE	CMPS BYTE PTR SS:[SI],ES:[DI]	;Test for match
;	popf					;Allow interrupts again
	JE	Found_High_ResA 		;Found character
	ADD	BX,Char_Length			;Next position
	MOV	SI,DX				;Restore position
	INC	AL				;Next character
	JNE	Locate_High_Res_LoopA		;Locate character

Found_High_ResA:
	MOV	AH,05				;For compatibility
	ADD	SP,Char_Length			;Restore stack
	RET
%						;v0.083}
;****************************************************************
;  VGA Mode 13 Character read
;****************************************************************

VGA_Mode13_Read:
	MOV	AX,0A000H			;High res mode page
	MOV	ES,AX				;Set high res
	MOV	AX,Cursor_Location[00]		;Get cursor location
	MOV	DI,AX				;Get column
	AND	DI,0FFH 			;Reset high byte
	MOV	AL,AH				;AL is row position
	MUL	BYTE PTR Video_Columns		;Multiply by columns
	MUL	Char_Length			;Multiply by length
	ADD	DI,AX				;Set starting scan line
	SHL	DI,1				;Multiply by eight
	SHL	DI,1				;since each character
	SHL	DI,1				;is eight bytes wide

Do_VGA_Mode13_Read:
	MOV	AL,BYTE PTR Char_Length 	;Get length of character
	DEC	AL				;Backup by one
	MUL	BYTE PTR Video_Columns		;Multiply by width
	MOV	CL,03				;Multiply by eight since
	SHL	AX,CL				;width is 8 bytes
	MOV	SI,DI				;Get current offset
	ADD	SI,AX				;Add offset to last line
	MOV	DX,Video_Columns		;Get width
	SHL	DX,CL				;Determine physical width
	ADD	DX,08				;Subtract 8 more every line
	MOV	CX,Char_Length			;Get number of scan lines

Read_Mode13_Char_Loop:
	MOV	BL,08				;Read eight byte per line
	XOR	AH,AH				;Clear starting value

Read_Mode13_Line_Loop:
	LODS	BYTE PTR ES:[SI]		;Get byte from video ram
	CMP	AL,01				;Is it zero or non-zero
	CMC					;C = non-zero, NC = zero
	RCL	AH,1				;Roll into result
	DEC	BL				;Repeat for eight chars
	JNE	Read_Mode13_Line_Loop
	PUSH	AX				;Save on stack
	INC	SP				;Remove byte from stack
	SUB	SI,DX				;Backup one scan
	LOOP	Read_Mode13_Char_Loop		;Read entire byte
	MOV	SI,SP				;Get stack pointer
	XOR	AL,AL
	MOV	ES,INT_Address			;Set interrupt area
	LES	BX,ES:[43H*4]			;Get pointer to graphics
	MOV	DX,SI				;Save pointer to character

Locate_High_Res_LoopB:
	MOV	DI,BX				;Save pointer to table
;gdl	pushf
;	CLI					;No interrupts
	MOV	CX,Char_Length			;Get length of character
	REPE	CMPS BYTE PTR SS:[SI],ES:[DI]	;Test for match
;	popf					;Allow interrupts again
	JE	Found_High_ResB 		;Found character
	ADD	BX,Char_Length			;Next position
	MOV	SI,DX				;Restore position
	INC	AL				;Next character
	JNE	Locate_High_Res_LoopB		 ;Locate character

Found_High_ResB:

	XOR	AH,AH				;For compatibility
	ADD	SP,Char_Length			;Restore stack
	RET
BIOS_Read_Char_Attr ENDP

;****************************************************************
;   Read a entire row of the a medium resolution character and
;   compress it to a one byte (8 pixel) value. The bit is
;   determined to be a off, if and only if both bits of the pel
;   are zero.
;
;   Entry: DS:SI - Pointer to character scan row
;****************************************************************

Row_Read PROC NEAR
	MOV	DL,08				;Decode 8 column pixels/char
	XOR	BL,BL				;Initial value is zero
	LODSW					;Read 16 bits for column
	XCHG	AL,AH				;Put in order displayed

Read_Next_Column:
	SHL	AX,1				;Roll high bit into carry
	JNS	Set_Read_Column 		;Go if new high bit isnt set
	STC					;If it is set then bit is a 1

Set_Read_Column:
	RCL	BL,1				;Roll in a 1 if either bit set
	SHL	AX,1				;Clear 2nd bit out of word
	DEC	DL				;Decrement column count
	JNE	Read_Next_Column		;Repeat for all columns
	RET
Row_Read ENDP

;****************************************************************
;   Search the specified character table for a match. If a match
;   is found then the character code number will be returned.
;   Each character table entry is assumed to be 8 bytes long,
;   that is, one byte for each scan row (8 x 8 font).
;
;   Entry: DS:SI - Character to be found
;	   ES:DI - Pointer to character table
;	      DX - Characters in Table
;****************************************************************

Character_Search PROC NEAR
	MOV	BX,DI				;Save start of table
	PUSH	BP

Search_Next_Char:
	MOV	AX,SI				;Save start of character
	MOV	BP,DI				;Save current table ptr
	MOV	CX,04				;Match four words (8 bytes)
	REPE	CMPSW				;Check if entries match
	MOV	DI,BP				;Restore start of entry
	JE	Found_It			;Yes-Go return code number
	ADD	DI,08				;No -Advance to next char
	MOV	SI,AX				;Restore char to match ptr
	DEC	DX				;Decrement entries in table
	JNE	Search_Next_Char		;Repeat until table checked
	POP	BP
;gdl:02/03/92 Fixup read char return for failure
	xor	ax,ax				;Character not found
	RET					;Return Z if not found

Found_It:
	SUB	DI,BX				;Subtract start of table
	MOV	CL,03				;Divide by 8 since there
	SHR	DI,CL				;are 8 bytes per character
	MOV	AX,DI				;Get character code in AX
	OR	CL,CL				;Set NZ condition
	POP	BP
	RET
Character_Search ENDP

;****************************************************************
;   Compute the character position from the cursor location of the
;   specified page.
;
;   Entry: BH - Video page
;	   BL - Screen attribute (Write Only)
;   Exit:  DI - Screen location
;	   AH - Screen attribute
;	   AL - Character (Write Only)
;****************************************************************

Text_Position PROC NEAR
	MOV	AH,BL
	MOV	DI,AX
	MOV	BL,BH				;Get active page
	XOR	BH,BH				;Extend to BX
	MOV	AX,Video_Length 		;Compute page start address
	SHR	AX,1				;Only character calculation
	MUL	BX				;by multiply by page size
	MOV	DX,AX				;Save page start
	SHL	BX,1				;Get word offset for cursor
	MOV	BX,Cursor_Location[BX]		;Get cursor position
	MOV	AL,BYTE PTR Video_Columns	;Get column position
	MUL	BH				;Multiply by row size
	ADD	AX,DX				;Add to page start
	XOR	BH,BH				;Column position is in BX
	ADD	AX,BX				;Add in column offset
	SHL	AX,1				;Mult by 2 for attributes
	XCHG	AX,DI
	RET
Text_Position ENDP

;****************************************************************
;   AH = 09	Write character and attribute at cursor
;		AL - Character to write
;		BL - Character attribute for alpha modes
;		     Character color for graphics modes
;		BH - Page to write character
;		CX - Count of characters to write
;****************************************************************

;gdl	ALIGN	4

Video_Write_Char_Attr PROC NEAR
	MOV	AH,Video_Mode			;Get current video mode
	CMP	AH,07				;Test for above standard
	JBE	Default_CGA_Write_Char_Attr	;Go handle CGA modes

	cmp	ah,0Ch
	jbe	Video_Write_Char_Attr_Abort

	CMP	AH,13H				;Test for mode 13
	JE	VGA_Mode13_Write		;Go handle mode 13
	ja	Do_Extended_Write_Char_Attr	;Do extended graphics write
;	JB	Default_VGA_Write_Char_Attr	;Perform VGA graphics write
;	JMP	Extended_Write_Char_Attr	;Do extended graphics write

Default_VGA_Write_Char_Attr:
	CMP	AH,11H				;Are we mode 11
	JNE	Not_VGA_Mode11			;No -Go handle VGA write
	AND	BL,080H 			;Yes-Always use 3F attr
	OR	BL,03FH 			;Dont destroy XOR bit

Not_VGA_Mode11:
	JMP	VGA_Graphics_Write		;Perform VGA graphics write
Do_Extended_Write_Char_Attr:
	jmp	Extended_Write_Char_Attr	;Do extended graphics write

;gdl	ALIGN	4

VGA_Mode13_Write:
	JMP	VGA_Graphics_Mode13		;Go perform mode 13 write

;gdl	ALIGN	4

Default_CGA_Write_Char_Attr:
	MOV	DL,BYTE PTR Equipment_Installed ;Get equipment installed
	AND	DL,030H 			;Isolate video switches
	CMP	DL,030H 			;Test if monochrome
	MOV	DX,0B000H			;Get monochrome seg address
	JE	Set_Write_RegenCA		;Yes-Go set monochrome seg
	MOV	DH,0B8H 			;Advance to color graphics

Set_Write_RegenCA:
	MOV	ES,DX				;Set video segment address
	CMP	AH,07				;Are we in monochrome
	JE	Fast_Write_CA			;Yes-Go write w/o retrace
	CMP	AH,03
	JA	Goto_Graphics_Write

;gdl:04/03/92 This should be done in motherboard as well, and we don't need
;	to check for mode 0,1,2, which should be just 0 and 2, anyway, for
;	color burst.
IFDEF ADAPTER
;	CMP	AH,02				;Are we in 40 x 25 mode
;	JB	Fast_Write_CA			;Yes-Go write w/o retrace
	TEST	EGA_StatusA,Retrace_Active	;Test for retrace active
	JNE	Slow_Write_CA			;Don't wait for retrace
ENDIF

Fast_Write_CA:
	OR	BH,BH				;Handle page 0 as a
	JNE	Not_Page0_WCA			;special case
	MOV	AH,BL				;Save attribute
	MOV	DI,AX
	MOV	BX,Cursor_Location[00]		;Get cursor position
	MOV	AL,BYTE PTR Video_Columns	;Get column position
	MUL	BH				;Multiply by row size
	XOR	BH,BH				;Column position is in BX
	ADD	AX,BX				;Add in column offset
	SHL	AX,1				;Mult by 2 for attributes
	XCHG	AX,DI
	REP	STOSW
Video_Write_Char_Attr_Abort:
	RET


Not_Page0_WCA:
	CALL	Text_Position			;Compute location from cursor
	REP	STOSW				;Write the characters
	RET


Goto_Graphics_Write:
	JMP	Graphics_Write


;gdl:04/03/92 This should be done in motherboard as well.
IFDEF ADAPTER
Slow_Write_CA:
	CALL	Text_Position			;Compute location from cursor
	MOV	DX,M6845_Address		;Get 6845 address
	ADD	Dl,06				;Advance to status register
	MOV	BL,AL				;Get character to write

Wait_For_Out_CA:
;	IN	AL,DX				;Read retrace status
;	TEST	AL,01				;Test for retrace bit
;	JNE	Wait_For_Out_CA 		;Wait until we exit retrace

Wait_For_In_CA:
	IN	AL,DX				;Read retrace status
	TEST	AL,01				;Test for retrace bit
	JE	Wait_For_In_CA			;Wait until in retrace
	MOV	AL,BL				;Get character to write
	STOSW					;Save character on screen
	LOOP	Wait_For_Out_CA 		;Repeat for CX characters
	RET
ENDIF
Video_Write_Char_Attr	ENDP

;****************************************************************
;   AH = 0A	Write character at cursor
;		BH - Page to write character
;		AL - Character to write
;		CX - Count of characters to write
;****************************************************************

;gdl	ALIGN	4

Video_Write_Char PROC NEAR
	MOV	AH,Video_Mode			;Get current video mode
	CMP	AH,07				;Test for above standard
	JBE	Default_CGA_Write_Char		;Go handle CGA modes

	cmp	ah,0Ch
	jbe	Video_Write_Char_Abort

	CMP	AH,13H				;Test for mode 13
	JE	VGA_Mode13_Write		;Go handle mode 13
	ja	Do_Extended_Write_Char		;Do extended graphics write
;	JB	Default_VGA_Write_Char		;Perform VGA graphics write
;	JMP	Extended_Write_Char		;Do extended graphics write

Default_VGA_Write_Char:
	JMP	VGA_Graphics_Write		;Perform VGA graphics write
Do_Extended_Write_Char:
	JMP	Extended_Write_Char		;Do extended graphics write

;gdl	ALIGN	4

Default_CGA_Write_Char:
	MOV	DL,BYTE PTR Equipment_Installed ;Get equipment installed
	AND	DL,030H 			;Isolate video switches
	CMP	DL,030H 			;Test if monochrome
	MOV	DX,0B000H			;Get monochrome seg address
	JE	Set_Write_RegenC		;Yes-Go set monochrome seg
	MOV	DH,0B8H 			;Advance to color graphics

Set_Write_RegenC:
	MOV	ES,DX				;Set video segment address
	CMP	AH,07				;Are we in monochrome
	JE	Fast_Write_C			;Yes-Go write w/o retrace
	CMP	AH,03
	JA	Graphics_Write

;gdl:04/03/92 This should be done in motherboard as well, and we don't need
;	to check for mode 0,1,2, which should be just 0 and 2, anyway, for
;	color burst.
IFDEF ADAPTER
;	CMP	AH,02				;Are we in 40 x 25 mode
;	JB	Fast_Write_C			;Yes-Go write w/o retrace
	TEST	EGA_StatusA,Retrace_Active	;Test for retrace active
	JNE	Slow_Write_C			;Don't wait for retrace
ENDIF

Fast_Write_C:
	OR	BH,BH				;Handle page 0 as a
	JNE	Not_Page0_WC			;special case
	MOV	DI,AX
	MOV	BX,Cursor_Location[00]		;Get cursor position
	MOV	AL,BYTE PTR Video_Columns	;Get column position
	MUL	BH				;Multiply by row size
	XOR	BH,BH				;Column position is in BX
	ADD	AX,BX				;Add in column offset
	SHL	AX,1				;Mult by 2 for attributes
	XCHG	AX,DI

Fast_Write_Loop1:
	STOSB					;Write the character
	INC	DI				;Skip attribute field
	LOOP	Fast_Write_Loop1		;Repeat for CX characters
Video_Write_Char_Abort:
	RET


Not_Page0_WC:
	CALL	Text_Position			;Compute location from cursor

;gdl:04/03/92 Add this JMP to identical function above for smaller code size.
	jmp	short Fast_Write_Loop1

;Fast_Write_Loop2:
;	STOSB					;Write the character
;	INC	DI				;Skip attribute field
;	LOOP	Fast_Write_Loop2		;Repeat for CX characters
;	RET

;gdl:04/03/92 This should be done in motherboard as well.
IFDEF ADAPTER
Slow_Write_C:
	CALL	Text_Position			;Compute location from cursor
	MOV	DX,M6845_Address		;Get 6845 address
	ADD	Dl,06				;Advance to status register
	MOV	AH,AL				;Get attribute to write

Wait_For_Out_C:
;	IN	AL,DX				;Read retrace status
;	TEST	AL,01				;Test for retrace bit
;	JNE	Wait_For_Out_C			;Wait until we exit retrace

Wait_For_In_C:
	IN	AL,DX				;Read retrace status
	TEST	AL,01				;Test for retrace bit
	JE	Wait_For_In_C			;Wait until in retrace
	MOV	AL,AH				;Get character to write
	STOSB					;Save character on screen
	INC	DI				;Advance past attribute
	LOOP	Wait_For_Out_C			;Repeat for CX characters
	RET
ENDIF

;****************************************************************
;   Graphics write character / attribute
;****************************************************************

;gdl	ALIGN	4

Graphics_Write:
	MOV	DX,AX				;Save callers AX
	MOV	AL,BYTE PTR Cursor_Location[01] ;Get current row position
	MUL	BYTE PTR Video_Columns		;Multiply by column length
	MOV	DI,AX				;Save row offset
	SHL	DI,1				;Multiply by 4 since 4 lines
	SHL	DI,1				;per char (dont count odd)
	MOV	AL,BYTE PTR Cursor_Location[00] ;Get column position
	XOR	AH,AH				;Extend to AX
	ADD	DI,AX				;Add column offset
	CMP	DH,06H				;Are we in hi res graphics
	JE	Hi_Position			;Yes-Weve got our position
	SHL	DI,1				;Have two bytes / char width

Hi_Position:
	MOV	AL,DL
	MOV	DS,INT_Address			;No more access to BIOS data
	OR	AL,AL				;Is character above 127
	JNS	Low_End_Char			;No -Use our character set
	AND	AL,07FH 			;Yes-Use char set at 1F
	LDS	SI,DS:[01FH*4]			;Get pointer to char set
	JMP	SHORT Table_Position		;Go compute table position

Low_End_Char:
	LDS	SI,DS:[043H*4]			;Get interrupt 43 pointer

Table_Position:
	XOR	AH,AH				;Extend char code to AX
	SHL	AX,1				;Multiply by 8 which is
	SHL	AX,1				;the size of each char entry
	SHL	AX,1
	ADD	SI,AX				;Compute character position
	CMP	DH,06				;Test if in low res
	JNE	Write_Low_Res_Char		;Yes-Go write lo res character

;****************************************************************
;   Hi resolution (mode 6) character write
;****************************************************************

Next_Hi_Char_Write:
	MOV	DL,04				;Write 4 even and 4 odd rows
	OR	BL,BL				;Are we XORing data ?
	JS	Hi_XOR_Write			;Yes-Go handle seperatly

Hi_Char_Write:
	LODSW					;Read character word
	STOSB					;Write first byte on even row
	ADD	DI,2000H - 1			;Advance to odd row
	MOV	AL,AH				;Get odd row char value
	STOSB					;Write odd row
	SUB	DI,2000H - 50H + 1		;Move back to next even row
	DEC	DL				;Repeat 4 times for a total
	JNE	Hi_Char_Write			;of 8 lines / character
	SUB	DI,140H - 1			;Move back to next char
	SUB	SI,08				;on even row-Move back to char
	LOOP	Next_Hi_Char_Write		;Repeat for char count in CX
	MOV	DS,INT_Address			;It wasn't-Check for user
	RET

Hi_XOR_Write:
	LODSW					;Read character word
	XOR	ES:[DI],AL			;XOR even row on screen
	ADD	DI,2000H			;Advance to odd row
	XOR	ES:[DI],AH			;XOR odd row on screen
	SUB	DI,2000H - 50H			;Move back to next even row
	DEC	DL				;Repeat 4 times for a total
	JNE	Hi_XOR_Write			;of 8 lines/character
	SUB	DI,140H - 1			;Move back to next char
	SUB	SI,08				;on even row-Move back to char
	LOOP	Next_Hi_Char_Write		;Repeat for char count ix CX
	MOV	DS,INT_Address			;It wasn't-Check for user
	RET

;****************************************************************
;		Low resolution (modes 4,5) character write
;****************************************************************

Write_Low_Res_Char:
	push	bp		;gdl:11/27/91 Don't trash BP for exit
	MOV	BH,BL				;Get color to write (0-3)
	AND	BH,03				;Mask XOR bit
	MOV	BP,CX				;Save characters left to write

Lo_Res_Char_Write:
	MOV	DH,04				;Do even/odd row 4 times

Row_Write_Loop:
	CALL	Row_Write			;Write the even char row
	ADD	DI,2000H - 2			;Move to the odd row
	CALL	Row_Write			;Write the odd char row
	SUB	DI,2000H - 50H + 2		;Move to the even row
	DEC	DH				;Write 4 even and 4 odd rows
	JNE	Row_Write_Loop			;for a total of 8 rows
	SUB	DI,13EH 			;Move to next char position
	SUB	SI,08				;Backup to start of char
	DEC	BP				;Restore chars left to write
	JNE	Lo_Res_Char_Write		;Repeat for BP characters
	MOV	DS,INT_Address			;It wasn't-Check for user
	pop	bp		;gdl:11/27/91 Don't trash BP for exit
	RET

;****************************************************************
;  Graphics Write for modes 0DH through 12H
;****************************************************************

VGA_Graphics_Write:
	push	bp		;gdl:11/27/91 Don't trash BP for exit
	MOV	SI,AX				;Save char code to write
	MOV	BP,CX				;Save character count

;	MOV	AX,0A000H			;High res mode page
	MOV	ES,Segment_A000 		;Set high res
	MOV	AL,BH				;Get page number
	XOR	AH,AH				;Reset high byte
	SHL	AX,1				;Make word offset
	MOV	DI,AX				;Get page number
	MOV	AX,Cursor_Location[DI]		;Get cursor location
	MOV	DI,AX
	AND	DI,0FFH 			;Reset high byte
	MOV	AL,BYTE PTR Video_Columns	;Get number of columns
	MUL	AH				;Multiply by rows
	MUL	Char_Length			;Multiply by length
	ADD	DI,AX				;Set starting scan line
	XOR	AH,AH				;Reset high byte
	MOV	AL,BH				;Get page number
	MUL	Video_Length			;Multiply by page size
	ADD	DI,AX				;Add to base
	MOV	DL,BL				;Save attribute byte

Do_VGA_Graphics_Write:
	MOV	CX,Char_Length			;Get length of character
	MOV	BX,Video_Columns		;Get width of line
	DEC	BX				;Decrement for add
	MOV	AX,SI				;Get character code
;(99){
	call	DetectEnvPtr			;v0.051
	jnz	not_C8x14			;v0.051
	cmp	cx, 14
	jnz	not_C8x14
	add	cx, 2
	mul	cl
	sub	cx, 2
	jmp	short cal_offset
not_C8x14:
;(99)}
	MUL	BYTE PTR Char_Length		;Compute table position
cal_offset:
	LDS	SI,DS:[43H*4]			;Get pointer to graphics
	ADD	SI,AX				;Add character offset

	MOV	AH,DL				;Get attribute color
	XOR	AL,AL				;Set bits to clear in set/reset reg
	MOV	DX,Graphics_Controller		;Setup graphics controller
	OUT	DX,AX				;Write set/reset reg
	INC	AL				;Move to enable reg
	NOT	AH				;Invert color for mask
	OUT	DX,AX				;Set enable for clear bits only
	TEST	AH,080H 			;Are we XORing?
	JE	Do_XOR_Char			;Yes-Do XOR

Write_Scans:
	MOV	DX,Sequencer
	MOV	AX,0F02H			;Enable all maps
	OUT	DX,AX				;Write to sequencer

Write_VGA_Character:
	PUSH	SI				;Save font position
	PUSH	DI				;Save screen position
	MOV	DX,CX				;Get character length
comment	%
;(99){
	call	DetectEnvPtr			;v0.051
	jnz	not_8x14			;v0.051
	cmp	cx, 14
	jnz	not_8x14
;v0.073inc	si
not_8x14:
;(99)}
%
Write_VGA_Char:
	MOVSB					;Store byte
	ADD	DI,BX				;Next position
	LOOP	Write_VGA_Char			;Write character
	MOV	CX,DX
	POP	DI
	POP	SI
	INC	DI
	DEC	BP				;Decrement number of chars
	JNE	Write_VGA_Character		;Write the VGA next character
	MOV	AX,0003H			;Restore controller
	MOV	DX,Graphics_Controller
	OUT	DX,AX				;Write to graphics controller
	XOR	AX,AX
	OUT	DX,AX
	INC	AX
	OUT	DX,AX
	MOV	DS,INT_Address			;It wasn't-Check for user
	pop	bp		;gdl:11/27/91 Don't trash BP for exit
	RET

Do_XOR_Char:
	MOV	AX,1803H			;Set XOR mode
	OUT	DX,AX				;Write to graphics controller
	MOV	DX,Sequencer
	MOV	AX,0F02H			;Enable all maps
	OUT	DX,AX				;Write to sequencer

XOR_VGA_Character:
	PUSH	SI				;Save font position
	PUSH	DI				;Save screen position
	MOV	DX,CX				;Get character length

XOR_VGA_Char:
	MOV	AL,ES:[DI]			;Read into latches
	MOVSB					;XOR the byte
	ADD	DI,BX				;Next position
	LOOP	XOR_VGA_Char			;Write character
	MOV	CX,DX
	POP	DI
	POP	SI
	INC	DI
	DEC	BP				;Decrement number of chars
	JNE	XOR_VGA_Character		;Write the VGA next character
	MOV	AX,0003H			;Restore controller
	MOV	DX,Graphics_Controller
	OUT	DX,AX				;Write to graphics controller
	XOR	AX,AX
	OUT	DX,AX
	INC	AX
	OUT	DX,AX
	MOV	DS,INT_Address			;It wasn't-Check for user
	pop	bp		;gdl:11/27/91 Don't trash BP for exit
	RET

;****************************************************************
;  Mode 13 graphics write
;****************************************************************

VGA_Graphics_Mode13:
	push	bp		;gdl:11/27/91 Don't trash BP for exit
	MOV	BP,CX				;Save number of chars
	MOV	CX,AX
	MOV	AX,0A000H			;High res mode page
	MOV	ES,AX				;Set high res
	MOV	AX,Cursor_Location[00]		;Get cursor location
	MOV	DI,AX				;Get column
	AND	DI,0FFH 			;Reset high byte
	MOV	AL,BYTE PTR Video_Columns
	MUL	AH
	MUL	Char_Length			;Multiply by length
	ADD	DI,AX				;Set starting scan line
	SHL	DI,1				;Multiply by eight
	SHL	DI,1				;since each character
	SHL	DI,1				;is eight bytes wide

	MOV	AX,Char_Length			;Get size of character
	MOV	DX,AX				;DX is # of lines to write
	MUL	CL				;Compute char table offset
	MOV	DS,INT_Address			;No more access to BIOS data
	LDS	SI,DS:[43H*4]			;Get interrupt 43 pointer
	ADD	SI,AX				;Compute start of char

Write_Char_13_Loop:
	PUSH	DI				;Save regen offset
	PUSH	DX				;Save bytes per character

Write13_Line_Loop:
	MOV	CX,08				;Character is eight bytes wide
	MOV	AH,[SI] 			;Get byte from char table
	INC	SI				;Advance table pointer

Write13_Bit_Loop:
	RCL	AH,1				;Shift bit into carry
	MOV	AL,BL				;If set write forground
	JC	Write13_Forground		;Yes-Go write foreground
	MOV	AL,BH				;Otherwise write background

Write13_Forground:
	STOSB					;Write one dot of character
	LOOP	Write13_Bit_Loop		;Repeat for entire line
	ADD	DI,40 * 8 - 8			;Move to next line of char
	DEC	DX				;Decrement line counter
	JNE	Write13_Line_Loop		;Write Char_Length lines
	POP	DX				;Restore bytes per character
	POP	DI				;Restore regen pointer
	SUB	SI,DX
	ADD	DI,08				;Advance to next char pos
	DEC	BP				;Any characters left to write
	JNE	Write_Char_13_Loop		;Yes-Repeat for CX characters
	MOV	DS,INT_Address			;It wasn't-Check for user
	pop	bp		;gdl:11/27/91 Don't trash BP for exit
	RET
Video_Write_Char ENDP

;****************************************************************
;   Read the current character from the character table, convert
;   it into the write color values for medium resolution graphics,
;   and write the graphics pattern to the video. This function
;   will have then written one row of the medium resolution
;   character.
;
;   Entry: DS:SI - Current character table pointer
;	   ES:DI - Current screen write location
;	      BH - Current color attribute (0-3)
;	      BL - Bit 7 = 1 is XOR function
;****************************************************************

Row_Write	PROC	NEAR
	MOV	DL,08				;Eight columns per char row
	XOR	CX,CX				;Starting row value
	LODSB					;Get character from table

Next_Column:
	RCR	AL,1				;Current bit set ?
	JNC	Column_Off			;No -Write 00's for that bit
	OR	CL,BH				;Yes-Or in color

Column_Off:
	ROR	CX,01				;Shift around two bits
	ROR	CX,01				;to advance next pel
	DEC	DL				;Repeat for 8 pels
	JNE	Next_Column			;16 bits = 8 pels * 2 bits
	MOV	AX,CX				;Get row pattern
	XCHG	AL,AH				;Swap for screen storage
	OR	BL,BL				;Are we writing or XOR'ing
	JS	Write_XOR_Row			;Yes-Go do XOR
	STOSW					;No -Write to screen location
	RET

Write_XOR_Row:
	XOR	ES:[DI],AX			;XOR with current value
	ADD	DI,02				;Advance screen position
	RET
Row_Write	ENDP

;****************************************************************

VGA_Segment ENDS

	END
