;
;	Refresh buffer addresses.
;

Rbx	equ	0xfe3c		; absolute x cap.
Rby	equ	0xfe3e		; " y.
Rbrmsk	equ	0xfe40		; read mask.
Rbovcl	equ	0xfe42		; overlay plane color.

;
; set up color table by loading next 4 registers 
; with color number to define, red, green, blue values.
; 

Rbcltn	equ	0xfe44		; color number defined below.
Rbcltr	equ	0xfe46		; red component.
Rbcltg	equ	0xfe48		; green.
Rbcltb	equ	0xfe4a		; blue.

Rbwmsk	equ	0xfe4c		; write mask.

;
; Control register.  Control bits are -
;	bit 	7 - set if drawing acc busy - keep hands off.
;		    Note - this bit appears (inverted) in bit
;		    6 of PolDev (0xff48).  It is better to look
;		    for dpu busy in PolDev, as reading Capctl while
;		    dpu is busy puts cpu into wait state until
;		    dpu is done.
;		6 - set to enable special erase.
;		5 - set to enable overlay plane read/write.
;		4 - set to make overlay plane visible.
;		3 - set to make screen 1280x960. 
;		2 - set to make y the major axis
;		    (i.e. Vmimaj incs Rby).
;		1 - set for major axis inc down. 
;		0 - set for minor axis inc down.
;
Rbctl	equ	0xfe4e
Capctl	equ	Rbctl
Rbstip	equ	0xfe50

;
; Video ram access addresses - 3 groups of 4 addresses.
; All 12 addresses access the pixel pointed to by
; Rbx,Rby.  After the access, 0 or 1 or both of Rbx, Rby
; is incremented or decremented, depending on the access address
; and the state of bits 0-2 of the CAP control register.
;

Vm	equ	0xfe60		; no increment.
Vmimaj	equ	0xfe62		; increment major.
Vmimin	equ	0xfe64		; incerement minor.
Vmimm	equ	0xfe66		; increment both.

;
; Writing a value to these locations causes the
; a pixel to be written at CAP if bit 7 of the stipple 
; register is set.  The stipple register is then
; rotated left.  

Stp	equ	0xfe68
Stpmaj	equ	0xfe6a
Stpmin	equ	0xfe6c
Stpmm	equ	0xfe6e

;
; Writing these locations writes the 10 pixels
; (Rbx - Rbx mod 10, Rby) .. (Rbx - Rbx mod 10 + 9, Rby)
;

Mwe	equ	0xfe70
Mwemaj	equ	0xfe72
Mwemin	equ	0xfe74	
Mwemm	equ	0xfe76

;
; Clipping is in effect when these locations are written
;
 
Clp	equ	0xfef6
Clpmaj	equ	0xfef8
Clpmin	equ	0xfefa
Clpmm	equ	0xfefc

;
; Drawing accelerator addresses.  The firmware
; communicates with the drawing accelerator through
; addresses 0xfe00 - 0xfeff.  This address range is
; broken down as follows -
;
;	fe00 - fe1f :	16 word parameter registers.  Only the
;			least 12 bits of each register is used.
;	fe24 - fe3b :	not used.
;	fe40 - fe5f :	32 byte parameter registers.
;	fe80 - feff :	64 drawing acc. startup addresses.  
;
; 12 bit parameter registers.
;
Dapr0	equ	0xfe00
Dapr1	equ	0xfe02
Dapr2	equ	0xfe04
Dapr3	equ	0xfe06
Dapr4	equ	0xfe08
Dapr5	equ	0xfe0a
Dapr6	equ	0xfe0c
Dapr7	equ	0xfe0e
Dapr8	equ	0xfe10
Dapr9	equ	0xfe12
Dapr10	equ	0xfe14
Dapr11	equ	0xfe16
Dapr12	equ	0xfe18
Dapr13	equ	0xfe1a
Dapr14	equ	0xfe1c
Dapr15	equ	0xfe1e

;
; 8 bit parameter registers.
;
;
; Drawing accelerator control bits.
; bit	0 - stipple enable.
; bit	1 - not used.
; bit	2 - clipping enable.
; bit	3 -  ?
; bit	4 - special DMA processing (?).
; bit	5 - erase src rectangle after DaCra, DaCrr.
; bit	6 - double height characters (DaChr).
; bit	7 - double wide  ".
;
DaCtl	equ	0xfe52
DaFlag	equ	DaCtl

DaColr	equ	0xfe54		; drawing color.
DaBclr	equ	0xfe56		; erasing color.

DaChrx	equ	0xfe58		; char size in x (12 max).
DaChry	equ	0xfe5a		; rows/char (16 max).


;
; Absolute caps
;
Xabs	equ	0xfe3c
Yabs	equ	0xfe3e

;
; Window relative CAPs.
;
Xcap	equ	0xfe20
Ycap	equ	0xfe22

Xorg	equ	0xfe24
Yorg	equ	0xfe26
Xwbot	equ	0xfe28
Ywbot	equ	0xfe2a
Xwtop	equ	0xfe2c
Ywtop	equ	0xfe2e

;
; Drawing accelerator functions
;

; Set caps = 0, write mask, stipple reg = ff
; window parameters = 0,0,1279,1023,
; cap control = 0.
;
DaRst	equ	0xfe80		;reset.

;
; Set (pr0,1) (hi,lo) = pr0 * pr2
;
DaMul	equ	0xfe82		;multiply.

;
; Set pr0 = (pr0,1)/pr2, pr1 = (pr0,1) mod pr2.
;
DaDiv	equ	0xfe84		;divide.

;
; Copy or move rectangle (Xcap,Ycap, Xcap+Pr0,Ycap+Pr1)
; to (Xcap+Pr2,Ycap+Pr3).
;
DaBbc	equ	0xfe86		;copy rectangle.
DaBbm	equ	0xfe88		;move rectangle.
;

;
; Erase clipping window.
; Window is erased to DaBclr
;
DaErw	equ	0xfec4		;erase window.

;
; Draw vector absolute, from
; (DaXcap,DaYcap) to Dapr0,1.
;
DaDva	equ	0xfec6		;draw vector absolute.

;
; Draw vector relative, from
; (DaXcap,DaYcap) to (DaXcap+Dapr0,DaYcap+Dapr1).
;
DaDvr	equ	0xfec8		;draw vector relative.

;
; Draw filled rectangle absolute, from
; (DaXcap,DaYcap) to Dapr0,1.
;
DaDfr	equ	0xfeca		;draw filled rectangle absolute.

;
; Draw filled rectangle relative, from
; (DaXcap,DaYcap) to (DaXcap+Dapr0,DaYcap+Dapr1).
;
DaFrr	equ	0xfecc		;draw filled rectangle relative.

;
; Draw character defined by the bit map in
; Dapr0..15.  CAP is then moved by amount
; DaChdx, DaChdy.
;

DaChr	equ	0xfed2		;draw character.

;
; Write Dapr0 pixels in color DaColr in
; major direction.
;
DaWnp	equ	0xfed4		;write n pixels.

;
; Edge flag fill (for DFP).
; Set Dapr0-3 = coords of bounding box,
; Dapr4 = flag color.
;
DaDfp	equ	0xfed6		;edge flag fill.

;
; Interior fill routines.
; Set CAP, Capctl.  Set Dapr0 = y CAP limit.
;
; For interior fill, also pass interior color.

DaIfs	equ	0xfed8		;interior fill search.
DaIff	equ	0xfeda		;interior fill fill.

;
; For overlay fill, also pass 
;
DaOfs	equ	0xfedc		;overlay fill search.
DaOff	equ	0xfede		;overlay fill fill.

;
; For GFL, also pass 
;
DaGfs	equ	0xfee0		;general overlay fill search.
DaGff	equ	0xfee2		;general overlay fill fill.

DaErs	equ	0xfee4		;special screen erase.
DaScr	equ	0xfee6		;special scroll.

DaWda	equ	0xfe96		; read/write aoi
DaRda	equ	DaWda

	end
