;
; Prototype version - diff from breadboard
;		is in looking for data flag.
; 
; Entries :
; 		putpar - send byte out parallel interface.
; 		getpar - get byte from parallel interface.
;		getcdm - get command dma byte.
;		cdmctl - enter/exit command dma mode.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Send a byte to the parallel interface.;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

putpar:
	php
	rep	#0x20
	pha
	sep	#0x20
;
; send the byte
;
	sta	>0,ParOut	; put the byte in parallel port
				; and set byte assembled.
	sta	>0,DevEnd	; pulse device end - interrupt host.
;
; wait for ack (any parallel byte from host)
;

$1:	lda	>0,PolDev	; data avail  (bit 7) ?
	bpl	$1		; no

	rep	#0x20		; need to read low byte to clear 
	lda	>0,ParIn	; terminal busy.
	bit	##0x200

	bne	$2		; yes.. skip
	sta	>0,DevEnd	; pulse device end
$2:
	pla
	plp
	rtl


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Read one byte from the parallel interface.	;
; Generate device end if bit 2 of the high	;
; byte of the parallel data is non-zero.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

getpar:
	php
	rep	#0x20		; 16 bit mem
$1:	lda	>0,PolDev-1	; data avail  (bit 15)?
	bpl	$1		; no

	lda	>0,ParIn	; Get status bits and data.
	bit	##0x0200	; no intr?
	bne	$2		; yes.. skip
	sta	>0,DevEnd	; pulse device end
$2:
	and	##0xff		; mask off non-data bits.
	plp
	rtl

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; This routine sets up for command dma	;
; transfer on command from host.  Also	;
; it terminates this mode on command	;
; from host.  Actual enabling and 	;
; disabling of dma is done on a word by ;
; word basis in wcdma.			;
; Enter with acc 0 to disable	 	;
; command dma, <>0 to enable.		;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

cdmctl:	php
	sep	#0x20
	cmp	#0		; exit command dma mode ?
	beq	$1		; br if yes.
	lda	#8		; data flag enable.
$1:	sta	>0,DmaCtl	; enable/disable data flag.
	lda	#0		; initialize firmware flag to 
	sta	>0,Cdmsw	; indicate next cdma byte from
				; LSB of parallel port.
	plp
	rtl


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Wait for command dma byte.  Command dma input		;
; comes 2 bytes at a time.				;
; This routine requires one byte of static storage	;
; for a flag to toggle input between the low and	;
; high bytes of the input register, and one byte	;
; to save the high data byte until it is needed.	;
; NOTE - this routine should probably monitor		;
;	 host command out, and abort dma mode if it	;
;	 occurs.					;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

getcdm:
	php			; save callers m/x mode.
	sep	#0x20		; set 8 bit mem.
	
	lda	>0,Cdmsw	; time to get next word ?
	beq	$read		; branch if yes

	lda	#0		; reset 'next word flag'
	sta	>0,Cdmsw

	xba
	lda	>0,Cdmbuf+1	; get the (buffered) data byte.
	plp
	rtl

$read:
;	lda	>0,PolDev+1	; command dma word avail (bit 7) ?
;	bpl	$read		; branch if no, wait some more.

	lda	>0,PolDev+1	; command dma word avail (bit 7) ?
	bit	#64
	beq	$read		; branch if no, wait some more.

	sta	>0,Cdmsw	; set the 'read high byte next' flag.

	rep	#0x20
	lda	>0,CdmPrt	; get low (first) byte for caller.
	sta	>0,Cdmbuf	; stash it away.
	sta	>0,DmaEna	; raise data flag to request dma.
	and	##0xff
	plp			; restore callers m/x mode
	rtl			; and return.

cdmend:
	end
