	title	"Physical I/O Routines"
	psect	code

;
;	non-interrupt driven putchr.
;	output a byte in the accumulator
;
XON	equ	0x11
XOFF	equ	0x13

putchr:
	php
	phd
	pea	##dirpag
	pld
	sep	#0x20		; 8 bit mem
	pha			; save chr to print


	bit	<xoffed
	bpl	$2
;
; We're XOFFed, wait for XON
;
$1:	lda	>ACEBNK,auxsta	; Data ready ?
	bit	#1
	beq	$1
	lda	>ACEBNK,auxdat	; Is it XON ?
	and	#0x7f
	cmp	#XON
	bne	$1
	lda	#128
	trb	<xoffed
	bra	$wai
;
; Check for XOFF 
;

$2:
	lda	>ACEBNK,auxsta
	bit	#1
	beq	$wai
	lda	>ACEBNK,auxdat
	and	#0x7f
	cmp	#XOFF
	beq	$1
	sta	<ungetc
	lda	#64
	tsb	<xoffed
;
; send the char
;
$wai:	lda	>ACEBNK,auxsta	; wait until aux xmtr is free
	bit	#32
	beq	$wai

	pla			; get the chr
	sta	>ACEBNK,auxdat	; write it out

	pld
	plp			; restore memory mode
	rts

;
;	non-interrupt driven getchr
;	wait for a character from the aux port
;	return chr in accumulator when received
;

getchr:
	php
	phd
	pea	##dirpag
	pld
	sep	#0x20			; set 8 bit memory

	lda	#64
	trb	<xoffed
	beq	$1
	lda	<ungetc
	bra	$2
$1:
	lda	>ACEBNK,auxsta		; wait for chr avail
	bit	#1
	beq	$1
	lda	>ACEBNK,auxdat

$2:	and	#0x7f			; mask parity bit
	cmp	#0x20
	blt	$3
	cmp	#0x7f
	beq	$done
	bsr	putchr			; print chr and exit
	bra	$done
$3:
	cmp	#XON
	bne	$4
	stz	<xoffed
	bra	$1			; wait for real char
	bra	$done
$4:
	cmp	#XOFF
	bne	$done
	lda	#128
	tsb	<xoffed
	bra	$1			; wait for real char
$done:
	pld
	plp
	rts
	eject
;

waitp:
	php
	rep	#0x20
$1:	lda	>0,intpol-1
	bpl	$1
	lda	>0,parprt
	bit	##0x0200
	bne	$2
	sta	>0,devend
$2:	and	##0xff
	plp
	rts

	title	"Trap Handlers"
;
;
; this routine is entered when a breakpoint
; exception is encountered in 816 mode
;
;	when entered, the following is on the stack
;
;       4 pbr
;       3 pc hi
;       2 pc lo
;       1 psw
;  sp-> ---
;
brk:
	rep	#0x30	; 16 bit mem/idx
;
;	save program context
;
	pha			; save his acc
	phd			; and direct page
	pea	##dirpag	; set dbgr direct page
	pld
	pla			; stash his dir page 
	sta	<sdp		; and acc
	pla
	sta	<sac

	tsc
	sta	<ssp	; save stack pointer

	stx	<six	; ix
	sty	<siy	; iy

	lda	2,s	; pc + 2 byte brk ins
	dec	a
	dec	a
	sta	<spc	; program counter at location of brk

	lda	1,s
	sta	<sps	; proc status wrd

	lda	4,s	
	and	##0xff
	sta	<spb	; pgm bank reg

	phb
	phb
	pla
	and	##0xff
	sta	<sdb	;data bank reg

;	lda	<dbgsp
;	tcs		; load debugger stack pointer

	phk		; set dbgr dbr
	plb

	brl	dbgbrk

;
;	Here on soft reset or stack overflow.
;	

nmi:
	brl	dbg
;
;	proceed from breakpoint
;
pcmd:
;
;	restore the process's registers
;
	rep	#0x30	; 16 bit memory
	tsc
	sta	<dbgsp	; save a copy of our stack pointer

	ldx	<six
	ldy	<siy	; restore index regs

	lda	<ssp
	tcs		; stack references to his stack now...

	lda	<spc
	sta	2,s	; load the updated pc back on the stack

	sep	#0x20	; 8 bit memory
	lda	<sdb
	pha
	plb		; load data bank reg
	lda	<spb
	sta	4,s	; load the updated pbr onto the stack
	lda	<sps
	ora	#4	; ensure interrupts disabled
	sta	1,s	; load the updated psw onto the stack

	rep	#0x30
	lda	<sac	; restore his acc.
	pei	<sdp	; restore his dir page.
	pld
;
;
;	the last thing we do is set the pgm ctr and psw
;	by doing an rti from his stack
;	(the pc was updated to the correct spot by the
;	 brk exception routine)
;
	rti			; away we go.....

