	title	"1280 constants"
;
;	Machine-dependent constants for the 1280
;

intvec	equ	0x7fc0	; thru 7fff, 16 long vectors,quad aligned.
nmivec	equ	0x7f84		; Soft reset/stack overflow.
brkvec	equ	0x7f80		; break instr.

auxsta	equ	0x1a		; in bank 0xf8 (control)
auxdat	equ	0x10		;   " (data)

dirpag	equ	0x3000
dbgstk	equ	dirpag-4
inisp	equ	dbgstk-68
inipc	equ	0x0
inipsw	equ	0x34		; native mode, 8 bit mx, SEI.



;	ACE offsets (in decreasing interrupt priority level):

ACEBNK equ 0x20		; Data bank containing ACEs.
ACEPAG equ 0		; Page containing ACEs.
aceadd equ 0		; Page offset of first ACE.
acepad equ aceadd+0	; Mouse/pad ACE.
acekbd equ aceadd+0x30	; Keyboard ACE.
acehst equ aceadd+0x20	; Host ACE.
aceaux equ aceadd+0x10	; Aux ACE.

;	ACE register offsets :

;	(These 2 accessible if bit 7 of LCR = 1)
DLL equ  0		; Divisor Latch Low byte.
DLH equ  2		; Divisor Latch High byte.

;	(These 3 accessible if bit 7 of LCR = 0)
RBR equ  0		; Receiver Buffer Reg. (read data).
THR equ  0		; Transmitter Holding Reg. (write data).
IER equ  2		; Interrupt Enable Reg.

;	(Regardless of ACELCR bit 7).
IIR equ  4		; Interrupt Ident. Reg.(read only).
LCR equ  6		; Line Control Register.
MCR equ  8		; Modem Control Reg. (not used).
LSR equ  10		; Line Status Register.
MSR equ  12		; Modem Status Reg. (not used).
SCR equ  14		; Scratch reg. (not used).
	

;
; Parallel I/O register addresses
;

devend	equ	0xff20	; write to pulse device end - intrpt host
parprt	equ	0xff00	; parallel i/o port (2 bytes).  Writing
			; the low byte sets byte assembled for
			; the host.  Some bits in the high byte are
			; writeable (ask Richard).
dmaena	equ	0xff00	; write to set ADRE - enable dma transfer
dmadsb	equ	0xff10	; write clears ADRE - disable dma transfer
intpol	equ	0xff1c	; device polling is done by inspecting 
			; bits in this word.
;  
;	0xff1c :
;	bit 7 - host command out, set if data available
;		in parallel port.
;


