/*
	Ellipse generator.
	Generates an ellipse, centered at CAP.
*/

#include <stdio.h>
#include <math.h>

double sqrt();
long atol();

int	D;

long	fx,
	fy,
	fxx,
	fyy,
	fxy;

long	falpha,
	fX,
	fY,
	fXY;

long	absfX,
	absfY,
	absfXY;

int	x,y;
int	deltax, deltay;

long	a,b,c,d,e,g;

main(argc,argv)
int argc;
char **argv;
{
	a=b=c=d=e=g=1;
	x = y = 512;
	D = 1;
	
	if(argc > 1){
		x = atoi(*(++argv));
		y = atoi(*(++argv));
		D = atoi(*(++argv));

		a = atol(*(++argv));
		b = atol(*(++argv));
		c = atol(*(++argv));
		d = atol(*(++argv));
		e = atol(*(++argv));
		g = atol(*(++argv));
	}

	fxx = a<<1;
	fyy = b<<1;
	fxy = c;

	fx = x*fxx + c*y + d;
	fy = y*fyy + c*x + e;

	falpha = 0;
	
	mov(x,y);

	for(;;){
		dxdy();
		feasibles();
		step();
		partials();
	}
}


feasibles()
{
	fX = falpha + fx*deltax + a;
	fY = falpha + fy*deltay + b;
	fXY = fY + fX - falpha + c*deltax*deltay;

	absfX = fX > 0 ? fX : -fX;
	absfY = fY > 0 ? fY : -fY;
	absfXY = fXY > 0 ? fXY : -fXY;
}

step()
{
	if((absfY <= absfX) && (absfY < absfXY)){/* step in y */
		falpha = fY;
		deltax = 0;
	}
	else
	if((absfXY <= absfX) && (absfXY <= absfY)){/* step in x,y */
		falpha = fXY;
	}
	else
	if((absfX < absfY) && (absfX < absfXY)){ /* step in x */
		falpha = fX;
		deltay = 0;
	}
	else{
		printf("Hosed step\n");
		exit(0);
	}

	wpx(2);
	mvr(deltax,deltay);
}


partials()
{
	fx += fxx*deltax + fxy*deltay;
	fy += fyy*deltay + fxy*deltax;
}

dxdy()
{
	if(D){
		deltax = fy < 0 ? 1 : -1;
		deltay = fx < 0 ? -1 : 1;
	}
	else{
		deltax = fy < 0 ? -1 : 1;
		deltay = fx < 0 ? 1 : -1;
	}
}
