		
	psect	2

;	Unsigned divide routine.
;	Push divisor, dividend.
;	Pull quotient, remainder.
;	Uses acc, x, y.  Sets X=M=1.

DIVDND equ 5
QUOTNT equ 5
DIVISR equ 7
REMAIN equ 7
			
DIVIDE
	rep	#0x30		; M = X = 1.
	phd
	tsc
	tcd

	lda	##0		; init partial dividend.
	ldy	##16		; init bit counter.
	
LOOP
	asl	<DIVDND
	rol	a
	cmp	<DIVISR
	bcc	$1
	sbc	<DIVISR
	inc	<QUOTNT
$1
	dey
	bne	LOOP

	sta	<REMAIN
	pld
	rts	



;	Unsigned 16 bit multiply.
;	Multiplies contents of x,y registers.  Product
;	low word in acc, high in x.

PLIER equ 1
PLCAND equ 3
PRODCT equ 5

MLTPLY
	rep	#0x30		; M = X = 1.
	phd
	
	lda	##0		; init product low word.
	pha			; ditto high word.
	phx			; Save multiplier 
	phy			; and multiplicand.

	tsc
	tcd

	lda	##0
	ldy	##16		; bit count.

MLOOP
	lsr	<PLIER
	bcc	$1
	clc
	adc	<PLCAND
$1
	ror	a
	ror	<PRODCT
	dey
	bne	MLOOP

	plx			; cleanup stack
	plx

	tax			; High result in x,
	pla			; low in acc.

	pld
	rts

