#include "tcp.h"

dtm(ixo,iyo,ixscal,iyscal)	/* define tablet mapping */
int ixo,iyo;
int ixscal,iyscal;
{
	aedbf[0] = DTM;
	aedbf[1] = ixo.hibyte;
	aedbf[2] = ixo.lobyte;
	aedbf[3] = iyo.hibyte;
	aedbf[4] = iyo.lobyte;
	aedbf[5] = ixscal;
	aedbf[6] = iyscal;
	obyte( aedbf,7);
}

etc(key,iflag,icode,ix,iy)	/* enable tablet cursor and read cursor */
int *key,*iflag,*icode;		/*  position */
int *ix,*iy;
{
	aedbf[0] = ETC;
	aedbf[1] = 126;	/* 126 is tablet id char	*/
	ordcmd(aedbf,2);

	/*	poll tablet until id char comes back	*/

	*key = 0;
	while( *key != 126 ){
		ibyte(key,1);
	}

	ibyte(&aedbf[2],5);	/* aedbf[2] because we're not	*/
				/* done with aedbf[0]		*/

	*iflag = (aedbf[2] >> 4 ) &15;
	*icode = aedbf[2] & 15;
	ix->hibyte = aedbf[3];
	ix->lobyte = aedbf[4];
	iy->hibyte = aedbf[5];
	iy->lobyte = aedbf[6];

	aedbf[1]=0;	/* disable tablet */
	obyte(aedbf,2);
}

etp(idchar)		/* enable (idchar!=0) disable (idchar=0) tablet */ 
int idchar;
{
	aedbf[0] = XTD;
	aedbf[1] = ETP;
	aedbf[2] = idchar;
	obyte(aedbf,3);
}

rtp(idchar,istat,ix,iy)	/* read tablet position */
int *idchar,*istat;
int *ix,*iy;
{
	aedbf[0]= RTP;
	ordcmd(aedbf,1);
	ibyte(aedbf,6);

        *idchar = aedbf[0];
        *istat = aedbf[1];
	ix->hibyte = aedbf[2];
	ix->lobyte = aedbf[3];
	iy->hibyte = aedbf[4];
	iy->lobyte = aedbf[5];
}

stp(parm)	/* set tablet parameters */
int parm;
{
	aedbf[0] = XTD;
	aedbf[1] = STP;
	aedbf[2] = parm;
	obyte(aedbf,3);
}
