/* Spirograph by Steve Heiker */

#include <stdio.h>
#include <math.h>

#define COLOR 5
#define PI 3.14159265358979323846
#define FACTOR 17	/* points per radian */
#define H ((a-b)/b)
#define G ((a+b)/b)
#define CIRCLES 100	/* number of circles */

int first = 1;

main(argc,argv)
char **argv;
{
double x,y,a,b,phi;
long limit,points;
int eqn;

	if(argc == 1 ){
	 printf("Usage: spiro [fixed] [rolling] [eqn]\n");
	 exit();
	}

a=atof(argv[1]);		/* radius of fixed circle */
b=atof(argv[2]);		/* radius of rolling circle */
eqn = atoi(argv[3]);

esc();
ers();

limit=(long)(2*PI*FACTOR*CIRCLES);

for(points=1;points<limit;points++)
  {
  phi=(((double)points)/FACTOR);

  switch(eqn){
	case 1:
	    x = (a+b)*(cos(phi)) - b*(cos(G*phi));
	    y = (a+b)*(sin(phi)) - b*(sin(G*phi));
	    break;
	case 2:
	    x=(a-b)*(cos(phi)) + b*(cos(G*phi));
	    y=(a-b)*(sin(phi)) - b*(sin(G*phi));
	    break;
	case 3:
	    x=(a-b)*(sin(phi)) + b*(cos(H*phi));
	    y=(a-b)*(sin(phi)) - b*(sin(H*phi));
	    break;
	case 4:
	    x = (a-b)*(cos(phi)) + b*(cos(G*phi)) * (a+b)*sin(phi);
	    y = (a-b)*(sin(phi)) - b*(sin(G*phi)) * (a+b)*cos(phi);
	case 5:
	    x = ((a-b)*(cos(phi)) + b*(sin(G*phi))) * (a+b)*sin(phi);
	    y = ((a-b)*(sin(phi)) + b*(cos(G*phi))) * (a+b)*cos(phi);
	case 6:
	    x = ((a+b)*(cos(phi)) + b*(sin(H*phi))) * cos(G*phi);
	    y = ((a+b)*(sin(phi)) + b*(cos(H*phi))) * sin(phi);

  }

  if(first){
    mov(((int)x)+512, ((int)y)+320);
    first = 0;
  }
  else
    dva(((int)x)+512,((int)y)+320);

  }
}
