;
; Seed fill routines - ifl, bfl, ofl, gfl.
;

ifl:
	php
	rep	#0x30

	ldx	<xpos
	ldy	<ypos
;
; Find out what color interior is,
; and exit if = fill color.
;
	sep	#0x20
	stz	<fltype

$w1:	bit	Dpdone			; wait dpu not busy
	bvc	$w1
	stx	Xcap
	sty	Ycap
	lda	Vm
	cmp	<color
	bne	$1
	plp
	rtl
$1:
	sta	<icolor		; save interior color.
	rep	#0x20
	and	##0xff
	sta	0xfe00

;
; set up pointers to drawing
; accelerator search/fill routines.
;
	lda	##DaIff
	sta	<filfnc
	lda	##DaIfs
	sta	<schfnc

	sep	#0x20
	lda	<color
	sta	<savclr
	and	<wmask
	sta	<color

	brl	fstart

bfl:
	php
	rep	#0x10
	sep	#0x20
	lda	#1
	sta	<fltype
	jsl	>0,Getb
	sta	<icolor		; boundary color

$w1:	bit	Dpdone		; wait dpu not busy
	bvc	$w1

	rep	#0x20
	and	##0xff
	sta	0xfe00		;* pass boundary color to da.

	lda	<color		;* ditto color.
	and	<wmask
	and	##0xff
	sta	0xfe04

	lda	<wmask		;* ditto mask to look for interior etc.
	and	##0xff
	sta	0xfe06
;
; set up pointers to search/fill routines.
;
	lda	##DaGff
	sta	<filfnc
	lda	##DaGfs
	sta	<schfnc

	sep	#0x20
	brl	fstart
gfl:
	php
	rep	#0x10
	sep	#0x20
	lda	#1
	sta	<fltype
	lda	<color

$1:	bit	Dpdone
	bvc	$1
	rep	#0x20
	and	##0xff
	sta	0xfe00		;* pass boundary color to da.

	jsl	>0,Getb		; get gfl mask.
	sta	0xfe06

	jsl	>0,Getb
	sta	0xfe04

	sep	#0x20
	sta	<icolor
;
; set up pointers to search/fill routines.
;
	rep	#0x20

	lda	##DaGff
	sta	<filfnc
	lda	##DaGfs
	sta	<schfnc

	sep	#0x20
	brl	fstart

ofl:
	php
	rep	#0x30

	ldx	<xpos
	ldy	<ypos

	lda	##DaOfs
	sta	<schfnc
	lda	##DaOff
	sta	<filfnc

	sep	#0x20
	lda	#2
	sta	<fltype
	lda	<color

$1:	bit	Dpdone
	bvc	$1
	sta	Rbwmsk

	rep	#0x20
	and	##0xff
	sta	0xfe00

	sep	#0x20
	stx	Xcap
	sty	Ycap
	lda	Vm
	and	<color
	beq	fstart
	lda	<wmask
	sta	Rbwmsk
	plp
	rtl
	
fstart:	
;
; Direct page temps :
;

icolor	equ 	tmpblk	; color of interior pixels for ifl,
			; boundary color for bfl.
fltype	equ	tmpblk+18 ; fill type.
filfnc	equ	tmpblk+20
schfnc	equ	tmpblk+22
savclr	equ	tmpblk+24
$first	equ	tmpblk+1 ; x coord of left edge of previous run
$last 	equ	tmpblk+3 ; ditto right edge
$nf 	equ	tmpblk+5 ; x coord left edge current run (new first)
$nl 	equ	tmpblk+7 ; ditto right edge
$direc	equ	tmpblk+9 ; direction to move in y after current run
$temp	equ	tmpblk+11 ; scratch word
;$depth	equ	tmpblk+14 ; max recursion depth (degugging aid).
;$level	equ	tmpblk+16 ; current recursion depth (ditto).

;***fltype equ tmpblk+18****
;***filfnc equ tmpblk+20****
;***schfnc equ tmpblk+22****
;***savclr equ tmpblk+24****
 
$stkmin	 equ	tmpblk+26	; start popping if stack gets down
				; to this level (Heaptop + fudge).

;
; Set CAP
;
	ldy	<ypos
	sty	Ycap
	ldx	<xpos
	stx	Xcap

	phy			; preserve CAP, restore when done
	phx

	ldx	Rbx		; save physical caps
	ldy	Rby
	
	rep	#0x20
	lda	0xfe52
	and	##4
	bne	$1
	lda	<winox		; clipping disabled, make virtual the
	sta	Xorg		; same as physical
	lda	<winoy
	sta	Yorg
	lda	##1280
	sta	<windx
	lda	##1024
	sta	<windy
	bra	$4
$1
	stz	Xorg		; clipping enabled, make corner 0,0 so
	stz	Yorg		; upper corner = (windx,windy)
$4
	sep	#0x20
	sty	Rby		; restore
	stx	Rbx
	
	ldy	Ycap
	ldx	Xcap
;
; Set cap direction - y major, x, y up.
;
	lda	#127-7
	and	Capctl
	ora	#4
	sta	Capctl
	
	lda	#2		; done when this gets popped
	pha
	
; push(ypos,ypos,xpos-1,-1)

	phy
	phy
	dex
	phx
	inx
	lda	#-1
	pha

; push(ypos,ypos,xpos,1)

	phy
	phy
	phx
	lda	#1
	pha

;	ldy	##2
;	sty	<$depth
;	sty	<$level

	rep	#0x20
	clc
	lda	HeapTop
	adc	##80
	sta	<$stkmin
	
$unstk:
	sep	#0x20
	rep	#0x10
	pla
	cmp	#2			; stack empty ?
	bne	$fillet			; no, go on

	lda	<fltype			; interior fill ?
	bne	$u1			; br if no.
	lda	<savclr			; yes, restore current color.
	sta	<color
	bra	$rescap
$u1:
	cmp	#2			; overlay fill ?
	bne	$rescap			; br if no.
	lda	<wmask			; restore write mask.
	sta	Rbwmsk
$rescap:
	rep	#0x20	
	lda	<worgx
	sta	Xorg
	lda	<worgy
	sta	Yorg
	lda	Xwtop
	sta	<windx
	lda	Ywtop
	sta	<windy

	plx				; restore callers CAP
	stx	<xpos
	ply
	sty	<ypos
$done:
	plp
	rtl

$fillet:

; pop(direc,x,last,first)

	sta	<$direc
	sta	<$direc+1
	cmp	#-1
	beq	$2
	stz	<$direc+1
$2:
;	ldy	<$level
;	dey
;	sty	<$level

	plx
	stx	Xcap
	stx	<xpos
	ply
	sty	<$last
	ply
	sty	<$first
	cpy	<windy
	bcs	$unstk
	
$fills:

	cpx	<windx			; x overflow ?
	bcs	$unstk			; yes, go unstack

	lda	#4+2			; set major(y) cap dir down.
	ora	Capctl
	and	#127-1
	sta	Capctl
	sty	Ycap

	lda	<fltype
	beq	$ifsrch
	lsr	a
	bcs	$bfsrch
	lsr	a
	bcs	$ofsrch

$bfsrch:
	lda	Vm
	cmp	<icolor
	beq	$ifind
	and	<wmask
	cmp	<color
 	bne	$srch
	brl	$ifind
$ifsrch:
	lda	Vm
	cmp	<icolor
	beq	$srch
	brl	$ifind
$ofsrch:
	lda	Vm
	and	<color
	beq	$srch
	brl	$ifind

$srch:
	ldx	##0		; set low limit for y cap.
	stx	0xfe02
	sta	(<filfnc)	; fill down.
	nop
	nop
	nop
	nop
$iw1:	bit	Dpdone		; wait dpu not busy.
	bvc	$iw1
	rep	#0x20
	lda	Ycap
	inc	a
	and	##0xfff
	sta	<$nf
	sep	#0x20
	iny			; move to bottom of upward run.
	cpy	<windy		; out of window ?
	bcs	$idone		; done filling if yes.
$iup:	sty	Ycap
	ldx	<windy		; set upper limit.
	stx	0xfe02
	lda	Capctl
	and	#127-2
	sta	Capctl		; set y cap to up.
	sta	(<filfnc)	; fill upwards.
	nop
	nop
	nop
	nop

$iw2:	bit	Dpdone		; wait dpu not busy
	bvc	$iw2
	ldy	Ycap		; find out where we stopped.
$idone:	dey
	sty	<$nl		; save coord last interior point.
	brl	$nxtcol		; done filling.
;
; move up to interior or limit.
; If an interior pixel is found, cap will
; be 1 past the first interior point, else
; cap will be at limit.
;
$ifind:
	ldx	<$last		; set limit.
	inx
	inx
	stx	0xfe02
	lda	#2
	trb	Capctl		; set y cap to up.
	sta	(<schfnc)	; search upwards.
	nop
	nop
	nop
	nop
$iw3:	bit	Dpdone		; wait dpu not busy
	bvc	$iw3
	ldy	Ycap		; get coord first 
	dey
	sty	<$nf
	cpy	<$last
	bcc	$iup
	beq	$iup
	brl	$unstk

;
; we just filled the pixels from y = nf to y = nl.
; see what (if any) sequences of potential interior points
; can be inferred from the known sequences first..last
; and nf..nl, remembering that these sequences are on adjacent
; columns.

$nxtcol:
	rep	#0x30

; if nf <= first-2
;	 push(nf,first-2,x-direc,-direc)
;
;	|-potential interior pixel
;	||- known boundary pixel
;	|||-first - leftmost filled pixel of run above current line
;	?B**********
;       *********
;	|-nf = leftmost filled pixel of current line
;

	tsc
	cmp	<$stkmin
	bcs	$sok1
	brl	$recurse
$sok1:
	lda	<$first
	dec	a
	dec	a
	cmp	<$nf
	bmi	$10
	pei	<$nf
	pha
	lda	<xpos
	sec
	sbc	<$direc
	pha
	sep	#0x20
	lda	<$direc
	eor	#-1
	inc	a
	pha
	rep	#0x20

;	lda	<$level		; just for grins, track
;	inc	a		; the max recursion depth
;	cmp	<$depth
;	bcc	$0
;	sta	<$depth
;$0:	sta	<$level
	
$10:
; if nl+2 <= last
;	 push(nl+2,last,x,direc)
;
;		  |-last - rightmost of run above current line
;	***********
;       *********B? <- nl+2 = ?
;		|-nl = rightmost filled pixel of current line
;
	tsc
	cmp	<$stkmin
	bcs	$sok2
	brl	$recurse
$sok2:
	lda	<$nl
	inc	a
	inc	a
	sta	<$temp
	lda	<$last
	cmp	<$temp
	bmi	$20
	pei	<$temp
	pha
	pei	<xpos
	sep	#0x20
	lda	<$direc
	pha
	rep	#0x20

;	lda	<$level
;	inc	a
;	cmp	<$depth
;	bcc	$o0
;	sta	<$depth
;$o0:	sta	<$level

	brl	$recurse
$20:
;
; if last+2 <= nl
;	 push(last+2,nl,x-direc,-direc)
;
;		    |-last+2 - potential interior
;	***********B?
;       *************
;		    |-nl = rightmost filled pixel of current line
;
	inc	a
	inc	a
	sta	<$temp

	tsc
	cmp	<$stkmin
	bcs	$sok3
	brl	$recurse
$sok3:

	lda	<$nl
	cmp	<$temp
	bmi	$recurse
	pei	<$temp
	pha
	lda	<xpos
	sec
	sbc	<$direc
	pha	
	sep	#0x20
	lda	<$direc
	eor	#-1
	inc	a
	pha
	rep	#0x20
;	lda	<$level
;	inc	a
;	cmp	<$depth
;	bcc	$oo0
;	sta	<$depth
;$oo0:	sta	<$level

$recurse:
;
; proceed to the next column.  all the points on the next 
; column from nf to nl are potential interior points.
;
	ldy	<$nl
	sty	<$last
	ldy	<$nf
	sty	<$first
	lda	<xpos
	clc
	adc	<$direc
	sta	<xpos
	sta	Xcap
	tax
	sep	#0x20
	brl	$fills

	end
