
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Wait for byte from host or	;
; keyboard if in local mode.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

get:
	php
	sep	#0x20
$loop:
	bit	Setupk
	bpl	$10
	brl	kludge
$10:
	bit	<locsw		; in local mode ?
	bmi	$local		; br if yes.
	lda	<cdmflg		; doing command dma ?	
	bne	$getcdm		; br if yes.
	bit	PolDev		; command out ?
	bmi	$getpar		; br if yes.

	lda	<autovt		; should we check serial port ?
	bne	$loop		; loop if serial is for vt100.
	bra	$serial	

;
; get byte from parallel interface.
;
$getpar
	plp
	jmp	>0,Getpar

;
; get command dma byte.
;
$getcdm:

	bit	<cdmsw		; time to get word from host?
	bpl	$read		; branch if yes
	stz	<cdmsw		; reset 'next word flag'
	lda	#0		; clear acc high byte.
	xba
	lda	<cdmbuf+1	; get the (buffered) data byte.
	plp
	rtl
$read:
	bit	PolDev		; command dma word avail (bit 6) ?
	bmi	$xcd		; exit command dma if command out.
	bvs	$yes		; br if yes.
	brl	$loop		; no, wait some more.
$yes:	dec	<cdmsw		; set the 'read high byte next' flag.
	rep	#0x20
	lda	CdmPrt		; get data word from host.
	sta	<cdmbuf		; save high byte for next caller.
	sta	DmaEna		; turn on data flag.
	and	##0xff		; return low byte to caller.
$done:	plp			; restore callers m/x mode
	rtl			; and return.
$xcd:
	stz	<cdmflg
	stz	DmaCtl
	brl	$loop
;
; get host serial data if any in queue.
;
$serial:
	bit	Iqcnt2+1	; anything in serial input q ?
	bpl	$loop		; go wait some more if no.
	jsl	>0,GetHst
	cmp	#127		; delete ?	
	bne	$s1		; return if not.
	bit	<rubopt		; are we ignoring delete ?
	bpl	$s1		; br if no, return.
	brl	$loop		; yes, go get next char.
$s1:	xba			; clear acc high byte
	lda	#0		; and return.
	xba
	plp
	rtl
;
; Here in local mode, get
; next non-special key.
;
$local:
	jsl	>0,ChkKbd	; go get key (if ASCII).
	bcs	$loop		; br if key was not ASCII.
	rep	#0x20
	and	##0xff
	plp
	rtl


send:
	php
	sep	#0x20
	bit	<sifval
	bmi	$111
	bvs	$11
	plp
	jmp	>0,SndHst
$11:
	plp
	jmp	>0,Dchar
$111:
	plp
	jmp	>0,Putpar

sndend:


	end



