;
; VT100 buffer management routines.
;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Call this routine after changing cury.;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

chngln:
	php
	rep	#0x30
	phy

	sep	#0x10		; 16 bit m, 8 bit x.

	ldy	<rowmax		; make sure new cury is valid.
	cpy	<cury
	bcs	$ok
	sty	<cury
$ok:

;
; Save the per line info for old cury.
;
	ldy	<curidx		; get index into line arrays.
	lda	<ncol		; get current ncol,nchr.
	sta	(<lsizes),y	; save 
	lda	<chrsiz		; get current chrsiz,spflag.
	sta	(<lflags),y	; save.
;
; Adjust curidx per new cury.
;
	sep	#0x20
	lda	<cury		; get new cury.
	dec	a		; map (1..) to (0..)
	tay
	lda	(<linmap),y
	cmp	<curidx
	beq	$done
	sta	<curidx
	tay
	rep	#0x20
;
; Copy the info for new cury to direct page.
;
	lda	(<lsizes),y	; get nchr, ncol.
	sta	<ncol
	lda	(<lflags),y	; get chrsiz, spflag.
	bsl	chgsiz
	lda	(<txtmap),y	; get pointer to current line text
	sta	<txtptr
	lda	(<attmap),y	; ditto attributes.
	sta	<attptr
$done:
	sep	#0x20
	stz	<vauto
	rep	#0x30
	ply
	plp
	rts

chgsiz:
	php
	rep	#0x30
	phx
	phy
	sep	#0x30

	cmp	<chrsiz
	beq	$done
	sta	<chrsiz
	bit	<chrsiz
	bvc	$ok
	ora	#128
$ok	sta	<daflag

$1	bit	Dpdone
	bvc	$1

	lda	DaCtl
	and	#255-128-64
	ora	<daflag
	sta	DaCtl

$done	rep	#0x30
	ply
	plx
	plp
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Call this routine to change character	;
; size from single to double or vice	;
; versa.  Enter with new size in acc.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

setsiz:
	cmp	<chrsiz		; new size different ?
	beq	$done		; done if no.
	sta	<chrsiz		; yes, save it for later.
	bit	<chrsiz
	bvc	$ok
	ora	#128
$ok	sta	<daflag

	lda	<colmax		; assume new size single width.
	sta	<ncol		; save max # chars line can have.
	lda	<chrsiz		; get new size.
	beq	$ll		; br if single width, done.
;
; Going from single to double.
; Truncate the line if nchr > ncol/2.
; Make sure that curx and nchr
; are <= ncol.
;
	
	lsr	<ncol		; double wide, chop max chars/line.
	lda	<nchr		; empty line ?
	beq	$ll		; br if yes.
	cmp	<ncol		; chars past end of line ?
	bcc	$20
	beq	$20		; br if no
	tay			; yes, truncate ncol to nchr.
	lda	<ncol
	bsl	erase
$20:		
	lda	<ncol		; get max val for curx.
	cmp	<curx		; curx <= ncol ?
	bcs	$2		; br if yes.
	sta	<curx		; no, set curx to end of line.
$2:	cmp	<nchr		; # chars in line  <= ncol ?
	bcs	$ll		; br if yes.
	sta	<nchr		; no, truncate line.

$ll	bit	Dpdone
	bvc	$ll

	lda	DaCtl		; update da char writing control bits
	and	#255-128-64
	ora	<daflag
	sta	DaCtl

$done	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Put a character into the text buffer.	;
; Draw the character. Advance curx and	;
; cury to next character position.  	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

putbuf:
	php
	rep	#0x30
	phx
	phy
	sep	#0x30

	tay			; temp

	bit	<vauto		; find out if last key was at ncol
	bpl	$1		; br if not

	bit	<nlmode		; yes, now check if autowrap enabled
	bvc	$1		; br if not
	bsl	nxtlin		; goto next line
	stz	<vauto
	tya	

$1	ldy	<curx		; get cursor column.
	dey			; convert to index.
	sta	(<txtptr),y	; store char in txtbuf.
	bsl	dspchr		; draw the character at curx,cury.
	lda	<spattr		; get current attr, if any.
	sta	(<attptr),y	; save for display later.
	iny			; set y = curx.
	cpy	<nchr		; 
	bcc	$4		; br if no.
	sty	<nchr		; yes, update number chars this line.

$4:	iny			; advance to next char position.
	sty	<curx		; update cursor position.

	cpy	<ncol
	bcc	$l1		; it's ok if curx < or = ncol
	beq	$l1

$l2	ldy	<ncol		; curx > ncol, restrict at ncol first
	sty	<curx		; next char will advance to nextline
	lda	#128
	tsb	<vauto		; set flag, so next key will cr to nxtlin
	bra	$l4

$l1	stz	<vauto
$l4	rep	#0x30
	ply
	plx
	plp
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;
; Erase display, then	;
; refresh the screen.	;
;;;;;;;;;;;;;;;;;;;;;;;;;

redraw:
	php
	rep	#0x30
	phx
	phy
	pei	<curx
	sep	#0x30
	jsl	>0,Erase
	stz	<cury
$loop:
	inc	<cury
	bsl	chngln
	ldy	<nchr
	beq	$1
	lda	#1
	bsl	dsplin
$1:	lda	<cury
	cmp	<rowmax
	bcc	$loop

	pla
	sta	<curx
	pla
	sta	<cury
	bsl	chngln	

	rep	#0x30
	ply
	plx
	plp
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Erase chars from column(acc)	;
; to column(y) of current line.	;
; acc <= y is assumed.		;
; Called from erase line and 	;
; when changing single to double;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

erase:
	sta	<temp		; save left col to erase.
	lda	#0
$loop:	dey			; convert column to index.
	sta	(<txtptr),y	; remove from buffer.
	sta	(<attptr),y	; clear attributes.
	cpy	<temp		; next column < left column ?
	bcs	$loop		; loop if >=, not done yet.
	rts


	end
