;
; VT100 status commands.
;

;
; ESC [ Ps n	Ps = '5' send cursor position,
;		Ps = '6' send health message.
rqstat:
	bsl	getps
	bcs	$done		; exit if no parameter.
	cmp	#5
	beq	rqcurs
	cmp	#6
	beq	rqsick
$done:	rts

;
; Send ESC[x;yR to host.  If origin mode is
; set, x,y are relative to scrolling region.
;

rqcurs:
	bsl	ebout		; emit ESC[
	lda	#0		; clear acc high byte.
	xba
	lda	<curx		; get cursor column.
	bsl	btodec		; convert to decimal (in <dstrng).
	bsl	decout		; send the string.
	
	lda	#';'
	bsl	putchr		; send ';'.
	lda	<cury		; get cursor row.
	bit	<ormode		; origin mode set ?
	bpl	$1		; br if no, send row as is.
	sec			; yes, make row relative
	sbc	<srtop		;  to top of scrolling region.
	inc	a
$1:
	xba			; clear acc high byte.
	lda	#0
	xba
	bsl	btodec		; convert to decimal string.
	bsl	decout		; send the string.
	lda	#'R'		; send terminator.
	bsl	putchr
	rts
;
; Send ESC [ 0 n to host (terminal is ok).
;

rqsick:
	bsl	ebout		; emit ESC[
	lda	#'0'
	bsl	putchr
	lda	#'n'
	bsl	putchr
	rts

;
; ESC [ c (or ESC Z)	What are you ?
;
; Send ESC[?1;2c to host (VT100, no printer).
;

rqidnt:
	bsl	ebout		; emit ESC[
	lda	#'?'
	bsl	putchr
	lda	#'1'
	bsl	putchr
	lda	#';'
	bsl	putchr
	lda	#'2'
	bsl	putchr
	lda	#'c'
	bsl	putchr
	rts
;
; ESC [ 1 x (or ESC [ 0 x)	What are terminal parameters ?
;
;

rqtpar:
	bsl	ebout		; emit ESC[
	rts

;
; ENQ - send answerback message
;

ansbck:
	rts

;
; local routine to send ESC [
;
ebout:	lda	#ESC
	bsl	putchr
	lda	#'['
	bsl	putchr
	rts

setled:
	bsl	getps
	bcc	setled
	rts

slftst:
	bsl	getpn
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Output the null-terminated	;
; string in <dstrng.		;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

decout:
	php
	rep	#0x30
	pha
	phx
	phy
	sep	#0x30

	ldx	#0
$loop:	lda	<dstrng,x	; get next digit in string.
	beq	$done		; done if end of string.
	bsl	putchr		; send it.
	inx			; point to next digit.
	bra	$loop
$done:
	rep	#0x30
	ply
	plx
	pla
	plp
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Local routine to convert the (unsigned);
; value in acc to a string of decimal 	;
; digits in <dstring (null terminated)	;
; Max length is 5 digits, left adjusted	;
; + 1 null byte.			; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

btodec:
	php
	rep	#0x30
	pha
	phx
	phy
;
; point iotemp at table of powers of ten
;
	per	$tens
	plx
	stx	<temp
	
	sep	#0x10		; 8 bit idx.
	phk
	plx
	stx	<temp+2

	stz	<dcount
	ldy	#-2
;
; inc y until 10**y > acc.
;
$1:
	iny
	iny
	cmp	[<temp],y	; acc >= ten**y ?
	bcs	$1		; br if yes.
; 
; while(--y > 0)	(while acc >= 10)
; 	x = '0'
; 	while(acc >= 10**y)
;		acc -= 10**y
;		x++
;	output(x)
; output(acc + '0')
;
	bra	$4		; loop if --y > 0.
$2:
	sbc	[<temp],y	; subtract 10**y.
	inx			; inc coefficient of 10**y.
$22:	cmp	[<temp],y	; acc >= 10**y ?
	bcs	$2		; br if yes.
$3:
;	pha			; save val being converted.
;	txa			; get decimal digit.
;	bsl	putchr
;	pla			; recover val to convert.

	phy			; save index into table.
	ldy	<dcount		; get index next digit in string.
	stx	<dstrng,y	; store digit.
	inc	<dcount		; bump index into string.
	ply			; recover index into table.
$4:
	ldx	#'0'		; init coefficient of 10**y.
	dey			; down to onesies ?
	dey
	beq	$done
	bpl	$22		; br if no.
$done:
;	ora	##'0'		; convert acc to decimal digit.
;	bsl	putchr

	sep	#0x20		; put last digit and terminator.
	ora	#'0'
	tax
	ldy	<dcount
	stx	<dstrng,y	
	ldx	#0
	iny
	stx	<dstrng,y

	rep	#0x30
	ply
	plx
	pla
	plp
	rts

$tens:	dcw	0
	dcw	10
	dcw	100
	dcw	1000
	dcw	10000
	dcw	-1


	end


