

	/****************************************************************
	*								*
	*	serial down loader 	version 0.3			*	
	*		[C] feb 1985 aed, inc.				*
	*	programmer:	mark krueger mse			*
	*								*
	 ***************************************************************/

/*
	description:

	sends object file in m.out format ( form wa or mac ) to serial
	port /dev/tty01 or to std output if not /dev/console. Code preceeded
	with AED SSE(addr) LMR(start)(size) code... and followed with
	JUS(addr) optionally. AED commands in 1 char, 8 bit mode. Default
	load address is 0E00H, new load and execute addresses can be
	chosen with -a(addr) and -g(addr) switches (addr in hex). Will not
	execute unless -g switch present. -s switch ignores ram limitations
	and does not send SSE command. -g switch with address starts execution
	from that address with no download.
*/



#include <stdio.h>
#include <sgtty.h>

#define STDOUT	1		/* stdout filedes */
#define TTYFLG	040		/* sg_flags for port */
#define	MWORD	011223		/* magic word for input file */
#define	SECTS	8		/* max number of program sections */
#define	WSIZE	2		/* word size in bytes */
#define OPSIZE	8		/* op code size in bits */
#define	OPORT	"/dev/tty01"	/* output port for aed terminal */
#define	JUS	";"		/* aed run command */
#define	RST	"G18HHN~"	/* aed terminal init */
#define	LMR	":"		/* aed terminal load */
#define SSE	"}"		/* aed terminal set stack end */
#define CRLF	"\r\n"		/* car ret line feed pair for raw mode io */
#define LSB	0xff		/* to convert int to lsb char */
#define	STADD	0xe00		/* default starting load address */
#define	MAXRAM	0x27ff		/* highest ram location in aed term */
#define	GO	1		/* flag to run */
#define RAM	2		/* flag to not set stack end */
#define	NOLOAD	4		/* flag to not load */
#define NOGOAD	8		/* flag for no load address */
#define FALSE	0
#define USAGE	"usage: dls objfile [ -g[ADR] ] [ -a[ADR] ] [ -s ]\n\
   or: dls -gADR\n"

main(argc,argv)

int argc;
char *argv[];

{
	register unsigned i, j;
	char *com;
	static char flag = FALSE;
	unsigned ladd, gadd;
	static unsigned sladd;
	FILE *fopen(), *freopen(), *fin;
	static unsigned *buf[ 3 + 3*SECTS];
	struct sect {
		unsigned size;
		unsigned add;
		unsigned attrib;
	};
	struct sect psect[SECTS];
	struct sgttyb ttys;


/*
 *	interpret switches 
 */

	ladd = STADD;
	if ( argc < 2 || argc > 5) {
		fprintf(stderr,USAGE);
		exit(0);
		}
	i = 1;
	while (argc == 2 ) {
		com = argv[i];
		j = 0;
		if ( com[j++] != '-' )
			break;
		if ( com[j++] != 'g' )
			{
			fprintf(stderr,USAGE);
			exit(1);
			}
		if (sscanf(com + j,"%x",&gadd) == 0)
			{
			fprintf(stderr,"dls: illegal address %s\n", com+j);
			exit(1);
			}
		flag |= ( GO | NOLOAD );
		argv[i] = "program";
		argc = 1;
		}		
			

	if (argc > 1 ) {
		if ( (fin = fopen(argv[i],"r")) == NULL) {
			fprintf(stderr,"dls: can't open %s\n",argv[i]);
			exit(1);
			} 
		}
	i = argc;
	while ( i-- > 2  ) 	{
		com = argv[i];
		j = 0;
		if ( com[j++] != '-' ) {
			fprintf(stderr, "dls: unknown switch %s\n",com);
			exit(1);
			}
		switch(com[j++]) {
			case 'a': 	{
				if (sscanf(com + j,"%x",&ladd) == 0)
					ladd = STADD;
				break;
				}
			case 'g':	{
				if ( com[j] == 0 ) {
					flag |= NOGOAD;
					gadd = ladd;
					}
				else 	{
					if (sscanf(com + j,"%x",&gadd) == 0) {
						gadd = ladd;
						flag |= NOGOAD;
						}
					}
				flag |= GO;
				break;
				}
			case 's' : 	{
				flag |= RAM;
				break;
				}
			default:	{
				fprintf(stderr,"dls: unknown switch %s\n", com);
				exit(1);
				}
			}
		}

	if ( (flag & NOGOAD) == NOGOAD )
		gadd = ladd; 


/*
 *	check output port if stdout defined use it if not use OPORT
 */

	if ( strcmp((com = ttyname(STDOUT)),"/dev/console") == 0 ) {
		if (freopen(OPORT,"a",stdout) == NULL)
			{
			fprintf(stderr, "dls: can not open %s\n", OPORT);
			exit(1);
			}
		}

/*
 *	set up interface
 */

	if ( gtty(STDOUT, &ttys) == 0 ) {
		ttys.sg_flags = TTYFLG;
		stty(STDOUT, &ttys);
		}

/*
 * 	read and check headers 
 */

	if ( !(flag & NOLOAD) ) {
	  i = 0;
	  if ( fread(buf, WSIZE, ( 3 + 3*SECTS), fin) == 0 ) {
		fprintf(stderr, "dls: input error %s\n", argv[1]);
		exit(1);
		}
	  if ( buf[i++] != MWORD ) {
		fprintf(stderr, "dls: %s not in m.out format\n",argv[1]);
		exit(1);
		}
	  if ( buf[i++] != OPSIZE ) {
		fprintf(stderr, "dls: %s not bytes\n", argv[1]);
		exit(1);
		}

	  i++;	/* skip attrib word */
	  j = 0;
	  while ( j < SECTS ) {
		psect[j].size = buf[i++];
		psect[j].add = buf[i++];	  
		psect[j++].attrib = buf[i++];
		}

/*
 *	prime terminal
 */	

	  printf(RST);
	  printf("%sLoading %s...%s", CRLF, argv[1], CRLF);

/*
 *  	load all sections
 */

 	  for ( j = 0; j < SECTS; j++) {
		if (psect[j].size == 0)
			continue;
		if (psect[j].add != 0)
			ladd = psect[j].add;
		sladd = ladd;
	  fprintf(stderr,"psect:%2x size:%5x add:%5x\n",j ,psect[j].size,sladd);

/*
 *	check ram and tell terminal to load
 */
		if ( !(flag & RAM)) {
			if ( (i = psect[j].size + ladd) > MAXRAM || i == 0 ) {
				fprintf(stderr,"dls: out of memory at %x\n",i );
				exit(1);
				}
			printf(SSE);
			putchar(msb(i));
			putchar(lsb(i));
			printf("%s", CRLF);
			}
		printf(LMR);
		putchar(msb(ladd));		
		putchar(lsb(ladd));
		putchar(msb(psect[j].size));
		putchar(lsb(psect[j].size));

/*	
 *	send out bytes
 */

		while ( ladd < sladd + psect[j].size) {
			if ( fread(buf,WSIZE,1,fin) == 0 ) {
				fprintf(stderr,"dls: %s out of data\n",argv[1]);
				exit(1);
				}
			putchar(buf[0]);
			ladd++;
			}
		printf("%sSection %1x Loaded at %5x%s",CRLF, j ,sladd, CRLF);
		}

	}

/*
 *	start execution if selected
 */

	if ( flag & NOLOAD )
		{
		printf(RST);
		printf("\nStarting execution at %x\n", gadd);
		}

	if ( flag & GO ) {
		printf(JUS);
		putchar( msb(gadd));
		putchar( lsb(gadd));
		fprintf(stderr, "dls: %s running at %6x\n",argv[1], gadd);
		}
	exit(0);
}		


msb(num)

int num;

{
	int i;
	i = num >> 8;
	return( i & LSB );
}

lsb(num)

int num;

{
	return ( num & LSB );
}
