
#include	"mac.h"
#include	"mac.x"

/*
 *   This module contains all the code format listing stuff
 *   the general format for output is:
 *
 *   xxxx xxxx xxxxxxxx xxxxxxxxxxxxxxxx....
 *   line  pc    code     source line
 */

/*
 *   Pseudo opcode line	listing.
 */
plist(lc)
register int lc;
{
	register struct	st *q;
	register int i;
	register int l;
	register int ps;

	ps = intercode.i_op;

	/*
	 *   Call header() if at top of	page, and instruction
	 *   to	be listed is not 'title' or 'eject'.
	 */
	newpage();
	printf("%-4d ",nline);
	switch (ps)  {

	  case DC1:	/* dc's	*/
	  case DC2:
	  case DC3:
	  case DC4:
	    l = head.h_bu_len / 4;
	    ps = head.dctype[ps].f_len;
	    printl(4, lc);
	    putchar(' ');
	    for(i=0; i<ps; i++)
	      printl(l,*cp++);
	    printf("\t\t");
	    break;

	  case DCS:			/* dc special */
	    l = head.h_bu_len / 4;
	    printl(4, lc);
	    putchar(' ');
	    if(length > 4)
	      ps = 4;
	    else
	      ps = length;
	    for (i=0; i<ps; i++)
	      printl(l, *cp++);
	    if(length <= 4)
	     putchar('\t');
	    putchar('\t');
	    break;

	  case DS:
	    printl(4, lc);
	    printf("\t\t");
	    break;

	  case ALIGN:		/* align */
	  case ORG:		/* org */
	  case END:		/* end */
	    printl(4, locn[lcntr].l_value);
	    printf("\t\t");
	    break;

	  case EQU:		/* equ */
	  case STRUCT:		/* struc */
	  case ENDS:		/* ends	 */
	    i = intercode.i_label;
	    if (i != ERR)  {
	      q = &symtab[i];
	      printl(4, q->s_value);
	    }
	    else
	     printf("\t");

	    printf("\t\t");
	    break;

	  case EXPORT:		/* export */
	  case EXTERN:		/* extern */
	    printf("\t\t\t");
	    break;

	  case ASECT:		/* seg */
	  case PSECT:
	    printf("%04d\t\t", lcntr);
	    break;

	  case TITLE:
	  case EJECT:	/* eject */
	    getlin();			/* skip to next line */
	    if(lline < 2)
	      header(0);
	    else
	      putchar('\n');
	    return;
	}
	source();			/* print line of source	*/
	return;
}

/*
 *   Dud line listing -	just print source.
 */
tlist(lc)
{
	register int l;

	newpage();
	printf("%-4d ",nline);
	if ((l = intercode.i_label) != ERR)
	  printl(4, lc);
	else
	  printf("\t");

	printf("\t\t");
	source();
	return;
}

/*
 *   Opcode listing.
 */
olist(lc)
{
	register int i;
	register int len;

	newpage();
	printf("%-4d ",nline);
	printl(4, lc);
	printf(" ");
	len = head.h_bu_len;
	len =/ 4;
	for (i=0; i<length; i++)
	  printl(len, *cp++);
	if(length < 3) putchar('\t');
	putchar('\t');
	source();
	return;
}

source(){
	getlin();
	printf("%s",srcbuf);
	return;
}
