/*
 *	This file contains all of the fixed data areas
 *	External declarations are made via "include mac.x"
 */

#include	"mac.h"
#include	<stdio.h>

FILE	*srcfil;
char	*srcnam;			/* current source file */

int	intfil;				/* intercode file pointer */
int	objfil;				/* object file pointer    */
int	relfil;				/* reloc info file pointer*/
int	rfile;				/* rfile file pointer     */

char	tmp[16] = "/tmp/mxx";		/* intermediate code file */
char	dmptitle[] = "Generated Code";
char	reltitle[] = "Relocation Information";
char	symtitle[] = "Symbol Table";

char	*arg[MAXFILES+1];		/* stack of rfile and src names */
					/* rfile name is always arg[0]*/

int	nfile		0;		/* count of files in arg[] */
int	nline		0;		/* nth input line */
int	lline		0;		/* nth listing line */
int	lpage		0;		/* page	number */
int	nsyms		0;		/* # of	symbols	*/
int	errcount	0;		/* # errors */
int	inhcod		0;		/* ifdef/endif toggle */
int	lstflg		1;		/* list/nlist flag */
int	lastsym		ERR;		/* most recent symbol */
					/* used as idx for loc sym blks */

char	flags[] =   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		   /* A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P */
		      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		   /* Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  ` */
		      0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,
		   /* a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p */
		      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
		   /* q  r  s  t  u  v  w  x  y  z                   */

char	*p;				/* char	line pointer */
char	srcbuf[MAXBUF];			/* line	buffer */
char	clabel[64];			/* identifiers & strings */
char	ctitle[MAXOPN];			/* title buffer	*/
char	*literals;			/* literal labels */

struct	fd	*memory;		/* start of brk'd core & fmt tab */
struct	st	*symtab;		/* pointer to symbol table */
char		*opcode;		/* pointer to opcode table */
struct	tbl	*parse;			/* start of parser table */
char		*endcore;		/* end of core pointer */
char		*coreptr;		/* pointer to next free	byte */
int		*code;			/* pointer to assembled	code */

int	symtyp;				/* next	symbol */
int	member;				/* member of symbol */
int	oprstac[16];			/* general opr.	stack */
int	relstac[16];			/* relocatability word */
int	*cp;				/* pointer to object */
int	nstruc	0;			/* structure offset counter */

char	(*fn)();

int	eof;				/* eof indicator flag */
int	lcntr;				/* curr. locn counter */
int	length;				/* length of cur. instr. */

int	reloc;				/* current reloc factor	*/
int	mreloc;				/* internal reloc word */
int	gblidx;				/* reloc index */

char	*plabel[ ]	{		/* pseudo op labels */
	0,
	0,
	0,
	0,
	"equ",
	"export",
	"extern",
	"align",
	"org",
	"asect",
	"psect",
	"ds",
	"end",
	"title",
	"eject",
	"dcs",
	"struct",
	"ends",
	"ifdef",
	"endif",
	"list",
	"nlist",
	0
	};

extern	int	prdc1(),   prdc2(),   prdc3(),    prdc4();
extern	int	prnull(),  prequ(),   prexport(), prextern();
extern	int	pralign(), prorg(),   prasect();
extern	int	prpsect(), prds();
extern	int	prend(),   prdcs(),   prstruc(),  prends();
extern	int	prifdef(), prendif(), prlist(), prnlist();

/*
 *
 */

int	pradr[ ]	{
	&prdc1,
	&prdc2,
	&prdc3,
	&prdc4,
	&prequ,
	&prexport,
	&prextern,
	&pralign,
	&prorg,
	&prasect,
	&prpsect,
	&prds,
	&prend,
	&prnull,		/* title */
	&prnull,		/* eject */
	&prdcs,			/* special dc */
	&prstruc,
	&prends,
	&prifdef,
	&prendif,
	&prlist,
	&prnlist,
	0
	};

extern	int	pedc1(),   pedc2(),   pedc3(),  pedc4();
extern	int	pealign(), peorg(),   peasect();
extern	int	pepsect(),  peds();
extern	int	peend(),   petitle(), penull(), pedcs();

int	peadr[ ]	{
	&pedc1,
	&pedc2,
	&pedc3,
	&pedc4,
	&penull,		/* equ */
	&penull,		/* global */
	&penull,		/* extern */
	&pealign,
	&peorg,
	&peasect,
	&pepsect,
	&peds,
	&peend,
	&petitle,
	&penull,		/* eject */
	&pedcs,
	&penull,		/* struc 14 */
	&penull,		/* ends	*/
	&penull,
	&penull,
	&penull,
	&penull,
	0
	};

char	hextab[	] "0123456789abcdef";
char	octtab[	] "01234567";
char	dectab[	] "0123456789";
char	alptab[	] "ABCDEFGHIJLKMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz._$:";
char	oprtab[	] "+-*/%><~&|";

struct	st	*fchar[sizeof (alptab)];	/* first char indexes */

int	fcharsz = sizeof alptab;

struct	ht	head;				/* header record */

struct	lt	locn[LCOUNT];
struct	it	intercode;


int	bitmask[ ]	{

	0x0000,	0x0001,	0x0003, 0x0007, 0x000f,
	        0x001f, 0x003f, 0x007f, 0x00ff,
	        0x01ff, 0x03ff, 0x07ff, 0x0fff,
	        0x1fff, 0x3fff, 0x7fff, 0xffff

	};

