/*
 * Press-up game...
 *
 *	This excellent program was originally written by:
 *		Prof. Steve Ward
 *		Director, Real-Time Systems Group
 *		MIT Lab	for Computer Science
 *		Cambridge, Massachussetts, 02139
 *
 *	Extensive modifications	for AED	767 graphics terminal
 *	output were made by Steve Heiker of Advanced Electronics
 *	Design.
 *
 *	Also note that some parts of this code to prevent character
 *	entry from showing on the console...this feature does not work
 *	on systems that	do not permit single character I/O.
 */

#include <stdio.h>

#define	SIDE		7	/* Dimension of	board	*/

#define	HISFIRST (SIDE*2+1)	/* His best first move	*/
#define	MYFIRST	(SIDE+SIDE/2-1)	/* My best first move	*/
#define	BELL 0x07
#define	BACKSP 0x08
#define	MESG static char


char *yourmv="Your Move";
char *think ="Thinking...";
char *hthink="I'm thinking for you...";
char errors[]={BELL,'E','R','R','O','R',BELL,0};
char *cwin  ="COMPUTER WINS!";
char *pwin = "   you won";
char *twin = "   Tie game";
char *nother = "Another game?";
char *helpf = "YOU'VE HAD HELP";
char *igo = "I go first";
char *ugo = "You go first";
char *gotu = "I've got you now!";
char *gotme = "You've got me!";
MESG cr[1],bs[1],alpha[1];
MESG lf[]={1};
char *computer="Computer";
char *player="Player";
char *search="Search Depth";
char *zhlp="Press Z for help";
MESG credits[]={'P','R','E','S','S','U','P',' ','c','o','u','r','t','e','s',
'y',' ','o','f',' ','A','D','V','A','N','C','E','D',' ','E','L','E','C','T',
'R','O','N','I','C','S',' ','D','E','S','I','G','N',' ','a','s',' ','m','o',
'd','i','f','i','e','d',' ','b','y',' ','S','t','e','p','h','e','n',' ','H',
'e','i','k','e','r','.',0};



int	Depth;		/* Search depth	(default = 4)	*/
int	Helpflag;
char	FFlag;		/* -f option: machine goes first */
char	Startflag;	/* True	on first move only */
char	Sflag;		/* Play	a sample game */
int	tmp,hflagg,firstmv,rscore,bscore,oldn,oldch; /*	graphics variables */
static int blank[1];

char *image;
int Adj[16] ={-1,-1,-1,0,-1,1,0,-1,0,1,1,-1,1,0,1,1};

int	BestMove;		/* Returned by search	*/

#define	BBOARD struct bord

struct bord
  {	char board[SIDE*SIDE];
	int  star;
	char red;
	char blue;
  };

BBOARD initb;

BBOARD master;

char string[20];

CheckWin(bp)
 BBOARD	*bp;
 {	int i;
	i = search(bp,1,1,-32000,-32000);
	if (BestMove >=	0) return;

	if (i>0) windsp(cwin);
	if (i<0) windsp(pwin);
	if (i==0) windsp(twin);
	return(1);
	}

asknew()
{
	commdsp(nother);	/* ask for another game	*/
	while(tmp=toupper(getchar()))
	  {
	  if(tmp=='Y'){cclear(); break;}
	  if(tmp=='N'){sbc(0); ffd(); exit();}	/*save phosphor	on screen*/
	  cclear();
	  }
}

main(argc,argv)
 char **argv;
  {	int i,j;
	char *arg,qchar;
	FFlag = 1;
	Sflag = hflagg = 0;
	image =	".rbXRB";

	Depth =	4;
	for (i=1; i<argc; i++)
	  {
	  if (*(arg = argv[i])=='-')
	    switch (toupper(*++arg))
	      {
		case 'D':	Depth =atoi(argv[++i]);	continue;
		case 'F':	FFlag--; continue;
		case 'S':	Sflag++; FFlag++; continue;
		default:	printf("Illegal	argument: '%1s'\n",argv[i]);
				exit();
	      }
	   else	{printf("Illegal argument: '%1s'\n",arg); exit(); }
	  }
	if(Depth==0){printf("Depth 0 not legal!\n"); exit();}

printf("\nWould	you like some help? <Y or N>");

while(qchar=getchar())
  {
  cclear();
  if(qchar=='y'||qchar=='Y')
    {
    dsphelp();
    break;
    }
  if(qchar=='n'||qchar=='N') break;
  }

printf("\n");
ngame:
	Startflag=1;
	if(Sflag) hflagg=0;
	Sflag ?	(Helpflag=1) : (Helpflag=0);
	for (i=0; i<(SIDE*SIDE); i++) initb.board[i] = 0;
	 for (j=1; j<(SIDE-1); j++)
		{ initb.board[j] = 1;
		  initb.board[(SIDE*SIDE-1)-j] = 1;
		  initb.board[SIDE*j] =	2;
		  initb.board[SIDE*j + SIDE-1] = 2; };
	initb.star = -1; initb.red = 0;	initb.blue = 0;

	bcopy(&initb,&master);
	initterm();	/* draw	board on graphics terminal */
	pboard(&master);
	gput(Depth,'D');	/* display depth setting */

	for(;;)
	  {	if (FFlag) { FFlag = 0;	goto Mine; }
		if (CheckWin(&master)) {
			asknew();
			goto ngame;
		 }
		i = getmove();
		if (i == 'Q') {
			cclear();
			asknew();
			goto ngame;
		 }
		dmove(i);
		if (CheckWin(&master)) {
			asknew();
			goto ngame;
		 }
	Mine:	commdsp(think);
		i = search(&master,Depth,1,-32000,-32000);
		dmove(BestMove);
		if (i >	500) {commdsp(gotu); delay(15);}
		if (i <	-500) {commdsp(gotme); delay(15);}

	  }
  }


pboard()
  {
	if(Helpflag) hlpdsp(helpf);
	if(Startflag)
	  {
	  FFlag	? commdsp(igo) : commdsp(ugo);
	  delay(25);
	  }
	Startflag = 0;
  }

bcopy(p1,p2)
BBOARD *p1, *p2;
  {	int i;
	i = (SIDE*SIDE)-1;
	do p2->board[i]	= p1->board[i];
		while(i--);
	p2->star = p1->star;
	p2->red	= p1->red;
	p2->blue = p1->blue;
  }


/* display move	#n */

dmove(n) /* n is the array address (0-48) of the move */
  {
	move(&master,n);	/* update master display array */
	gmove(&master,n);	/* update graphics display */
	pboard(&master);	/* send	display	to screen */
  }

/* converts position in	an array into a	'used' value for display and
updates	the score count	stored in that array */

move(bp,n)
BBOARD *bp;
  {	int type;
	type = bp->board[n] += 3;	/* update array	and get	type */
	if (type == 4) bp->red++;	/* update red score if true */
	else if	(type == 5) bp->blue++;	/* update blue score if	true */
	bp->star = n;			/* update current move value */
  }

search (bp,ddepth,who,alpha,beta)
BBOARD *bp;
  {	int i,j,k;
	int myalpha,hisalpha,status;
	int best;
	int num;
	int bestmove, ii, jj, n;
	int SavStar;
	int SavBlue;
	int SavRed;
	int Save;
	char moves[9];
	status = -1;
	best = -32000;
	num = 0;
	SavStar	= bp ->	star;
	SavBlue	= bp ->	blue;
	SavRed	= bp ->	red;
	BestMove = -1;		/* No best move	yet...	*/

	if (SavStar == -1)	/* special case	opening	moves	*/
	 { BestMove = HISFIRST;
	   if (who > 0)	BestMove = MYFIRST;
	   return;};

	if (!ddepth--)
		return(who * (bp->blue - bp->red));
	if (bp->blue ==	(SIDE*2-4) || bp->red == (SIDE*2-4))
		return(who*(bp->blue - bp->red)*1000);

		  /* alpha-beta	pruning	  */
	  if (who>0)   { myalpha = bp->blue; hisalpha =	bp->red; }
	   else		{ myalpha = bp->red; hisalpha =	bp->blue; }
	   myalpha += ddepth;  /* Most optimistic estimate. */
	   if (myalpha > (SIDE*2-4)) myalpha = (SIDE*2-4);
	   if (myalpha == (SIDE*2-4)) myalpha =	1000*(myalpha-hisalpha);
	   else	myalpha	-= hisalpha;
	   if (myalpha <= alpha) return(best);

	k = bp->star;
	i = k%SIDE;
	j = k/SIDE;
	for (n=0; n<8; n++)
	 {
		if ((ii	= i+Adj[n+n]) <	0 || ii	>= SIDE) continue;
		if ((jj	= j+Adj[n+n+1])	< 0 || jj >= SIDE) continue;
		if (bp->board[moves[num] = jj*SIDE + ii] < 3) num++; }
	if (num	== 0) return(who*(bp->blue - bp->red)*1000);
	bestmove = moves[0];
	for (i=0; i<num; i++)
	 { Save	= bp->board[moves[i]];	move(bp,moves[i]);
	   k = -search(bp,ddepth,-who,beta,alpha);
	   bp->board[moves[i]] = Save;
	   bp->blue = SavBlue; bp->red = SavRed; bp->star = SavStar;
	   if (k > alpha) alpha	= k;
	   if (k > best) { best	= k; bestmove =	moves[i]; }
	   if (k>100) break; }
	BestMove = bestmove;
	return(best); }

Help()
 {	Helpflag = 1;
	commdsp(hthink);
	search(&master,Depth,-1,-32000,-32000);
	return(BestMove); }

getmove()
  {	int row, col, n;
	int dc,	dr;
	int star2;
	star2 =	master.star;
loop:	commdsp(yourmv);
getrow:	for (;;) {
		 esc();		/* turn	interpreter back on */
		 if(Sflag) return(Help());	/* play	sample game */
		 if ((row = toupper(getchar()) ) == 'Z') {
			cclear();
			return(Help());
			}
		  cclear();
		  if (row == 'Q') return(row);
		  if (row == 0177 || row == '\n') goto err;
		  msetup('R');	/* set up term to display move */
		  outval(&row);
		  esc();
		  if (row<'A' || row> ('A'+SIDE-1)){
			msetup('B');	/* test	bounds */
			cclear();;
			}
			else break;
		}
	cclear();
	row -= 'A';

	for (;;) {
		 col = getchar();
		 cclear();
		 msetup('C');	/* set up term to display move */
		 outval(&col);
		 esc();		/* turn	interpreter back on */
		  if (col == 0177) {
			cclear();
			msetup('B');
			goto getrow;
		   }

		if (col	== '\n'	|| col == '\b')	goto err;
		if (col	< '1' || col > ('0'+SIDE)){
			cclear();
			msetup('B');
		   }
			else break;
		}
	cclear();

	col -= '1';
	n = row*SIDE + col;
	dr = row - star2/SIDE;
	if(dr<0) dr=(-dr);
	dc = col - star2%SIDE;
	if(dc<0) dc=(-dc);
	if ((star2 < 0 && master.board[n] == 0)	||
	    (dr	< 2 && dc < 2 && master.board[n] < 3))
		return(n);

   err:	commdsp(errors);
	delay(30);
	goto loop;
  }



/* Initialize the 767 graphics terminal	*/

initterm()
{

int cnt,xpnt,ypnt,square;
int t1,t2,width;

rscore=0;
bscore=0;
oldch=6;
firstmv=1;
*cr=13;
*bs=8;		/* backspace character */
square=50;	/* size	of play	squares	*/
width=3;	/* line	width */
esc();	/* set interpreter on */
sbc(3);	/* yellow background */
ers();	/* clear screen	*/

/* draw	grid pattern on	the screen */

sec(5);		/* color of grid is magenta */
for(ypnt=200;ypnt<=(7*square+200);ypnt+=square)
  {
  xpnt=200;	/* left	border */
  mov(xpnt,ypnt);
  dfr(xpnt+7*square,ypnt+width);	/* draw	horizontal line	*/
  if(ypnt<(7*square+200))
    {
    for(xpnt=200;xpnt<=(200+7*square);xpnt+=square)
      {
      mov(xpnt,ypnt);
      dfr(xpnt+width,ypnt+square+width);	/* draw	vertical lines */
      }
    }
  }
sec(6);		/* draw	squares	in cyan	*/
for(xpnt=205,ypnt=205;ypnt<205+7*square;ypnt+=square)
  {
  for(xpnt=205;xpnt<=205+6*square;xpnt+=square)
    {
    mov(xpnt,ypnt);
    ifl();
    }
  }

/* Position the	playing	pieces */
sac(3);			/* no alpha cursur */
sec(1);			/* red characters */
t1=200+square/2-4;	/* x coordinate	*/
t2=7*square+5+200;	/* y coordinate	*/
mov(t1,t2);
sap('2','7',square,square,'L');	 /* set	for alphanumerics */
alf();			/* enter alpha mode */
*alpha='1';		/* start numbers at 1 */
for(cnt=0;cnt<7;cnt++)
  {
  outval(alpha);
  (*alpha)++;
  }
esc();			/* interpreter on */
t1=183;
t2=6*square-8+200+square/2;
mov(t1,t2);		/* position of column */
sap('2','7',0,0,'L');	/* set for alphanumerics */
*alpha='A';
for(cnt=0;cnt<350;cnt+=50)
  {
  mov(t1,t2-cnt);	/* vertical column of alphas */
  alf();
  outval(alpha);
  esc();		/* interpreter on */
  (*alpha)++;
  }


/* draw	the playing pieces */

for(t1=2;t1<7;t1++)
  {
  drawp(1,t1,2);	/* draw	blue setup */
  drawp(7,t1,2);
  drawp(t1,1,1);	/* draw	red setup */
  drawp(t1,7,1);
  }

/* Put up all of the signs */
mov(60,9*square);	/* display computer title */
sap('1','7',12,15,'L');	/* set for alphanumerics */
alf();			/* leave interpreter */
outary(computer);
esc();
mov(75,350);
sec(7);
dfr(75+square,350+square);

mov(624,450);
sec(1);
alf();
outary(player);
esc();
mov(630,350);
sec(7);
dfr(630+square,350+square);
mov(264,155);
sec(1);
alf();
outary(searchl);
esc();
mov(440,133);
sec(7);
dfr(440+square,133+square);

mov(150,100);		/* draw	message	box */
dfr(150+220,100-18);

mov(166,65);		/* print help message */
sec(4);
alf();
outary(zhlp);
esc();

mov(75,3);		/* print credits */
sec(5);
sap('1','7',8,0,'L');	/* set for alphanumerics */
alf();
outary(credits);
esc();
}


/* Get data from array and send	it to graphics terminal...store	new
moves, send asterisk to	screen,	then update the	display	*/

gmove(gbp,n)
BBOARD *gbp;
{
if(firstmv!=1)dgmove(oldch,oldn);
oldn=n;				/* save	pointer	*/
oldch =	gbp->board[n] -	1;	/* graphics type to save */
if(firstmv!=1)dgmove(oldch,oldn); /* background	for marker */
firstmv=0;
dgmove(5,n);			/* draw	marker for first showing */

if((oldch!=3)&&(oldch!=4)) oldch=6;
if(oldch==3){++rscore; gput(rscore,'P');}	/* update scores */
if(oldch==4){++bscore; gput(bscore,'C');}
}

/* convert n array value to xy coordinates */

dgmove(gchar,nplace)
int gchar,nplace;
{
int xpos,ypos;

xpos=nplace%7;		/* generate xy coordinates */
ypos=(nplace-xpos)/7;
drawp(xpos+1,ypos+1,gchar);
}

/* draw	a playing piece	on the board

arguments are as follows:

drawp(xcoord,ycoord,piece)

	xcoord and ycoord are array values 1 thru 7
	pieces are 1 for red setup, 2 for blue setup,
		   3 for red move, 4 for blue move,
		   5 for marker, 6 for used blank square.

*/

drawp(xcoord,ycoord,piece)
int xcoord, ycoord, piece;
{
int xc,yc,gcolor;
int square;

square=50;

switch(piece)
  {
  case 1: gcolor=1; break;	/* translate colors */
  case 2: gcolor=4; break;
  case 3: gcolor=1; break;
  case 4: gcolor=4; break;
  case 5: gcolor=0; break;
  case 6: gcolor=0; break;
  }
xc=(xcoord-1)*square+225;		/* x & y centered in squares */
yc=(7-ycoord)*square+225;
mov(xc,yc);			/* position CAP	*/
sec(6);
if(piece!=5) ifl();			/* erase figure	there now */
sec(gcolor);
if(piece==1||piece==2||piece==5)dcl(10);
ifl();
}


/* routine to place all	values on the screen during play */

MESG odval[1];

gput(dval,iplace)
char dval,iplace;
{
int color,xplac,yplac;
char addval,ddval[1];

addval=0;
*odval=dval-1+0x30;	/* character to	clear */
if(dval>9)	/* convert >9 to two numbers */
{
addval=dval;
dval=addval%10;
addval=(addval-dval)/10+0x30;
}

*ddval=dval+0x30;	/* convert to character	*/
switch(iplace)
  {
  case 'C': color=4; yplac=366;	xplac=93; break;
  case 'D': color=0; yplac=150;	xplac=458; break;
  case 'P': color=1; yplac=366;	xplac=649; break;
  case 'Z': color=1; break;
  }
sap('2','7',16,0,'L');
sec(7);			/* redraw last value in	white to erase */
mov(xplac,yplac);
alf();
outval(odval);
esc();
mov(xplac,yplac);	/* back	for write of first number */
sec(color);
if(addval>0)
  {
  mov(xplac-10,yplac);	/* to display greater than 9 */
  alf();
  outval(&addval);
  esc();
  }
alf();
outval(ddval);
esc();
}

/* displays terminal communications

Message	arguments are:

	Pointer	to base	of string.
	String terminated by a null.
*/
commdsp(msg)
char *msg;
{
sap('1','7',8,0,'L');
sec(7);
mov(150,100);		/* clear by redrawing */
dfr(150+220,100-18);
mov(153,87);		/* start of message area */
sec(7);
ifl();
sec(0);
alf();
outary(msg);
esc();
}

/* Print game won messages */

windsp(wins)
char *wins;
{
sec(1);
mov(225,30);
sap('2','7',20,0,'L');
alf();
outary(wins);
esc();
}

/* waste time subroutine */

delay(times)
int times;
{
int xt;
for(;times>0;times--) for(xt=1;xt<1000;xt++);
}

/* display that	player has asked for help */

hlpdsp(msg)
char *msg;
{
	if(hflagg>0) return;
	hflagg=1;
	sap('1','7',14,0,'L');
	sec(7);
	mov(150,120);
	dfr(150+220,120-18);
	mov(158,107);		/* start of message area */
	sec(1);
	alf();
	outary(msg);
	esc();
}

/* setup for operator's	entry of a move	*/

msetup(cdis)
int cdis;
{
static int Cflg,dpos,cpos;

	if(cdis=='R')		/* row value */
	  {
	  Cflg=1;
	  esc();
	  sap('1','7',0,0,'L');
	  cpos=150+199;
	  dpos=cpos+8;
	  mov(cpos,87);		/* position of first char */
	  sec(0);
	  alf();
	  }
	if(cdis=='C')		/* column value	*/
	  {
	  Cflg=0;
	  esc();
	  sec(0);
	  mov(dpos,87);
	  alf();
	  }
	if(cdis=='B')
	  {
	  esc();
	  sec(7);
	  Cflg?	mov(cpos,100) :	mov (dpos,100);	/* erase last */
	  dfr(150+220,100-18);
	  }
}

/* Something that should clear anything	*/

cclear()
{
	printf("%c %c",BACKSP,BACKSP);
}

/* Kludge patch	to allign boundaries for 16 bit	machines */

outary(inbuff)
char *inbuff;
{
int pcalc,cnt;
char *startbf, outbf[80];

	pcalc=outbf;
	cnt=0;
	(pcalc & 1) ? (startbf = &outbf[1]):(startbf = &outbf[0]);
	while(*inbuff>0){startbf[cnt++]= *inbuff++;}
	if(cnt!=0)obyte(startbf,cnt);
}

MESG vals[]={0,0};

outval(inbuff)		/* single byte value passing */
char *inbuff;
{
	*vals =	*inbuff;
	outary(vals);
}

dsphelp()
{
	printf("\n\n\n\n\n\n\n\nPress-up game...\n");
	printf("pressup	<options>\n");
	printf("where <options>	may include:\n");
	printf("    -s	    Play a sample game\n");
	printf("    -f	    Machine goes first\n");
	printf("    -d n    Search depth is n moves, the default is 4.\n");
	printf("	    (greater search depths take	longer...but\n");
	printf("	    play better!!)\n\n");
	printf("This excellant program was originally written by:\n\n");
	printf("Prof. Steve Ward\n");
	printf("Director, Real-Time Systems Group\n");
	printf("MIT Lab	for Computer Science\n");
	printf("Cambridge, Massachussetts, 02139\n");
	printf("\nExtensive modifications for AED 767 graphics terminal	output were made\n");
	printf("by Steve Heiker	of Advanced Electronics	Design.\n\n");
	printf("<enter Y to continue N to abort>");
	while (tmp=toupper(getchar()))
	  {
	  if(tmp=='Y') break;
	  if(tmp=='N') return;
	  }
	cclear();
	printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
	printf("The game of Press-Ups is played	as follows:\n\n");
	printf("  The board is a n by n	array of pegs, each of which is	standing up at\n");
	printf("  the start of the game. Pegs come in 3	colors:	Red (yours), Blue (the\n");
	printf("  machine's), and light	blue (they're neutral.)\n\n");
	printf("  The first player to move must	'push down' a neutral peg. Thereafter,\n");
	printf("  players take turns pushing down pegs,	where each peg pushed must be\n");
	printf("  adjacent to the last one pushed.\n\n");
	printf("  Pegs are named by giving a letter and	a number, for the row and column\n");
	printf("  of the desired peg.\n\n");
	printf("  As soon as a player gets all of his pegs down, he wins.  When	there\n");
	printf("  are no more legal moves to play, the player with the most of his own\n");
	printf("  colored pegs down is the winner.\n\n");
	printf("  Watch	out...at search	depths of 6 or more, this program plays	a\n");
	printf("  mean game!!!\n\n");
}

