/*
 * File:	medulla_errors.sdl
 *
 * Copyright (C) 1994 by
 * Digital Equipment Corporation, Maynard, Massachusetts.
 * All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  of  the  terms  of  such  license  and with the
 * inclusion of the above copyright notice. This software or  any  other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 * The information in this software is  subject to change without notice
 * and  should  not  be  construed  as a commitment by Digital Equipment
 * Corporation.
 *
 * Digital assumes no responsibility for the use  or  reliability of its
 * software on equipment which is not supplied by Digital.
 *
 * Abstract:	Medulla error definitions
 *
 * Author:	C. G. Heiter
 *
 * Modifications:
 *
 *	tna	4-Jan-1999	added a universe_diag statement
 *	rnf	10-Aug-1994	added strings for Memtest and Exer failures
 *
 *	rnf	 1-Aug-1994	added nvram error log structures
 *
 *      rnf     20-Jul-1994	z8530 detailed error codes added.
 *
 *      dch     20-Jul-1994     misc detailed error codes added - table
 *
 *	cgh	10-Jun-1994	Initial Entry
 *
 */
#include "cp$src:time.h"

/*
 *
 *-------------------------------------------------------------------------
 *		             E r r o r   V e c t o r
 *-------------------------------------------------------------------------
 *   The error vector includes the actual error detected and information
 * pertaining to the failing part(s) of the hardware circuitry.
 *
 * Error Vector:
 *
 *                       Diagnostic       Failure        Detailed
 *         Flags         Name Code        Point          Error Code
 *    +-------------+ +-------------+ +-------------+ +-------------+
 *    |             | |             | |             | |             |
 *    +-------------+ +-------------+ +-------------+ +-------------+
 *     31         24   23         16   15          8   7           0
 *
 * The 'Flags' area contains various information related to the error
 * vector itself. For example, it might give information as to the memory
 * space of an address provided in the rest of the ####
 *
 *-------------------------------------------------------------------------
 * Memory Space Code offset and mask.
 */
#define MED$V_EV_FLAGS 			24
#define MED$M_EV_FLAGS 			(0xff << MED$V_EV_FLAGS)
/* Diagnostic Name Code offset and mask. */
#define MED$V_EV_DIAG_NAME_CODE		16
#define MED$M_EV_DIAG_NAME_CODE		(0xff << MED$V_EV_DIAG_NAME_CODE) 
/* Failure Point offset and mask. */
#define MED$V_EV_FAILURE_POINT 		8
#define MED$M_EV_FAILURE_POINT		(0xff << MED$V_EV_FAILURE_POINT) 
/* Detailed error code offset and mask.  */
#define MED$V_EV_ERROR_CODE 		0
#define MED$M_EV_ERROR_CODE 		(0xff << MED$V_EV_ERROR_CODE) 
/*
 * Medulla Error Vector Flags. For each of these constants, there should
 * be a corresponding string below.
 *
 *	NB: There can be no more than 8 bits defined.
 *
 *	  7       6       5       4       3       2       1       0
 *    +-------+-------+-------+-------+-------+-------+-------+-------+
 *    | New   | Non-  | Don't |    Compare    |        Address        |
 *    | Format| Diag  | Store |     size      |         space         |
 *    +-------+-------+-------+-------+-------+-------+-------+-------+
 *
 *
 * Address Space: 2 bits. Default should not be NO_ADDR since that would
 *   force no address information to be printed.
 */
#define MED$V_EVFL_ADDR_SPACE 		(0 + MED$V_EV_FLAGS) 
#define MED$M_EVFL_ADDR_SPACE 		(0x07 << MED$V_EVFL_ADDR_SPACE) 
#define   MED$K_EVFL_PCI_MEM_SPACE	(1 << MED$V_EVFL_ADDR_SPACE) 
#define   MED$K_EVFL_PCI_IO_SPACE 	(2 << MED$V_EVFL_ADDR_SPACE) 
#define   MED$K_EVFL_PCI_CONFIG_SPACE 	(3 << MED$V_EVFL_ADDR_SPACE) 
#define   MED$K_EVFL_PHYS_ADDR 		(4 << MED$V_EVFL_ADDR_SPACE) 
#define   MED$K_EVFL_NO_ADDR 		(5 << MED$V_EVFL_ADDR_SPACE) 
/* 
 * Compare Size: 2 bits. Default size should be QUAD, so it should be = 0.
 */
#define MED$V_EVFL_SIZE 		(3 + MED$V_EV_FLAGS) 
#define MED$M_EVFL_SIZE 		(0x03 << MED$V_EVFL_SIZE)
#define   MED$K_EVFL_SIZE_QUAD		(0 << MED$V_EVFL_SIZE) 
#define   MED$K_EVFL_SIZE_BYTE		(1 << MED$V_EVFL_SIZE) 
#define   MED$K_EVFL_SIZE_WORD		(2 << MED$V_EVFL_SIZE) 
#define   MED$K_EVFL_SIZE_LONG		(3 << MED$V_EVFL_SIZE) 
/*
 * Don't Store Flag -- this flag tells the error handler that the error
 *	information should not be stored in the NVRAM. By default, the
 *	information will be stored unless this bit is set.
 */
#define MED$V_EVFL_DONT_STORE		(5 + MED$V_EV_FLAGS) 
#define MED$M_EVFL_DONT_STORE		(0x01 << MED$V_EVFL_DONT_STORE) 
/*
 * Non-Diagnostic Flag -- this flag tells the error handler that the error
 *	information was generated by a routine which was not a diagnostic
 *	(so the error report should not include such things as the word
 *	"diagnostic" in the printout). 
 */
#define MED$V_EVFL_NON_DIAGNOSTIC	(6 + MED$V_EV_FLAGS) 
#define MED$M_EVFL_NON_DIAGNOSTIC	(0x01 << MED$V_EVFL_NON_DIAGNOSTIC) 
/*
 * New Format Flag -- this is temporary until all diags use new error 
 *    reporting strategy. Delete the setting of this bit in the 
 *    FORM_ERROR_VECTOR macro definition below when this has been done.
 */
#define MED$V_EVFL_NEW_FORMAT 		(7 + MED$V_EV_FLAGS) 
#define MED$M_EVFL_NEW_FORMAT 		(0x01 << MED$V_EVFL_NEW_FORMAT) 

/*---------------------------------------------------------------------------
 * Medulla Diagnostic Name Codes (DNC). For each of these constants, there
 * should be a corresponding string below. These codes do not necessarily
 * have to be diagnostics, they could be console code/utilities as well. 
 *
 * !!! NB: Each of these numbers must be unique !!!
 *
 *---------------------------------------------------------------------------*/
#define MED$K_DNC_UNKNOWN 		0
#define MED$K_DNC_FLASH_DIAG 		1
#define MED$K_DNC_DISPLAY_DIAG 		2
#define MED$K_DNC_MOD_CONTROL_DIAG 	3
#define MED$K_DNC_MOD_CONFIG_DIAG 	4
#define MED$K_DNC_HEARTBEAT_DIAG 	5
#define MED$K_DNC_INTERVAL_TIMER_DIAG 	6
#define MED$K_DNC_ENET_LB_DIAG 		7
#define MED$K_DNC_ENET_CSR_DIAG 	8
#define MED$K_DNC_BCACHE_DIAG 		9
#define MED$K_DNC_UART_DIAG 		10
#define MED$K_DNC_DS1386_DIAG 		11
#define MED$K_DNC_ENET_ROM_DIAG 	12
#define MED$K_DNC_NCR810_DIAG 		13
#define MED$K_DNC_WDOG_DIAG 		14
#define MED$K_DNC_VCT_DIAG 		15
#define MED$K_DNC_VME_DIAG  		16 
#define MED$K_DNC_MEMECC_DRAM_DIAG 	17
#define MED$K_DNC_MEMTEST 		18
#define MED$K_DNC_MEMDIAG 		19
#define MED$K_DNC_NCR810_CONFIG		20
#define MED$K_DNC_EXER			21
#define MED$K_DNC_VMESLAVE_DIAG		22
#define MED$K_DNC_SBLT_DIAG 		23
#define MED$K_DNC_MBLT_DIAG 		24
#define UNV$K_DNC_VME_DIAG 		25 

#define MED$K_DNC_TABLE_SIZE \
	(sizeof (medulla_diag_name_strings) / sizeof (struct String_record) )
/*
 * Diagnostic Name Code text strings
 */
#define MED$T_DNC_UNKNOWN "Unknown"
#define MED$T_DNC_FLASH_DIAG "Flash"
#define MED$T_DNC_DISPLAY_DIAG "LED Display"
#define MED$T_DNC_MOD_CONTROL_DIAG "Module Control Register"
#define MED$T_DNC_MOD_CONFIG_DIAG "Module Configuration Register"
#define MED$T_DNC_HEARTBEAT_DIAG "Heartbeat"
#define MED$T_DNC_INTERVAL_TIMER_DIAG "Interval Timer"
#define MED$T_DNC_ENET_LB_DIAG "Ethernet Loopback"
#define MED$T_DNC_ENET_CSR_DIAG "Ethernet CSR"
#define MED$T_DNC_BCACHE_DIAG "Backup Cache"
#define MED$T_DNC_UART_DIAG "Serial UAR/T"
#define MED$T_DNC_DS1386_DIAG "Dallas 1386"
#define MED$T_DNC_ENET_ROM_DIAG "Ethernet address ROM"
#define MED$T_DNC_NCR810_DIAG "NCR810 SCSI Chip"
#define MED$T_DNC_WDOG_DIAG "Watchdog Timer"
#define MED$T_DNC_VCT_DIAG "VME Cycle Tester"
#define MED$T_DNC_VME_DIAG "VIP Diag"
#define MED$T_DNC_MEMECC_DRAM_DIAG "Memory ECC"
#define MED$T_DNC_MEMTEST "Memory Test"
#define MED$T_DNC_MEMDIAG "Memory"
#define MED$T_DNC_NCR810_CONFIG "NCR810 Configuration"
#define MED$T_DNC_EXER "EXERciser"
#define MED$T_DNC_VMESLAVE_DIAG "VME Slave"
#define MED$T_DNC_SBLT_DIAG "SBLT Diag"
#define MED$T_DNC_MBLT_DIAG "MBLT Diag"
#define UNV$T_DNC_VME_DIAG "Universe Diag"
/*---------------------------------------------------------------------------
 * Medulla Detailed Error Codes. For each of these constants, there should
 * be a corresponding string below.
 *
 * !!! NB: Each of these numbers must be unique !!!
 *
 *---------------------------------------------------------------------------*/
#define MED$K_DEC_UNKNOWN 0              /* Unknown error code.              */
#define MED$K_DEC_DATA_COMPARE 1         /* Set SIZE flag for memory size.   */
#define MED$K_DEC_CHECKSUM_MISCOMPARE		2
#define MED$K_DEC_BIT_STUCK_LOW			3
#define MED$K_DEC_BIT_STUCK_HIGH		4
#define MED$K_DEC_INIT_ERROR			5
#define MED$K_DEC_DEV_NOT_FOUND			6
#define MED$K_DEC_INT_VEC_NOT_CLEARED		7
#define MED$K_DEC_INT_VEC_NOT_SET		8
#define MED$K_DEC_ISR_INVOKED			9
#define MED$K_DEC_ISR_NOT_INVOKED		10
#define MED$K_DEC_TMR2_STAT_NOT_SET		11
#define MED$K_DEC_INV_TIMER_STATUS		12
#define MED$K_DEC_TOO_MANY_ISRS_INVOKED		13
#define MED$K_DEC_INC_NUM_ISRS_INVOKED		14
#define MED$K_DEC_INC_PKT_CNT			15
#define MED$K_DEC_INC_PKT_LEN			16
#define MED$K_DEC_BAD_CHIP_REV			17
#define MED$K_DEC_DEV_NOT_ENABLED		18
#define MED$K_DEC_MALLOC_FAILED			19
#define MED$K_DEC_VAL_OUT_OF_RANGE		20
#define MED$K_DEC_FILE_OPEN_FAILED		21
#define MED$K_DEC_FILE_READ_FAILED		22
#define MED$K_DEC_INT_NOT_ENABLED		23
#define MED$K_DEC_BAD_WDOG_LED			24
#define MED$K_DEC_RX_BUF_NOT_EMPTY		25
#define MED$K_DEC_RX_BUF_NOT_FILLING		26
#define MED$K_DEC_TX_BUF_NOT_AVAIL		27
#define MED$K_DEC_BAD_ALIGNMENT			28
#define MED$K_DEC_BLKSIZE_GT_LENGTH		29
#define MED$K_DEC_NO_BYTES_READ			30
#define MED$K_DEC_NO_BYTES_WRITTEN		31
#define MED$K_DEC_NOBYTES_MATCH			32
#define MED$K_DEC_TABLE_SIZE \
	(sizeof (medulla_error_strings) / sizeof (struct String_record) )
/*
 * Detailed Error Code text strings
 */
#define MED$T_DEC_UNKNOWN "Unknown"
#define MED$T_DEC_DATA_COMPARE "Data compare"
#define MED$T_DEC_CHECKSUM_MISCOMPARE "Checksum miscompare"
#define MED$T_DEC_BIT_STUCK_LOW "Bit stuck at 0"
#define MED$T_DEC_BIT_STUCK_HIGH "Bit stuck at 1"
#define MED$T_DEC_INIT_ERROR "Initialization Error"
#define MED$T_DEC_DEV_NOT_FOUND "Could not find device"
#define MED$T_DEC_INT_VEC_NOT_CLEARED "Interrupt vector not cleared"
#define MED$T_DEC_INT_VEC_NOT_SET "Interrupt vector not set"
#define MED$T_DEC_ISR_INVOKED "Interrupt occurred and should not have"
#define MED$T_DEC_ISR_NOT_INVOKED "Interrupt not invoked and should have been"
#define MED$T_DEC_TMR2_STAT_NOT_SET "TMR2 Status not set"
#define MED$T_DEC_INV_TIMER_STATUS "Invalid timer status"
#define MED$T_DEC_TOO_MANY_ISRS_INVOKED "Too many Interrupts occurred"
#define MED$T_DEC_INC_NUM_ISRS_INVOKED "Incorrect number of Interrupts occurred"
#define MED$T_DEC_INC_PKT_CNT "Incorrect packet count"
#define MED$T_DEC_INC_PKT_LEN "Incorrect packet length"
#define MED$T_DEC_BAD_CHIP_REV "Incorrect chip revision"
#define MED$T_DEC_DEV_NOT_ENABLED "Device not enabled"
#define MED$T_DEC_MALLOC_FAILED "Malloc failed"
#define MED$T_DEC_VAL_OUT_OF_RANGE "Value out of range"
#define MED$T_DEC_FILE_OPEN_FAILED "File open failed"
#define MED$T_DEC_FILE_READ_FAILED "File read failed"
#define MED$T_DEC_INT_NOT_ENABLED "Interrupts are not enabled"
#define MED$T_DEC_BAD_WDOG_LED "Bad Watchdog LED"
#define MED$T_DEC_RX_BUF_NOT_EMPTY "RX Buffer Can't be emptied"
#define MED$T_DEC_RX_BUF_NOT_FILLING "RX Buffer Not Filling"
#define MED$T_DEC_TX_BUF_NOT_AVAIL "TX Not Available"
#define MED$T_DEC_BAD_ALIGNMENT "Parameter is improperly aligned"
#define MED$T_DEC_BLKSIZE_GT_LENGTH "Block Size is greater than the Length"
#define MED$T_DEC_NO_BYTES_READ "No Bytes Read"
#define MED$T_DEC_NO_BYTES_WRITTEN "No Bytes Written"
#define MED$T_DEC_NOBYTES_MATCH "Number of Bytes Read and Written are Unequal"
/*
 * This macro takes care of formatting the error vector from the constituent
 * parts (detailed error code, flags, failure point in code, diag name) as
 * pictured above. 
 * 
 * Note that the flags do not need to be shifted since they are already in
 * the correct byte position. 
 * 
 *   ### For now, set the New Format flag until all diags use new error 
 *   ### reporting strategy. Delete the bit definition above when this 
 *   ### has been done. 
 */ 
#define FORM_ERROR_VECTOR(flags, name, fail_pt, error_code) \
	    (flags | MED$M_EVFL_NEW_FORMAT) | \
	    ((name) << MED$V_EV_DIAG_NAME_CODE) | \
	    ((fail_pt) << MED$V_EV_FAILURE_POINT) | \
	    ((error_code) << MED$V_EV_ERROR_CODE)
 
/*
 *  Medulla Error Log
 *
 *    This structure holds the error log information for console failures.
 */
struct Medulla_error_log 
{
   /*
    * The error vector.
    */
    unsigned int error_vector;
   /*
    * This address holds a pointer to the specific failure information for
    * the particular error held in 'error_vector'. For example, it might
    * hold the data compare information details such as expected, received,
    * address, etc. The format of the packet is dictated by the detailed
    * code.
    */
    int *failure_info;
    /*
     * This byte holds the value displayed on the LED.
     */
    char LED_value;
    /*
     * If there is any additional detail to the error, then this string will
     * hold the information.
     */
    char *additional_text;
};


/*---------------------------------------------------------------------------
 *
 * Medulla NVRAM Error Log information
 *
 *
 * Note: A single, complete error log entry consists of:
 *
 * 			Error_Header 
 *	 		Error_Block
 *
 *---------------------------------------------------------------------------
 */
struct error_header
 {
  unsigned char  version_id;
  unsigned char	 misc_flags;
  unsigned char  error_type;
  unsigned char  test_number;
  struct toy_date_time timestamp;
 };

#define MISC_FLAGS_SEEN_BIT 	1

struct sio_block
 {
  unsigned int error_vector;
  unsigned int pass_count;
  unsigned int reserved[6];
 };

struct sio_ext_block
 {
  unsigned int error_vector;
  unsigned int pass_count;
  unsigned int exp_data[2];
  unsigned int rec_data[2];
  unsigned int address[2];
 };

struct mchk_block 
 {
  unsigned int scb_vector;
  unsigned int mchk_type;
  unsigned int qw0 [2];
  unsigned int qw1 [2];
  unsigned int pc [2];
 };

struct unexp_block 
 {
  unsigned int scb_vector;
  unsigned int reserved;
  unsigned int pc0 [2];
  unsigned int pc1 [2];
  unsigned int pc2 [2];
 };

union error_block
 {
  struct sio_block     sio_blk;
  struct sio_ext_block sio_ext_blk;
  struct mchk_block    mchk_blk;
  struct unexp_block   unexp_blk;
 };

struct fault_cell
 {
  struct error_header error_hdr;
  union  error_block  error_blk;
 };

/*---------------------------------------------------------------------------
 *
 * Medulla NVRAM Error Log Miscellaneous Definitions 
 *
 * 1. Error_Header Definitions:
 *	- version_id
 *	- error_type
 *---------------------------------------------------------------------------
 */
/*
 * NOTE: MED$K_VERSION_ID must never be zero (0) -- this is a key to
 *	 indicate a 'valid' fault cell
 *
 */
#define	MED$K_VERSION_ID	1

#define MED$K_SIO_ERROR		1
#define MED$K_SIO_EXT_ERROR	2
#define MED$K_MCHK		3
#define MED$K_UNEXPECTED_INT	4

/*---------------------------------------------------------------------------
 *
 * 2. Error_Block Definitions:
 *	- mchk_type
 *---------------------------------------------------------------------------
 */
#define MED$K_MCHK_MEM		1
#define MED$K_MCHK_IOC		2
#define MED$K_MCHK_UNKNOWN	3

/*---------------------------------------------------------------------------
 *
 * 3. Error Log Buffer Definitions:
 *
 *---------------------------------------------------------------------------
 */
#define ERROR_LOG_BASE		0x8200
#define NO_FAULT_CELLS		65
#define BYTES_PER_FAULT_CELL	sizeof(struct fault_cell)
#define BYTES_PER_ERROR_HEADER	sizeof(struct error_header)
#define BYTES_PER_ERROR_BLOCK	sizeof(union  error_block)
/*
 * Note: "EL" is short for Error Log
 *
 */
#define EL_INIT_FLAG		(ERROR_LOG_BASE + 0)
#define EL_INIT_VALUE		(0xAABBCCDD)
#define EL_BUFFER_PTR		(ERROR_LOG_BASE + 4)
#define EL_ERROR_COUNT		(ERROR_LOG_BASE + 8)
#define EL_BUFFER_START		(ERROR_LOG_BASE + 0x100)
#define EL_BUFFER_LAST_CELL	(EL_BUFFER_START + ((NO_FAULT_CELLS-1)*BYTES_PER_FAULT_CELL))
 
