
%x ProcessRestOftheLine

%{
/*
 * $Author: slee $
 * $Revision: 1.6 $
 * $Id: hwmon_cfg.lex,v 1.6 2001/03/12 20:11:33 slee Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "listmgr.h"
#include "hwmon_cfg.h"
#include "hwmon_cfg.tab.h"

char *token_cpy( const char *str );
char shutdown_str[256];
char shutdown_str_i=0;
%}

BUS	bus
DEV	device
SNS	sensor
SHUT	shutdown

K_ADR 	address
K_MOD	module

S_FAN	fan_sensor
F_NOM	fan_nom
F_MIN	fan_min

S_THM	temp_sensor
S_MAX	temp_max
S_HYS	temp_hyst

S_VLT	volt_sensor
V_NOM	volt_nom
V_MAX	volt_max
V_MIN	volt_min

NUM	[0-9]+
ADDR	0x[0-9a-fA-F]+
NAME	[a-z][a-z0-9_\-\.]*
QUOTE	\".*\"
FLOAT	[0-9]*"."[0-9]+

%%

{BUS}	{ return TOK_BUS; }

{DEV}	{ return TOK_DEVICE; }
{K_ADR}	{ return TOK_ADDR_KEY; }
{K_MOD}	{ return TOK_MOD_KEY; }

{SNS}	{ return TOK_SENSOR; }

{SHUT}	{ 
	  BEGIN ProcessRestOftheLine;
	  shutdown_str_i = 0;
	  return TOK_SHUTDOWN;
	}

<ProcessRestOftheLine>. { shutdown_str[shutdown_str_i++] = *yytext; }
<ProcessRestOftheLine>\n { 
	  BEGIN 0;
	  shutdown_str[shutdown_str_i] = 0; 
	  yylval.str = shutdown_str; 
	  return TOK_OPTLINE; 
	}

{S_FAN}	{ return TOK_SENSOR_FAN; }
{F_NOM} { return TOK_FAN_NOM; }
{F_MIN}	{ return TOK_FAN_MIN; }


{S_VLT}	{ return TOK_SENSOR_VOLT; }
{V_NOM}	{ return TOK_VOLT_NOM; }
{V_MIN} { return TOK_VOLT_MIN; }
{V_MAX} { return TOK_VOLT_MAX; }

{S_THM}	{ return TOK_SENSOR_THERMAL; }
{S_MAX} { return TOK_THERM_MAX; }
{S_HYS}	{ return TOK_THERM_HYST; }



{FLOAT}	{
	    yylval.flt = atof( yytext );
	    return TOK_FLOAT;
	}

{NUM}	{
	    yylval.num = atoi( yytext );
	    return TOK_NUMBER;
	}

{ADDR}	{
	    sscanf( yytext, "0x%x", &yylval.num );
	    return TOK_ADDRESS;
	}

{NAME}|{QUOTE}	{
	    yylval.str = token_cpy( yytext );
//printf("Q%d\n", strlen(yylval.str));
//printf("%s\n", yylval.str);
	    return TOK_NAME;
	}

#.*$			/* eat up comments */
[ \t\n]+		/* eat up white space */

.	{ return yytext[0]; }

%%


/* Stuff to handle duplicating the input for string handling */
char *token_cpy( const char *str )
{
    char *S;
    size_t len = strlen( str ) + 1;

    S = malloc( len );

    if ( S==NULL )
    {
	fprintf( stderr, "Malloc failed on token copy of %d bytes\n", len );
	exit( -1 );
    }

    strncpy( S, str, len );
    return S;
}



