
/*****************************************************************************

       Copyright  1993, 1994 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/

/*
 * $Log: time.c,v $
 * Revision 1.15  2000/11/16 18:16:21  stig
 * General fixups for smoothing the go test
 *
 * Revision 1.14  2000/10/13 12:29:40  stig
 * fixed bug with sleeping
 *
 * Revision 1.13  2000/07/13 17:24:45  stig
 * Version bumped to 1.41pre1
 * BUG(S) FIXED:
 * BACKEND RELATED:
 *
 * Revision 1.11  2000/04/06 20:14:23  stig
 * Better sanity checking for CMOS date
 *
 * Revision 1.7  2000/01/30 23:38:03  stig
 * Diagnostics revision 1.2 for both UP1000 and UP2000
 * Including:
 * * SMP support (and Linux boot)
 * * Improved implementation of kernel-in-rom
 * * Improved implementation of flash firmware management
 * BUG(S) FIXED:
 * BACKEND RELATED:
 *
 * Revision 1.6  2000/01/21 15:53:50  stig
 * Misc small fixups in preparation for release 1.2
 * BUG(S) FIXED:
 * BACKEND RELATED:
 *
 * Revision 1.4  1999/09/01 19:18:31  stig
 * Completed first pass at integrated test.  Implemented changes required to
 * make that possible.
 *
 * Revision 1.3  1999/07/26 07:42:28  stig
 * Numerous amendments and bugfixes in preparation for first release version
 *
 * Revision 1.2  1999/07/12 13:36:35  stig
 * Added API copyright header
 *
 * Revision 1.1  1999/03/29 21:27:53  stig
 * Folded in the debug monitor sources, introduced mechanism for mulit-platform
 * manufacturing diagnostics.
 *
 * Revision 1.1.1.1  1998/12/29 21:36:12  paradis
 * Initial CVS checkin
 *
 * Revision 1.7  1996/07/11  14:29:27  fdh
 * Added msleep().
 *
 * Revision 1.6  1995/12/06  19:36:47  cruz
 * Fixed localtime() to match the code change in time().
 *
 * Revision 1.5  1995/10/26  23:45:29  cruz
 * Added casting and changed the name of a variable
 *
 * Revision 1.4  1995/10/12  21:30:05  fdh
 * Added casts to pass proper datatypes.
 *
 * Revision 1.3  1995/09/02  07:04:17  fdh
 * Added extern declaration.
 *
 * Revision 1.2  1995/09/02  06:27:16  fdh
 * Added sleep() and usleep().
 *
 * Revision 1.1  1995/08/25  20:35:39  fdh
 * Initial revision
 *
 */

#include "lib.h"
#include "uilib.h"
#include "cmos_rtc.h"
#include "time.h"


/* This variable is updated on every timer periodic interrupt -
 * interrupts must be enabled for any effect */

volatile unsigned long jiffies;


const char MonthsOfYear[] = {
        'B','A','D','\0',
        'J','a','n','\0','F','e','b','\0','M','a','r','\0','A','p','r','\0',
        'M','a','y','\0','J','u','n','\0','J','u','l','\0','A','u','g','\0',
        'S','e','p','\0','O','c','t','\0','N','o','v','\0','D','e','c','\0'
};

const char DaysOfWeek[] = {
        'B','A','D','\0',
        'S','u','n','\0','M','o','n','\0','T','u','e','\0','W','e','d','\0',
        'T','h','u','\0','F','r','i','\0','S','a','t','\0'
};


/* return seconds since Jan 1, 1970 */
time_t gettime(void)
{
  return(time(NULL));
}

struct tm *localtime(const time_t *tp)
{
  static struct tm tms;  /* Note that this MUST be static */
  time_t cvt_time = *tp;

  tms.tm_sec  = cvt_time % 60;
  tms.tm_min  = (cvt_time / 60) % 60;
  tms.tm_hour = (cvt_time / (60 * 60)) % 24;
  tms.tm_mday = ((cvt_time / (24 * 60 * 60)) % 31) + 1;
  tms.tm_mon  = ((cvt_time / (31 * 24 * 60 * 60)) % 12) + 1;
  tms.tm_year = (cvt_time / (12 * 31 * 24 * 60 * 60));
  tms.tm_year += 70;
  return &tms;
}

void usleep(unsigned long usecs)
{
  /* wait_cycles takes a 32-bit argument, be aware of overflow here */
  wait_cycles( (usecs*1000000UL) / primary_impure->CYCLE_CNT );
}

void msleep(unsigned long ms)
{
  while ( ms-- )	usleep( 1000 );
}

void sleep(unsigned int seconds)
{
  while ( seconds-- )	usleep( 1000000 );
}


/* Put a datestamp into the char buffer supplied (nb user allocates buffer) */

#define FAILBUFSIZE 80

DBM_STATUS datestamp( String S )
{
    RTC_t t;
    DBM_STATUS sval=STATUS_SUCCESS;
    char failbuf[FAILBUFSIZE];

    memset( failbuf, 0, FAILBUFSIZE );

    sval = cmosready();
    if ( sval != STATUS_SUCCESS )	
    {
	sprintf_dbm( S, "[Clock not functional]" );
	return STATUS_FAILURE;
    }
   
    RTC_Get( &t );

    /* Check month */
    if( t.month < 1 || t.month > 12)
    {
	sval=STATUS_FAILURE;
	t.month = 0;
	strcat( failbuf, "Month " );
    }

    /* Check day */
    if( t.daymth < 1 || t.daymth > 31)
    {
	sval=STATUS_FAILURE;
	strcat( failbuf, "Day-of-month " );
    }

    if( t.daywk < 1 || t.daywk > 7 )
    {
	sval=STATUS_FAILURE;
	t.daywk = 0;
	strcat( failbuf, "Day-of-week " );
    }

    /* Check hour */
    if( t.hours > 23)
    {
	sval=STATUS_FAILURE;
	strcat( failbuf, "Hour " );
    }

    /* Check minutes */
    if( t.mins >59)
    {
	sval=STATUS_FAILURE;
	strcat( failbuf, "Minutes " );
    }

    /* Check seconds */
    if( t.secs >59)
    {
	sval=STATUS_FAILURE;
	strcat( failbuf, "Seconds " );
    }

    /* Check year (already tested for writing the CMOS epoch */
    if ( (t.year != EPOCH_ARC) && (t.year != EPOCH_SRM) )
    /* Guess whether the clock is in ARC or SRM year format */
    if (t.year < 20 || t.year > 80) 	/* gives lifetime to 2032 (SRM) */
    {	
	sval=STATUS_FAILURE;
	strcat( failbuf, "Year(Epoch) " );
    }
    
    if ( sval == STATUS_SUCCESS )
    {
	sprintf_dbm( S, "%d:%02d:%02d %d %s %d", t.hours, t.mins, t.secs,
		 t.daymth, MonthsOfYear + t.month*4, t.year + rtc_epoch );
    }
    else
    {
	sprintf_dbm( S, "BAD %d:%02d:%02d %d %s %d",
		t.hours, t.mins, t.secs, t.daymth, MonthsOfYear + t.month*4,
		t.year + rtc_epoch );
	mobo_logf( LOG_CRIT "Corrupted system date: %s failing on: %s\n",
		S, failbuf );
    }

    return sval;
}



void system_datestamp( const String prefix )
{
    char tmbuf[20];
    DBM_STATUS sval;
    
    sval = datestamp( tmbuf );
    mobo_logf( LOG_INFO "%s: at %s (system date is %s)\n", prefix, tmbuf,
		sval == STATUS_SUCCESS ? "valid" : "corrupted" );
}


