#ifndef	DIAGS__CONSOLE_H_LOADED
#define	DIAGS__CONSOLE_H_LOADED
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* Alpha Diagnostics Console IO Framework */
/* Theory: we have high-level and low-level layers of console IO.
 * The high level layers deal with groupings of IO channels for 
 * input and output.  The low-level layers refer to a single input, output
 * or bidirectional channel alone. 
 *
 * For serial port downloads, use the low-level implementation.
 * For everything else, use the high-level implementation
 */


/*----------------------------------------------------------------------*/
/* Lowest level of abstraction in console IO */

typedef enum {	DEV_SROM=1<<0,
		DEV_COM1=1<<1,
		DEV_COM2=1<<2,
		DEV_COM3=1<<3,
		DEV_COM4=1<<4,
		DEV_LPT1=1<<5,
		DEV_LPT2=1<<6,
		DEV_VGA=1<<7,
		DEV_KBD=1<<8,
		DEV_ROM=1<<9,	/* persistent record in NVRAM sector */
		DEV_NULL=0,	/* /dev/null device */
		DEV_ERRDEV=-1	/* No device */
} io_dev;

DBM_STATUS io_dev_init( io_dev );	/* setup - returns OK if already done */
void io_dev_fini( io_dev );		/* shutdown - some devs need this */

void simple_putstr( String S, io_dev d );
DBM_STATUS io_dev_putc( io_dev d, int c );
int io_dev_getc( io_dev d );		/* times out if not ready */
int io_dev_getc_t( io_dev d, int msec );

/* Bring a device offline and ensure that log and tty discontinue using it */
void io_dev_shutdown( io_dev d );

/*----------------------------------------------------------------------*/
/* Mid-level abstraction in console IO implementation */

typedef enum {	GRP_SROM=1<<0,
		GRP_COM1=1<<1,
		GRP_COM2=1<<2,
		GRP_COM3=1<<3,
		GRP_COM4=1<<4,
		GRP_LPT1=1<<5,	/* only has meaning for log stream */
		GRP_LPT2=1<<6,	/* only has meaning for log stream */
		GRP_LOCAL=1<<7,	/* local screen and keyboard */
		GRP_ROM=1<<8,	/* log stream output to NVRAM log sector */
		GRP_NONE=0, 	/* no IO routing (nb must be zero for bitops) */
		GRP_ERRGRP=-1	/* Error return value - no matching group */
} io_grp;


/* Convert a grouping into its input and output IO components */
io_dev grp_output( const io_grp G );
io_dev grp_input( const io_grp G );

DBM_STATUS setty( io_grp );		/* does any setup required */
io_grp getty( void );

DBM_STATUS setlog( unsigned );
io_grp getlog( void );


/*----------------------------------------------------------------------*/
/* Highest-level abstraction in console IO implementation */

void PutChar( char c );
void LogChar( char c );

int GetChar_t( int msec );	/* timeout in msec - returns -1 if nothing */
int GetChar( void );

#endif 		/* DIAGS__CONSOLE_H_LOADED */
