#ifndef __KBD_H_LOADED
#define __KBD_H_LOADED
/*****************************************************************************

       Copyright  1993, 1994 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the copyright notice and this permission notice appear in all copies
of software and supporting documentation, and that the name of Digital not
be used in advertising or publicity pertaining to distribution of the software
without specific, written prior permission. Digital grants this permission
provided that you prominently mark, as not part of the original, any
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees
with regard to this software, including all implied warranties of fitness for
a particular purpose and merchantability, and makes no representations
regarding the use of, or the results of the use of, the software and
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at
your own risk.

******************************************************************************/

/* Moved in here from lib/kbd.c by Stig Telfer, API, enabling me to share low-
 * level access routines for a new IRQ test */

/* Externally visible function prototypes for low-level access */

extern DBM_STATUS kbd_init(void );
extern DBM_STATUS mouse_init(void );

extern int kbd_locked(void );
extern void kbd_leds(void );
extern void kbd_ctl_cmd(int c);
extern void kbd_ctl_output(int c);
extern int kbd_input(void );
extern int kbd_output(int c);
extern int kbd_output_noverify(int c);
extern int kbd_charav(void );
extern int kbd_getc(void );

#ifdef NOT_IN_USE
extern void kbd_reset_state(void );
#endif

/* Programmable Interrupt Controller (PIC) */
#define ICW1                    0x20
#define OCW1                    0x21
#define KCM     0x40
#define KKSW    0x80
#define CMD     0x64
#define RDI     0xC0

#define KBD_INT_ENABLE          0x02    /* 0 = enable */

/* 82C106 */
#define KBD_STAT        0x64
#define KBD_CMD         0x64
#define KBD_DATA        0x60

/* status */
#define KBD_OBF         0x01
#define KBD_IBF         0x02
#define KBD_KBEN        0x10
#define KBD_MS_OBF      0x20
#define KBD_GTO         0x40
#define KBD_PERR        0x80

/* mode */
#define KBD_EKI         0x01
#define KBD_EMI         0x02
#define KBD_SYS         0x04
#define KBD_DKB         0x10
#define KBD_DMS         0x20
#define KBD_KCC         0x40

/* kbd ctl */
#define KBD_CTL_RDMODE  0x20
#define KBD_CTL_WRMODE  0x60
#define KBD_CTL_MOUSEEN	0xA8
#define KBD_CTL_MTEST	0xA9
#define KBD_CTL_TEST1   0xAA
#define KBD_CTL_TEST1_PASS   0x55

#define KBD_CTL_TEST2   0xAB
#define KBD_CTL_DISABLE 0xAD
#define KBD_CTL_ENABLE  0xAE
#define KBD_CTL_RDOUT   0xD0
#define KBD_CTL_WROUT   0xD1
#define KBD_CTL_WRKOBUF 0xD2		/* Write keyb output buf, raise int */
#define KBD_CTL_WRMOBUF 0xD3		/* Write mouse output buf, raise int */
#define KBD_CTL_WRMOUSE 0xD4
#define KBD_CTL_RDPORT  0xC0

/* kbd */
#define KBD_ID		0xF2
#define KBD_RESET       0xFF
#define KBD_MAKEBREAK   0xFC
#define KBD_SETLEDS     0xED
#define KBD_SELECTCODE  0xF0
#define KBD_ENABLE      0xF4
#define KBD_ACK         0xFA
#define KBD_RESEND      0xFE
#define KBD_DEFAULTS    0xF6

/* mouse - preceded by a write of KBD_CTL_WRMOUSE to KBD_CMD */
#define MOUSE_SCALE11	0xE6
#define MOUSE_SCALE21	0xE7
#define MOUSE_RES	0xE8
#define MOUSE_INFO	0xE9
#define MOUSE_ID	0xF2
#define MOUSE_SAMPLE	0xF3
#define MOUSE_EN	0xF4
#define MOUSE_RESET	0xFF


/* outport */
#define HDLED           0x0002

/* prefix */
#define F0SEEN          0x0001
#define E0SEEN          0x0002

/* shift */
#define LFLAG           0x0001
#define RFLAG           0x0002


#endif		/* __KBD_H_LOADED */
