/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* Memory map for the manufacturing diagnostics */
/* $Id: memory.h,v 1.14 2001/02/28 16:58:28 stig Exp $
 * $Author: stig $
 * $Version$
 */

#ifndef DIAGS__MEMORY_H__LOADED
#define DIAGS__MEMORY_H__LOADED

/* Defining this will cause diags to emit page faults making tracing easier */
#undef DEBUG_MEM

#define KSEG43		0xFFFFFC0000000000
#define KSEG48		0xFFFF800000000000

#ifdef DEBUG_MEM
#define DBM_SUPER	0
#else
#define DBM_SUPER	KSEG48
#endif

#define LINUX_SUPER     KSEG43


/* Fixed addresses used by Diags and PALcode */
/* Note: these are not desirable features and should be kept to a minimum */
#define RAW_PAL_DATA	0x001000	/* Private PALcode data */
#define RAW_HWRPB	0x002000	/* DBM's HWRPB */
#define RAW_ENTRY	0x010000	/* compressed code entry */
#define RAW_MAIN	0x080000	/* main body at 512K */
#define RAW_MEM_MAP	0x100000	/* Memory map (256K for 2GB) */
#define STACK_MEGS	2
#define RAW_STACK	0x200000	/* Stack (counting downwards) */
#define RAW_OSFPAL	0x200000	/* Linux kernel OSF PALcode */
#define RAW_KRNL	0x300000	/* Linux kernel base */
#define RAW_DLD		0x800000	/* Applet Download buffer */

/* Equivalents of the above with Diags superpage added */
#define DIAGS_PAL_DATA	(DBM_SUPER | RAW_PAL_DATA )
#define DIAGS_HWRPB	(DBM_SUPER | RAW_HWRPB )
#define DIAGS_ENTRY	(DBM_SUPER | RAW_ENTRY )
#define DIAGS_MAIN	(DBM_SUPER | RAW_MAIN )
#define DIAGS_MEM_MAP	(DBM_SUPER | RAW_MEM_MAP )
#define DIAGS_STACK	(DBM_SUPER | RAW_STACK )
#define DIAGS_OSFPAL	(DBM_SUPER | RAW_OSFPAL )
#define DIAGS_KRNL	(DBM_SUPER | RAW_KRNL )
#define DIAGS_DLD	(DBM_SUPER | RAW_DLD )


/* Here we collect miscellaneous assumptions about image sizes etc */
#define PAL_PAGES		4		/* PALcode no more than 32K */
#define PAL_DATA_PAGES  	1		/* PAL data in 1 page */
#define HWRPB_PAGES		1		/* HWRPB = 1 page or less */
#define HWRPB_CPU_PAGES		1		/* HWRPB CPU data */
#define DIAGS_STACK_PAGES	8		/* 64K stack (PER CPU) */
#define POOL_DFLT_PAGES		10		/* Heap starting size */
#define LINUX_KRNL_PAGES	512		/* Kernel rgn max size = 4MB */
#define APPLET_PAGES		8		/* 64K max applet size */
#define MAX_DMA_PFN		2048		/* 16MB is top of ISA DMA win */


/*------------------------------------------------------------------------*/
/* Page management functions: */

/* The basic unit of memory in diags is an 8K page */
#define PAGE_SHIFT	13
#define PAGE_SIZE	(1UL<<PAGE_SHIFT)

/* Some useful macros for converting between addresses and page numbers */
/* In these macros, p=pfn, a=addr, s=superpage in use */
#define PFN2ADDR(p,s)	((void *) ( (s) | ((unsigned long)(p) << PAGE_SHIFT) ))
#define ADDR2PFN(a,s)	( ((uint64)(a) & ~((uint64)(s))) >> PAGE_SHIFT )
#define PFNCOUNT( n )	( ( (n) + PAGE_SIZE - 1 ) >> PAGE_SHIFT )


#if LANGUAGE_C		/* NB we're included by asm and linkers too */
/* Memory page usage tracking */
enum mem_page_usage {
        FREE_PAGE = 0,
        ALLOCATED_PAGE = 1,
        TEMPORARY_PAGE = 2,

	/* Extra meanings unofficially added by API */
	HEAP_PAGE = 100,	/* Page is being used for heap */
	BOOTMEM_PAGE = 101	/* Page is being used for DBLX bootmem */
};

/* Request a number of contiguous pages, returning base PFN (or -1) */
extern int page_alloc( int n_pfns, uint8 usage );

/* Mark a particular region with a given usage in the memory map */
extern void page_mark_range( int base_pfn, int n_pfns, uint8 usage );

/* Find the largest possible contiguous allocation of memory */
/* Useful for the memory tests */
void page_max_free( int *base_pfn, int *n_pfns );

#endif			/* LANGUAGE_C */



/*------------------------------------------------------------------------*/
/* Heap management functions: */

#if LANGUAGE_C		/* NB we're included by asm and linkers too */

/* Standard allocation and free functions */
extern void *malloc( size_t size );
extern void *realloc( void *ptr, size_t size );
extern void free( void *ptr );


/* Paranoia: Check for heap consistency */
extern void heap_valid( void );

/* Debug: dump our allocated and free blocks */
extern void heap_dump( void );

#endif			/* LANGUAGE_C */



/*------------------------------------------------------------------------*/
/* Memory management in general */

#if LANGUAGE_C		/* NB we're included by asm and linkers too */

/* High-level routine, intended to be called once during initialisation,
 * which configures the page usage data structures and sets up a heap.
 */
extern void mem_init(void);

#endif			/* LANGUAGE_C */



/* PCI Memory and IO allocations */
#define PCIMEMBASE	(1UL << 30)		/* 1 gbyte */
#define PCIIOBASE	0x1000


#endif /* DIAGS__MEMORY_H__LOADED */
