/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* SMP management interface */
/* Begun by Stig Telfer, Alpha Processor Inc, 30 June 1999 */

#ifndef SMP_H__LOADED
#define SMP_H__LOADED


#ifndef MAX_CPUS		/* may be overridden in platform specifics */
#define MAX_CPUS 2
#endif


/* must be a 32-bit quantity because the atomic_tas uses ldl_l instructions */
typedef volatile unsigned smp_mask;
typedef smp_mask smp_mutex;

/* Mutex concurrency control */
#define M_FREE 0
void smp_acquire( smp_mutex * );
void smp_release( smp_mutex * );

#define NOT_DETERMINED -1
extern volatile int smp_primary_cpu;
extern smp_mask smp_all_cpus;
extern volatile unsigned char smp_online_count;

/* Register this processor to the SMP interface.  Returns TRUE if the 
 * processor is a new registration otherwise FALSE if its going round again. */
BOOLEAN smp_register( void );

/* Return the number of CPUs started in the system */
int smp_ncpus( void );

/* Return my logical numbering (All CPUs enumerated from 0) */
int smp_myid( void );

/* Return the physical processor number */
int smp_phys_id( void );

/* Is this processor the primary CPU? */
BOOLEAN smp_primary( void );


void smp_sync( void );
DBM_STATUS smp_exec( Action_t );

/* called by each secondary - this is their event loop */
void smp_corral( void );		


/* Inter-processor interrupt signalling and management */

typedef enum {
	IPI_NULL,		/* The IPI identity operation */
	IPI_PING,		/* Request response via IPI (arg=source cpu) */
	IPI_PONG,		/* Response to the above */
	IPI_EXEC		/* Execute function (arg=func ptr) */
} IPI_t;

DBM_STATUS smp_ipi( unsigned cpu, IPI_t type, uint64 arg );

extern volatile unsigned long smp_ipi_pingpongs;
void smp_ipi_handler( void );	/* IPI interrupt handler */


#endif					/* SMP_H_LOADED */
