/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* PC-compatibility IO space access routines */

#include <alpha/regdef.h>		/* symbolic register names */



/*----------------------------------------------------------------------*/
/* basic address forming stuff */

/* pcicfgaddr - make a PCI-bus address to be written for PCI config CSRs */
/* uint32 pcicfgaddr(bus, dev, func, offset ) */
	.data
addrbaseval:
	.long	0x8000000		/* msb = config cycle enable */

	.text
	.align	3
	.globl	pcicfgaddr
	.ent	pcicfgaddr
pcicfgaddr:
	lda	t0, addrbaseval(gp)	/* base value for cfg addr */
	ldl	t1, 0(t0)

	sll	a0, 16, a0		/* shift up to right bitfield posns */
	sll	a1, 11, a1
	sll	a2, 8, a2
	/* sll	a3, 2, a3 */		/* 2-bit offset pre-computed */

	bis	a0, t1, t1		/* OR everything together for addr */
	bis	a1, t1, t1
	bis	a2, t1, t1
	bis	a3, t1, v0		/* return value in v0 */

	ret
	.end	pcicfgaddr

	
/* ioaddr - construct an EV6->PC-compatibility IO space address */
/* uint64 ioaddr(uint16 addr) */

	.text
	.align	3
	.globl	ioaddr
	.ent	ioaddr
ioaddr:
        ldah    t0, 0x8(zero)
        lda     t0, 0x01fc(t0)
        sll     t0, 24, t0
        lda     t1, -1(zero)
        sll     t1, 47, t1
        bis     t0, t1, t0
        bis	t0, a0, a0		/* return value in a0 */

	ret
	.end	ioaddr



/*----------------------------------------------------------------------*/
/* reads and writes to PC-compatibility 16-bit IO space */

/* inportb - read a byte from 16-bit PC-compatibility IO space */
/* uint8 inportb(uint16 addr) */

	.text
	.align	3
	.globl	inportb
	.ent	inportb
inportb:
	bis	ra, ra, t8		/* save in unused scratch reg */
	bsr	ra, ioaddr			/* build full IO address */
	bis	t8, t8, ra

	ldbu	v0, 0(a0)		/* load zero-extended byte */
	ret	(ra)
	.end	inportb



/* inportw - read a 16-bit word from 16-bit PC-compatibility IO space */
/* uint16 inportw(uint16 addr) */

	.text
	.align	3
	.globl	inportw
	.ent	inportw
inportw:
	bis	ra, ra, t8		/* save in unused scratch reg */
	bsr	ra, ioaddr			/* build full IO address */
	bis	t8, t8, ra

	ldwu	v0, 0(a0)		/* load zero-extended word */
	ret	(ra)
	.end	inportw



/* inportl - read a 32-bit long from 16-bit PC-compatibility IO space */
/* int32 inportl(uint16 addr) */

	.text
	.align	3
	.globl	inportl
	.ent	inportl
inportl:
	bis	ra, ra, t8		/* save in unused scratch reg */
	bsr	ra, ioaddr			/* build full IO address */
	bis	t8, t8, ra

	ldl	v0, 0(a0)		/* load zero-extended word */
	ret	(ra)
	.end	inportl



/* outportb - write a byte to 8-bit PC-compatibility IO space */
/* void outportb(uint16 addr, uint8 wval) */

	.text
	.align	3
	.globl	outportb
	.ent	outportb
outportb:
	bis	ra, ra, t8		/* form EV6 bus address */
	bsr	ra, ioaddr
	bis	t8, t8, ra

	stb	a1, 0(a0)
	ret	(ra)
	.end	outportb


/* outportw - write a byte to 8-bit PC-compatibility IO space */
/* void outportw(uint16 addr, uint16 wval) */

	.text
	.align	3
	.globl	outportw
	.ent	outportw
outportw:
	bis	ra, ra, t8		/* form EV6 bus address */
	bsr	ra, ioaddr
	bis	t8, t8, ra

	stw	a1, 0(a0)
	ret	(ra)
	.end	outportw


/* outportl - write a byte to 8-bit PC-compatibility IO space */
/* void outportl(uint16 addr, uint32 wval) */

	.text
	.align	3
	.globl	outportl
	.ent	outportl
outportl:
	bis	ra, ra, t8		/* form EV6 bus address */
	bsr	ra, ioaddr
	bis	t8, t8, ra

	stl	a1, 0(a0)
	ret	(ra)
	.end	outportl




/* outled - put a byte out to the LED port */
/* void outled( uint8 val ) */

	.text
	.align	3
	.globl	outled
	.ent	outled
outled:
        bis     a0, zero, a1            /* output LED value */
        lda     a0, 0x80(zero)          /* output LED port */

        bis     ra, zero, t7            /* a reg that isn't used by outportb */
        bsr     ra, outportb            /* outportb now does the work */

        bis     t7, zero, ra
        ret     (ra)
        .end    outled


