#ifndef DIAGS__NAUTILUS_H__LOADED
#define DIAGS__NAUTILUS_H__LOADED
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* (c) 1999 Alpha Processor, Inc, begun 19 April 1999 by Stig Telfer */
/* Details and definitions for the Nautilus (UP1000) platform */


#define MAX_CPUS 1

/*------------------------------------------------------------------------*/
/* PCI device IDs */
#define PCI_AMD_IG	0	/* bridge to PCI bus */
#define PCI_AMD_IG2	1	/* bridge to AGP bus */
#define PCI_ALI_ISA	7
#define PCI_ALI_IDE	16
#define PCI_ALI_PMU	17
#define PCI_ALI_USB	20

#define PCI_SLOT1	8
#define PCI_SLOT2	9
#define PCI_SLOT3	10
#define PCI_SLOT4	11

#define AGP_SLOT1	5



/* Global standard definitions */

#define PLAT_ISAID	PCI_ALI_ISA
#define PLAT_IDEID	PCI_ALI_IDE
#define PLAT_PMUID	PCI_ALI_PMU
#define PLAT_USBID	PCI_ALI_USB


/*------------------------------------------------------------------------*/
/* I2C bus configuration */

#define NAUT_I2C_MUX		0x74
#define NAUT_I2C_LED		0x78
#define NAUT_I2C_SMD		0x58
#define NAUT_I2C_SDRAMCLK	0xD2
#define NAUT_I2C_LM75		0x90
#define NAUT_I2C_SLOTB_EPROM	0xA0
#define NAUT_I2C_DIMM0		0xA0
#define NAUT_I2C_DIMM1		0xA2
#define NAUT_I2C_DIMM2		0xA4

#define TEMP_MAX_CPU	60
#define TEMP_HYST_CPU	55
#define TEMP_MAX_MOBO	45
#define TEMP_HYST_MOBO	40


/*------------------------------------------------------------------------*/
#endif 		/*  DIAGS__NAUTILUS_H__LOADED  */
