/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* ALI M1543C Southbridge access routines */
/* (c) 1999 Alpha Processor Inc */
/* Begun 11 Feb 1999 by Stig Telfer, API */

/*----------------------------------------------------------------------*/
/* Registers and definitions */

/* PCI-ISA bridge */

#define ISA_VENDOR	0x00
#define ISA_DEVICE	0x02
#define ISA_CMD		0x04
#define ISA_STATUS	0x06
#define ISA_REV		0x08
#define ISA_CCODE	0x09

#define ISA_HT		0x0E

#define ISA_SVID	0x2C
#define ISA_SDID	0x2E

#define ISA_PIC		0x40
#define ISA_IORC	0x41
#define ISA_ISAC1	0x42
#define ISA_ISAC2	0x43
#define ISA_IDENR1	0x44
#define ISA_PIPM	0x45

#define ISA_BCSC	0x47
#define ISA_PIRT1	0x48
#define ISA_PIRT2	0x49
#define ISA_PIRT3	0x4A
#define ISA_PIRT4	0x4B
#define ISA_PILET	0x4C

#define ISA_IOPW1	0x50
#define ISA_IOPW2	0x52
#define ISA_HSSB	0x54
#define ISA_PCSAD	0x55
#define ISA_IDEIC	0x58
#define ISA_GPIS	0x59
#define ISA_GPOS	0x5A
#define ISA_DMDC	0x5C
#define ISA_SMCC1	0x5E
#define ISA_SMCC2	0x5F

#define ISA_RAM		0x6D
#define ISA_ISPSS	0x6E
#define ISA_ISPSD	0x6F
#define ISA_SIRQCR	0x70
#define ISA_DDMAS	0x71
#define ISA_USBIDS	0x72
#define ISA_DDMABA	0x73
#define ISA_USBIR	0x74
#define ISA_IDENR2	0x75
#define ISA_SCIIR	0x76
#define ISA_SMBIR	0x77
#define ISA_AGPIS	0x78

#define ISA_MAPR	0x7C


/* IDE Interface */

#define IDE_VENDOR	0x00
#define IDE_DEVICE	0x02
#define IDE_CMD		0x04
#define IDE_STATUS	0x06
#define IDE_REV		0x08
#define IDE_CCODE	0x09

#define IDE_LATENCY	0x0D
#define IDE_HT		0x0E

#define IDE_BA1		0x10
#define IDE_BA2		0x14
#define IDE_BA3		0x18
#define IDE_BA4		0x1C
#define IDE_BA5		0x20

#define IDE_SVID	0x2C
#define IDE_SDID	0x2E

#define IDE_IL		0x3C
#define IDE_IP		0x3D
#define IDE_MG		0x3E
#define IDE_ML		0x3F

#define IDE_CCA1	0x43

#define IDE_UT		0x4B

#define IDE_CCA2	0x4D

#define IDE_CCA3	0x50
#define IDE_RAT		0x51
#define IDE_FCS		0x52
#define IDE_CDRC	0x53
#define IDE_FTHP	0x54
#define IDE_FTHS	0x55
#define IDE_UDMAP	0x56
#define IDE_UDMAS	0x57
#define IDE_PCAS	0x58
#define IDE_PCCB	0x59
#define IDE_PCDT0	0x5A
#define IDE_PCDT1	0x5B
#define IDE_SCAS	0x5C
#define IDE_SCCB	0x5D
#define IDE_SCDT0	0x5E
#define IDE_SCDT1	0x5F
#define IDE_DEBUG	0x60

#define IDE_IDEC	0x78


/* M7101 power management unit register file */

#define PMU_VENDOR	0x00
#define PMU_DEVICE	0x02
#define PMU_CMD		0x04
#define PMU_STATUS	0x06
#define PMU_REV		0x08
#define PMU_CCODE	0x09

#define PMU_HT		0x0E

#define PMU_ABA		0x10		/* ACPI IO Base Address Register */
#define PMU_SBA		0x14		/* SMBus IO Base Address Register */

#define PMU_SVID	0x2C
#define PMU_SDID	0x2E

#define PMU_SEOG	0x40
#define PMU_SSOG	0x42
#define PMU_SEWS	0x44

/* SMI Status on wakeup from standby - general SMI status register */
#define PMU_SSWS	0x48
#define 	SSWS_USB	(1<<21)
#define		SSWS_SIRQ	(1<<20)
#define		SSWS_SMB	(1<<19)
#define		SSWS_IOGRPC	(1<<15)
#define		SSWS_PARP	(1<<12)
#define		SSWS_KBD	(1<<11)
#define		SSWS_SERIAL	(1<<10)
#define		SSWS_FLOPPY	(1<<9)
#define 	SSWS_VIDEO	(1<<8)
#define		SSWS_AUDIO	(1<<7)
#define		SSWS_IDE2	(1<<6)
#define		SSWS_IDE1	(1<<5)
#define		SSWS_MODEM	(1<<4)
#define 	SSWS_BUSM_STAT	(1<<3)
#define		SSWS_USB_STAT	(1<<2)
#define		SSWS_DISP_TO	(1<<1)
#define		SSWS_STDBY_ON	(1<<0)


#define PMU_EESS	0x4C
#define PMU_SESS	0x4E
#define PMU_EEGS	0x50
#define PMU_SEGS	0x52
#define PMU_ST		0x54
#define PMU_APMTA	0x55

#define PMU_GDT		0x59

#define PMU_ATPC	0x5B

#define PMU_SEMST	0x60
#define PMU_DEMDT	0x64

#define PMU_SED1	0x68

#define PMU_SED2	0x6C
#define PMU_SED3	0x70
#define PMU_SED4	0x72
#define PMU_SWUS	0x74
#define PMU_TIMBA	0x75
#define PMU_TNTDTI	0x76

#define PMU_SMI_CNTL	0x77			/* SMI control register */
#define 	SMI_CNTL_DELAY_M	(3<<0)	/* Delay between IRQ and SMI */
#define 	SMI_CNTL_DELAY0		(0<<0)
#define		SMI_CNTL_DELAY125	(1<<0)
#define		SMI_CNTL_DELAY250	(2<<0)
#define		SMI_CNTL_DELAY500	(3<<0)
#define		SMI_CNTL_SOFT_ENA	(1<<2)	/* Soft SMI by port 0xB1 */
#define	 	SMI_CNTL_SMI_ENA	(1<<3)	/* SMI enable / disable */
#define		SMI_CNTL_CLRMODE	(1<<4)	/* W1C or read to clear? */
#define		SMI_CNTL_CLRALL		(1<<5)	/* 0->clear all status bits */
#define		SMI_CNTL_SMIACK		(1<<6)	/* 1-0 => SMI ACK */
#define 	SMI_CNTL_SMIMODE	(1<<7)	/* 1 = M7101, 0 = ACPI */

#define PMU_PTS		0x78
#define PMU_PIIGS	0x7A
#define PMU_SCC		0x7B
#define PMU_BES1	0x7C
#define PMU_DCGPIO	0x7D
#define PMU_DOGPIO	0x7E
#define PMU_DIGPIO	0x7F
#define PMU_COES1	0x80

#define PMU_COEG1	0x84
#define PMU_COEG2	0x88
#define PMU_COES2	0x8C

#define PMU_CGPES1	0x90
#define PMU_CGPES2	0x91
#define PMU_WTR		0x92

#define PMU_MGA		0x94
#define PMU_SLEE	0x98

#define PMU_IOGC	0xA4

#define PMU_CSS		0xB2
#define PMU_SC		0xB3
#define PMU_SLED	0xB4
#define PMU_LEDC	0xB5

#define PMU_RIC		0xB7
#define PMU_ODEGPO	0xB8
#define PMU_IDEGPI	0xBA
#define PMU_SRIO70	0xBC
#define PMU_PCCA	0xBD
#define PMU_PSANS	0xBE

#define PMU_DOGPO1	0xC0
#define PMU_DOGPO2	0xC3
#define PMU_IDGPI	0xC4
#define PMU_SMIRB	0xC6

#define PMU_MMEAT	0xC8
#define PMU_LRWACR	0xC9
#define PMU_WBP		0xCA

#define PMU_DCC		0xCC

#define PMU_SMT		0xD4
#define PMU_HSS1	0xD5
#define PMU_HSS2	0xD6

#define PMU_DSC		0xD8
#define PMU_BES2	0xD9

#define PMU_SMBHSI	0xE0	/* SMBus Host & Slave Interface configuration */
#define		PMU_SMBHSI_HOST_EN	(1<<0)	/* Enable interface as host */
#define		PMU_SMBHSI_SLAVE_EN	(1<<1)	/* Enable interface as slave */

#define PMU_SMBHSC	0xE1	/* SMBus Host Slave Command register */

#define PMU_SMBHCBC	0xE2	/* SMBus Host Controller Base Clock */
#define 	PMU_SMBHCBC_149K	(0<<5)	/* SMB base clock settings */
#define 	PMU_SMBHCBC_74K		(1<<5)
#define 	PMU_SMBHCBC_37K		(2<<5)
#define 	PMU_SMBHCBC_223K	(4<<5)
#define 	PMU_SMBHCBC_111K	(5<<5)
#define 	PMU_SMBHCBC_55K		(6<<5)

#define		PMU_SMBHCBC_DL64	(0<<3)	/* SMB idle time delay ticks */
#define		PMU_SMBHCBC_DL32	(1<<3)
#define		PMU_SMBHCBC_DL128	(2<<3)


/*----------------------------------------------------------------------*/
/* SMBus IO-space-mapped registers */
/* These are offset from the base given in the M1701 PMU SBA BAR (CSR 0x14) */

#define SMBUS_SMBSTS	0x00	/* Host/slave status (read, write-1-clear) */
#define 	SMBUS_SMBSTS_HSTSLV_BSY	(1<<0)
#define		SMBUS_SMBSTS_HSTSLV_STS	(1<<1)
#define		SMBUS_SMBSTS_IDL_STS	(1<<2)	/* 1 if bus is idle */
#define		SMBUS_SMBSTS_HST_BSY	(1<<3)
#define		SMBUS_SMBSTS_SMI_I_STS	(1<<4)
#define		SMBUS_SMBSTS_DEVICE_ERR	(1<<5)
#define		SMBUS_SMBSTS_BUS_COLLI	(1<<6)
#define		SMBUS_SMBSTS_TERMINATE	(1<<7)

#define		SMBUS_SMBSTS_ERROR	(SMBUS_SMBSTS_TERMINATE | \
					 SMBUS_SMBSTS_BUS_COLLI | \
					 SMBUS_SMBSTS_DEVICE_ERR )

#define SMBUS_SMBCMD	0x01	/* Host/slave command */
#define		SMBUS_SMBCMD_TERMINATE	(1<<2)	/* Abort, reset host ctrllr */
#define		SMBUS_SMBCMD_T_OUT_CMD	(1<<3)	/* Timeout, reset all bus */
#define		SMBUS_SMBCMD_COMMAND	(1<<4)	/* Command register (below) */
#define		SMBUS_SMBCMD_BLK_CLR	(1<<7)	/* reset block register ptr */

#define 	SMBUS_COMMAND_QUICK	(0<<4)	/* Quick command (?) */
#define		SMBUS_COMMAND_SNDRCV	(1<<4)	/* Send/receive byte */
#define		SMBUS_COMMAND_WRRDB	(2<<4)	/* Write/read byte */
#define 	SMBUS_COMMAND_WORD	(3<<4)	/* Write/read word */
#define 	SMBUS_COMMAND_BLOCK	(4<<4)	/* Write/read block (32 byte) */

#define SMBUS_START	0x02			/* Write here to start op */
#define SMBUS_ADDR	0x03
#define SMBUS_DATA_A	0x04
#define SMBUS_DATA_B	0x05
#define SMBUS_BLOCK	0x06
#define SMBUS_CMD	0x07			/* Command to be transmitted */

/*----------------------------------------------------------------------*/
/* Access functions */

void AcerSIOInit(void);

String ali_revstr( String );

/* GPIO cache routines: every application using the GPIO bits must check and
 * keep consistent these cached copies. */

extern uint8 ali_gpio_data, ali_gpio_dirn, ali_gpio_cached;
extern void ali_load_gpio_cache( void );

/* Poke around the SMI registers and look for interesting stuff */
extern void ali_smi( void );

