/*****************************************************************************/
/*FILE: ALPHA_OPCODE.H	(EV5)						     */
/*****************************************************************************/
/*****************************************************************************
	Copyright (c) 1992,93,94
	Digital Equipment Corporation, Maynard, Massachusetts 01754

	The HAL Alpha Assembler is free software; you can redistribute 
	it and/or modify it with the sole restriction that this copyright 
	notice be attached.

	The information in this software is subject to change without notice 
	and should not be construed as a commitment by Digital Equipment
	Corporation.

	The author disclaims all warranties with regard to this software,
	including all implied warranties of merchantability and fitness, in
	no event shall he be liable for any special, indirect or consequential
	damages or any damages whatsoever resulting from loss of use, data, 
	or profits, whether in an action of contract, negligence or other
	tortious action, arising out of or in connection with the use or
	performance of this software.
 *****************************************************************************/
/* opcode and subfunction in correct location in long word                  */
/* suitable for OR'ing directly into the target instruction                 */
#define OPC32_LDB 671088640
#define OPC32_LDW 805306368
#define OPC32_LDL -1610612736
#define OPC32_LDQ -1543503872
#define OPC32_LDLL -1476395008
#define OPC32_LDQL -1409286144
#define OPC32_LDQU 738197504
#define OPC32_LDA 536870912
#define OPC32_STB 939524096
#define OPC32_STW 872415232
#define OPC32_STL -1342177280
#define OPC32_STQ -1275068416
#define OPC32_STLC -1207959552
#define OPC32_STQC -1140850688
#define OPC32_STQU 1006632960
#define OPC32_LDAH 603979776
#define OPC32_LDF -2147483648
#define OPC32_LDD -2080374784
#define OPC32_LDS -2013265920
#define OPC32_LDT -1946157056
#define OPC32_STF -1879048192
#define OPC32_STD -1811939328
#define OPC32_STS -1744830464
#define OPC32_STT -1677721600
#define OPC32_MB 1677672448
#define OPC32_WMB 1677673472
#define OPC32_MB8 1677674496
#define OPC32_MBC 1677675520
#define OPC32_WH64   0x63e0F800
#define OPC32_ECB    0x63e0E800
#define OPC32_TRAPB 1612644352
#define OPC32_EXCB 1612645376
#define OPC32_RCC 0x6000C000
#define OPC32_FETCH 1610645504
#define OPC32_FETCH_M 1610653696
#define OPC32_RC 1612701696
#define OPC32_RS 1612705792
#define OPC32_JMP 1744830464
#define OPC32_JSR 1744846848
#define OPC32_RET 1744863232
#define OPC32_JSR_COROUTINE 1744879616
#define OPC32_BR -1073741824
#define OPC32_BSR -805306368
#define OPC32_BLBC -536870912
#define OPC32_BLBS -268435456
#define OPC32_FBEQ -1006632960
#define OPC32_FBNE -738197504
#define OPC32_BEQ -469762048
#define OPC32_BNE -201326592
#define OPC32_FBLT -939524096
#define OPC32_FBGE -671088640
#define OPC32_BLT -402653184
#define OPC32_BGE -134217728
#define OPC32_FBLE -872415232
#define OPC32_FBGT -603979776
#define OPC32_BLE -335544320
#define OPC32_BGT -67108864
#define OPC32_ADDL 1073741824
#define OPC32_ADDLV 1073743872
#define OPC32_ADDQ 1073742848
#define OPC32_ADDQV 1073744896
#define OPC32_S4ADDL 1073741888
#define OPC32_S4ADDQ 1073742912
#define OPC32_S8ADDL 1073742400
#define OPC32_S8ADDQ 1073743424
#define OPC32_S4SUBL 1073742176
#define OPC32_S4SUBQ 1073743200
#define OPC32_S8SUBL 1073742688
#define OPC32_S8SUBQ 1073743712
#define OPC32_SUBL 1073742112
#define OPC32_SUBLV 1073744160
#define OPC32_SUBQ 1073743136
#define OPC32_SUBQV 1073745184
#define OPC32_CMPEQ 1073743264
#define OPC32_CMPLT 1073744288
#define OPC32_CMPLE 1073745312
#define OPC32_CMPULT 1073742752
#define OPC32_CMPULE 1073743776
#define OPC32_CMPBGE 1073742304
#define OPC32_AND 1140850688
#define OPC32_BIC 1140850944
#define OPC32_CMOVEQ 1140851840
#define OPC32_CMOVNE 1140851904
#define OPC32_BIS 1140851712
#define OPC32_ORNOT 1140851968
#define OPC32_CMOVLT 1140852864
#define OPC32_CMOVGE 1140852928
#define OPC32_XOR 1140852736
#define OPC32_EQV 1140852992
#define OPC32_AMASK   0x47E00C20
#define OPC32_IMPLVER 0x47E03D80
#define OPC32_CMOVLE 1140853888
#define OPC32_CMOVGT 1140853952
#define OPC32_CMOVLBS 1140851328
#define OPC32_CMOVLBC 1140851392
#define OPC32_EXTBL 1207959744
#define OPC32_EXTWL 1207960256
#define OPC32_EXTLL 1207960768
#define OPC32_EXTQL 1207961280
#define OPC32_EXTWH 1207962432
#define OPC32_EXTLH 1207962944
#define OPC32_EXTQH 1207963456
#define OPC32_INSBL 1207959904
#define OPC32_INSWL 1207960416
#define OPC32_INSLL 1207960928
#define OPC32_INSQL 1207961440
#define OPC32_INSWH 1207962336
#define OPC32_INSLH 1207962848
#define OPC32_INSQH 1207963360
#define OPC32_MSKBL 1207959616
#define OPC32_MSKWL 1207960128
#define OPC32_MSKLL 1207960640
#define OPC32_MSKQL 1207961152
#define OPC32_MSKWH 1207962176
#define OPC32_MSKLH 1207962688
#define OPC32_MSKQH 1207963200
#define OPC32_ZAP 1207961088
#define OPC32_ZAPNOT 1207961120
#define OPC32_SRA 1207961472
#define OPC32_SRL 1207961216
#define OPC32_SLL 1207961376
#define OPC32_SEXTB 1879048192
#define OPC32_SEXTW 1879048224
#define OPC32_CTPOP  0x70000600
#define OPC32_PERR   0x70000620
#define OPC32_CTLZ   0x70000640
#define OPC32_CTTZ   0x70000660
#define OPC32_UNPKBW 0x70000680
#define OPC32_UNPKBL 0x700006A0
#define OPC32_PKWB   0x700006C0
#define OPC32_PKLB   0x700006E0
#define OPC32_MINSB8 0x70000700
#define OPC32_MINSW4 0x70000720
#define OPC32_MINUB8 0x70000740
#define OPC32_MINUW4 0x70000760
#define OPC32_MAXUB8 0x70000780
#define OPC32_MAXUW4 0x700007A0
#define OPC32_MAXSB8 0x700007C0
#define OPC32_MAXSW4 0x700007E0
#define OPC32_FTOIT  0x70000E00
#define OPC32_FTOIS  0x70000F00
/* These no longer exist 
  #define OPC32_LDWSB  0x70000800
  #define OPC32_LDLSB  0x70002800
  #define OPC32_LDQSB  0x70006800
  #define OPC32_STWSB  0x70008800
  #define OPC32_STLSB  0x7000A800
  #define OPC32_STQSB  0x7000E800
*/
#define OPC32_NOP 0x47FF041F  /* BIS r31,r31,r31 */
#define OPC32_FNOP 0x5FFF041F /* CPYS f31,f31,f31 */
#define OPC32_UNOP 0x2FE00000 /* ldq/u r31, x(rx) -- disp & rb added later */
#define OPC32_MULL 1275068416
#define OPC32_MULQV 1275071488
#define OPC32_MULLV 1275070464
#define OPC32_UMULH 1275069952
#define OPC32_MULQ 1275069440
#define OPC32_CPYS 1543504896
#define OPC32_CPYSN 1543504928
#define OPC32_CPYSE 1543504960
#define OPC32_CPYSEE 1543503968
#define OPC32_WR_FPCTL 1543505024
#define OPC32_RD_FPCTL 1543505056
#define OPC32_CVTLQ 1608516096
#define OPC32_CVTQL 1608517120
#define OPC32_CVTQLV 1608525312
#define OPC32_CVTQLSV 1608558080
#define OPC32_FCMOVEQ 1543505216
#define OPC32_FCMOVNE 1543505248
#define OPC32_FCMOVLT 1543505280
#define OPC32_FCMOVGE 1543505312
#define OPC32_FCMOVLE 1543505344
#define OPC32_FCMOVGT 1543505376
#define OPC32_ADDS 1476399104
#define OPC32_ADDSC 1476395008
#define OPC32_ADDSM 1476397056
#define OPC32_ADDSP 1476401152
#define OPC32_ADDSU 1476407296
#define OPC32_ADDSUC 1476403200
#define OPC32_ADDSUM 1476405248
#define OPC32_ADDSUP 1476409344
#define OPC32_ADDSS 1476431872
#define OPC32_ADDSSC 1476427776
#define OPC32_ADDSSM 1476429824
#define OPC32_ADDSSP 1476433920
#define OPC32_ADDSSU 1476440064
#define OPC32_ADDSSUC 1476435968
#define OPC32_ADDSSUM 1476438016
#define OPC32_ADDSSUP 1476442112
#define OPC32_ADDSSUI 1476456448
#define OPC32_ADDSSUIC 1476452352
#define OPC32_ADDSSUIM 1476454400
#define OPC32_ADDSSUIP 1476458496
#define OPC32_ADDT 1476400128
#define OPC32_ADDTC 1476396032
#define OPC32_ADDTM 1476398080
#define OPC32_ADDTP 1476402176
#define OPC32_ADDTU 1476408320
#define OPC32_ADDTUC 1476404224
#define OPC32_ADDTUM 1476406272
#define OPC32_ADDTUP 1476410368
#define OPC32_ADDTS 1476432896
#define OPC32_ADDTSC 1476428800
#define OPC32_ADDTSM 1476430848
#define OPC32_ADDTSP 1476434944
#define OPC32_ADDTSU 1476441088
#define OPC32_ADDTSUC 1476436992
#define OPC32_ADDTSUM 1476439040
#define OPC32_ADDTSUP 1476443136
#define OPC32_ADDTSUI 1476457472
#define OPC32_ADDTSUIC 1476453376
#define OPC32_ADDTSUIM 1476455424
#define OPC32_ADDTSUIP 1476459520
#define OPC32_CMPSEQ 1476399264
#define OPC32_CMPSEQSU 1476440224
#define OPC32_CMPSLT 1476399296
#define OPC32_CMPSLTSU 1476440256
#define OPC32_CMPSLE 1476399328
#define OPC32_CMPSLESU 1476440288
#define OPC32_CMPSUN 1476399232
#define OPC32_CMPSUNSU 1476440192
#define OPC32_CMPTEQ 1476400288
#define OPC32_CMPTEQSU 1476441248
#define OPC32_CMPTLT 1476400320
#define OPC32_CMPTLTSU 1476441280
#define OPC32_CMPTLE 1476400352
#define OPC32_CMPTLESU 1476441312
#define OPC32_CMPTUN 1476400256
#define OPC32_CMPTUNSU 1476441216
#define OPC32_CVTQS 1541412736
#define OPC32_CVTQSC 1541408640
#define OPC32_CVTQSM 1541410688
#define OPC32_CVTQSP 1541414784
#define OPC32_CVTQSSUI 1541470080
#define OPC32_CVTQSSUIC 1541465984
#define OPC32_CVTQSSUIM 1541468032
#define OPC32_CVTQSSUIP 1541472128
#define OPC32_CVTQT 1541412800
#define OPC32_CVTQTC 1541408704
#define OPC32_CVTQTM 1541410752
#define OPC32_CVTQTP 1541414848
#define OPC32_CVTQTSUI 1541470144
#define OPC32_CVTQTSUIC 1541466048
#define OPC32_CVTQTSUIM 1541468096
#define OPC32_CVTQTSUIP 1541472192
#define OPC32_CVTST 1541428608
#define OPC32_CVTSTS 1541461376
#define OPC32_CVTTS 1541412224
#define OPC32_CVTTSC 1541408128
#define OPC32_CVTTSM 1541410176
#define OPC32_CVTTSP 1541414272
#define OPC32_CVTTSU 1541420416
#define OPC32_CVTTSUC 1541416320
#define OPC32_CVTTSUM 1541418368
#define OPC32_CVTTSUP 1541422464
#define OPC32_CVTTSS 1541444992
#define OPC32_CVTTSSC 1541440896
#define OPC32_CVTTSSM 1541442944
#define OPC32_CVTTSSP 1541447040
#define OPC32_CVTTSSU 1541453184
#define OPC32_CVTTSSUC 1541449088
#define OPC32_CVTTSSUM 1541451136
#define OPC32_CVTTSSUP 1541455232
#define OPC32_CVTTSSUI 1541469568
#define OPC32_CVTTSSUIC 1541465472
#define OPC32_CVTTSSUIM 1541467520
#define OPC32_CVTTSSUIP 1541471616
#define OPC32_DIVS 1476399200
#define OPC32_DIVSC 1476395104
#define OPC32_DIVSM 1476397152
#define OPC32_DIVSP 1476401248
#define OPC32_DIVSU 1476407392
#define OPC32_DIVSUC 1476403296
#define OPC32_DIVSUM 1476405344
#define OPC32_DIVSUP 1476409440
#define OPC32_DIVSS 1476431968
#define OPC32_DIVSSC 1476427872
#define OPC32_DIVSSM 1476429920
#define OPC32_DIVSSP 1476434016
#define OPC32_DIVSSU 1476440160
#define OPC32_DIVSSUC 1476436064
#define OPC32_DIVSSUM 1476438112
#define OPC32_DIVSSUP 1476442208
#define OPC32_DIVSSUI 1476456544
#define OPC32_DIVSSUIC 1476452448
#define OPC32_DIVSSUIM 1476454496
#define OPC32_DIVSSUIP 1476458592
#define OPC32_DIVT 1476400224
#define OPC32_DIVTC 1476396128
#define OPC32_DIVTM 1476398176
#define OPC32_DIVTP 1476402272
#define OPC32_DIVTU 1476408416
#define OPC32_DIVTUC 1476404320
#define OPC32_DIVTUM 1476406368
#define OPC32_DIVTUP 1476410464
#define OPC32_DIVTS 1476432992
#define OPC32_DIVTSC 1476428896
#define OPC32_DIVTSM 1476430944
#define OPC32_DIVTSP 1476435040
#define OPC32_DIVTSU 1476441184
#define OPC32_DIVTSUC 1476437088
#define OPC32_DIVTSUM 1476439136
#define OPC32_DIVTSUP 1476443232
#define OPC32_DIVTSUI 1476457568
#define OPC32_DIVTSUIC 1476453472
#define OPC32_DIVTSUIM 1476455520
#define OPC32_DIVTSUIP 1476459616
#define OPC32_MULS 1476399168
#define OPC32_MULSC 1476395072
#define OPC32_MULSM 1476397120
#define OPC32_MULSP 1476401216
#define OPC32_MULSU 1476407360
#define OPC32_MULSUC 1476403264
#define OPC32_MULSUM 1476405312
#define OPC32_MULSUP 1476409408
#define OPC32_MULSS 1476431936
#define OPC32_MULSSC 1476427840
#define OPC32_MULSSM 1476429888
#define OPC32_MULSSP 1476433984
#define OPC32_MULSSU 1476440128
#define OPC32_MULSSUC 1476436032
#define OPC32_MULSSUM 1476438080
#define OPC32_MULSSUP 1476442176
#define OPC32_MULSSUI 1476456512
#define OPC32_MULSSUIC 1476452416
#define OPC32_MULSSUIM 1476454464
#define OPC32_MULSSUIP 1476458560
#define OPC32_MULT 1476400192
#define OPC32_MULTC 1476396096
#define OPC32_MULTM 1476398144
#define OPC32_MULTP 1476402240
#define OPC32_MULTU 1476408384
#define OPC32_MULTUC 1476404288
#define OPC32_MULTUM 1476406336
#define OPC32_MULTUP 1476410432
#define OPC32_MULTS 1476432960
#define OPC32_MULTSC 1476428864
#define OPC32_MULTSM 1476430912
#define OPC32_MULTSP 1476435008
#define OPC32_MULTSU 1476441152
#define OPC32_MULTSUC 1476437056
#define OPC32_MULTSUM 1476439104
#define OPC32_MULTSUP 1476443200
#define OPC32_MULTSUI 1476457536
#define OPC32_MULTSUIC 1476453440
#define OPC32_MULTSUIM 1476455488
#define OPC32_MULTSUIP 1476459584
#define OPC32_SUBS 1476399136
#define OPC32_SUBSC 1476395040
#define OPC32_SUBSM 1476397088
#define OPC32_SUBSP 1476401184
#define OPC32_SUBSU 1476407328
#define OPC32_SUBSUC 1476403232
#define OPC32_SUBSUM 1476405280
#define OPC32_SUBSUP 1476409376
#define OPC32_SUBSS 1476431904
#define OPC32_SUBSSC 1476427808
#define OPC32_SUBSSM 1476429856
#define OPC32_SUBSSP 1476433952
#define OPC32_SUBSSU 1476440096
#define OPC32_SUBSSUC 1476436000
#define OPC32_SUBSSUM 1476438048
#define OPC32_SUBSSUP 1476442144
#define OPC32_SUBSSUI 1476456480
#define OPC32_SUBSSUIC 1476452384
#define OPC32_SUBSSUIM 1476454432
#define OPC32_SUBSSUIP 1476458528
#define OPC32_SUBT 1476400160
#define OPC32_SUBTC 1476396064
#define OPC32_SUBTM 1476398112
#define OPC32_SUBTP 1476402208
#define OPC32_SUBTU 1476408352
#define OPC32_SUBTUC 1476404256
#define OPC32_SUBTUM 1476406304
#define OPC32_SUBTUP 1476410400
#define OPC32_SUBTS 1476432928
#define OPC32_SUBTSC 1476428832
#define OPC32_SUBTSM 1476430880
#define OPC32_SUBTSP 1476434976
#define OPC32_SUBTSU 1476441120
#define OPC32_SUBTSUC 1476437024
#define OPC32_SUBTSUM 1476439072
#define OPC32_SUBTSUP 1476443168
#define OPC32_SUBTSUI 1476457504
#define OPC32_SUBTSUIC 1476453408
#define OPC32_SUBTSUIM 1476455456
#define OPC32_SUBTSUIP 1476459552
#define OPC32_CVTSQ 1541411296
#define OPC32_CVTSQC 1541407200
#define OPC32_CVTSQV 1541419488
#define OPC32_CVTSQVC 1541415392
#define OPC32_CVTSQSV 1541452256
#define OPC32_CVTSQSVC 1541448160
#define OPC32_CVTSQSVI 1541468640
#define OPC32_CVTSQSVIC 1541464544
#define OPC32_CVTTQ 1541412320
#define OPC32_CVTTQC 1541408224
#define OPC32_CVTTQV 1541420512
#define OPC32_CVTTQVC 1541416416
#define OPC32_CVTTQSV 1541453280
#define OPC32_CVTTQSVC 1541449184
#define OPC32_CVTTQSVI 1541469664
#define OPC32_CVTTQSVIC 1541465568
#define OPC32_CVTTQD 1541414368
#define OPC32_CVTTQVD 1541422560
#define OPC32_CVTTQSVD 1541455328
#define OPC32_CVTTQSVID 1541471712
#define OPC32_CVTTQM 1541410272
#define OPC32_CVTTQVM 1541418464
#define OPC32_CVTTQSVM 1541451232
#define OPC32_CVTTQSVIM 1541467616
#define OPC32_CVTTQP 1541414368
#define OPC32_CVTTQVP 1541422560
#define OPC32_CVTTQSVP 1541455328
#define OPC32_CVTTQSVIP 1541471712
#define OPC32_CVTTQS 1541445088
#define OPC32_CVTTQSC 1541440992
#define OPC32_CVTTQSM 1541443040
#define OPC32_CVTTQSP 1541447136
#define OPC32_CVTTQSD 1541447136
#define OPC32_ITOFS     0x50000080
#define OPC32_ITOFF     0x50000280
#define OPC32_ITOFT     0x50000480
#define OPC32_SQRTS     0x50001160
#define OPC32_SQRTSC    0x50000160
#define OPC32_SQRTSM    0x50000960
#define OPC32_SQRTSD    0x50001960
#define OPC32_SQRTSU    0x50003160 
#define OPC32_SQRTSUC   0x50002160
#define OPC32_SQRTSUM   0x50002960
#define OPC32_SQRTSUD   0x50003960
#define OPC32_SQRTSSU   0x5000B160
#define OPC32_SQRTSSUC  0x5000A160
#define OPC32_SQRTSSUM  0x5000A960
#define OPC32_SQRTSSUD  0x5000B960 
#define OPC32_SQRTSSUI  0x5000F160
#define OPC32_SQRTSSUIC 0x5000E160
#define OPC32_SQRTSSUIM 0x5000E960
#define OPC32_SQRTSSUID 0x5000F960
#define OPC32_SQRTT     0x50001560
#define OPC32_SQRTTC    0x50000560
#define OPC32_SQRTTM    0x50000D60
#define OPC32_SQRTTD    0x50001D60
#define OPC32_SQRTTU    0x50003560
#define OPC32_SQRTTUC   0x50002560
#define OPC32_SQRTTUM   0x50002D60
#define OPC32_SQRTTUD   0x50003D60
#define OPC32_SQRTTSU   0x5000B560
#define OPC32_SQRTTSUC  0x5000A560
#define OPC32_SQRTTSUM  0x5000AD60
#define OPC32_SQRTTSUD  0x5000BD60
#define OPC32_SQRTTSUI  0x5000F560
#define OPC32_SQRTTSUIC 0x5000E560
#define OPC32_SQRTTSUIM 0x5000ED60
#define OPC32_SQRTTSUID 0x5000FD60
#define OPC32_ADDD 1409290752
#define OPC32_ADDDC 1409286656
#define OPC32_ADDDU 1409298944
#define OPC32_ADDDUC 1409294848
#define OPC32_ADDDS 1409323520
#define OPC32_ADDDSC 1409319424
#define OPC32_ADDDSU 1409331712
#define OPC32_ADDDSUC 1409327616
#define OPC32_ADDF 1409290240
#define OPC32_ADDFC 1409286144
#define OPC32_ADDFU 1409298432
#define OPC32_ADDFUC 1409294336
#define OPC32_ADDFS 1409323008
#define OPC32_ADDFSC 1409318912
#define OPC32_ADDFSU 1409331200
#define OPC32_ADDFSUC 1409327104
#define OPC32_ADDG 1409291264
#define OPC32_ADDGC 1409287168
#define OPC32_ADDGU 1409299456
#define OPC32_ADDGUC 1409295360
#define OPC32_ADDGS 1409324032
#define OPC32_ADDGSC 1409319936
#define OPC32_ADDGSU 1409332224
#define OPC32_ADDGSUC 1409328128
#define OPC32_CMPDEQ 1409290912
#define OPC32_CMPDLT 1409290944
#define OPC32_CMPDLE 1409290976
#define OPC32_CMPDEQS 1409323680
#define OPC32_CMPDLTS 1409323712
#define OPC32_CMPDLES 1409323744
#define OPC32_CMPGEQ 1409291424
#define OPC32_CMPGLT 1409291456
#define OPC32_CMPGLE 1409291488
#define OPC32_CMPGEQS 1409324192
#define OPC32_CMPGLTS 1409324224
#define OPC32_CMPGLES 1409324256
#define OPC32_CVTDF 1474302848
#define OPC32_CVTDFC 1474298752
#define OPC32_CVTDFS 1474335616
#define OPC32_CVTDFSC 1474331520
#define OPC32_CVTDG 1474302912
#define OPC32_CVTDGC 1474298816
#define OPC32_CVTDGU 1474311104
#define OPC32_CVTDGUC 1474307008
#define OPC32_CVTDGS 1474335680
#define OPC32_CVTDGSC 1474331584
#define OPC32_CVTDGSU 1474343872
#define OPC32_CVTDGSUC 1474339776
#define OPC32_CVTGD 1474303392
#define OPC32_CVTGDC 1474299296
#define OPC32_CVTGDU 1474311584
#define OPC32_CVTGDUC 1474307488
#define OPC32_CVTGDS 1474336160
#define OPC32_CVTGDSC 1474332064
#define OPC32_CVTGDSU 1474344352
#define OPC32_CVTGDSUC 1474340256
#define OPC32_CVTFG 1474302400
#define OPC32_CVTFGC 1474298304
#define OPC32_CVTFGS 1474335168
#define OPC32_CVTFGSC 1474331072
#define OPC32_CVTGF 1474303360
#define OPC32_CVTGFC 1474299264
#define OPC32_CVTGFU 1474311552
#define OPC32_CVTGFUC 1474307456
#define OPC32_CVTGFS 1474336128
#define OPC32_CVTGFSC 1474332032
#define OPC32_CVTGFSU 1474344320
#define OPC32_CVTGFSUC 1474340224
#define OPC32_CVTQD 1474303904
#define OPC32_CVTQDC 1474299808
#define OPC32_CVTQDS 1474336672
#define OPC32_CVTQDSC 1474332576
#define OPC32_CVTQF 1474303872
#define OPC32_CVTQFC 1474299776
#define OPC32_CVTQFS 1474336640
#define OPC32_CVTQFSC 1474332544
#define OPC32_CVTQG 1474303936
#define OPC32_CVTQGC 1474299840
#define OPC32_CVTQGS 1474336704
#define OPC32_CVTQGSC 1474332608
#define OPC32_DIVD 1409290848
#define OPC32_DIVDC 1409286752
#define OPC32_DIVDU 1409299040
#define OPC32_DIVDUC 1409294944
#define OPC32_DIVDS 1409323616
#define OPC32_DIVDSC 1409319520
#define OPC32_DIVDSU 1409331808
#define OPC32_DIVDSUC 1409327712
#define OPC32_DIVF 1409290336
#define OPC32_DIVFC 1409286240
#define OPC32_DIVFU 1409298528
#define OPC32_DIVFUC 1409294432
#define OPC32_DIVFS 1409323104
#define OPC32_DIVFSC 1409319008
#define OPC32_DIVFSU 1409331296
#define OPC32_DIVFSUC 1409327200
#define OPC32_DIVG 1409291360
#define OPC32_DIVGC 1409287264
#define OPC32_DIVGU 1409299552
#define OPC32_DIVGUC 1409295456
#define OPC32_DIVGS 1409324128
#define OPC32_DIVGSC 1409320032
#define OPC32_DIVGSU 1409332320
#define OPC32_DIVGSUC 1409328224
#define OPC32_MULD 1409290816
#define OPC32_MULDC 1409286720
#define OPC32_MULDU 1409299008
#define OPC32_MULDUC 1409294912
#define OPC32_MULDS 1409323584
#define OPC32_MULDSC 1409319488
#define OPC32_MULDSU 1409331776
#define OPC32_MULDSUC 1409327680
#define OPC32_MULF 1409290304
#define OPC32_MULFC 1409286208
#define OPC32_MULFU 1409298496
#define OPC32_MULFUC 1409294400
#define OPC32_MULFS 1409323072
#define OPC32_MULFSC 1409318976
#define OPC32_MULFSU 1409331264
#define OPC32_MULFSUC 1409327168
#define OPC32_MULG 1409291328
#define OPC32_MULGC 1409287232
#define OPC32_MULGU 1409299520
#define OPC32_MULGUC 1409295424
#define OPC32_MULGS 1409324096
#define OPC32_MULGSC 1409320000
#define OPC32_MULGSU 1409332288
#define OPC32_MULGSUC 1409328192
#define OPC32_SUBD 1409290784
#define OPC32_SUBDC 1409286688
#define OPC32_SUBDU 1409298976
#define OPC32_SUBDUC 1409294880
#define OPC32_SUBDS 1409323552
#define OPC32_SUBDSC 1409319456
#define OPC32_SUBDSU 1409331744
#define OPC32_SUBDSUC 1409327648
#define OPC32_SUBF 1409290272
#define OPC32_SUBFC 1409286176
#define OPC32_SUBFU 1409298464
#define OPC32_SUBFUC 1409294368
#define OPC32_SUBFS 1409323040
#define OPC32_SUBFSC 1409318944
#define OPC32_SUBFSU 1409331232
#define OPC32_SUBFSUC 1409327136
#define OPC32_SUBG 1409291296
#define OPC32_SUBGC 1409287200
#define OPC32_SUBGU 1409299488
#define OPC32_SUBGUC 1409295392
#define OPC32_SUBGS 1409324064
#define OPC32_SUBGSC 1409319968
#define OPC32_SUBGSU 1409332256
#define OPC32_SUBGSUC 1409328160
#define OPC32_CVTDQ 1474302944
#define OPC32_CVTDQC 1474298848
#define OPC32_CVTDQV 1474311136
#define OPC32_CVTDQVC 1474307040
#define OPC32_CVTDQS 1474335712
#define OPC32_CVTDQSC 1474331616
#define OPC32_CVTDQSV 1474343904
#define OPC32_CVTDQSVC 1474339808
#define OPC32_CVTGQ 1474303456
#define OPC32_CVTGQC 1474299360
#define OPC32_CVTGQV 1474311648
#define OPC32_CVTGQVC 1474307552
#define OPC32_CVTGQS 1474336224
#define OPC32_CVTGQSC 1474332128
#define OPC32_CVTGQSV 1474344416
#define OPC32_CVTGQSVC 1474340320
#define OPC32_SQRTF    0x50001140
#define OPC32_SQRTFC   0x50000140
#define OPC32_SQRTFU   0x50003140
#define OPC32_SQRTFUC  0x50002140
#define OPC32_SQRTFS   0x50009140
#define OPC32_SQRTFSC  0x50008140
#define OPC32_SQRTFSU  0x5000B140
#define OPC32_SQRTFSUC 0x5000A140
#define OPC32_SQRTG    0x50001540
#define OPC32_SQRTGC   0x50000540
#define OPC32_SQRTGU   0x50003540
#define OPC32_SQRTGUC  0x50002540
#define OPC32_SQRTGS   0x50009540
#define OPC32_SQRTGSC  0x50008540
#define OPC32_SQRTGSU  0x5000B540
#define OPC32_SQRTGSUC 0x5000A540
#define OPC32_BPT 128
#define OPC32_BUGCHK 129
#define OPC32_CHME 130
#define OPC32_CHMK 131
#define OPC32_CHMS 132
#define OPC32_CHMU 133
#define OPC32_IMB 134
#define OPC32_INSQHIL 135
#define OPC32_INSQTIL 136
#define OPC32_INSQHIQ 137
#define OPC32_INSQTIQ 138
#define OPC32_INSQUEL 139
#define OPC32_INSQUEQ 140
#define OPC32_INSQUELD 141
#define OPC32_INSQUEQD 142
#define OPC32_PROBER 143
#define OPC32_INSQHILR 162
#define OPC32_INSQTILR 163
#define OPC32_INSQHIQR 164
#define OPC32_INSQTIQR 165
#define OPC32_AMOVRR 160
#define OPC32_AMOVRM 161
#define OPC32_PROBEW 144
#define OPC32_RD_PS 145
#define OPC32_REI 146
#define OPC32_REMQHIL 147
#define OPC32_REMQTIL 148
#define OPC32_REMQHIQ 149
#define OPC32_REMQTIQ 150
#define OPC32_REMQUEL 151
#define OPC32_REMQUEQ 152
#define OPC32_REMQUELD 153
#define OPC32_REMQUEQD 154
#define OPC32_REMQHILR 166
#define OPC32_REMQTILR 167
#define OPC32_REMQHIQR 168
#define OPC32_REMQTIQR 169
#define OPC32_GENTRAP 170
#define OPC32_SWASTEN 155
#define OPC32_WR_PS_SW 156
#define OPC32_RSCC 157
#define OPC32_READ_UNQ 158
#define OPC32_WRITE_UNQ 159
#define OPC32_CFLUSH 1
#define OPC32_DRAINA 2
#define OPC32_HALT 0
#define OPC32_LDQP 3
#define OPC32_STQP 4
#define OPC32_SWPCTX 5
#define OPC32_MFPR_ASN 6
#define OPC32_MTPR_ASTEN 7
#define OPC32_MTPR_ASTSR 8
#define OPC32_CSERVE 9
#define OPC32_SWPPAL 10
#define OPC32_MFPR_FEN 11
#define OPC32_MTPR_FEN 12
#define OPC32_MTPR_IPIR 13
#define OPC32_MFPR_IPL 14
#define OPC32_MTPR_IPL 15
#define OPC32_MFPR_MCES 16
#define OPC32_MTPR_MCES 17
#define OPC32_MFPR_PCBB 18
#define OPC32_MFPR_PRBR 19
#define OPC32_MTPR_PRBR 20
#define OPC32_MFPR_PTBR 21
#define OPC32_MFPR_SCBB 22
#define OPC32_MTPR_SCBB 23
#define OPC32_MTPR_SIRR 24
#define OPC32_MFPR_SISR 25
#define OPC32_MFPR_TBCHK 26
#define OPC32_MTPR_TBIA 27
#define OPC32_MTPR_TBIAP 28
#define OPC32_MTPR_TBIS 29
#define OPC32_MFPR_ESP 30
#define OPC32_MTPR_ESP 31
#define OPC32_MFPR_SSP 32
#define OPC32_MTPR_SSP 33
#define OPC32_MFPR_USP 34
#define OPC32_MTPR_USP 35
#define OPC32_MTPR_TBISD 36
#define OPC32_MTPR_TBISI 37
#define OPC32_MFPR_ASTEN 38
#define OPC32_MFPR_ASTSR 39
#define OPC32_VMS2OSF 40
#define OPC32_MFPR_VPTBASE 41
#define OPC32_MTPR_VPTBASE 42
#define OPC32_MTPR_PERFMON 43
#define OPC32_MTPR_DATAFX 46
#define OPC32_MFPR_WHAMI 63
#define OPC32_GETSS 123
#define OPC32_PUTSS 124
/* Constant BPT		equals ((EVX$OPC_PAL@#opc)!(EVX$PAL_BPT@#PFNC)) Prefix "EVX$" TAG "opc32"; */
/* Constant BUGCHK	equals ((EVX$OPC_PAL@#opc)!(EVX$PAL_BUGCHK@#PFNC)) Prefix "EVX$" TAG "opc32"; */
#define OPC32_CALLSYS 131
/* Constant GENTRAP	equals ((EVX$OPC_PAL@#opc)!(EVX$PAL_GENTRAP@#PFNC)) Prefix "EVX$" TAG "opc32"; */
/* Constant IMB		equals ((EVX$OPC_PAL@#opc)!(EVX$PAL_IMB@#PFNC)) Prefix "EVX$" TAG "opc32"; */
#define OPC32_RDUNIQUE 158
#define OPC32_WRUNIQUE 159
/* Constant HALT	equals ((EVX$OPC_PAL@#opc)!(EVX$PAL_HALT@#PFNC)) Prefix "EVX$" TAG "opc32"; */
/* Constant CFLUSH	equals ((EVX$OPC_PAL@#opc)!(EVX$PAL_CFLUSH@#PFNC)) Prefix "EVX$" TAG "opc32"; */
#define OPC32_RDMCES 16
#define OPC32_WRMCES 17
#define OPC32_WRPERFMON 57
#define OPC32_RDPS 54
#define OPC32_RDUSP 58
#define OPC32_RDVAL 50
#define OPC32_RETSYS 61
#define OPC32_RTI 63
#define OPC32_WRIPIR 13
#define OPC32_OSFSWPCTX 48
#define OPC32_SWPIPL 53
#define OPC32_TBI 51
#define OPC32_WHAMI 60
#define OPC32_WRENT 52
#define OPC32_WRFEN 43
#define OPC32_WRKGP 55
#define OPC32_WRUSP 56
#define OPC32_WRVAL 49
#define OPC32_WRVPTPTR 45
/* Opcodes reserved for PALcode                                             */
#define OPC32_PAL19 1677721600
#define OPC32_PAL1B 1811939328
#define OPC32_PAL1D 1946157056
#define OPC32_PAL1E 2013265920
#define OPC32_PAL1F 2080374784
/* Opcodes reserved for DIGITAL                                             */
#define OPC32_OPC01 67108864
#define OPC32_OPC02 134217728
#define OPC32_OPC03 201326592
#define OPC32_OPC04 268435456
#define OPC32_OPC05 335544320
#define OPC32_OPC06 402653184
#define OPC32_OPC07 469762048
#define OPC32_OPC14 1342177280
#define OPC32_OPC1C 1879048192
#define OPC32_NPHALT 191

/* EV4 PAL opcodes */
#define OPC32_EV4_HW_REI	(0x1E<<26 | 0x8000 | 31<<21 | 31<<16)
#define OPC32_EV4_HW_MFPR	(0x19<<26)
#define OPC32_EV4_HW_MTPR	(0x1D<<26)
#define OPC32_EV4_HW_LD	        (0x1B<<26)
#define OPC32_EV4_HW_ST	        (0x1F<<26)

/* EV5 PAL opcodes */
#define OPC32_EV5_HW_REI	(0x1E<<26 | 0x8000 | 31<<21 | 31<<16)
#define OPC32_EV5_HW_MFPR	(0x19<<26)
#define OPC32_EV5_HW_MTPR	(0x1D<<26)
#define OPC32_EV5_HW_LD	        (0x1B<<26)
#define OPC32_EV5_HW_ST	        (0x1F<<26)

/* EV6 PAL opcodes */
#define OPC32_EV6_HW_RET	(0x1E<<26 | 31<<21)
#define OPC32_EV6_HW_MFPR	(0x19<<26 | 31<<16)
#define OPC32_EV6_HW_MTPR	(0x1D<<26 | 31<<21)
#define OPC32_EV6_HW_LD	        (0x1B<<26)
#define OPC32_EV6_HW_ST	        (0x1F<<26)

