; HP 9895A floppy disk firmware
; Partially reverse-engineered by Eric Smith <spacewar@gmail.com>
; and Craig Ruff

; Cross-assembles with Macro Assembler AS:
;   http://john.ccac.rwth-aachen.de:8000/as/

; PHI chip (Processor to Hpib Interface) I/O ports

; Marketing blurb about PHI chip:
;   Hewlett-Packard Computer Advances, Volume 2 Number 4, November 1977
;   included in Computerworld, Volume XI Number 46, November 14, 1977
;
; General description of the PHI chip:
;   "PHI, the HP-IB Interface Chip", John W. Figueroa,
;   Hewlett Packard Journal, Volume 29 Number 11, July 1978, pp. 16-16
;
; Detailed information about PHI chip:
;   "HP 12009A HP-IB Interface Reference Manual",
;   manual part number 12009-90001, September 1982

; Note that HP 12009A inverts address A1 (A14 in HP numbering), so
; register numbering doesn't match that documentation.

; The 9895A uses the PHI in the 8-bit mode, so the D0 (bit 9) and D1 (bit 8) bits
; in these registers must be indirectly accessed via the phi_status register
; "high order bit access" bits 7 and 6.

phi_int_cond	port	10h	; PHI register 2 (HP 12009A numbering)
                bdef    7, INT_PEND     ; bit D0: interrupt pending (in phi_status)
                bdef    6, PRTY_ERR     ; bit D1: parity error (in phi_status)
		bdef    7, STAT_CHNG    ; bit 7: status change
		bdef    6, PROC_ABRT    ; bit 6: processor handshake abort
		bdef    5, PP_RESP      ; bit 5: parallel poll response
		bdef    4, SERV_RQST    ; bit 4: service request
		bdef    3, FIFO_ROOM    ; bit 3: fifo room available
		bdef    2, FIFO_BYTE    ; bit 2: fifo bytes available
		bdef    1, FIFO_IDLE    ; bit 1: fifo idle
		bdef    0, DEV_CLR      ; bit 0: device clear

phi_int_mask	port	11h	; PHI register 3 (HP 12009A numbering)
                bdef    7, INT_ENAB     ; bit D0: INT ENAB
                                        ; bits D1,7..0: interrupt mask corresponding to phi_int_cond bits

phi_fifo	port	12h	; PHI register 0 (HP 12009A numbering)
				; bit 15..14: 00 - RX/TX normal data
				;             01 - RX secondary address
				;	      01 - TX interface command
				; 	      10 - TX byte count (controller)
				;             11 - RX end
				;	      11 - TX uncounted transfer enable
				; bits 7..0: data
                                ; inbound  fifo has 8 entries
                                ; outbound fifo has 8 entries

                bdef    7, OUT_END      ; out (D0) assert END with this byte (EOI)

                equ     IN_EOI, 0c0h    ; last byte of record (EOI)
                bdef    6, SAD_D1       ; in  (D1) SAD received
                bdef    5, TLK          ; in Received SAD is a talk address
                bfield  4, 0, SAD       ; in The SAD

phi_status	port	13h	; PHI register 1 (HP 12009A numbering)
                bfield  7, 6, D0D1      ; bits 7..6: high order bit access
                bdef    1, D0
                bdef    6, D1
		bdef    5, REM          ; bit 5: Remote state
		bdef    4, HPIB_CTRL    ; bit 4: HP-IB Controller
		bdef    3, SYST_CTRL    ; bit 3: HP-IB System Controller
		bdef    2, TLK_IDF      ; bit 2: Addressed to talk or identify
		bdef    1, LTN          ; bit 1: Addressed to listen
		bdef    0, DATA_FRZ     ; bit 0: Outbound data freeze

phi_id1		port	16h	; PHI register 4 (HP 12009A numbering)
                                        ; device mode: IDENTIFY byte 1

phi_id2		port	17h	; PHI register 5 (HP 12009A numbering)
                                        ; device mode: IDENTIFY byte 2

phi_control	port	14h	; PHI register 6 (HP 12009A numbering)
                bdef 7, POLL_HLDF       ; bit D0: Don't respond to parallel poll if data freeze active
                bdef 6, DHSK_DLY        ; bit D1: require NDAC and NRFD remain false for a period before sensing them
		bdef 7, EIGHT_BIT       ; bit 7: 8-bit processor
		bdef 6, PRTY_FRZ        ; bit 6: parity freeze
		bdef 5, REN             ; bit 5: REN value
		bdef 4, IFC             ; bit 4: IFC value
		bdef 3, RSPD_PP         ; bit 3: respond to parallel poll
		bdef 2, RQST_SRVC       ; bit 2: request service
		bdef 1, FIFO_SEL        ; bit 1: DMA fifo select
		bdef 0, INIT_FIFO       ; bit 0: initialize outbound FIFO (write only)

phi_address	port	15h	; PHI register 7 (HP 12009A numbering)
                bdef    7, CRCE         ; bit D0: enable CRC SAD processing (see page 3-25a)
                bdef    6, EPAR         ; bit D1: generate even parity on the HP-IB bus
                bdef    7, ONL          ; bit 7: PHI online to HP-IB bus
                bdef    6, TA           ; bit 6: talk always
                bdef    5, LA           ; bit 5: listen always
                bfield  4, 0, ADDRESS_PHI ; bits 4..0: HP-IB address
