/**********************************************************/
/* IBM 3278 keyboard to PS/2                              */
/*                                                        */
/* Copyright (c) 2013, Henk Stegeman                      */
/*                                                        */
/* All rights reserved.                                   */
/*                                                        */
/* This program is free software; you can redistribute it */
/* and/or modify it under the terms of the GNU General    */
/* Public License as published by the Free Software       */
/* Foundation; either version 2 of the License, or        */
/* (at your option) any later version.                    */
/*                                                        */
/* This program is distributed in the hope that it will   */
/* be useful, but WITHOUT ANY WARRANTY; without even the  */
/* implied warranty of MERCHANTABILITY or FITNESS FOR A   */
/* PARTICULAR PURPOSE.  See the GNU General Public        */
/* License for more details.                              */
/*                                                        */
/* You should have received a copy of the GNU General     */
/* Public License along with this program; if not, write  */
/* to the Free Software Foundation, Inc.,                 */
/* 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/*                                                        */
/* Licence can be viewed at                               */
/* http://www.fsf.org/licenses/gpl.txt                    */
/*                                                        */
/**********************************************************/

// IBM keyboard includes
 
#include <inttypes.h>

// Keyboard bus & control pins.
#define KB_IDENT_0    PINB0
#define KB_IDENT_1    PINB1
#define KB_MAK_BRK    PINB7
#define KB_DATA_AVAIL PIND3 
#define KB_ACK        PIND4
#define KB_SCAN_6     PIND6

// PS/2 bus pins.
#define PS2_CLK_OUT   PINB2
#define PS2_DATA_INP  PIND2
#define PS2_CLK_INP   PIND5
#define PS2_DATA_OUT  PIND7

// ALT key
#define ALT_ON TRUE
#define ALT_OFF FALSE
#define ALT_MAKE      0x79
#define ALT_BREAK     0xF9

// SHIFT keys
#define SHIFT_ON TRUE
#define SHIFT_OFF FALSE
#define CAPS_MAKE     0x19
#define CAPS_BREAK    0x99
#define LSHIFT_MAKE   0x59
#define LSHIFT_BREAK  0xD9
#define RSHIFT_MAKE   0x39
#define RSHIFT_BREAK  0xB9

// PS/2 
#define PS2_ACK       0xFA
#define SELF_TEST_OK  0xAA

// Buffer overflow
#define BUF_OVERFLOW  0xFF

// UART transmit pin.
#define UART_TX       PIND1

// Used routines
void init_io(void);
void ms_delay(uint16_t ms);
void kbd_to_ps2(uint8_t kbd_scan_code, uint8_t shift_state, uint8_t alt_state);




