/**********************************************************/
/* IBM 3278 keyboard to PS/2                              */
/*                                                        */
/* Copyright (c) 2013, Henk Stegeman                      */
/*                                                        */ 
/* All rights reserved.                                   */
/*                                                        */
/* This program is free software; you can redistribute it */
/* and/or modify it under the terms of the GNU General    */
/* Public License as published by the Free Software       */
/* Foundation; either version 2 of the License, or        */
/* (at your option) any later version.                    */
/*                                                        */
/* This program is distributed in the hope that it will   */
/* be useful, but WITHOUT ANY WARRANTY; without even the  */
/* implied warranty of MERCHANTABILITY or FITNESS FOR A   */
/* PARTICULAR PURPOSE.  See the GNU General Public        */
/* License for more details.                              */
/*                                                        */
/* You should have received a copy of the GNU General     */
/* Public License along with this program; if not, write  */
/* to the Free Software Foundation, Inc.,                 */
/* 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/*                                                        */
/* Licence can be viewed at                               */
/* http://www.fsf.org/licenses/gpl.txt                    */
/*                                                        */
/**********************************************************/

// Global definitions

#ifndef GLOBAL_H
   #define GLOBAL_H

#include <inttypes.h>

// Macro's

#define outp(data, addr) addr = (data)
#define inp(addr) (addr)

#ifndef BV
	#define BV(bit) (1 << (bit))
#endif

#ifndef cbi
	#define cbi(reg,bit)	reg &= ~(BV(bit))
#endif

#ifndef sbi
	#define sbi(reg,bit)	reg |= (BV(bit))
#endif

#define TRUE  1
#define FALSE 0

#define MAKE  1
#define BREAK 0

// CPU clock speed, make your choice... 

//#define F_CPU         7372800UL              		// 7.372MHz processor
//#define F_CPU         8000000UL              		// 8MHz processor
//#define F_CPU        10000000UL              		// 10MHz processor
//#define F_CPU        12000000UL              		// 12MHz processor
#define F_CPU          14760300UL             		// 14.76MHz processor
//#define F_CPU        16000000UL              		// 16MHz processor
//#define F_CPU        20000000UL              		// 20MHz processor

#define CYCLES_PER_US ((F_CPU+500000)/1000000) 	   // Nr of CPU cycles / microsecond

#endif
