	title	'Loader BIOS for CP/M 3.0 & PMC-101'

 ;	*****************************************************
 ;	*                                                   *
 ;	*	NOTE:                                       *
 ;	*                                                   *
 ;	*       DO NOT MODIFY ANY CODE IN THIS MODULE       *
 ;	*                                                   *
 ;	*        PMC CANNOT SUPPORT ANY MODIFICATIONS       *
 ;	*            	                                    *
 ;	*****************************************************


 ;		'LDRBIOS'
 ;		' Copyright (C), 1983	Personal Micro Computers, Inc.'
 ;		' 475 Ellis St. Mountain View, CA  94304'
 ;		' version 3.0       6 June 1983'
 ;
 ;	Requirements:
 ;
 ;	   Must Boot from a PMC-101 Double Density Diskette with 1024 byte sectors.
 ;
 ;	   Drive must be able to step at 6ms or faster.
 ;
 ;
 ;	To Implement:
 ;		SUBMIT LDR<RETURN>
 ;		<RESET>
 ;

	maclib z80
	maclib cpm3
	maclib ports
	maclib PMCequ

	extrn	@mxtpa

    ; BIOS Jump vector.
Loader:
	jmp	boot	; initial entry on cold start
?wboot:	jmp	wboot	; reentry on program exit, warm start
	jmp	const	; return console input status
	jmp	conin	; return console input character
	jmp	conout	; send console output character
	jmp	list	; send list output character
	jmp	auxout	; send auxilliary output character
	jmp	auxin	; return auxilliary input character
	jmp	home	; set disks to logical home
	jmp	seldsk	; select disk drive, return disk parameter info
	jmp	settrk	; set disk track
	jmp	setsec	; set disk sector
	jmp	setdma	; set disk I/O memory address
	jmp	read	; read physical block(s)
	jmp	write	; write physical block(s)
	jmp	listst	; return list device status
	jmp	sectrn	; translate logical to physical sector
	jmp	conost	; return console output status
	jmp	auxist	; return aux input status
	jmp	auxost	; return aux output status
	jmp	devtbl	; return address of device def table
	jmp	cinit	; change baud rate of device
	jmp	getdrv	; return address of disk drive table
	jmp	multio	; set multiple record count for disk I/O
	jmp	flush	; flush BIOS maintained disk caching
	jmp	move	; block move memory to memory
	jmp	time	; Signal Time and Date operation
	jmp	bnksel	; select bank for code execution and default DMA
	jmp	setbnk	; select different bank for disk I/O DMA operations.
	jmp	xmove	; set source and destination banks for one operation
	jmp	0	; reserved for future expansion
	jmp	0	; reserved for future expansion
	jmp	0	; reserved for future expansion


boot:
	DI
	mvi	a,JMP
	sta	0
	sta	5		; set up jumps in page zero
	lxi	h,?wboot
	shld	1		; BIOS warm start entry
	lhld	@MXTPA
	shld	6		; BDOS system call entry
	ret

conout:
	call	conost
	ora	a
	jrz	conout
	mov	a,c
	out	p$TRM$data
	ret

conost:
	in	p$TRM$stat
	ani	4		;check TBE
	mvi	a,0
	rz
	ori	-1
	ret

seldsk:
	lxi	h,dph0		;force drive A
	ret

home:
	call	restore
	lxi	b,0		; same as set track zero
settrk:	mov	l,c
	mov	h,b
	shld	@trk
	ret

setsec:
	mov	l,c
	mov	h,b
	shld	@sect
	ret

setdma:
	mov	l,c
	mov	h,b
	shld	@dma
	ret

sectrn:
	mov	l,c
	mov	h,b
	mov	a,d
	ora	e
	rz
	xchg
	dad	b
	mov	l,m
	mvi	h,0
	ret

read:
	mvi	a,RDCmd
	sta	dskcmd
	lxi	h,oldtrk
	mov	a,m
	out	p$fdtrack	;put cur Trk for this Drv back in tk reg
	lxi	h,dskcmd
	lda	@sect		;get desired Sector
	cpi	sctcnt+1	;see if <=physical Sec/Trk
	res	SIDbit,m	;preset for for yes (side0 in 1797cmnd)
	jrc	RWe$0		;skip if yes
	setb	SIDbit,m	;else set Side 1 bit in 1797 cmnd
RWe$0:	call	SelDrv		;Select & check for Disk
RWe$1:	xra	A		;clear retry count
	sta	RtyCnt
RWe$2:	lxi	h,oldtrk
	lda	@sect
	cpi	sctcnt+1		;see if <= to physical Sec/Trk
	jrc	side0		;if so skip
	sui	sctcnt		;else cnvrt Sec 6 thru 10  to  01 thru 05
side0:	out	p$fdsector	;set Sector
	mvi	a,0FFH		;if Drv not previously Selected
	cmp	m
	jz	RWd$1		;then do a home & go back to RWe$2
	lda	@trk		;else get desired track
	cmp	m		;see if =current track
	jrz	noSek		;if so skip seek
	out	p$fddata	;else output track to data port
	mov	m,a
	call	f$seek
noSek:	call	f$force
	mvi	C,p$fddata
	lhld	@dma
	lda	dskcmd
	di
	out	p$fdcmnd
	call	Delay
RDent:	in	p$fdcmnd
	bit	1,A		;check DRQ
	jrz	noDRQ1
	ini
noDRQ1:	bit	0,A		;check busy
	jnz	RDent
RWdon:	ei
	ani	1CH		;mask errors
	rz
	lxi	h,RtyCnt
	inr	m		;up retry count
	mov	a,m
	cpi	Retries		;see if max
	jrz	MaxRty		;if so set to NZ and ret
RWd$1:	call	restore
	jmp	RWe$2		;else home & reseek
MaxRty:
	mvi	a,1
	ret

 ;**************
SelDrv:
	in	p$fdcmnd	;check FOR TIMEOUT
	rlc
	push	psw		;C=not READY
	lda	selmsk		;reSelect Drv
	out	p$select
	pop	psw
	rnc
	mvi	a,Seldly
	call	Delay2
DSKin?:	in	p$fdcmnd
	rrc
	jrc	DSKin?		;loop until not busy
	call	f$force
	ani	00000010B	;check index
	mov	D,A		;save index status
	mvi	H,4EH		;set counter
din$2:	dcx	h		;drop counter
	mov	a,H
	ora	L
	jrz	DSKin?		;if counter expires try again
	in	p$fdcmnd
	ani	00000010B	;check index
	cmp	D		;compare it to last index status
	mov	D,A		;save new status
	jrz	din$2		;loop back if equal
	ret

 ;**********
f$force:
	mvi	a,frcCmd
	out	p$fdcmnd
	call	Delay
	in	p$fddata
	in	p$fdcmnd
	mvi	a,frcCmd
	out	p$fdcmnd
	call	Delay
	in	p$fdcmnd
	ret

 ;**********
f$seek:
	ora	A
	jrz	restore
	out	p$fddata	;else output track to p$fddata
	mvi	a,sekCmd	;seek command
	out	p$fdcmnd	;output to p$fdcmnd
	call	Delay
sk$1:	in	p$fdcmnd
	rrc			;check busy
	jrc	sk$1
	mvi	a,Sekdly	;Wait for STEP to settle
	call	Delay2		;18ms
	ret

 ;**********
restore:
	call	f$force
	BIT	7,A
	jrnz	restore
	call	f$force
	mvi	a,homCmd
	out	p$fdcmnd
wait3:	call	Delay
	in	p$fdcmnd
	bit	0,a
	jrnz	wait3
	lxi	h,oldtrk
	mvi	m,0		;UpDate Track#
	ret

 ;**********
Delay:
	push	b		;44us
	lxi	b,5
USRdly:	dcx	b
	mov	a,B
	ora	C
	jrnz	USRdly
	pop	b
	ret

 ;**********
Delay2:
	push	d		;4945.25us*A+14us
	push	b
	mov	C,A
D12$1:	lxi	d,0760
D12$2:	dcx	d
	mov	a,E
	ora	D
	jrnz	D12$2
	dcr	C
	jrnz	D12$1
	pop	b
	pop	d
	ret

getdrv:
	lxi	h,@dtbl
	ret

move:
	xchg		; we are passed source in DE and dest in HL
	ldir		; use Z80 block move instruction
	xchg		; need next addresses in same regs
	ret

wboot:			;Non implemented routines
const:
conin:
list:
auxout:
auxin:
write:
listst:
auxist:
auxost:
devtbl:
cinit:
multio:
flush:
time:
bnksel:
setbnk:
xmove:
f$init:
f$login:
	xra	a
	ret			; return with no error

 ;**************************************************************************

@dtbl	dw 	dph0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
ddtrans	db	1,2,3,4,5,6,7,8,9,10

dph0	dph     ddtrans,dpbddds,32,51
dpbddds	dpb 	1024,10,40,2048,128,1

@trk	ds	2		; current track number
@sect	ds	2		; current sector number
@dma	ds	2		; current DMA address
selmsk:	db	drvAon		; current drive select code
RtyCnt:	db	retries		;disk retry count
oldtrk:	db	-1
dskcmd:	db	RDcmd		; current wd1797 command

max$len	equ	600h	;max permissable length of LDRBIOS
			; Max$len =
			;  (sector length*(sector qty-1))-length of CPMLDR.REL
			;   Length of CPMLDR.IMG should = 1000h 

	ds	max$len-($-Loader)	;create dummy filler to pad Trk0.img
					; so CCP.img will merge to proper 
					; location.
	end

