// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package crt_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateCrtStoreCreatedCode is the HTTP code returned for type CreateCrtStoreCreated
const CreateCrtStoreCreatedCode int = 201

/*
CreateCrtStoreCreated Certificate Store created

swagger:response createCrtStoreCreated
*/
type CreateCrtStoreCreated struct {

	/*
	  In: Body
	*/
	Payload *models.CrtStore `json:"body,omitempty"`
}

// NewCreateCrtStoreCreated creates CreateCrtStoreCreated with default headers values
func NewCreateCrtStoreCreated() *CreateCrtStoreCreated {

	return &CreateCrtStoreCreated{}
}

// WithPayload adds the payload to the create crt store created response
func (o *CreateCrtStoreCreated) WithPayload(payload *models.CrtStore) *CreateCrtStoreCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create crt store created response
func (o *CreateCrtStoreCreated) SetPayload(payload *models.CrtStore) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateCrtStoreCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateCrtStoreAcceptedCode is the HTTP code returned for type CreateCrtStoreAccepted
const CreateCrtStoreAcceptedCode int = 202

/*
CreateCrtStoreAccepted Configuration change accepted and reload requested

swagger:response createCrtStoreAccepted
*/
type CreateCrtStoreAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.CrtStore `json:"body,omitempty"`
}

// NewCreateCrtStoreAccepted creates CreateCrtStoreAccepted with default headers values
func NewCreateCrtStoreAccepted() *CreateCrtStoreAccepted {

	return &CreateCrtStoreAccepted{}
}

// WithReloadID adds the reloadId to the create crt store accepted response
func (o *CreateCrtStoreAccepted) WithReloadID(reloadID string) *CreateCrtStoreAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create crt store accepted response
func (o *CreateCrtStoreAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create crt store accepted response
func (o *CreateCrtStoreAccepted) WithPayload(payload *models.CrtStore) *CreateCrtStoreAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create crt store accepted response
func (o *CreateCrtStoreAccepted) SetPayload(payload *models.CrtStore) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateCrtStoreAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateCrtStoreBadRequestCode is the HTTP code returned for type CreateCrtStoreBadRequest
const CreateCrtStoreBadRequestCode int = 400

/*
CreateCrtStoreBadRequest Bad request

swagger:response createCrtStoreBadRequest
*/
type CreateCrtStoreBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateCrtStoreBadRequest creates CreateCrtStoreBadRequest with default headers values
func NewCreateCrtStoreBadRequest() *CreateCrtStoreBadRequest {

	return &CreateCrtStoreBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create crt store bad request response
func (o *CreateCrtStoreBadRequest) WithConfigurationVersion(configurationVersion string) *CreateCrtStoreBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create crt store bad request response
func (o *CreateCrtStoreBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create crt store bad request response
func (o *CreateCrtStoreBadRequest) WithPayload(payload *models.Error) *CreateCrtStoreBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create crt store bad request response
func (o *CreateCrtStoreBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateCrtStoreBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateCrtStoreConflictCode is the HTTP code returned for type CreateCrtStoreConflict
const CreateCrtStoreConflictCode int = 409

/*
CreateCrtStoreConflict The specified resource already exists

swagger:response createCrtStoreConflict
*/
type CreateCrtStoreConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateCrtStoreConflict creates CreateCrtStoreConflict with default headers values
func NewCreateCrtStoreConflict() *CreateCrtStoreConflict {

	return &CreateCrtStoreConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create crt store conflict response
func (o *CreateCrtStoreConflict) WithConfigurationVersion(configurationVersion string) *CreateCrtStoreConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create crt store conflict response
func (o *CreateCrtStoreConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create crt store conflict response
func (o *CreateCrtStoreConflict) WithPayload(payload *models.Error) *CreateCrtStoreConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create crt store conflict response
func (o *CreateCrtStoreConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateCrtStoreConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateCrtStoreDefault General Error

swagger:response createCrtStoreDefault
*/
type CreateCrtStoreDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateCrtStoreDefault creates CreateCrtStoreDefault with default headers values
func NewCreateCrtStoreDefault(code int) *CreateCrtStoreDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateCrtStoreDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create crt store default response
func (o *CreateCrtStoreDefault) WithStatusCode(code int) *CreateCrtStoreDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create crt store default response
func (o *CreateCrtStoreDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create crt store default response
func (o *CreateCrtStoreDefault) WithConfigurationVersion(configurationVersion string) *CreateCrtStoreDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create crt store default response
func (o *CreateCrtStoreDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create crt store default response
func (o *CreateCrtStoreDefault) WithPayload(payload *models.Error) *CreateCrtStoreDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create crt store default response
func (o *CreateCrtStoreDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateCrtStoreDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
