// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_errors

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"
)

// GetHTTPErrorsSectionHandlerFunc turns a function with the right signature into a get HTTP errors section handler
type GetHTTPErrorsSectionHandlerFunc func(GetHTTPErrorsSectionParams, interface{}) middleware.Responder

// Handle executing the request and returning a response
func (fn GetHTTPErrorsSectionHandlerFunc) Handle(params GetHTTPErrorsSectionParams, principal interface{}) middleware.Responder {
	return fn(params, principal)
}

// GetHTTPErrorsSectionHandler interface for that can handle valid get HTTP errors section params
type GetHTTPErrorsSectionHandler interface {
	Handle(GetHTTPErrorsSectionParams, interface{}) middleware.Responder
}

// NewGetHTTPErrorsSection creates a new http.Handler for the get HTTP errors section operation
func NewGetHTTPErrorsSection(ctx *middleware.Context, handler GetHTTPErrorsSectionHandler) *GetHTTPErrorsSection {
	return &GetHTTPErrorsSection{Context: ctx, Handler: handler}
}

/*
	GetHTTPErrorsSection swagger:route GET /services/haproxy/configuration/http_errors_sections/{name} HTTPErrors getHttpErrorsSection

# Return a http-error section

Returns one http-error section with a given name from the configuration.
*/
type GetHTTPErrorsSection struct {
	Context *middleware.Context
	Handler GetHTTPErrorsSectionHandler
}

func (o *GetHTTPErrorsSection) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewGetHTTPErrorsSectionParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal interface{}
	if uprinc != nil {
		principal = uprinc.(interface{}) // this is really a interface{}, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
