/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.ClientCertificateAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONCertificate;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONFormattedAccessLogFields;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONClientCertificateAccessLogMessage
extends JSONAccessLogMessage
implements ClientCertificateAccessLogMessage {
    private static final long serialVersionUID = -7815846275883142789L;
    @NotNull
    private final List<JSONCertificate> peerCertificateChain;
    @Nullable
    private final String autoAuthenticatedAsDN = this.getString(JSONFormattedAccessLogFields.AUTO_AUTHENTICATED_AS);

    public JSONClientCertificateAccessLogMessage(@NotNull JSONObject jsonObject) throws LogException {
        super(jsonObject);
        List<JSONValue> certValues = jsonObject.getFieldAsArray(JSONFormattedAccessLogFields.PEER_CERTIFICATE_CHAIN.getFieldName());
        if (certValues == null) {
            this.peerCertificateChain = Collections.emptyList();
        } else {
            ArrayList<JSONCertificate> certList = new ArrayList<JSONCertificate>(certValues.size());
            for (JSONValue v : certValues) {
                if (v instanceof JSONObject) {
                    certList.add(new JSONCertificate((JSONObject)v));
                    continue;
                }
                certList.clear();
                break;
            }
            this.peerCertificateChain = Collections.unmodifiableList(certList);
        }
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.CLIENT_CERTIFICATE;
    }

    @NotNull
    public List<JSONCertificate> getPeerCertificateChain() {
        return this.peerCertificateChain;
    }

    @Override
    @Nullable
    public String getPeerSubjectDN() {
        if (this.peerCertificateChain.isEmpty()) {
            return null;
        }
        return this.peerCertificateChain.get(0).getSubjectDN();
    }

    @Override
    @NotNull
    public List<String> getIssuerSubjectDNs() {
        ArrayList<String> issuerSubjectDNs = new ArrayList<String>();
        for (JSONCertificate c : this.peerCertificateChain) {
            String issuerSubjectDN = c.getIssuerSubjectDN();
            if (issuerSubjectDN == null) {
                issuerSubjectDNs.clear();
                break;
            }
            if (issuerSubjectDNs.contains(issuerSubjectDN)) continue;
            issuerSubjectDNs.add(issuerSubjectDN);
        }
        return Collections.unmodifiableList(issuerSubjectDNs);
    }

    @Override
    @Nullable
    public String getAutoAuthenticatedAsDN() {
        return this.autoAuthenticatedAsDN;
    }
}

