//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
/// \file optical/wls/include/WLSDetectorMessenger.hh
/// \brief Definition of the WLSDetectorMessenger class
//

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....
//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

#ifndef WLSDetectorMessenger_h
#define WLSDetectorMessenger_h 1

#include "WLSDetectorConstruction.hh"

#include "G4UImessenger.hh"

class G4UIdirectory;
class G4UIcmdWithABool;
class G4UIcmdWithAString;

class G4UIcmdWithADouble;
class G4UIcmdWithAnInteger;
class G4UIcmdWithADoubleAndUnit;
class G4UIcmdWithoutParameter;
class G4UIcmdWithoutParameter;

class WLSDetectorMessenger : public G4UImessenger
{
  public:
    WLSDetectorMessenger(WLSDetectorConstruction*);
    ~WLSDetectorMessenger() override;

    void SetNewValue(G4UIcommand*, G4String) override;

  private:
    WLSDetectorConstruction* fDetector = nullptr;

    G4UIdirectory* fDetDir = nullptr;

    G4UIcmdWithAString* fSetPhotonDetGeometryCmd = nullptr;
    G4UIcmdWithAnInteger* fSetNumOfCladLayersCmd = nullptr;
    G4UIcmdWithADoubleAndUnit* fSetWLSLengthCmd = nullptr;
    G4UIcmdWithADoubleAndUnit* fSetWLSRadiusCmd = nullptr;
    G4UIcmdWithADoubleAndUnit* fSetClad1RadiusCmd = nullptr;
    G4UIcmdWithADoubleAndUnit* fSetClad2RadiusCmd = nullptr;
    G4UIcmdWithADoubleAndUnit* fSetPhotonDetHalfLengthCmd = nullptr;
    G4UIcmdWithADoubleAndUnit* fSetGapCmd = nullptr;
    G4UIcmdWithADoubleAndUnit* fSetPhotonDetAlignmentCmd = nullptr;
    G4UIcmdWithADouble* fSetXYRatioCmd = nullptr;
    G4UIcmdWithADouble* fSetSurfaceRoughnessCmd = nullptr;
    G4UIcmdWithADouble* fSetMirrorPolishCmd = nullptr;
    G4UIcmdWithADouble* fSetMirrorReflectivityCmd = nullptr;
    G4UIcmdWithADouble* fSetPhotonDetPolishCmd = nullptr;
    G4UIcmdWithADouble* fSetPhotonDetReflectivityCmd = nullptr;
    G4UIcmdWithABool* fSetMirrorCmd = nullptr;
    G4UIcmdWithADoubleAndUnit* fSetBarLengthCmd = nullptr;
    G4UIcmdWithADoubleAndUnit* fSetBarBaseCmd = nullptr;
    G4UIcmdWithADoubleAndUnit* fSetHoleRadiusCmd = nullptr;
    G4UIcmdWithADoubleAndUnit* fSetCoatingThicknessCmd = nullptr;
    G4UIcmdWithADoubleAndUnit* fSetCoatingRadiusCmd = nullptr;
};

#endif
