//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
/// \file runAndEvent/RE03/src/RE03DetectorConstruction.cc
/// \brief Implementation of the RE03DetectorConstruction class
//
//

#include "RE03DetectorConstruction.hh"

#include "G4Box.hh"
#include "G4Colour.hh"
#include "G4LogicalVolume.hh"
#include "G4Material.hh"
#include "G4MultiFunctionalDetector.hh"
#include "G4NistManager.hh"
#include "G4PSEnergyDeposit.hh"
#include "G4PSNofStep.hh"
#include "G4PSTrackLength.hh"
#include "G4PVPlacement.hh"
#include "G4SDManager.hh"
#include "G4SDParticleFilter.hh"
#include "G4SystemOfUnits.hh"
#include "G4VPrimitiveScorer.hh"
#include "G4VisAttributes.hh"
#include "G4ios.hh"

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......
RE03DetectorConstruction::RE03DetectorConstruction()
  : G4VUserDetectorConstruction(),
    fAir(0),
    fWater(0),
    fWorldPhys(0),
    fPhantomPhys(0),
    fConstructed(false)
{
  ;
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......
RE03DetectorConstruction::~RE03DetectorConstruction()
{
  ;
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......
G4VPhysicalVolume* RE03DetectorConstruction::Construct()
{
  if (!fConstructed) {
    fConstructed = true;
    DefineMaterials();
    SetupGeometry();
  }
  return fWorldPhys;
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......
void RE03DetectorConstruction::DefineMaterials()
{
  //-------- NIST Materials -----------------------------------------------
  //  Material Information imported from NIST database.
  G4NistManager* NISTman = G4NistManager::Instance();
  fWater = NISTman->FindOrBuildMaterial("G4_WATER");
  fAir = NISTman->FindOrBuildMaterial("G4_AIR");
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......
void RE03DetectorConstruction::SetupGeometry()
{
  //
  // World
  //
  G4VSolid* worldSolid = new G4Box("World", 2. * m, 2. * m, 2. * m);
  G4LogicalVolume* worldLogical = new G4LogicalVolume(worldSolid, fAir, "World");
  fWorldPhys = new G4PVPlacement(0, G4ThreeVector(), worldLogical, "World", 0, false, 0);

  //
  // Phantom
  //
  G4VSolid* phantomSolid = new G4Box("Calor", 1. * m, 1. * m, 1. * m);
  G4LogicalVolume* phantomLogical = new G4LogicalVolume(phantomSolid, fWater, "Phantom");
  fPhantomPhys =
    new G4PVPlacement(0, G4ThreeVector(), phantomLogical, "Phantom", worldLogical, false, 0);
  //
  // Visualization attributes
  //
  // worldLogical->SetVisAttributes(G4VisAttributes::GetInvisible());
  G4VisAttributes* simpleBoxVisAtt = new G4VisAttributes(G4Colour(1.0, 1.0, 1.0));
  simpleBoxVisAtt->SetVisibility(true);
  phantomLogical->SetVisAttributes(simpleBoxVisAtt);
}

void RE03DetectorConstruction::ConstructSDandField()
{
  ;
}
