/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.defaults;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.CfaEdge;
import proguard.analysis.cpa.interfaces.CfaNode;
import proguard.analysis.cpa.interfaces.ProgramLocationDependent;
import proguard.analysis.cpa.interfaces.ReachedSet;
import proguard.classfile.Signature;

public final class ProgramLocationDependentReachedSet<CfaNodeT extends CfaNode<CfaEdgeT, SignatureT>, CfaEdgeT extends CfaEdge<CfaNodeT>, AbstractStateT extends AbstractState & ProgramLocationDependent<CfaNodeT, CfaEdgeT, SignatureT>, SignatureT extends Signature>
implements ReachedSet {
    private Map<CfaNodeT, Set<AbstractStateT>> locationToStates = new HashMap<CfaNodeT, Set<AbstractStateT>>();

    @Override
    public boolean add(AbstractState abstractState) {
        boolean[] result = new boolean[]{false};
        HashSet<AbstractState> newValue = new HashSet<AbstractState>();
        AbstractState state = abstractState;
        newValue.add(state);
        this.locationToStates.merge(((ProgramLocationDependent)((Object)state)).getProgramLocation(), newValue, (oldStates, newStates) -> {
            result[0] = oldStates.addAll(newStates);
            return oldStates;
        });
        return result[0];
    }

    @Override
    public boolean addAll(Collection<? extends AbstractState> abstractStates) {
        return abstractStates.stream().map(this::add).collect(Collectors.toCollection(HashSet::new)).stream().anyMatch(b -> b);
    }

    @Override
    public boolean remove(AbstractState abstractState) {
        AtomicBoolean result = new AtomicBoolean(false);
        AbstractState state = abstractState;
        HashSet newValue = new HashSet();
        this.locationToStates.merge(((ProgramLocationDependent)((Object)state)).getProgramLocation(), newValue, (oldStates, newStates) -> {
            result.set(oldStates.remove(state));
            return oldStates;
        });
        return result.get();
    }

    @Override
    public boolean removeAll(Collection<?> abstractStates) {
        return abstractStates.stream().map(state -> this.remove((AbstractState)state)).collect(Collectors.toCollection(HashSet::new)).stream().anyMatch(b -> b);
    }

    public Collection<AbstractStateT> asCollection() {
        return this.locationToStates.values().stream().reduce(new HashSet(), (x, y) -> {
            x.addAll(y);
            return x;
        });
    }

    @Override
    public Collection<? extends AbstractState> getReached(AbstractState abstractState) {
        return this.getReached(((ProgramLocationDependent)((Object)abstractState)).getProgramLocation());
    }

    public Collection<? extends AbstractState> getReached(CfaNodeT location) {
        return this.locationToStates.getOrDefault(location, Collections.emptySet());
    }
}

