/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.util.ClassUtil;

public class InternalTypeEnumeration {
    private final String descriptor;
    private final int formalTypeParametersIndex;
    private final int openIndex;
    private final int closeIndex;
    private int index;

    public InternalTypeEnumeration(String descriptor) {
        this.descriptor = descriptor;
        int formalTypeParametersIndex = 0;
        if (descriptor.charAt(0) == '<') {
            formalTypeParametersIndex = 1;
            int nestingLevel = 1;
            do {
                char c = descriptor.charAt(formalTypeParametersIndex++);
                switch (c) {
                    case '<': {
                        ++nestingLevel;
                        break;
                    }
                    case '>': {
                        --nestingLevel;
                    }
                }
            } while (nestingLevel > 0);
        }
        this.formalTypeParametersIndex = formalTypeParametersIndex;
        this.openIndex = descriptor.indexOf(40, formalTypeParametersIndex);
        this.closeIndex = this.openIndex >= 0 ? descriptor.indexOf(41, this.openIndex) : descriptor.length();
        this.reset();
    }

    public int typeCount() {
        this.reset();
        int count = 0;
        while (this.hasMoreTypes()) {
            this.nextType();
            ++count;
        }
        this.reset();
        return count;
    }

    public int typesSize() {
        this.reset();
        int size = 0;
        while (this.hasMoreTypes()) {
            String type = this.nextType();
            size += ClassUtil.internalTypeSize(type);
        }
        this.reset();
        return size;
    }

    private void reset() {
        this.index = this.openIndex >= 0 ? this.openIndex + 1 : this.formalTypeParametersIndex;
    }

    public boolean hasFormalTypeParameters() {
        return this.formalTypeParametersIndex > 0;
    }

    public String formalTypeParameters() {
        return this.descriptor.substring(0, this.formalTypeParametersIndex);
    }

    public boolean isMethodSignature() {
        return this.openIndex >= 0;
    }

    public boolean hasMoreTypes() {
        return this.index < this.closeIndex;
    }

    public String nextType() {
        int startIndex = this.index;
        this.skipArray();
        char c = this.descriptor.charAt(this.index++);
        switch (c) {
            case 'L': 
            case 'T': {
                this.skipClass();
                break;
            }
            case '<': {
                this.skipGeneric();
            }
        }
        return this.descriptor.substring(startIndex, this.index);
    }

    public String returnType() {
        return this.descriptor.substring(this.closeIndex + 1);
    }

    private void skipArray() {
        while (this.descriptor.charAt(this.index) == '[') {
            ++this.index;
        }
    }

    private void skipClass() {
        while (true) {
            char c = this.descriptor.charAt(this.index++);
            switch (c) {
                case '<': {
                    this.skipGeneric();
                    break;
                }
                case ';': {
                    return;
                }
            }
        }
    }

    private void skipGeneric() {
        int nestingLevel = 1;
        do {
            char c = this.descriptor.charAt(this.index++);
            switch (c) {
                case '<': {
                    ++nestingLevel;
                    break;
                }
                case '>': {
                    --nestingLevel;
                }
            }
        } while (nestingLevel > 0);
    }

    public static void main(String[] args2) {
        try {
            for (int index = 0; index < args2.length; ++index) {
                String descriptor = args2[index];
                System.out.println("Descriptor [" + descriptor + "]");
                InternalTypeEnumeration enumeration = new InternalTypeEnumeration(descriptor);
                if (enumeration.hasFormalTypeParameters()) {
                    System.out.println("  Formal type parameters [" + enumeration.formalTypeParameters() + "]");
                }
                while (enumeration.hasMoreTypes()) {
                    System.out.println("  Type [" + enumeration.nextType() + "]");
                }
                if (!enumeration.isMethodSignature()) continue;
                System.out.println("  Return type [" + enumeration.returnType() + "]");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

