/*
 * Decompiled with CFR 0.152.
 */
package proguard.configuration;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationLogger
implements Runnable {
    private static final Logger logger = LogManager.getLogger(ConfigurationLogger.class);
    private static final boolean LOG_ONCE = false;
    private static final String ANDROID_UTIL_LOG = "android.util.Log";
    private static final String LOG_TAG = "ProGuard";
    private static final String CLASS_CLASS = "Class";
    private static final String CLASS_CLASS_LOADER = "ClassLoader";
    private static final String METHOD_FOR_NAME = "forName";
    private static final String METHOD_LOAD_CLASS = "loadClass";
    private static final String METHOD_GET_DECLARED_FIELD = "getDeclaredField";
    private static final String METHOD_GET_FIELD = "getField";
    private static final String METHOD_GET_DECLARED_CONSTRUCTOR = "getDeclaredConstructor";
    private static final String METHOD_GET_CONSTRUCTOR = "getConstructor";
    private static final String METHOD_GET_DECLARED_METHOD = "getDeclaredMethod";
    private static final String METHOD_GET_METHOD = "getMethod";
    private static final String KEEP = "-keep";
    private static final String KEEP_CLASS_MEMBERS = "-keepclassmembers";
    public static final String CLASS_MAP_FILENAME = "classmap.txt";
    public static final int CLASS_KEPT = 1;
    public static final int ALL_DECLARED_CONSTRUCTORS_KEPT = 2;
    public static final int ALL_PUBLIC_CONSTRUCTORS_KEPT = 4;
    public static final int ALL_DECLARED_FIELDS_KEPT = 8;
    public static final int ALL_PUBLIC_FIELDS_KEPT = 16;
    public static final int ALL_DECLARED_METHODS_KEPT = 32;
    public static final int ALL_PUBLIC_METHODS_KEPT = 64;
    public static final int CLASS_SHRUNK = 128;
    public static final int MEMBER_KEPT = 1;
    public static final int MEMBER_SHRUNK = 2;
    private static final String EMPTY_LINE = "\u00a0\n";
    private static final String INIT = "<init>";
    private static final int FNV_HASH_INIT = -2128831035;
    private static final int FNV_HASH_PRIME = 16777619;
    private static final Method logMethod = ConfigurationLogger.getLogMethod();
    private static final Map<String, ClassInfo> sObfuscatedClassNameInfoMap = new HashMap<String, ClassInfo>();
    private static final Set<String> sMissingClasses = new HashSet<String>();
    private static final Map<String, Set<String>> sMissingFields = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> sMissingMethods = new HashMap<String, Set<String>>();
    private static final Set<String> sFieldListingCLasses = new HashSet<String>();
    private static final Set<String> sConstructorListingClasses = new HashSet<String>();
    private static final Set<String> sMethodListingClasses = new HashSet<String>();

    public static void checkForName(String reflectedClassName, String callingClassName) {
        ConfigurationLogger.checkClass(CLASS_CLASS, METHOD_FOR_NAME, reflectedClassName, callingClassName);
    }

    public static void checkLoadClass(String reflectedClassName, String callingClassName) {
        ConfigurationLogger.checkClass(CLASS_CLASS_LOADER, METHOD_LOAD_CLASS, reflectedClassName, callingClassName);
    }

    public static void checkClass(String reflectionClassName, String reflectionMethodName, String reflectedClassName, String callingClassName) {
        ClassInfo classInfo = sObfuscatedClassNameInfoMap.get(reflectedClassName);
        if (classInfo == null) {
            return;
        }
        if (ConfigurationLogger.isKept(classInfo)) {
            return;
        }
        if (ConfigurationLogger.shouldLog(sMissingClasses, reflectedClassName)) {
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(callingClassName) + "' is calling " + reflectionClassName + "." + reflectionMethodName + " to retrieve\nthe class '" + reflectedClassName + "'" + (ConfigurationLogger.originalClassName(reflectedClassName).equals(reflectedClassName) ? "" : "(originally '" + ConfigurationLogger.originalClassName(reflectedClassName) + "')") + ", but there is no rule to keep the class.\nYou should consider preserving the class,\nwith a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepClassRule(ConfigurationLogger.originalClassName(reflectedClassName)));
        }
    }

    public static void checkGetField(Class reflectedClass, String reflectedFieldName, String callingClassName) {
        ConfigurationLogger.checkGetField(METHOD_GET_FIELD, reflectedClass, reflectedFieldName, callingClassName);
    }

    public static void checkGetDeclaredField(Class reflectedClass, String reflectedFieldName, String callingClassName) {
        ConfigurationLogger.checkGetField(METHOD_GET_DECLARED_FIELD, reflectedClass, reflectedFieldName, callingClassName);
    }

    private static void checkGetField(String reflectionMethodName, Class reflectedClass, String reflectedFieldName, String callingClassName) {
        MemberInfo fieldInfo = ConfigurationLogger.getDeclaringClass(reflectedClass, reflectedFieldName);
        if (fieldInfo != null && !ConfigurationLogger.isKept(fieldInfo) && ConfigurationLogger.shouldLog(reflectedClass, sMissingFields, reflectedFieldName)) {
            String keepClassName = fieldInfo.declaringClassName;
            String reflectedClassName = ConfigurationLogger.originalClassName(reflectedClass.getName());
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(callingClassName) + "' is calling Class." + reflectionMethodName + "\non class '" + ConfigurationLogger.originalClassName(reflectedClass) + "' to retrieve the field '" + reflectedFieldName + "'" + (!reflectedClassName.equals(keepClassName) ? " (declared in class '" + keepClassName + "')" : "") + ",\n but there is no rule to keep the field.\nYou should consider preserving it, with a rule like:\n" + EMPTY_LINE + ConfigurationLogger.keepFieldRule(keepClassName, reflectedFieldName) + "\n" + EMPTY_LINE);
        }
    }

    public static void checkGetDeclaredFields(Class reflectedClass, String callingClassName) {
        if (!ConfigurationLogger.allDeclaredFieldsKept(reflectedClass) && ConfigurationLogger.shouldLog(sFieldListingCLasses, reflectedClass)) {
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(callingClassName) + "' is calling Class.getDeclaredFields\non class '" + ConfigurationLogger.originalClassName(reflectedClass) + "' to retrieve its fields.\nYou might consider preserving all fields with their original names,\nwith a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepAllFieldsRule(reflectedClass) + "\n" + EMPTY_LINE);
        }
    }

    public static void checkGetFields(Class reflectedClass, String callingClassName) {
        if (!ConfigurationLogger.allPublicFieldsKept(reflectedClass) && ConfigurationLogger.shouldLog(sFieldListingCLasses, reflectedClass)) {
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(callingClassName) + "' is calling Class.getFields\non class '" + ConfigurationLogger.originalClassName(reflectedClass) + "' to retrieve its fields.\nYou might consider preserving all public fields with their original names,\nwith a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepAllPublicFieldsRule(reflectedClass) + "\n" + EMPTY_LINE);
        }
    }

    public static void checkGetDeclaredConstructor(Class reflectedClass, Class[] constructorParameters, String callingClassName) {
        ConfigurationLogger.checkGetConstructor(METHOD_GET_DECLARED_CONSTRUCTOR, reflectedClass, constructorParameters, callingClassName);
    }

    public static void checkGetConstructor(Class reflectedClass, Class[] constructorParameters, String callingClassName) {
        ConfigurationLogger.checkGetConstructor(METHOD_GET_CONSTRUCTOR, reflectedClass, constructorParameters, callingClassName);
    }

    public static void checkGetConstructor(String reflectionMethodName, Class reflectedClass, Class[] constructorParameters, String callingClassName) {
        String signature;
        MemberInfo constructorInfo = ConfigurationLogger.getDeclaringClass(reflectedClass, INIT, constructorParameters, false);
        if (constructorInfo != null && !ConfigurationLogger.isKept(constructorInfo) && (constructorParameters == null || constructorParameters.length > 0) && ConfigurationLogger.shouldLog(reflectedClass, sMissingMethods, signature = ConfigurationLogger.signatureString(INIT, constructorParameters, true))) {
            String keepClassName = reflectedClass.getName();
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(callingClassName) + "' is calling Class." + reflectionMethodName + "\non class '" + ConfigurationLogger.originalClassName(reflectedClass) + "' to retrieve\nthe constructor with signature " + signature + ", but there is no rule to keep the constructor.\nYou should consider preserving it, with a rule like:\n" + EMPTY_LINE + ConfigurationLogger.keepConstructorRule(keepClassName, signature) + "\n" + EMPTY_LINE);
        }
    }

    public static void checkGetDeclaredConstructors(Class reflectedClass, String callingClassName) {
        if (!ConfigurationLogger.allDeclaredConstructorsKept(reflectedClass) && ConfigurationLogger.shouldLog(sConstructorListingClasses, reflectedClass)) {
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(callingClassName) + "' is calling Class.getDeclaredConstructors\non class '" + ConfigurationLogger.originalClassName(reflectedClass) + "' to retrieve its constructors.\nYou might consider preserving all constructors with their original names,\nwith a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepAllConstructorsRule(reflectedClass) + "\n" + EMPTY_LINE);
        }
    }

    public static void checkGetConstructors(Class reflectedClass, String callingClassName) {
        if (!ConfigurationLogger.allPublicConstructorsKept(reflectedClass) && ConfigurationLogger.shouldLog(sConstructorListingClasses, reflectedClass)) {
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(callingClassName) + "' is calling Class.getConstructors\non class '" + ConfigurationLogger.originalClassName(reflectedClass) + "' to retrieve its constructors.\nYou might consider preserving all constructors with their original names,\nwith a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepAllConstructorsRule(reflectedClass) + "\n" + EMPTY_LINE);
        }
    }

    public static void checkGetDeclaredMethod(Class reflectedClass, String reflectedMethodName, Class[] reflectedMethodParameters, String callingClassName) {
        ConfigurationLogger.checkGetMethod(METHOD_GET_DECLARED_METHOD, reflectedClass, reflectedMethodName, reflectedMethodParameters, callingClassName);
    }

    public static void checkGetMethod(Class reflectedClass, String reflectedMethodName, Class[] reflectedMethodParameters, String callingClassName) {
        ConfigurationLogger.checkGetMethod(METHOD_GET_METHOD, reflectedClass, reflectedMethodName, reflectedMethodParameters, callingClassName);
    }

    private static void checkGetMethod(String reflectionMethodName, Class reflectedClass, String reflectedMethodName, Class[] reflectedMethodParameters, String callingClassName) {
        String signature;
        MemberInfo methodInfo = ConfigurationLogger.getDeclaringClass(reflectedClass, reflectedMethodName, reflectedMethodParameters, true);
        if (methodInfo != null && !ConfigurationLogger.isKept(methodInfo) && ConfigurationLogger.shouldLog(reflectedClass, sMissingMethods, signature = ConfigurationLogger.signatureString(reflectedMethodName, reflectedMethodParameters, true))) {
            String keepClassName = methodInfo.declaringClassName;
            String reflectedClassName = ConfigurationLogger.originalClassName(reflectedClass);
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(callingClassName) + "' is calling Class." + reflectionMethodName + "\non class '" + reflectedClassName + "' to retrieve the method\n" + signature + (!reflectedClassName.equals(keepClassName) ? " (declared in class '" + keepClassName + "')" : "") + ", but there is no rule to keep the method.\nYou should consider preserving it, with a rule like:\n" + EMPTY_LINE + ConfigurationLogger.keepMethodRule(keepClassName, signature) + "\n" + EMPTY_LINE);
        }
    }

    public static void checkGetDeclaredMethods(Class reflectedClass, String callingClassName) {
        if (!ConfigurationLogger.allDeclaredMethodsKept(reflectedClass) && ConfigurationLogger.shouldLog(sMethodListingClasses, reflectedClass)) {
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(callingClassName) + "' is calling Class.getDeclaredMethods\non class '" + ConfigurationLogger.originalClassName(reflectedClass) + "' to retrieve its methods.\nYou might consider preserving all methods with their original names,\nwith a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepAllMethodsRule(reflectedClass) + "\n" + EMPTY_LINE);
        }
    }

    public static void checkGetMethods(Class reflectedClass, String callingClassName) {
        if (!ConfigurationLogger.allPublicMethodsKept(reflectedClass) && ConfigurationLogger.shouldLog(sMethodListingClasses, reflectedClass)) {
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(callingClassName) + "' is calling Class.getMethods\non class '" + ConfigurationLogger.originalClassName(reflectedClass) + "' to retrieve its methods.\nYou might consider preserving all public methods with their original names,\nwith a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepAllPublicMethodsRule(reflectedClass) + "\n" + EMPTY_LINE);
        }
    }

    private static boolean isKept(MemberInfo memberInfo) {
        return memberInfo != null && (memberInfo.flags & 1) != 0;
    }

    private static boolean isShrunk(MemberInfo memberInfo) {
        return memberInfo != null && (memberInfo.flags & 2) != 0;
    }

    private static boolean isKept(ClassInfo classInfo) {
        return classInfo != null && (classInfo.flags & 1) != 0;
    }

    private static boolean isShrunk(ClassInfo classInfo) {
        return classInfo != null && (classInfo.flags & 0x80) != 0;
    }

    private static MemberInfo getDeclaringClass(Class reflectedClass, String fieldName) {
        String className = reflectedClass.getName();
        while (className != null) {
            ClassInfo classInfo = sObfuscatedClassNameInfoMap.get(className);
            if (classInfo != null) {
                int signatureHash = ConfigurationLogger.hashFnv1a32_UTF8(fieldName);
                for (int i = 0; i < classInfo.fieldHashes.length; ++i) {
                    if (classInfo.fieldHashes[i] != signatureHash) continue;
                    return new MemberInfo(classInfo.originalClassName, classInfo.fieldFlags[i]);
                }
                className = classInfo.superClassName;
                continue;
            }
            className = null;
        }
        return null;
    }

    private static MemberInfo getDeclaringClass(Class reflectedClass, String methodName, Class[] parameters, boolean checkHierarchy) {
        String className = reflectedClass.getName();
        while (className != null) {
            ClassInfo classInfo = sObfuscatedClassNameInfoMap.get(className);
            if (classInfo != null) {
                int signatureHash = ConfigurationLogger.hashFnv1a32_UTF8(ConfigurationLogger.signatureString(methodName, parameters, false));
                for (int i = 0; i < classInfo.methodHashes.length; ++i) {
                    if (classInfo.methodHashes[i] != signatureHash) continue;
                    return new MemberInfo(classInfo.originalClassName, classInfo.methodFlags[i]);
                }
                className = checkHierarchy ? classInfo.superClassName : null;
                continue;
            }
            className = null;
        }
        return null;
    }

    private static boolean allDeclaredFieldsKept(Class clazz) {
        ClassInfo classInfo = sObfuscatedClassNameInfoMap.get(clazz.getName());
        return classInfo != null && (classInfo.flags & 8) != 0;
    }

    private static boolean allPublicFieldsKept(Class clazz) {
        ClassInfo classInfo = sObfuscatedClassNameInfoMap.get(clazz.getName());
        return classInfo != null && (classInfo.flags & 0x10) != 0;
    }

    private static boolean allDeclaredConstructorsKept(Class clazz) {
        ClassInfo classInfo = sObfuscatedClassNameInfoMap.get(clazz.getName());
        return classInfo != null && (classInfo.flags & 2) != 0;
    }

    private static boolean allPublicConstructorsKept(Class clazz) {
        ClassInfo classInfo = sObfuscatedClassNameInfoMap.get(clazz.getName());
        return classInfo != null && (classInfo.flags & 4) != 0;
    }

    private static boolean allDeclaredMethodsKept(Class clazz) {
        ClassInfo classInfo = sObfuscatedClassNameInfoMap.get(clazz.getName());
        return classInfo != null && (classInfo.flags & 0x20) != 0;
    }

    private static boolean allPublicMethodsKept(Class clazz) {
        ClassInfo classInfo = sObfuscatedClassNameInfoMap.get(clazz.getName());
        return classInfo != null && (classInfo.flags & 0x40) != 0;
    }

    private static String signatureString(String methodName, Class[] parameters, boolean deobfuscate) {
        StringBuilder builder = new StringBuilder();
        builder.append(methodName);
        builder.append("(");
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                if (i != 0) {
                    builder.append(",");
                }
                builder.append(deobfuscate ? ConfigurationLogger.originalClassName(parameters[i]) : parameters[i].getName());
            }
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public void run() {
        ConfigurationLogger.printConfiguration();
    }

    private static void printConfiguration() {
        ConfigurationLogger.log("The following settings may help solving issues related to\nmissing classes, methods and/or fields:\n");
        for (String clazz : sMissingClasses) {
            ConfigurationLogger.log(ConfigurationLogger.keepClassRule(clazz) + "\n");
        }
        for (String clazz : sMissingMethods.keySet()) {
            for (String method : sMissingMethods.get(clazz)) {
                ConfigurationLogger.log(ConfigurationLogger.keepMethodRule(clazz, method) + "\n");
            }
        }
        for (String clazz : sMissingFields.keySet()) {
            for (String field : sMissingFields.get(clazz)) {
                ConfigurationLogger.log(ConfigurationLogger.keepFieldRule(clazz, field) + "\n");
            }
        }
    }

    private static String keepClassRule(String className) {
        return "-keep class " + className;
    }

    private static String keepConstructorRule(String className, String originalMethodSignature) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(className) + " {\n    " + originalMethodSignature + ";\n}";
    }

    private static String keepMethodRule(String className, String originalMethodSignature) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(className) + " {\n    *** " + originalMethodSignature + ";\n}";
    }

    private static String keepFieldRule(String className, String fieldName) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(className) + " {\n    *** " + fieldName + ";\n}";
    }

    private static String keepAllConstructorsRule(Class className) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(className) + " {\n    <init>(...);\n}";
    }

    private static String keepAllMethodsRule(Class className) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(className) + " {\n    <methods>;\n}";
    }

    private static String keepAllPublicMethodsRule(Class className) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(className) + " {\n    public <methods>;\n}";
    }

    private static String keepAllFieldsRule(Class className) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(className) + " {\n    <fields>;\n}";
    }

    private static String keepAllPublicFieldsRule(Class className) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(className) + " {\n    public <fields>;\n}";
    }

    private static String originalClassName(Class className) {
        return ConfigurationLogger.originalClassName(className.getName());
    }

    private static String originalClassName(String className) {
        ClassInfo classInfo;
        int arrayDimension = className.lastIndexOf("[") + 1;
        if (arrayDimension != 0) {
            className = ConfigurationLogger.getExternalClassNameFromComponentType(className.substring(arrayDimension));
        }
        String originalClassName = (classInfo = sObfuscatedClassNameInfoMap.get(className)) != null ? classInfo.originalClassName : className;
        return ConfigurationLogger.addArrayBrackets(originalClassName, arrayDimension);
    }

    private static String addArrayBrackets(String className, int arrayDimension) {
        StringBuilder sb = new StringBuilder(className);
        for (int index = 0; index < arrayDimension; ++index) {
            sb.append("[]");
        }
        return sb.toString();
    }

    private static String getExternalClassNameFromComponentType(String componentType) {
        switch (componentType.charAt(0)) {
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'S': {
                return "short";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'F': {
                return "float";
            }
            case 'D': {
                return "double";
            }
            case 'L': {
                return componentType.substring(1, componentType.length() - 1);
            }
        }
        throw new IllegalArgumentException("Unknown component type [" + componentType + "]");
    }

    private static boolean isLibraryClass(Class clazz) {
        return !sObfuscatedClassNameInfoMap.containsKey(clazz.getName());
    }

    private static Method getLogMethod() {
        try {
            Class<?> logClass = Class.forName(ANDROID_UTIL_LOG);
            return logClass.getMethod("w", String.class, String.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void initializeClassMap() throws IOException {
        ConfigurationLogger.loadClassMap(ConfigurationLogger.class.getClassLoader().getResourceAsStream(CLASS_MAP_FILENAME), sObfuscatedClassNameInfoMap);
    }

    public static void loadClassMap(InputStream inputStream, Map<String, ClassInfo> map) throws IOException {
        if (inputStream == null) {
            return;
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int classCount = dataInputStream.readInt();
        for (int i = 0; i < classCount; ++i) {
            String originalClassName = dataInputStream.readUTF();
            String obfuscatedClassName = dataInputStream.readUTF();
            String superClassName = dataInputStream.readUTF();
            short flags = dataInputStream.readShort();
            int fieldCount = dataInputStream.readShort();
            int[] fieldHashes = new int[fieldCount];
            byte[] fieldFlags = new byte[fieldCount];
            for (int j = 0; j < fieldCount; ++j) {
                fieldHashes[j] = dataInputStream.readInt();
                fieldFlags[j] = dataInputStream.readByte();
            }
            int methodCount = dataInputStream.readShort();
            int[] methodHashes = new int[methodCount];
            byte[] methodFlags = new byte[methodCount];
            for (int j = 0; j < methodCount; ++j) {
                methodHashes[j] = dataInputStream.readInt();
                methodFlags[j] = dataInputStream.readByte();
            }
            ClassInfo classInfo = new ClassInfo(originalClassName, superClassName, flags, fieldHashes, fieldFlags, methodHashes, methodFlags);
            map.put(obfuscatedClassName, classInfo);
        }
    }

    private static <T> boolean shouldLog(Class reflectedClass, Map<String, Set<T>> classValuesMap, T value) {
        if (ConfigurationLogger.isLibraryClass(reflectedClass)) {
            return false;
        }
        Set<T> values2 = ConfigurationLogger.computeIfAbsent(classValuesMap, reflectedClass.getName());
        return ConfigurationLogger.shouldLog(values2, value);
    }

    private static boolean shouldLog(Set<String> classes, Class reflectedClass) {
        return !ConfigurationLogger.isLibraryClass(reflectedClass) && ConfigurationLogger.shouldLog(classes, reflectedClass.getName());
    }

    private static <T> boolean shouldLog(Set<T> values2, T value) {
        return true;
    }

    private static <T> Set<T> computeIfAbsent(Map<String, Set<T>> map, String key) {
        Set<T> set = map.get(key);
        if (set == null) {
            set = new HashSet<T>();
            map.put(key, set);
        }
        return set;
    }

    private static void log(String message) {
        if (logMethod != null) {
            try {
                logMethod.invoke(null, LOG_TAG, message);
            }
            catch (Exception e) {
                logger.error(message);
            }
        } else {
            logger.error(message);
        }
    }

    private static int hashFnv1a32_UTF8(String string) {
        return ConfigurationLogger.hash(string, -2128831035);
    }

    private static int hash(String string, int init) {
        return ConfigurationLogger.hash(string.getBytes(StandardCharsets.UTF_8), init);
    }

    private static int hash(byte[] data2, int init) {
        int hash = init;
        for (byte b : data2) {
            hash ^= b;
            hash *= 16777619;
        }
        return hash;
    }

    static {
        try {
            ConfigurationLogger.initializeClassMap();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class MemberInfo {
        final String declaringClassName;
        final byte flags;

        MemberInfo(String declaringClassName, byte flags) {
            this.declaringClassName = declaringClassName;
            this.flags = flags;
        }

        public String toString() {
            return this.declaringClassName + " (" + ((this.flags & 1) != 0 ? "kept" : "not kept") + ", " + ((this.flags & 2) != 0 ? "shrunk" : "not shrunk") + ")";
        }
    }

    public static class ClassInfo {
        final String originalClassName;
        final String superClassName;
        final short flags;
        public final int[] fieldHashes;
        final byte[] fieldFlags;
        public final int[] methodHashes;
        final byte[] methodFlags;

        ClassInfo(String originalClassName, String superClassName, short flags, int[] fieldHashes, byte[] fieldFlags, int[] methodHashes, byte[] methodFlags) {
            this.originalClassName = originalClassName;
            this.superClassName = superClassName;
            this.flags = flags;
            this.fieldHashes = fieldHashes;
            this.fieldFlags = fieldFlags;
            this.methodHashes = methodHashes;
            this.methodFlags = methodFlags;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.originalClassName);
            if (!this.superClassName.equals("")) {
                sb.append(" extends ").append(this.superClassName);
            }
            sb.append(" (");
            if ((this.flags & 1) != 0) {
                sb.append("kept");
            } else {
                sb.append("not kept");
            }
            if ((this.flags & 0x80) != 0) {
                sb.append(", shrunk");
            } else {
                sb.append(", not shrunk");
            }
            sb.append(")");
            sb.append(" ");
            sb.append(this.fieldHashes.length).append(" fields, ").append(this.methodHashes.length).append(" methods");
            return sb.toString();
        }
    }
}

