/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.evaluation.value.Value;

public class ReflectiveMethodCallUtil {
    public static Class<?>[] stringtypesToClasses(String descriptor) throws ClassNotFoundException {
        InternalTypeEnumeration typeEnum = new InternalTypeEnumeration(descriptor);
        Class[] parameterClasses = new Class[typeEnum.typeCount()];
        int i = 0;
        while (typeEnum.hasMoreTypes()) {
            Class<?> c;
            String internalType = typeEnum.nextType();
            if (!ClassUtil.isInternalArrayType(internalType) && ClassUtil.isInternalClassType(internalType)) {
                c = Class.forName(ClassUtil.externalClassName(ClassUtil.internalClassNameFromClassType(internalType)));
            } else if (internalType.length() == 1 && ClassUtil.isInternalPrimitiveType(internalType)) {
                c = ReflectiveMethodCallUtil.getClassForPrimitive(internalType.charAt(0));
            } else {
                return null;
            }
            parameterClasses[i++] = c;
        }
        return parameterClasses;
    }

    public static Object getObjectForValue(Value value, Class<?> expectedType) {
        Object ret = null;
        switch (value.computationalType()) {
            case 1: {
                ret = value.integerValue().value();
                if (expectedType == Character.class || expectedType == Character.TYPE) {
                    ret = Character.valueOf((char)((Integer)ret).intValue());
                    break;
                }
                if (expectedType == Byte.class || expectedType == Byte.TYPE) {
                    ret = (byte)((Integer)ret).intValue();
                    break;
                }
                if (expectedType == Short.class || expectedType == Short.TYPE) {
                    ret = (short)((Integer)ret).intValue();
                    break;
                }
                if (expectedType != Boolean.class && expectedType != Boolean.TYPE) break;
                ret = (Integer)ret == 1;
                break;
            }
            case 2: {
                ret = value.longValue().value();
                break;
            }
            case 3: {
                ret = Float.valueOf(value.floatValue().value());
                break;
            }
            case 4: {
                ret = value.doubleValue().value();
                break;
            }
            case 5: {
                ret = value.referenceValue().value();
            }
        }
        return ret;
    }

    public static Class<?> getClassForPrimitive(char internalPrimitiveType) {
        switch (internalPrimitiveType) {
            case 'V': {
                return Void.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
        }
        throw new IllegalArgumentException("Unexpected primitive type [" + internalPrimitiveType + "]");
    }

    public static Object callConstructor(String className, Class<?>[] parameterClasses, Object[] parameterObjects) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> baseClass = Class.forName(className);
        Constructor<?> constructor = baseClass.getConstructor(parameterClasses);
        return constructor.newInstance(parameterObjects);
    }

    public static Object callMethod(String className, String methodName, Object instance, Class<?>[] parameterClasses, Object[] parameterObjects) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, ClassNotFoundException {
        Class<?> baseClass = Class.forName(className);
        Method method = baseClass.getMethod(methodName, parameterClasses);
        return method.invoke(instance, parameterObjects);
    }
}

